package Lire::Config::ReportSectionSpec;

use strict;

use base qw/Lire::Config::ObjectSpec/;

use Lire::Config::StringSpec;
use Lire::Config::DlfSchemaSpec;
use Lire::Config::XMLSpecListSpec;
use Locale::TextDomain 'lire';

=pod

=head1 NAME

Lire::Config::ReportSectionSpec - Defines a report section.

=head1 DESCRIPTION

This Lire::Config::TypeSpec is a CompoundSpec which defines a report's
section.

=head2 new()

Create a Lire::Config::SectionSpec object.

=cut

sub new {
    my $self = shift->SUPER::new( @_, 'label' => 'title',
                                'class' => 'Lire::ReportSection' );

    $self->add( new Lire::Config::StringSpec( 'name' => 'title',
                                              'summary' => N__( "Section's title" ),
                                              'description' => '<para>' . join( "", N__( "The section's title that will appear in the generated report." ) ) . '</para>' ) );
    $self->add( new Lire::Config::DlfSchemaSpec( 'name' => 'superservice',
                                                 'superservices' => 1,
                                                 'summary' => N__( "Section's Superservice" ),
                                              'description' => '<para>' . join( "", N__( 'The superservices that is used by this section.' ) ) . '</para>' ) );

    my $filters =
      new Lire::Config::XMLSpecListSpec( 'name' => 'filters',
                                         'type' => 'filters',
                                         'summary' => N__( "Section's filters" ),
                                         'description' => '<para>' . join( "", N__( 'List of filters that will be applied to this section.' ) ) . '</para>' );
    $self->add( $filters );

    my $specs =
      new Lire::Config::XMLSpecListSpec( 'name' => 'specs',
                                         'type' => 'reports',
                                         'summary' => N__( "Section's content" ),
                                         'description' => '<para>' . join( "", N__( 'The chart and subreport that will be included in this section.' ) ) . '</para>' );
    $self->add( $specs );

    return $self;
}

1;

__END__

=pod

=head2 SEE ALSO

  Lire::Config::XMLSpecListSpec(3pm), Lire::Config::ReportSpec(3pm),
  Lire::ReportSection(3pm)

=head1 VERSION

$Id: ReportSectionSpec.pm,v 1.2 2004/07/07 19:20:32 flacoste Exp $

=head1 AUTHORS

  Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
