package Lire::SQLExt::LrTimegroup;

use strict;

use Time::Timezone;
use Time::Local;
use Lire::WeekCalculator;

use vars qw/ $calc /;

sub lr_timegroup_sec {
    my ( $t, $period_size ) = @_;

    return undef unless ( defined $t && defined $period_size );

    return int($t) - ( $t % $period_size );
}

sub lr_timegroup_day {
    my $t = $_[0];

    return undef unless defined $t;

    return int($t) - ( $t % 86400 ) - tz_local_offset( $t );
}

sub lr_timegroup_week {
    my ( $t, $mult ) = @_;

    return undef unless ( defined $t && defined $mult );

    $calc ||= new Lire::WeekCalculator();

    my ($month, $year) = (localtime $t )[4,5];
    my $week_no = $calc->week_number( $t );
    $year++ if ( $month > 1 && $week_no == 1 );

    $week_no = int( ($week_no - 1) / $mult ) * $mult + 1
      if $mult > 1;

    return $calc->week_start( $year, $week_no );
}

sub lr_timegroup_month {
    my ( $t, $mult ) = @_;

    return undef unless ( defined $t && defined $mult );

    my ( $month, $year ) = ( localtime $t )[4,5];

    $month = int( $month / $mult ) * $mult
      if $mult > 1;

    return timelocal( 0, 0, 0, 1, $month, $year );
}

sub lr_timegroup_year {
    my ( $t, $mult ) = @_;

    return undef unless ( defined $t && defined $mult );

    my $year = (localtime $t)[5] + 1900;
    $year = int( ( $year - 1 ) / $mult ) * $mult + 1
      if $mult > 1;

    return timelocal( 0, 0, 0, 1, 0, $year - 1900 );
}

1;
__END__

=pod

=head1 NAME

Lire::SQLExt::LrTimegroup - FILL ME IN

=head1 SYNOPSIS

  FILL ME IN

=head1 DESCRIPTION

  FILL ME IN

=head1 SEE ALSO

Lire::DlfConverter(3pm)

=head1 VERSION

$Id: LrTimegroup.pm,v 1.4 2003/10/27 17:29:35 flacoste Exp $

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>
  Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2003 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut

