package tests::ChartTypesFixture;

use strict;

use Lire::Config::SpecParser;
use Lire::Utils qw/file_content deep_copy/;
use Lire::Config::Build qw/ac_info/;
use Lire::Config::ExecutableSpec;
use File::Basename qw/dirname/;

sub set_up_chart_types {
    my ( $self, $new_mgr) = @_;

    $new_mgr = ! $self->isa( 'Lire::Test::FunctionalTestCase' )
      unless defined $new_mgr;

    $self->set_up_plugin_mgr() if $new_mgr;

    my $testdir = dirname( __FILE__ );
    my $charttypesdir =  "$testdir/../Lire/ChartTypes";
    opendir my $dh, $charttypesdir
      or $self->error( "opendir '$charttypesdir' failed: $!" );
    foreach my $basename ( readdir $dh ) {
        next unless $basename =~ /_init$/;
        eval file_content( "$charttypesdir/$basename" );
        $self->error( "error loading '$charttypesdir/$basename': $@" )
          if $@;
    }
    closedir $dh;

    my $parser = new Lire::Config::SpecParser();
    unless ( $self->isa( 'Lire::Test::FunctionalTestCase' ) ) {
        $parser->{'_spec'} = deep_copy( $self->{'cfg'}{'_lr_config_spec'}
                                        || $self->lire_default_config_spec() );
    }
    $parser->merge_specifications_dir( "$testdir/../Lire/ChartTypes" );
    $self->{'cfg'}{'_lr_config_spec'} = $parser->configspec();
    $self->{'cfg'}{'lr_chart_font'} = '';
    $self->{'cfg'}{'ploticus_path'} =
      new Lire::Config::ExecutableSpec( 'name' => 'ploticus_path' )->instance( 'value' => ac_info( 'PLOTICUS' ) );

    return;
}


1;
