package tests::www;

use File::Basename qw/dirname/;
use Cwd qw/realpath/;

use base 'Test::Unit::TestSuite';

sub name { 'WWW Superservice Unit Tests' }

sub include_tests {
    # Files containing test cases all ends in Test.pm
    my $dir =  realpath( dirname(__FILE__) );

    opendir DIR, $dir
      or die "can't opendir $dir: $!";
    my @tests = ();
    foreach my $e ( readdir DIR ) {
        next unless $e =~ /(.*Test)\.pm$/;
        push @tests, "tests::$1";
    }
    closedir DIR;

    return @tests;
}

1;
