package tests::ConfigObjectSpecTest;

use strict;

use tests::ConfigSpecTest;
use base qw/tests::ConfigCompoundSpecTest/;

use Lire::Config::TypeSpec;
use Lire::Config::Object;

sub type {
    return 'Lire::Config::ObjectSpec';
}

sub additional_new_params {
    return ( 'class' => 'mypackage' );
}

sub test_new {
    my $self = $_[0];

    $self->SUPER::test_new();

    $self->assert_died( sub { Lire::Config::ObjectSpec->new( 'name' =>"name") },
                        qr/missing 'class' parameter/ );

    my $spec = Lire::Config::ObjectSpec->new( 'name' =>"name",
                                              'class' => 'package' );
    $self->assert_str_equals( 'package', $spec->class() );
}

1;
