<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRML/"
  exclude-result-prefixes="lire">

  <xsl:import href="config.xsl"/>
  <xsl:import href="logml-www.xsl"/>
  <xsl:import href="logml-email.xsl"/>

  <xsl:output method="xml" indent="yes"/>

  <!-- Prevent text output in special mode -->
  <xsl:template match="text()" mode="graph-mode"/>
  <xsl:template match="text()" mode="directories-mode"/>
  <xsl:template match="text()" mode="summary-mode"/>
  <xsl:template match="text()" mode="date_stat-mode"/>
  
  <xsl:template match="lire:report">
    <xsl:variable name="start-date" 
      select="substring-before(lire:timespan, ' -')"/>
    <xsl:variable name="end-date" 
      select="substring-after(lire:timespan, '- ')"/>
    
    <logml xmlns="http://www.cs.rpi.edu/LOGML"
      start_date="{$start-date}" end_date="{$end-date}">

      <graph xmlns="http://www.cs.rpi.edu/XGMML">
	<xsl:apply-templates mode="graph-mode" select="*/lire:subreport"/>
      </graph>

      <xsl:if test="*/lire:subreport[@superservice = 'www']">
        <!-- this info is only available for the www superservice -->
        <directories>
          <xsl:apply-templates mode="directories-mode" select="*/lire:subreport"/>
        </directories>

        <summary>
	  <xsl:apply-templates mode="summary-mode" select="*/lire:subreport"/>
	  <dateStat>
	    <xsl:apply-templates mode="date_stat-mode" select="*/lire:subreport"/>
	  </dateStat>
        </summary>
      </xsl:if>
    </logml>
  </xsl:template>

  <!-- Make a XGMML graph element from a lire:table where the edges
  are lire:entry and the node are the lire:name. Weight is based on lire:value
  -->

  <xsl:template name="node-id">
    <xsl:param name="node"/>
    <xsl:param name="is-source" select="false()"/>
    <xsl:for-each select="$node">
      <xsl:choose>
	<xsl:when test="$is-source">
	  <xsl:value-of select="count(preceding-sibling::*) * 2 + 1"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="count(preceding-sibling::*) * 2 + 2"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="table2graph">
    <xsl:param name="table" select="lire:table"/>

    <!-- Create the nodes -->
    <xsl:for-each select="$table/lire:entry">
      <!-- The id is absolute position of the lire:name in the
      lire:table. Some id may be skipped if a lire:name comes out more
      than once --> 
      <xsl:variable name="id-1" select="count(preceding-sibling::*) *
	2 + 1"/>
      <xsl:variable name="id-2" select="count(preceding-sibling::*) *
	2 + 2"/>

      <xsl:variable name="name-1" select="lire:name[1]"/>
      <xsl:variable name="name-2" select="lire:name[2]"/>
      <!-- The weight of a node is the sum of all the lire:value where
      that lire:name appears -->
      <xsl:variable name="weight-1"
	select="sum(../lire:entry[lire:name[1] = $name-1]/lire:value)"/>
      <xsl:variable name="weight-2"
	select="sum(../lire:entry[lire:name[2] = $name-2]/lire:value)"/>
      
      <!-- Create a new node only if this lire:name didn't appear
      before -->
      <xsl:if test="not(preceding-sibling::lire:entry[lire:name[1] = $name-1])">
	<node id="{$id-1}" label="{lire:name[1]}" weight="{$weight-1}"/>
      </xsl:if>
      <xsl:if test="not(preceding-sibling::lire:entry[lire:name[2] = $name-2])">
	<node id="{$id-2}" label="{lire:name[2]}" weight="{$weight-2}"/>
      </xsl:if>
    </xsl:for-each>

    <!-- Create the edges -->
    <xsl:for-each select="$table/lire:entry">
      <xsl:variable name="name-1" select="lire:name[1]"/>
      <xsl:variable name="name-2" select="lire:name[2]"/>

      <xsl:variable name="source" select="count(../lire:entry[lire:name[1] =
	$name-1][1]/preceding-sibling::*) * 2 + 1"/>
      <xsl:variable name="target" select="count(../lire:entry[lire:name[2] =
	$name-2][1]/preceding-sibling::*) * 2 + 2"/>
      
      <edge source="{$source}" target="{$target}" weight="{lire:value}"/>
    </xsl:for-each>
  </xsl:template>
  
</xsl:stylesheet>

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
