/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"

/*! \brief Konstruktor dwu członowego polecenia

	Konstruktor dwu członowego polecenia
*/
LWParityCommand::LWParityCommand (): matched(FALSE)
{
}

/*! \brief Czy polecenie jest dwuczłonowe

	Czy polecenie jest dwuczłonowe
	\return Zawsze zwraca prawdę
*/
gboolean LWParityCommand::isParity ()
{
	return TRUE;
}

/*! \brief Dopasowuje polecenie

	Oznacza polecenia jako już dopasowane z jego końcem
*/
void LWParityCommand::match ()
{
	matched = TRUE;
}

/*! \brief Czy polecenie jest już dopasowane

	Czy polecenie jest już dopasowane
	\return Zwraca prawdę jeśli było już dopasowane w przeciwnym razie fałsz
*/
gboolean LWParityCommand::isAlreadyMatched ()
{
	return matched;
}

/*! \brief Zeruje polecenie

	Zeruje polecenie czyniąc je niedopasowanym
*/
void LWParityCommand::reset1 ()
{
	matched = FALSE;
}

/*! \brief Czy próba sprawdzenia doposowania ma być dokonywana jako
	ostatnia. 

	Polecenie pozwala na prawidłowe wskazanie błędu występującego
	przy przecięciu dwóch operatorów parzystych, np. begin to,
	for end, begin until, repeat end. We wszystkich tych przypadkach
	bardziej sensowne wydaje się wyświetlenie błędu związanego
	z poleceniami for, to, dowto, repeat, until niz begin czy end.
	Funkcja pozwala zaznaczyć polecenia, które przy nieudanym
	dopasowaniu zwracają mało czytelne komunikaty błędów, tak
	jak w przypadku begin czy end. Nie przeciążona funkcja zwraca
	FAŁSZ.
	\return Jęśli próba dopasowania ma odbyć się na końcu zwracana
	jest PRAWDA, w przeciwnym wypadku FAŁSZ.
*/	
gboolean LWParityCommand::matchAsLastOne ()
{
	return FALSE;
}
