/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file boardset.h 
	\brief Zarządzanie zbiorem plansz
*/

#ifndef __LW_BOARDSET_H
#define __LW_BOARDSET_H

#include <libxml/tree.h>

typedef enum LWType {
LW_TYPE_ICONS=0,
LW_TYPE_COMMANDS=1,
LW_TYPE_WORLD=2,
LW_TYPE_PROGRAM=3,
LW_TYPE_PLAYGROUND=4
};

class LWBoard;

/*! \class LWBoardSet
	\brief Zarządzanie zbiorem plansz

	Klasa umożliwia operowanie
	na zbiorze plansz, umożliwia m.in. dodawanie i usuwanie plansz do zbioru
*/
class LWBoardSet {
private:
GSList *list_board;
GtkWidget *widget;
LWType type;
gboolean enable_grid;
public:
LWBoardSet (LWType a_type);
~LWBoardSet ();
void restoreFromXML (xmlNode *node);
void addBoard (LWBoard *board, gchar *title);
void changeBoardTitle (LWBoard *board, gchar *title);
void clear ();
void enableGrid (gboolean enable);
gboolean isGridEnabled (); 
GtkWidget *getWidget ();
LWType getType();
};

#include "board.h"

#endif
