/* =====================================================================

   Limo - APM Хåƥ꡼˥
   APM Info.  - APM ʬ

                                  Programed by Rero2 (K.Kunikane)

====================================================================== */

/* -------------------------------------------------------------
 --- History

  Nov.28.1999  Programing start (batmon)
  Dec.19.1999  FreeBSD,NetBSD,OpenBSDѥɤ¾Υץ
  Dec.30.1999  FreeBSD,NetBSD,OpenBSDѥɽ
  Jan.05.2000  FreeBSD,NetBSD,OpenBSDѥɤ AC ΥХ

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Preface

  ApmInfoGet          -- APM
  ApmInfoStat         -- Хåƥ꡼(¸ߤƤ뤫AC)
  ApmInfoValue        -- Хåƥ꡼

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Include
-------------------------------------------------------------- */

#include <config.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <gtk/gtk.h>

/* --- BSDϤ */
#ifdef __FreeBSD__
  #include <fcntl.h>
  #include <machine/apm_bios.h>
  #define APMDEV "/dev/apm"
#elif defined(__NetBSD__) || defined(__OpenBSD__)
  #include <sys/ioctl.h>
  #include <machine/apmvar.h>
  #include <fcntl.h>
  #define APMDEV "/dev/apm"
#endif


/* -------------------------------------------------------------
 --- Ƽ
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- ؿ
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- ѿ
-------------------------------------------------------------- */

/* --- Хåƥ꡼֤ɽΥǡ */
static gint  stat, remain;



/* -------------------------------------------------------------
 --- Gnome Applets BSDϤξɤߤȤ
     Υꥸʥ븢ɽ(ñʤGPL)
     Dec.19.1999
-------------------------------------------------------------- */

/*--------------------------------*-C-*---------------------------------*
 *
 *  Copyright 1999, Nat Friedman <nat@nat.org>.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 *
 *----------------------------------------------------------------------*/

/*
 * File: applets/battery/read-battery.c
 *
 * This file contains the routines which read the battery data from
 * the hardware.
 *
 * Author: Nat Friedman <nat@nat.org>
 */


/* -----------------------------------------------------------------------
 --- ץ
------------------------------------------------------------------------ */

/* -------------------------------------------------------------
  ApmInfoGet          -- APM

   return : void
   void

-------------------------------------------------------------- */
void ApmInfoGet(void)
{
  /* --- ǥե */
  stat = 2;
  remain = 0;

#ifdef __linux__
  /* -----------------------------------------------
     Linux ξAPM(Хåƥ꡼)
     /proc/apm Ȥե򻲾Ȥ뤳Ȥˤ
     뤳ȤǤ롣
     ɤ stat ڤ remain(Хåƥ꡼)
     ꤹΤʬǤ,ͣ OS ¸
     ʬǤ롣
   ------------------------------------------------*/
  {
    FILE *fp;
    gchar line[128];
    gint  arg1, arg2, arg3, arg4, val;
    gfloat  ver1, ver2;

    fp = fopen("/proc/apm", "r");
    if (fp == NULL) {
      /* -- /proc/apm ̵  apmd ưƤʤ */
      stat = 2;
      remain = 0;
    }
    else {
      fgets((char*)line, 127, fp);
      fclose(fp);
      sscanf(line, "%f %f 0x%x 0x%x 0x%x 0x%x %d",
	     &ver1, &ver2, &arg1, &arg2, &arg3, &arg4, &val);
      /* --- 󤫤ѥ᡼ */
      /* -- ACץ */
      if (arg2 == -1) {
	stat = 2;
      }
      else {
	if (arg2 == 0) {
	  stat = 1;
	}
	else {
	  stat = 0;
	}
      }
      /* -- Хåƥ꡼̾ */
      if (val != -1) {
	remain = val;
      }
      else {
	/* -- APM BIOS ͤǻ̤֤ʤե饰¬ */
	if ((arg4 % 1) > 0) {
	  remain = 100;
	}
	if ((arg4 % 2) > 0) {
	  remain = 40;
	}
	if ((arg4 % 4) > 0) {
	  remain = 10;
	}
      }
      /* -- Хåƥ꡼̵ͭ */
      if ((arg3 == 255) || (arg4 == 255) || ((arg4 & 0x80) > 0)) {
	stat = 2;
      }
      /* -- apmd ̵ͭ */
      if (((arg1 & 0x08) > 0) || ((arg1 & 0x10) > 0) || ((arg4 & 0x80) > 0)) {
	stat = 2;
      }
    }
  }

  /* -------------------------------------------
     FreeBSD Interface
     ------------------------------------------- */
#elif __FreeBSD__  /* was #ifdef __linux__ */
  {
    struct apm_info aip;
    int fd;

    fd = open(APMDEV, O_RDWR);
    if (fd == -1) {
      stat = 2;
      return;
    }
    if (ioctl(fd, APMIO_GETINFO, &aip) == -1) {
      stat = 2;
      return;
    }
    
    /* if APM is not turned on */
    if (!aip.ai_status) {
      stat = 2;
      return;
    }

    /* ACץͤդʤΤ */
    stat = (gint)(aip.ai_acline ^ 1);
    remain = (gint)aip.ai_batt_life;

    close(fd);
  }

#elif defined(__NetBSD__) || defined(__OpenBSD__)
  {
    struct apm_power_info aip;
    int fd;
    
    fd = open(APMDEV, O_RDONLY);
    if (fd == -1) {
      stat = 2;
      return;
    }
    if (ioctl(fd, APM_IOC_GETPOWER, &aip) == -1) {
      stat = 2;
      return;
    }
    
    /* if APM is not turned on */
    if (aip.battery_state == APM_BATT_UNKNOWN) {
      stat = 2;
      return;
    }
    if (aip.ac_state == APM_AC_UNKNOWN) {
      stat = 2;
      return;
    }
    
    if (aip.ac_state == APM_AC_ON) {
      stat = 0;
    }
    else {
      stat = 1;
    }
    remain = aip.battery_life;

    close(fd);
  }
#endif
}

/* -------------------------------------------------------------
  ApmInfoStat         -- Хåƥ꡼(¸ߤƤ뤫AC)

   return : gint (0=AC,1=BATTERY,2=NoBATTERY)
   void

-------------------------------------------------------------- */
gint ApmInfoStat(void)
{
  return(stat);
}

/* -------------------------------------------------------------
  ApmInfoValue        -- Хåƥ꡼

   return : gint (0100)
   void

-------------------------------------------------------------- */
gint ApmInfoValue(void)
{
  return(remain);
}


