/* =====================================================================

   LiMo - Liblary
      Graphic Display System.  - ̴ȥ֥ɽ

                                  Programed by Rero2 (K.Kunikane)

====================================================================== */

/* -------------------------------------------------------------
 --- History

  Sep.12.1999  Programing start
  Sep.24.1999  First release
  Oct.24.1999  Revision 2. (add OBJECT)
  Nov.28.1999  Revision 3. (add Window Shape)
  Dec.17.1999  Revision 4. (add Palette management)

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Preface

  RRScreenInit             -- ̽
  RRScreenFree             -- ̼곫
  RRScreenSwitch           -- ֥Хåեؤ
  RRScreenRedraw           -- Expose Event Ǥβ̥ɥ
  RRScreenBufNum           -- ֥Хåեν񤭹߲ǽڡ֤
  RRScreenBuffer           -- ߤν񤭹߲ǽ Pixmap ֤
  RRScreenGCColor          -- GC Υ顼ꤹ
  RRScreenGCGet            -- GC 
  RRScreenClear            -- 襹꡼ñɤĤ֤
  RRScreenCanvas           -- ɽåȤȤʤ drawable ֤
  RRScreenWindow           -- ɽåȤȤʤ window ֤
  RRScreenWinShape         -- ɽɥηޥ
  RRScreenSetPalette       -- ǥå顼
  RRScreenFontSetDirect    -- եľܻ
  RRScreenFontSetInit      -- եȤλ(ܸեȹ)
  RRScreenFontInit         -- եȤλʤ
  RRScreenFontLocate       -- եȤֻ
  RRScreenFontSize         -- ƥȤνĲ
  RRScreenFontPrint        -- ʸɽ
  RRScreenFontPrintDirect  -- Pixmapʸɽ
  RRScreenPutPixmap        -- 襹꡼Pixmapɽ
  RRScreenObjPut           -- Objectɽ
  RRScreenPoint            -- ɽ
  RRScreenLine             -- 饤ɽ
  RRScreenRectangle        -- ͳѤɽ

  RRGetParts               -- åȾλ̾ҥåȤ֤


-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Include
-------------------------------------------------------------- */

#include <gtk/gtk.h>
#include "rr_screen.h"

/* -------------------------------------------------------------
 --- Ƽ
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- ؿ
-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- ѿ
-------------------------------------------------------------- */

/* --- ֥륹꡼Хåե */
GdkPixmap *pixmap[2];

/* --- ꡼ڡ */
gint  page;

/* --- ꡼󥵥 */
gint  screen_w, screen_h;

/* --- եåƥ */
GdkGC     *win_gc[3];

/* --- ɽ꡼ widget */
GtkWidget  *canvas;
GtkWidget  *window;

/* --- ѹ줿襨ꥢΥ */
gint  drawmemo_x, drawmemo_y, drawmemo_w, drawmemo_h;

/* --- ɽեȤλ */
GdkFont  *sfont1 = NULL, *sfont2= NULL;

/* --- եȤɽ */
gint  font_x, font_y;

/* --- ɥηޥ */
GdkBitmap *win_mask = NULL;
GdkBitmap *win_mask_current = NULL;

/* --- ǥå顼 */
GdkColormap  *win_pal = NULL;
gint win_pal_n;

/* -----------------------------------------------------------------------
 --- ץ
------------------------------------------------------------------------ */

/* -------------------------------------------------------------
  RRScreenInit       -- ̴Ϣ

   return : void
   window   - ɽ륦ɥå
   screen   - window Drawable widget
   w        - 
   h        - ĥ
-------------------------------------------------------------- */
void RRScreenInit(GtkWidget *mainwin, GtkWidget *screen, gint w, gint h)
{
  /* size keep */
  screen_w = w;
  screen_h = h;
  window = mainwin;
  win_mask = NULL;
  win_pal = NULL;

  /* ɥ֥륨ꥢ */
  canvas = screen;

  /* ֥Хåե */
  pixmap[0] = gdk_pixmap_new(window->window, w, h, -1);
  pixmap[1] = gdk_pixmap_new(window->window, w, h, -1);
  win_gc[0] = gdk_gc_new(pixmap[0]);
  win_gc[1] = gdk_gc_new(pixmap[1]);
  win_gc[2] = gdk_gc_new(canvas->window);
  page = 1;
  RRScreenClear(0, 0, 0);
  page = 0;
  RRScreenClear(0, 0, 0);
  drawmemo_x = drawmemo_y = -1;
  drawmemo_w = drawmemo_h = 0;

  /* ¾ */
  font_x = font_y = 0;
}


/* -------------------------------------------------------------
  RRScreenFree       -- ̼곫

   return : void
   void
-------------------------------------------------------------- */
void       RRScreenFree(void)
{
  gdk_pixmap_unref(pixmap[0]);
  gdk_pixmap_unref(pixmap[1]);
  gdk_gc_destroy(win_gc[0]);
  gdk_gc_destroy(win_gc[1]);
  gdk_gc_destroy(win_gc[2]);
}


/* -------------------------------------------------------------
  RRScreenSwitch     -- ֥Хåեؤ

   return : ߤν񤭹߲ǽХåեֹ(0-1)
   void
-------------------------------------------------------------- */
gint       RRScreenSwitch(void)
{
  /* -- Ѥäʬ򥢥åץǡ */
  if ((drawmemo_w > 0) && (drawmemo_h > 0)) {
    gdk_gc_set_clip_mask(win_gc[2], win_mask);
    gdk_gc_set_clip_origin(win_gc[2], 0, 0);
    gdk_draw_pixmap(canvas->window, win_gc[2], pixmap[page],
		    drawmemo_x, drawmemo_y,
		    drawmemo_x, drawmemo_y, drawmemo_w, drawmemo_h);
  }

  /* -- Ԥޤ礦 */
  page ^= 1;
  drawmemo_x = drawmemo_y = -1;
  drawmemo_w = drawmemo_h = 0;

  /* -- β̤򥳥ԡ */
  gdk_gc_set_clip_mask(win_gc[page], NULL);
  gdk_gc_set_clip_origin(win_gc[page], 0, 0);
  gdk_draw_pixmap(pixmap[page], win_gc[page], pixmap[(page^1)],
		  drawmemo_x, drawmemo_y,
		  drawmemo_x, drawmemo_y, drawmemo_w, drawmemo_h);

  /* -- Window SHape */
  if (win_mask != win_mask_current) {
    win_mask_current = win_mask;
    gtk_widget_shape_combine_mask(window, win_mask, 0, 0); 
  }

  return(page);
}


/* -------------------------------------------------------------
  RRScreenRedraw     -- Expose Event Ǥβ̥ɥ

   ꥿ expose event ˽ऺ
-------------------------------------------------------------- */
gboolean   RRScreenRedraw(GtkWidget *win, GdkEventExpose *expose,
			  gpointer user_data)
{
  gdk_gc_set_clip_mask(win_gc[(page^1)], NULL);
  gdk_gc_set_clip_origin(win_gc[(page^1)], 0, 0);
  gdk_draw_pixmap(canvas->window, win_gc[(page^1)], pixmap[(page^1)], 
		  expose->area.x, expose->area.y,
		  expose->area.x, expose->area.y,
		  expose->area.width, expose->area.height);

  if (win_pal != NULL) {
    gdk_window_set_colormap(window->window, win_pal);
  }

  return(FALSE);
}


/* -------------------------------------------------------------
  RRScreenBufNum     -- ֥Хåեν񤭹߲ǽڡ

   return : ߤν񤭹߲ǽХåեֹ(0-1)
   void
-------------------------------------------------------------- */
gint       RRScreenBufNum(void)
{
  return(page);
}


/* -------------------------------------------------------------
  RRScreenBuffer     -- ߤν񤭹߲ǽ Pixmap ֤

   return : ߤν񤭹߲ǽPixmap pointera
   void
-------------------------------------------------------------- */
GdkPixmap *RRScreenBuffer(void)
{
  return(pixmap[page]);
}


/* -------------------------------------------------------------
  RRScreenCanvas     -- ɽåȤȤʤ drawable ֤

   return : ɽåȥå
   void
-------------------------------------------------------------- */
GtkWidget *RRScreenCanvas(void)
{
  return(canvas);
}


/* -------------------------------------------------------------
  RRScreenWindow     -- ɽåȤȤʤ륦ɥ֤

   return : ɽåȥå
   void
-------------------------------------------------------------- */
GtkWidget *RRScreenWindow(void)
{
  return(window);
}


/* -------------------------------------------------------------
  RRScreenWinShape    -- ɽɥηޥ

   return : void
   shape  ɥΥޥBitmap
-------------------------------------------------------------- */
void RRScreenWinShape(GdkBitmap *shape)
{
  win_mask = shape;
}


/* -------------------------------------------------------------
  RRScreenSetPalette       -- ǥå顼

   return : void
   shape  ɥΥޥBitmap
-------------------------------------------------------------- */
void RRScreenSetPalette(GdkColormap *col, gint n)
{
  if (win_pal != col) {
    win_pal = col;
    win_pal_n = n;
    gdk_window_set_colormap(window->window, win_pal);
  }
}


/* -------------------------------------------------------------
  RRScreenGCColor    -- GC Υ顼ꤹ

   return : void
   r, g, b - λ
-------------------------------------------------------------- */
void       RRScreenGCColor(gint r, gint g, gint b)
{
  GdkColor  col;

  col.red = r;
  col.green = g;
  col.blue = b;
  gdk_color_alloc(gdk_colormap_get_system()  ,&col);
  gdk_gc_set_foreground(win_gc[page], &col);
}


/* -------------------------------------------------------------
  RRScreenGCGet      -- GC 

   return : void
   void
-------------------------------------------------------------- */
GdkGC     *RRScreenGCGet(void)
{
  return(win_gc[page]);
}


/* -------------------------------------------------------------
  RRScreenClear      -- 襹꡼ñɤĤ֤

   return : void
   r, g, b - λ
-------------------------------------------------------------- */
void       RRScreenClear(gint r, gint g, gint b)
{
  RRScreenGCColor(r, g, b);
  gdk_draw_rectangle(pixmap[page], win_gc[page], TRUE,
		     0, 0, screen_w, screen_h);
  drawmemo_x = drawmemo_y = 0;
  drawmemo_w = screen_w;
  drawmemo_h = screen_h;
}


/* -------------------------------------------------------------
  RRScreenFontSetDirect  -- եľܻ

   return : void
   font - եȥݥ
-------------------------------------------------------------- */
void       RRScreenFontSetDirect(GdkFont *font)
{
  sfont1 = font;
}


/* -------------------------------------------------------------
  RRScreenFontSetInit   -- եȤλʤ

   return : void
   fontname - եȥå̾
-------------------------------------------------------------- */
void       RRScreenFontSetInit(gchar *fontname)
{
  sfont1 = gdk_fontset_load(fontname);
}


/* -------------------------------------------------------------
  RRScreenFontInit   -- եȤλʤ

   return : void
   fontname - եȥå̾
-------------------------------------------------------------- */
void       RRScreenFontInit(gchar *fontname)
{
  sfont1 = gdk_font_load(fontname);
}


/* -------------------------------------------------------------
  RRScreenFontLocate -- եȤֻ

   return : void
   x, y - ɸλ
-------------------------------------------------------------- */
void       RRScreenFontLocate(gint x, gint y)
{
  font_x = x;
  font_y = y;
}


/* -------------------------------------------------------------
  RRScreenFontSize -- ɽʸνĲ

   return : void
   disp - ʸ
   *w, *h - 
-------------------------------------------------------------- */
void       RRScreenFontSize(gchar *disp, gint *w, gint *h)
{
  *w = gdk_string_width(sfont1, disp);
  *h = gdk_string_height(sfont1, disp);
}


/* -------------------------------------------------------------
  RRScreenFontPrint  -- ʸɽ

   return : void
   disp - ɸλ
-------------------------------------------------------------- */
void       RRScreenFontPrint(gchar *disp)
{
  gint  w, h;

  w = gdk_string_width(sfont1, disp);
  h = gdk_string_height(sfont1, disp);
  gdk_draw_string(pixmap[page], sfont1, win_gc[page],
		  font_x, font_y+h-1, disp);
  /* -- ѤäꥢεϿ */
  if ((drawmemo_x < 0) || (drawmemo_x > font_x)) drawmemo_x = font_x;
  if ((drawmemo_y < 0) || (drawmemo_y > (font_y-1))) drawmemo_y = font_y-1;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < (font_x + w))) {
    drawmemo_w = (font_x + w) - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < (font_y + h))) {
    drawmemo_h = (font_y + h) - drawmemo_y;
  }
  /* -- ɽ֤ʤ */
  if ((font_x += w) > screen_w) {
    font_x = 0;
    if ((font_y += h) > screen_h) {
      font_y = 0;
    }
  }
}


/* -------------------------------------------------------------
  RRScreenFontPrintDirect  -- Pixmapʸɽ

   return : void
   disp - ɸλ
-------------------------------------------------------------- */
void       RRScreenFontPrintDirect(GdkPixmap *target, gchar *disp)
{
  gint  w, h;

  w = gdk_string_width(sfont1, disp);
  h = gdk_string_height(sfont1, disp);
  gdk_draw_string(target, sfont1, gdk_gc_new(target),
		  font_x, font_y+h-1, disp);
}


/* -------------------------------------------------------------
  RRScreenPutPixmap  -- 襹꡼Pixmapɽ

   return : void
   picture - žɽ
   x, y - ɽ֥եå
-------------------------------------------------------------- */
void       RRScreenPutPixmap(GdkPixmap *picture,  gint x, gint y)
{
  gint  w, h;

  gdk_window_get_size(picture, &w, &h);
  gdk_gc_set_clip_mask(win_gc[page], NULL);
  gdk_gc_set_clip_origin(win_gc[page], x, y);
  gdk_draw_pixmap(pixmap[page], win_gc[page], picture, 0, 0,
		  x, y, w, h);
  /* -- ѤäꥢεϿ */
  if ((drawmemo_x < 0) || (drawmemo_x > x)) drawmemo_x = x;
  if ((drawmemo_y < 0) || (drawmemo_y > y)) drawmemo_y = y;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < (x + w))) {
    drawmemo_w = (x + w) - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < (y + h))) {
    drawmemo_h = (y + h) - drawmemo_y;
  }
}


/* -------------------------------------------------------------
  RRScreenObjPut           -- Objectɽ

   return : void
   spr - žɽץ饤Ȥξ¤
-------------------------------------------------------------- */
void       RRScreenObjPut(RRSprite *spr)
{
  gint  w, h, x, y, ox, oy;

  if (spr->sw == FALSE) return;

  x = spr->x - spr->offset_x;
  y = spr->y - spr->offset_y;
  w = spr->w;
  h = spr->h;
  /* -- ϰϥå */
  if ((((x+w) < 0) || (x > screen_w) || ((y+h) < 0) || (y > screen_h)) == FALSE) {
    ox = spr->ox;
    oy = spr->oy;
    /* -- Ϥ߽Фå */
    if (x < 0) {
      ox -= x;
      w += x;
      x = 0;
    }
    if (y < 0) {
      oy -= y;
      h += y;
      y = 0;
    }
    if ((x+w) > screen_w) {
      w -= ((x+w) - screen_w);
    }
    if ((y+h) > screen_h) {
      h -= ((y+h) - screen_h);
    }
    /* -- åץޥ */
    gdk_gc_set_clip_mask(win_gc[page], spr->objmask);
    gdk_gc_set_clip_origin(win_gc[page], x-ox, y-oy);
    /* -- Obj  */
    gdk_draw_pixmap(pixmap[page], win_gc[page], spr->objmap, ox, oy,
		    x, y, w, h);
    /* -- ѤäꥢεϿ */
    if ((drawmemo_x < 0) || (drawmemo_x > x)) drawmemo_x = x;
    if ((drawmemo_y < 0) || (drawmemo_y > y)) drawmemo_y = y;
    if ((drawmemo_w == 0) ||
	((drawmemo_w + drawmemo_x) < (x + w))) {
      drawmemo_w = (x + w) - drawmemo_x;
    }
    if ((drawmemo_h == 0) ||
	((drawmemo_h + drawmemo_y) < (y + h))) {
      drawmemo_h = (y + h) - drawmemo_y;
    }
  }
}



/* -------------------------------------------------------------
  RRScreenPoint            -- ɽ

   return : void
   x, y - Ǥĺɸ
-------------------------------------------------------------- */
void       RRScreenPoint(gint x, gint y)
{
  gdk_draw_point(pixmap[page], win_gc[page], x, y);
  /* -- ѤäꥢεϿ */
  if (x < drawmemo_x) drawmemo_x = x;
  if (y < drawmemo_y) drawmemo_y = y;
  if (x > (drawmemo_x + drawmemo_w)) drawmemo_w = x - drawmemo_x;
  if (y > (drawmemo_y + drawmemo_h)) drawmemo_h = y - drawmemo_y;
}

/* -------------------------------------------------------------
  RRScreenLine             -- 饤ɽ

   return : void
   x1, y1, x2, y2 - Ҥɸ
-------------------------------------------------------------- */
void       RRScreenLine(gint x1, gint y1, gint x2, gint y2)
{
  gdk_draw_line(pixmap[page], win_gc[page], x1, y1, x2, y2);
  /* -- ѤäꥢεϿ */
  if ((drawmemo_x < 0) || (drawmemo_x > x1)) drawmemo_x = x1;
  if ((drawmemo_y < 0) || (drawmemo_y > y1)) drawmemo_y = y1;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < x2)) {
    drawmemo_w = x2 - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < y2)) {
    drawmemo_h = y2 - drawmemo_y;
  }
}

/* -------------------------------------------------------------
  RRScreenRectangle        -- ͳѤɽ

   return : void
   x, y, w, h - Ҥɸ
-------------------------------------------------------------- */
void       RRScreenRectanlge(gint fill, gint x, gint y, gint w, gint h)
{
  gdk_draw_rectangle(pixmap[page], win_gc[page], fill, x, y, w, h);

  /* -- ѤäꥢεϿ */
  if ((drawmemo_x < 0) || (drawmemo_x > x)) drawmemo_x = x;
  if ((drawmemo_y < 0) || (drawmemo_y > y)) drawmemo_y = y;
  if ((drawmemo_w == 0) ||
      ((drawmemo_w + drawmemo_x) < (x + w))) {
    drawmemo_w = (x + w) - drawmemo_x;
  }
  if ((drawmemo_h == 0) ||
      ((drawmemo_h + drawmemo_y) < (y + h))) {
    drawmemo_h = (y + h) - drawmemo_y;
  }
}




/* -------------------------------------------------------------
  RRGetParts         -- åȾλ̾ҥåȤ֤

   return : void
   mainwin - õ widget
   name - õ widget name
-------------------------------------------------------------- */
GtkWidget *RRGetParts(GtkWidget *mainwin, gchar *name)
{
  GtkWidget *parts = NULL;
  GList *wlist, *tmp;
  gint  n, i;
  gint max;

  wlist = gtk_container_children(GTK_CONTAINER(mainwin));
  max = g_list_length(wlist);
  n = -1;
  for(i=0; i<max; i++) {
    tmp = g_list_nth(wlist, i);
    parts = GTK_WIDGET(tmp->data);
    if (strcmp((char*)gtk_widget_get_name(parts), name) == 0) {
      /* -- ߡĤ */
      n = i;
      break;
    }
  }
  if (n == -1) {
    parts = NULL;
  }

  return(parts);
}


