#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "rr_screen.h"
#include "rr_main.h"

void
on_mainwin_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


gboolean
on_mainwin_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  guint key;
  gchar *keytop;

  key = gdk_keyval_to_lower(event->keyval);
  keytop = gdk_keyval_name(key);
  if (keytop[0] == 'q') {
    gtk_main_quit();
  }
  return FALSE;
}


gboolean
on_mainwin_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GdkEventButton *event_button;

  if (event->type == GDK_BUTTON_PRESS) {
    event_button = (GdkEventButton *) event;
    if (event_button->button == 1) {
      RRMainDragStart();
      return TRUE;
    }
  }
  return FALSE;
}


gboolean
on_mainwin_button_release_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GdkEventButton *event_button;

  if (event->type == GDK_BUTTON_RELEASE) {
    event_button = (GdkEventButton *) event;
    if (event_button->button == 1) {
      RRMainDragEnd();
      return TRUE;
    }
  }
  return FALSE;
}


gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  return(RRScreenRedraw(widget, event, user_data));
}


gboolean
on_mainwin_motion_notify_event         (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  if (event->type == GDK_MOTION_NOTIFY) {
    RRMainDragMove();
    return TRUE;
  }
  return FALSE;
}

