import email
import os
import subprocess
import sys
import time

from aminer.events import EventHandlerInterface
from aminer.input import LogAtom


class StreamPrinterEventHandler(EventHandlerInterface):
  """This class implements an event record listener, that will
just print out data about the event to a stream, by default this
is stdout"""
  def __init__(self, aminerConfig, stream=sys.stdout):
    self.stream=stream

  def receiveEvent(self, eventType, eventMessage, sortedLogLines, eventData,
      eventSource):
    """Receive information about a detected event."""
    message='%s (%d lines)\n' % (eventMessage, len(sortedLogLines))
    for line in sortedLogLines:
      message+='  '+line+'\n'
    if eventData!=None:
      if isinstance(eventData, LogAtom):
        message+='  [%s/%s]' % (eventData.getTimestamp(), eventData.source)
        if eventData.parserMatch!=None:
          message+=' '+eventData.parserMatch.matchElement.annotateMatch('')+'\n'
      else:
        message+='  '+str(eventData)+'\n'
    print >>self.stream, '%s' % message
    self.stream.flush()
    return
