/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: friendedit.c,v 1.2 2001/07/14 05:56:17 martine Exp $
 */

#include <gtk/gtk.h>

#include <stdlib.h>

#include "friends.h"
#include "friendedit.h"
#include "network.h"
#include "dotconf.h"
#include "util.h"

typedef struct {
	GtkWidget *win;
	GtkWidget *eusername, *ebgcolor, *efgcolor;
	GtkWidget *toedit;	/* the entry widget that we're using the color
						   selector on */ 
	GtkWidget *colsel;	/* the color selector */

	friend *editfriend;
	int okclicked;
} friend_edit_dlg;

static void
update_preview(friend_edit_dlg *fed) {
	GdkColor fg, bg;
	GtkStyle *newstyle;
	int i;

	hex_to_gdkcolor(gtk_entry_get_text(GTK_ENTRY(fed->efgcolor)), &fg);
	hex_to_gdkcolor(gtk_entry_get_text(GTK_ENTRY(fed->ebgcolor)), &bg);

	newstyle = gtk_style_copy(gtk_widget_get_style(fed->eusername));
	for (i = 0; i < 5; i++) newstyle->bg_pixmap[i] = NULL;
	memcpy(&newstyle->fg[GTK_STATE_NORMAL], &fg, sizeof(GdkColor));
	memcpy(&newstyle->base[GTK_STATE_NORMAL], &bg, sizeof(GdkColor));
	gtk_widget_set_style(fed->eusername, newstyle);
	gtk_style_unref(newstyle);
}

static void 
color_entry_changed(GtkEntry *e, friend_edit_dlg *fed) {
	if (strlen(gtk_entry_get_text(e)) == 7) 
		update_preview(fed);
}

static void 
change_entry_color_picked(GtkWidget *w, friend_edit_dlg *fed)
{
	GtkWidget *colorsel = GTK_COLOR_SELECTION_DIALOG(fed->colsel)->colorsel;
	gdouble colors[4];
	char new_hex[10];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel), colors);

	color_to_hex(colors, new_hex);

	gtk_entry_set_text(GTK_ENTRY(fed->toedit), new_hex);
	gtk_widget_destroy(colorsel);
}

static gint change_entry_color_dlg(friend_edit_dlg *fed, const char *title)
{
	GtkColorSelectionDialog *colorseldlg;
	char *curcolor;

	fed->colsel = gtk_color_selection_dialog_new(title);
	colorseldlg = GTK_COLOR_SELECTION_DIALOG(fed->colsel);

	gtk_window_set_modal(GTK_WINDOW(fed->colsel), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(fed->colsel), 
			GTK_WINDOW(fed->win));
	lj_win_set_icon(fed->colsel);

	gtk_widget_hide(colorseldlg->help_button);

	gtk_signal_connect_object(GTK_OBJECT(colorseldlg->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
			GTK_OBJECT(fed->colsel));

	gtk_signal_connect(GTK_OBJECT(colorseldlg->ok_button),
			"clicked", GTK_SIGNAL_FUNC(change_entry_color_picked), fed);
	gtk_signal_connect_object(GTK_OBJECT(colorseldlg->ok_button),
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
			GTK_OBJECT(fed->colsel));

	curcolor = gtk_entry_get_text(GTK_ENTRY(fed->toedit));
	
	/* convert existing hex color to the color selection's color */
	if (strlen(curcolor) == 7 && curcolor[0] == '#') {
		gdouble colors[4];
		hex_to_color(curcolor, colors);
		gtk_color_selection_set_color(
				GTK_COLOR_SELECTION(colorseldlg->colorsel), colors); 
	}

	gtk_widget_show(fed->colsel);
	lj_win_set_icon(fed->colsel);
	return 0;
}

static void 
change_col_bg(GtkWidget *w, gpointer d)
{
	friend_edit_dlg *fed = d;
	fed->toedit = fed->ebgcolor;
	change_entry_color_dlg(fed, "Select Background Color");
}

static void 
change_col_fg(GtkWidget *w, gpointer d)
{
	friend_edit_dlg *fed = d;
	fed->toedit = fed->efgcolor;
	change_entry_color_dlg(fed, "Select Foreground Color");
}

static void add_the_friend(GtkWidget *w, friend_edit_dlg *fed)
{
	GHashTable *request, *result;
	int friends_added = 0;
	gchar *username, *name, *fg, *bg;

	request = net_request_new("editfriends");

	g_hash_table_insert(request, g_strdup("editfriend_add_1_user"),
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fed->eusername))));
	g_hash_table_insert(request, g_strdup("editfriend_add_1_fg"),
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fed->efgcolor))));
	g_hash_table_insert(request, g_strdup("editfriend_add_1_bg"),
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fed->ebgcolor))));

	result = net_request_run(fed->win, "Adding Friend...", request);
	hash_destroy(request);

	if (!net_request_succeeded(result)) {
		hash_destroy(result);
		return;
	}

	friends_added = atoi(g_hash_table_lookup(result, "friends_added"));
	if (friends_added != 1) {
		hash_destroy(result);
		return;
	}
	
	name = g_hash_table_lookup(result, "friend_1_name");
	username = g_hash_table_lookup(result, "friend_1_user");

	fg = gtk_entry_get_text(GTK_ENTRY(fed->efgcolor));
	bg = gtk_entry_get_text(GTK_ENTRY(fed->ebgcolor));

	if (fed->editfriend == NULL || 
			strcmp(fed->editfriend->username, username) != 0) {
		/* we must create a new friend */
		fed->editfriend = g_new0(friend, 1);
		fed->editfriend->conn = FRIEND_MY;
	}

	string_replace(&fed->editfriend->username, g_strdup(username));
	string_replace(&fed->editfriend->name, g_strdup(name));
	strcpy(fed->editfriend->foreground, fg);
	strcpy(fed->editfriend->background, bg);

	fed->okclicked = TRUE;
	gtk_widget_destroy(fed->win);

	hash_destroy(result);
}

static void
entry_changed(GtkEntry *entry, GtkWidget* button) {
	gtk_widget_set_sensitive(button, 
			(strlen(gtk_entry_get_text(entry)) > 0));
}


friend*
friend_edit_dlg_run(GtkWidget *parent, gboolean edit, friend *f) {
	friend_edit_dlg fed_actual = { 0 };
	friend_edit_dlg *fed = &fed_actual;
	GtkWidget *button;
	GtkWidget *table;

	memset(fed, 0, sizeof(friend_edit_dlg));
	fed->editfriend = f;

	fed->win = lj_dialog_new(parent, 
			edit ? "Edit Friend" : (f ? "Add This Friend" : "Add a Friend"),
			-1, -1);
	gtk_signal_connect(GTK_OBJECT(fed->win), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	/* make the table */
	table = lj_table_new(3, 3);

	/* make the labels in the left side of the table */
	lj_table_label(GTK_TABLE(table), 0, "Friend's username:");
	lj_table_label(GTK_TABLE(table), 1, "Text color:");
	lj_table_label(GTK_TABLE(table), 2, "Background color:");

	/* make the color selector buttons */
	button = gtk_button_new_with_label(" ... ");
	gtk_table_attach(GTK_TABLE(table), button, 2, 3, 1, 2, GTK_FILL, 0, 2, 2);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(change_col_fg), fed);
	button = gtk_button_new_with_label(" ... ");
	gtk_table_attach(GTK_TABLE(table), button, 2, 3, 2, 3, GTK_FILL, 0, 2, 2);	  
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(change_col_bg), fed);
		   
	/* make the text boxes on the right side of the table */
	fed->eusername = gtk_entry_new_with_max_length(18);
	if (edit) gtk_entry_set_editable(GTK_ENTRY(fed->eusername), FALSE);
	gtk_table_attach(GTK_TABLE(table), fed->eusername, 
			1, 2, 0, 1, GTK_FILL, 0, 2, 2);	
	gtk_widget_set_usize(fed->eusername, 100, -1);

	fed->efgcolor = gtk_entry_new_with_max_length(7);
	gtk_signal_connect(GTK_OBJECT(fed->efgcolor), "changed",
			GTK_SIGNAL_FUNC(color_entry_changed), fed);
	gtk_table_attach(GTK_TABLE(table), fed->efgcolor, 
			1, 2, 1, 2, GTK_FILL, 0, 2, 2);	
	gtk_widget_set_usize(fed->efgcolor, 100, -1);

	fed->ebgcolor = gtk_entry_new_with_max_length(7);
	gtk_signal_connect(GTK_OBJECT(fed->ebgcolor), "changed",
			GTK_SIGNAL_FUNC(color_entry_changed), fed);
	gtk_table_attach(GTK_TABLE(table), fed->ebgcolor, 
			1, 2, 2, 3, GTK_FILL, 0, 2, 2);	
	gtk_widget_set_usize(fed->ebgcolor, 100, -1);
	
	lj_dialog_set_contents(fed->win, table);

	button = lj_dialog_add_okcancel(fed->win, edit ? "  Change  " : "  Add  ",
			add_the_friend, fed);

	/* enable/disable the button based on name text */
	gtk_signal_connect(GTK_OBJECT(fed->eusername), "changed",
		GTK_SIGNAL_FUNC(entry_changed), button);

	/* fill in default values. */
	if (f) {
		gtk_entry_set_text(GTK_ENTRY(fed->eusername), f->username);
	} else {
		gtk_entry_set_text(GTK_ENTRY(fed->eusername), "");
		/* emit the "changed" signal, anyway. */
	}

	if (!edit) {
		gtk_entry_set_text(GTK_ENTRY(fed->efgcolor), "#000000");
		gtk_entry_set_text(GTK_ENTRY(fed->ebgcolor), "#FFFFFF");
	} else {
		gtk_entry_set_text(GTK_ENTRY(fed->efgcolor), f->foreground);
		gtk_entry_set_text(GTK_ENTRY(fed->ebgcolor), f->background);
	}

	gtk_widget_show(fed->win);

	gtk_main();

	if (fed->okclicked) {
		return fed->editfriend;
	} else {
		return NULL;
	}
}


