/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: link.c,v 1.5 2001/11/08 20:47:04 martine Exp $
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdktypes.h>
#include <stdio.h>
#include <string.h>
#include "util.h"
#include "dotconf.h"


typedef struct {
	GtkWidget *win;
	gboolean okclicked;
} link_dlg;

static void
ok_cb(GtkWidget *w, link_dlg *ldlg) {
	ldlg->okclicked = TRUE;
	gtk_widget_hide(ldlg->win);
}

static GtkWidget*
hbox_wrap(GtkWidget *w) {
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), w, FALSE, FALSE, 0);
	return hbox;
}

static void
focus_in_cb(GtkWidget *w, GdkEvent *e, GtkToggleButton *toggle) {
	if (toggle && !gtk_toggle_button_get_active(toggle)) {
		gtk_toggle_button_set_active(toggle, TRUE);
	}
	gtk_editable_select_region(GTK_EDITABLE(w), 0, -1);
}

void
link_dialog_run(GtkWidget *parent, GtkEditable *gtktext) {
	link_dlg ldlg_actual = {0};
	link_dlg *ldlg = &ldlg_actual;
	GtkWidget *vbox, *okbutton;
	GtkAccelGroup *accelgroup;

	GtkWidget *etext, *ruser, *euser, *rurl, *eurl;
	GtkWidget *ritemid, *eitemid;
	
	char *input;
	gint pos, end;

	input = gtk_editable_get_chars(gtktext, 
			gtktext->selection_start_pos, gtktext->selection_end_pos);

	ldlg->win = lj_dialog_new(parent, "Make Link", -1, -1);
	gtk_signal_connect(GTK_OBJECT(ldlg->win), "hide",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_signal_connect_object(GTK_OBJECT(ldlg->win), "delete-event",
			GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(ldlg->win));

	accelgroup = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(ldlg->win), accelgroup);

	vbox = gtk_vbox_new(FALSE, 10); {
		GtkWidget *subbox;

		subbox = gtk_hbox_new(FALSE, 5); {
			GtkWidget *label;
			label = gtk_label_new(NULL);
			gtk_label_parse_uline(GTK_LABEL(label), "Link _Text:");
			gtk_box_pack_start(GTK_BOX(subbox), label, FALSE, FALSE, 0);

			etext = gtk_entry_new();
			gtk_entry_set_text(GTK_ENTRY(etext), input);
			gtk_widget_add_accelerator(etext, "grab-focus", accelgroup,
					GDK_t, GDK_MOD1_MASK, 0);
			gtk_box_pack_start(GTK_BOX(subbox), etext, TRUE, TRUE, 0);

			gtk_signal_connect(GTK_OBJECT(etext), "focus-in-event",
					GTK_SIGNAL_FUNC(focus_in_cb), NULL);
		}
		gtk_box_pack_start(GTK_BOX(vbox), subbox, FALSE, FALSE, 0);

		subbox = gtk_vbox_new(FALSE, 0); {
			rurl = gtk_radio_button_new(NULL); {
				GtkWidget *label;
				label = gtk_label_new(NULL);
				gtk_label_parse_uline(GTK_LABEL(label), "UR_L:");
				gtk_container_add(GTK_CONTAINER(rurl), label);
			}
			gtk_box_pack_start(GTK_BOX(subbox), hbox_wrap(rurl), FALSE, FALSE, 0);

			eurl = gtk_entry_new();
			gtk_entry_set_text(GTK_ENTRY(eurl), input);
			gtk_widget_add_accelerator(eurl, "grab-focus", accelgroup,
					GDK_l, GDK_MOD1_MASK, 0);
			gtk_signal_connect(GTK_OBJECT(eurl), "focus-in-event",
					GTK_SIGNAL_FUNC(focus_in_cb), rurl);
			gtk_box_pack_start(GTK_BOX(subbox), eurl, TRUE, TRUE, 0);

			gtk_signal_connect_object(GTK_OBJECT(rurl), "focus-in-event",
					GTK_SIGNAL_FUNC(gtk_widget_grab_focus), GTK_OBJECT(eurl));
		}
		gtk_box_pack_start(GTK_BOX(vbox), subbox, FALSE, FALSE, 0);

		subbox = gtk_vbox_new(FALSE, 0); {
			GtkWidget *hbox;

			ruser = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(rurl)); {
				GtkWidget *label;
				label = gtk_label_new(NULL);
				gtk_label_parse_uline(GTK_LABEL(label), "LiveJournal _User:");
				gtk_container_add(GTK_CONTAINER(ruser), label);
			}
			gtk_box_pack_start(GTK_BOX(subbox), hbox_wrap(ruser), FALSE, FALSE, 0);

			hbox = gtk_hbox_new(FALSE, 0); {
				gtk_box_pack_start(GTK_BOX(hbox), 
						gtk_label_new(".../users/"),
						FALSE, FALSE, 0);

				euser = gtk_entry_new();
				gtk_entry_set_text(GTK_ENTRY(euser), input);
				gtk_widget_set_usize(euser, 75, -1);
				gtk_widget_add_accelerator(euser, "grab-focus", accelgroup,
						GDK_u, GDK_MOD1_MASK, 0);
				gtk_signal_connect(GTK_OBJECT(euser), "focus-in-event",
						GTK_SIGNAL_FUNC(focus_in_cb), ruser);
				gtk_box_pack_start(GTK_BOX(hbox), euser, TRUE, TRUE, 0);

				gtk_signal_connect_object(GTK_OBJECT(ruser), "focus-in-event",
						GTK_SIGNAL_FUNC(gtk_widget_grab_focus), GTK_OBJECT(euser));
			}
			gtk_box_pack_start(GTK_BOX(subbox), hbox, FALSE, FALSE, 0);
		}
		gtk_box_pack_start(GTK_BOX(vbox), subbox, FALSE, FALSE, 0);

		subbox = gtk_vbox_new(FALSE, 0); {
			GtkWidget *hbox;

			ritemid = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(rurl)); {
				GtkWidget *label;
				label = gtk_label_new(NULL);
				gtk_label_parse_uline(GTK_LABEL(label), "LiveJournal _Comment by itemid:");
				gtk_container_add(GTK_CONTAINER(ritemid), label);
			}
			gtk_box_pack_start(GTK_BOX(subbox), hbox_wrap(ritemid), FALSE, FALSE, 0);

			hbox = gtk_hbox_new(FALSE, 0); {
				gtk_box_pack_start(GTK_BOX(hbox), 
						gtk_label_new(".../talkread.bml?itemid="),
						FALSE, FALSE, 0);

				eitemid = gtk_entry_new();
				gtk_entry_set_text(GTK_ENTRY(eitemid), input);
				gtk_widget_set_usize(eitemid, 75, -1);
				gtk_widget_add_accelerator(eitemid, "grab-focus", accelgroup,
						GDK_c, GDK_MOD1_MASK, 0);
				gtk_signal_connect(GTK_OBJECT(eitemid), "focus-in-event",
						GTK_SIGNAL_FUNC(focus_in_cb), ritemid);
				gtk_box_pack_start(GTK_BOX(hbox), eitemid, TRUE, TRUE, 0);

				gtk_signal_connect_object(GTK_OBJECT(ritemid), "focus-in-event",
						GTK_SIGNAL_FUNC(gtk_widget_grab_focus), GTK_OBJECT(eitemid));
			}
			gtk_box_pack_start(GTK_BOX(subbox), hbox, FALSE, FALSE, 0);
		}
		gtk_box_pack_start(GTK_BOX(vbox), subbox, FALSE, FALSE, 0);
	}

	gtk_widget_grab_focus(euser);

	okbutton = lj_dialog_add_okcancel(ldlg->win, NULL, ok_cb, ldlg);
	gtk_signal_connect(GTK_OBJECT(etext), "activate",
			GTK_SIGNAL_FUNC(ok_cb), ldlg);
	gtk_signal_connect(GTK_OBJECT(euser), "activate",
			GTK_SIGNAL_FUNC(ok_cb), ldlg);
	gtk_signal_connect(GTK_OBJECT(eurl), "activate",
			GTK_SIGNAL_FUNC(ok_cb), ldlg);
	gtk_signal_connect(GTK_OBJECT(eitemid), "activate",
			GTK_SIGNAL_FUNC(ok_cb), ldlg);
	gtk_widget_add_accelerator(okbutton, "clicked", accelgroup,
			GDK_Return, 0, 0);
	lj_dialog_set_contents(ldlg->win, vbox);
	gtk_widget_show(ldlg->win);
	gtk_main();

	if (!ldlg->okclicked)
		return;

	pos = gtktext->selection_start_pos;
	end = gtktext->selection_end_pos;

	if (pos == end) {
		pos = gtktext->current_pos;
	} else {
		if (pos > end) {
			/* swap selection end order */
			gint t;
			t = pos;
			pos = end;
			end = t;
		}
		gtk_editable_delete_text(gtktext, pos, end);
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rurl))) {
		/* build a "url" link.  we can't anticipate how long it'll be. */
		char *link;
		link = g_strdup_printf("<a href=\"%s\">%s</a>",
				gtk_entry_get_text(GTK_ENTRY(eurl)), 
				gtk_entry_get_text(GTK_ENTRY(etext)));
		gtk_editable_insert_text(gtktext, link, strlen(link), &pos);
		g_free(link);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ruser))) {
		/* build a "friends" link */
		char *link;
		link = g_strdup_printf("<a href=\"%s/users/%s\">%s</a>",
				conf.ljserver,
				gtk_entry_get_text(GTK_ENTRY(euser)), 
				gtk_entry_get_text(GTK_ENTRY(etext)));
		gtk_editable_insert_text(gtktext, link, strlen(link), &pos);
		g_free(link);
	} else {
		char *link;
		link = g_strdup_printf("<a href=\"%s/talkread.bml?itemid=%s\">%s</a>",
				conf.ljserver,
				gtk_entry_get_text(GTK_ENTRY(eitemid)), 
				gtk_entry_get_text(GTK_ENTRY(etext)));
		gtk_editable_insert_text(gtktext, link, strlen(link), &pos);
		g_free(link);
	}
	
	gtk_widget_destroy(ldlg->win);
}
