/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: meta.h,v 1.5 2001/11/15 23:03:01 martine Exp $
 */

#ifndef meta_h
#define meta_h

#include <gtk/gtkoptionmenu.h>

enum {
	METADATA_MOOD,
	METADATA_MUSIC,
	METADATA_PREFORMAT,
	METADATA_COMMENTS,
	METADATA_PICKEYWORD,
	METADATA_BACKDATED,
	METADATACOUNT
};

typedef struct _metadata_item metadata_item;

/* the metadata information for a single metadata view.
 * used by both the main window and the history view.
 * it only knows about existing types of metadata. */

#define METAMGR(obj)  GTK_CHECK_CAST(obj, metamgr_get_type(), MetaMgr)

typedef struct _MetaMgr      MetaMgr;

struct _MetaMgr {
	GtkOptionMenu optionmenu;
	GtkBox *insertbox;
	metadata_item* items[METADATACOUNT];
};

guint          metamgr_get_type        (void);
GtkWidget*     metamgr_new             (GtkBox *insertbox);

extern void metamgr_append_to_request  (MetaMgr *mm, GHashTable* request);
extern void metamgr_clear              (MetaMgr *mm);
extern void metamgr_load_from_request  (MetaMgr *mm, GHashTable *request);

/*
extern void meta_preload(metadata_widget *mw, char *name, char *value);
extern void meta_preload_by_index(metadata_widget *mw, int idx, char *value);
extern int meta_index(char *name);
extern int meta_index_from_key(char *key);*/

#endif /* meta_h */

