/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: protocol.c,v 1.3 2002/01/29 04:51:25 martine Exp $
 */

#include <glib.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include "md5.h"
#include "util.h"
#include "protocol.h"
#include "convert.h"

GHashTable* 
lj_protocol_parse_response(char *res) {
	char *key, *val;
	char *de_val;
	GHashTable *hash = lj_protocol_hash_new();
	int read_keys = 0;

	while (*res != 0) {
		key = util_getline(res);
		res = util_skipline(res);
		if (*res) {
			val = util_getline(res);
			res = util_skipline(res);

			de_val = urldecode(val);

			if (conf.convertcharset == CONVERT_KOI2WIN)
				win2koi(de_val);

			g_hash_table_insert(hash, key, de_val);
			g_free(val);
			read_keys++;
		}
	}
	if (read_keys == 0) { /* error. */
		lj_protocol_hash_free(hash);
		return NULL;
	}
	return hash;
}

int 
lj_protocol_request_succeeded(GHashTable *result) {
	char *error;

	if (result == NULL) return 0;

	error = g_hash_table_lookup(result, "success");
	if (error == NULL) return 0;

	return (strcasecmp(error, "OK") == 0);
}

static void
md5_hash(char *src, char *dest) {
	struct cvs_MD5Context context;
	unsigned char checksum[16];
	int i;

	cvs_MD5Init(&context);
	cvs_MD5Update(&context, (const unsigned char*)src, strlen(src));
	cvs_MD5Final(checksum, &context);
	for (i = 0; i < 16; i++)
		sprintf(&dest[i*2], "%02x", (unsigned int)checksum[i]);
}

GHashTable*
lj_protocol_request_new(char *mode, char *username, char *password, char *usejournal) {
	unsigned char buf[33];

	GHashTable *request = lj_protocol_hash_new();

	g_hash_table_insert(request, g_strdup("mode"), g_strdup(mode));
	g_hash_table_insert(request, g_strdup("user"), g_strdup(username));
	if (usejournal)
		g_hash_table_insert(request, g_strdup("usejournal"), 
				g_strdup(usejournal));

	md5_hash(password, buf);
	g_hash_table_insert(request, g_strdup("hpassword"), g_strdup(buf));

	return request;
}

GHashTable*
lj_protocol_hash_new() {
	return g_hash_table_new(g_str_hash, g_str_equal);
}

static gint free_all_hash_cb(gpointer key, gpointer val, gpointer user_data) {
	g_free(key); g_free(val);
	return TRUE;
}

void
lj_protocol_hash_free(GHashTable *hash) {
	g_hash_table_foreach_remove(hash, free_all_hash_cb, NULL);
	g_hash_table_destroy(hash);
}
