/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

void lt_colorset_ansi() { /* this sets up color definitions for the output module */
	
	/* simple strcpy's to the appropriate variables			*/
	strcpy(color.red, 		"\033[0;31m");
	strcpy(color.brightred, 	"\033[1;31m");

	strcpy(color.green,		"\033[0;32m");
	strcpy(color.brightgreen,	"\033[1;32m");
	
	strcpy(color.yellow,		"\033[0;33m");
	strcpy(color.brightyellow,	"\033[1;33m");

	strcpy(color.blue,		"\033[0;34m");
	strcpy(color.brightblue,	"\033[1;34m");
	
	strcpy(color.magenta,		"\033[0;35m");
	strcpy(color.brightmagenta,	"\033[1;35m");
	
	strcpy(color.cyan,		"\033[0;36m");
	strcpy(color.brightcyan,	"\033[1;36m");
	
	/* we use actually the ANSI for bright black for dim white :)	*/
	strcpy(color.dimwhite,		"\033[1;30m");
	strcpy(color.white,		"\033[0;37m");
	strcpy(color.brightwhite,	"\033[1;37m");
        
	strcpy(color.end, 		"\033[0m");
	strcpy(color.unknown,		color.end);
	strcpy(color.beep,		"\a");
}

void lto_parse_ansi() {
	/* we put this here in a wrapper in case we want to add our own post-parsing later	*/
	parse_pmsg();
}

void lto_ansi() {

	/* parse the \033e escpae sequences into native ANSI	*/
	lto_parse_ansi();
	
	/* if it's a duplicate message, just print the "!" warning to screen	*/
	if(event.type != EVENT_UNKNOWN && cf.input == TRUE && 	cf.supdupes == TRUE && 
			strcmp(event.message, event.lmessage) == 0 && strcmp(event.source, event.lsource) == 0) {
		printf("!");
	} else {
		if(cf.input == TRUE) {
			printf("\n");
		}
		/* if this isn't the first message, print a \newline			*/
		/* print yee old message as parsed by the module in question	*/
		cf.input = TRUE;
		printf("%s", event.pmsg);
	}
	fflush(stdout);
}
