/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#define C_NONE               0
#define C_WHISPER            1
#define C_WHOIS              2
#define C_EMOTE              3
#define C_JOIN               4
#define C_SEND               5
#define C_HELP               6
#define C_BAN                7
#define C_BROWSE             8
#define C_CHLEVEL            9
#define C_CLEAR             10
#define C_CLOAK             11
#define C_CONN              12
#define C_DATAPORT          13
#define C_DISC              14
#define C_EMAIL             15
#define C_KICK              16
#define C_KILL              17
#define C_LEVEL             18
#define C_CHLIST            19
#define C_MOTD              20
#define C_MUZZLE            21
#define C_WALLOP            22
#define C_PART              23
#define C_PASSWORD          24
#define C_PING              25
#define C_QUIT              26
#define C_SPEED             27
#define C_STATS             28
#define C_TOPIC             29
#define C_UNBAN             30
#define C_UNMUZZLE          31
#define C_VERSION           32
#define C_SCHEME            33
#define C_ALIAS             34
#define C_AFK               35
#define C_PUBLIC            36
#define C_REPLY             37
#define C_PRIVATE           38
///////////////
///////////////
#define C_IGNORE            41
#define C_CHCLEAR           42
#define C_UNIGNORE          43
#define C_CHBAN             44
#define C_CHUNBAN           45
#define C_NUKE              46
#define C_UNNUKE            47
#define C_GLOBAL            48
#define C_CVERSION          49
#define C_ECHO              50
#define C_CHLIMIT           51
#define C_SPING             52
#define C_FRIEND            53
#define C_ENEMY             54
#define C_HOTADD            55
#define C_HOTREM            56
#define C_CLIENTINFO        58
#define C_GUSER             59
#define C_SCONFIG           60
#define C_CLONES            61
#define C_EXEC              62
#define C_RAINBOW           63
#define C_RAW               64
#define C_RCOLORS           65
#define C_REDIRECT          66
#define C_CYCLE             67
#define C_SRECONFIG         68
#define C_PRETEND           69
#define C_SEARCH            70
#ifdef TRAFFIC_DEBUG
#define C_TRAFFIC           99
#endif
#ifdef PROTOCOL_DEBUG
#define C_TEST            100
#endif
#define C_OP               101
#define C_DEOP             102
#define C_CHVOICE          103
#define C_CHUNVOICE        104
#define C_INVITE           106
#define C_CHMUZZLE         107
#define C_CHUNMUZZLE       108
#define C_USERMODE         109
#define C_SSTATS           110
#define C_CHMODE           111
#define C_CHWALLOP         112
#define C_KILLGHOST        113
#define C_LOCATE           114
#define C_CLIENTS          115
#define C_WHOWAS           116
#define C_SLINK            117
#define C_SDELINK          118
#define C_SREMOVE          119
#define C_SKILL            120
#define C_SRELOAD          121
#define C_MASSKILL         122
#define C_LINKS            123
#define C_SHISTOGRAM       124
#define C_REGISTER         125
#define C_LIMIT            126
#define C_ILINE            127
#define C_DLINE            128
#define C_ELINE            129

#define COMMAND(f) void f (char *data)

typedef enum
{
  F_CHAT,
  F_UMOD,
  F_INFO,
  F_MISC,
  F_CLIENT,
  F_OP,
  F_MOD,
  F_ADMIN
}
folder_t;

#define NO_FOLDERS          8

typedef struct
{
  char *name;			// name of the command
  char *syntax;			// syntax
  char *description;		// description or (see....) if alias
  user_level_t level;
  folder_t folder;
  int id;			// command id
  int is_alias;			// 1 if alias otherwise 0
   COMMAND((*handler));
}
command_t;

int command_new(int id, char *iname, char *syntax, char *ides,
		user_level_t ilevel, folder_t ifolder,
		COMMAND((*ihandler)));
int command_rename(int iid, char *iname);
GList *command_search(char *prefix);
command_t *command_is_command(char *iname);
char *command_get_alias_string(int id);
int command_make_alias(char *iname, char *alias);
void command_delete_alias_for(int id);
void command_delete_all();

void handle_lopster_command(char *data);

COMMAND(lopster_none);
COMMAND(lopster_whisper);
COMMAND(lopster_whois);
COMMAND(lopster_emote);
COMMAND(lopster_join);
COMMAND(lopster_raw);
COMMAND(lopster_help);
COMMAND(lopster_ban);
COMMAND(lopster_chlevel);
COMMAND(lopster_clear);
COMMAND(lopster_cloak);
COMMAND(lopster_conn);
COMMAND(lopster_dataport);
COMMAND(lopster_disc);
COMMAND(lopster_email);
COMMAND(lopster_kick);
COMMAND(lopster_kill);
COMMAND(lopster_level);
COMMAND(lopster_chlist);
COMMAND(lopster_motd);
COMMAND(lopster_muzzle);
COMMAND(lopster_wallop);
COMMAND(lopster_part);
COMMAND(lopster_password);
COMMAND(lopster_ping);
COMMAND(lopster_quit);
COMMAND(lopster_speed);
COMMAND(lopster_stats);
COMMAND(lopster_topic);
COMMAND(lopster_unban);
COMMAND(lopster_unmuzzle);
COMMAND(lopster_version);
COMMAND(lopster_scheme);
COMMAND(lopster_alias);
COMMAND(lopster_afk);
COMMAND(lopster_public);
COMMAND(lopster_reply);
COMMAND(lopster_private);
COMMAND(lopster_ignore);
COMMAND(lopster_chclear);
COMMAND(lopster_unignore);
COMMAND(lopster_chban);
COMMAND(lopster_chunban);
COMMAND(lopster_nuke);
COMMAND(lopster_unnuke);
COMMAND(lopster_global);
COMMAND(lopster_cversion);
COMMAND(lopster_echo);
COMMAND(lopster_chlimit);
COMMAND(lopster_sping);
COMMAND(lopster_friend);
COMMAND(lopster_enemy);
COMMAND(lopster_hotadd);
COMMAND(lopster_hotrem);
COMMAND(lopster_clientinfo);
COMMAND(lopster_guser);
COMMAND(lopster_sconfig);
COMMAND(lopster_clones);
COMMAND(lopster_op);
COMMAND(lopster_deop);
COMMAND(lopster_chvoice);
COMMAND(lopster_chunvoice);
COMMAND(lopster_links);
COMMAND(lopster_invite);
COMMAND(lopster_chmuzzle);
COMMAND(lopster_chunmuzzle);
COMMAND(lopster_usermode);
COMMAND(lopster_sstats);
COMMAND(lopster_chmode);
COMMAND(lopster_chwallop);
COMMAND(lopster_killghost);
COMMAND(lopster_locate);
COMMAND(lopster_clients);
COMMAND(lopster_exec);
COMMAND(lopster_whowas);
COMMAND(lopster_rainbow);
COMMAND(lopster_rcolors);
COMMAND(lopster_browse);
COMMAND(lopster_send);
COMMAND(lopster_slink);
COMMAND(lopster_sdelink);
COMMAND(lopster_sremove);
COMMAND(lopster_skill);
COMMAND(lopster_sreload);
COMMAND(lopster_masskill);
COMMAND(lopster_shistogram);
COMMAND(lopster_register);
COMMAND(lopster_redirect);
COMMAND(lopster_cycle);
COMMAND(lopster_limit);
COMMAND(lopster_iline);
COMMAND(lopster_dline);
COMMAND(lopster_eline);
COMMAND(lopster_sreconfig);
COMMAND(lopster_pretend);
/* COMMAND(lopster_search); */

#ifdef TRAFFIC_DEBUG
COMMAND(lopster_traffic);
#endif
#ifdef PROTOCOL_DEBUG
COMMAND(lopster_test);
#endif
