/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

GtkWidget *create_search_list_popup(file_t * file);

gint search_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);

char *Destination(int id);
char* LifeTime(int id);
int destination2int(char *dest);
void cmd_search_response(char *data);
void cmd_end_of_search();
file_t *file_create_from_search_response(char *data);
void send_search_request();
void send_search_again(search_t* search);
void file_insert_search(file_t * file, int destination);

void napster_search(search_t * search);

search_pattern_t *search_pattern_new();
int search_pattern_fits_file(search_pattern_t * search, file_t * file,
			     int with_type);
void search_pattern_load();
void search_pattern_save();
search_pattern_t *search_pattern_copy(search_pattern_t * search);
void search_pattern_show(search_pattern_t * search);

search_t *search_new();
void search_clear(search_t * search);
void search_destroy(search_t * search);
void search_remove(search_t * search);
file_t *search_find_file(search_t * search, file_t * file);
void search_update_stats(search_t * search, int check);
void search_update_counter();
GtkWidget *search_fields_detach();
GtkWidget *search_fields_detach2();
void search_search(search_t * pattern);
void search_queue(search_t * search);
int search_unqueue(search_t * search);
void search_do(search_t * search);
void search_finish(search_t* search);
void search_next();
search_t* search_finish_oldest(int latest);
void search_insert_file(search_t* search, file_t * file);
void search_insert_file_real(GtkCList* clist, file_t * file);

void search_pattern_rename(search_pattern_t* pattern);
void search_pattern_search(search_pattern_t* pattern);
GtkWidget *create_search_pattern_popup(search_pattern_t *pattern);
