/* Copyright (C) 2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_WHITE_BOARD

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "log.h"
#include "commands.h"
#include "chat.h"
#include "handler.h"
#include "whiteboard.h"

#define WHITEBOARD_DEBUG
#define WB_DELIM_CHAR '\002'

gint whiteboard_get_input(gpointer data, gint source,
			  GdkInputCondition condition)
{
  /*
  char buf[MAX_GET + 1];
  int n, n2;
  socket_t *socket = data;
  whiteboard_t *wb = socket->data;
  char *cmp_buf;
#ifdef TRANSFER_DEBUG
  int cnt;
#endif
  long maxget;

  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, &(SocketStatus[S_INCOMPLETE]));
    return 1;
  }

  maxget = download_calc_max(socket);
  if (!maxget) return 1;

  //  if (global.down_width.current > global.down_width.limit) return 1;
  bzero(buf, sizeof(buf));
  n = recv(source, buf, maxget, 0);
  if (n <= 0) {
    if (transfer->progress >= transfer->size) {
      socket_destroy(socket, &(SocketStatus[S_FINISHED]));
    } else {
      socket_destroy(socket, &(SocketStatus[S_INCOMPLETE]));
    }
    return 0;
  }
  */
  return 0;
}

gint whiteboard_get_info(gpointer data, gint source,
			 GdkInputCondition condition)
{
  char buffer[1025];
  int cnt;
  socket_t *socket = (socket_t *) data;
  char *user;
  char *wb_name;
  whiteboard_t* wb;
  wb_user_t* wb_user;

  gdk_input_remove(socket->input);

  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, 0);
    return 1;
  }

  cnt = 0;
  switch (cnt = recv(source, buffer, 1024, 0)) {
  case -1:
    socket_destroy(socket, 0);
    return 1;
  case 0:
    socket_destroy(socket, 0);
    return 1;
  default:
    break;
  }

  buffer[cnt] = 0;
#ifdef WHITEBOARD_DEBUG
  printf(" [%s]\n", buffer);
#endif

  user = arg(buffer, 0);
  wb_name = arg(NULL, 0);
  if (!user || !wb_name) {
    socket_destroy(socket, 0);
    return 1;
  }
#ifdef WHITEBOARD_DEBUG
  printf("whiteboard [%s][%s]\n", user, wb_name);
#endif
  wb = whiteboard_search(wb_name);
  if (!wb) {
    send_private(user, "whiteboard does not exist", 1);
    socket_destroy(socket, 0);
    return 1;
  }
  wb_user = whiteboard_is_invited(wb, user);
  if (!wb_user) {
    send_private(user, "you are not invited", 1);
    socket_destroy(socket, 0);
    return 1;
  }
  if (wb_user->socket) {
    send_private(user, "you are already connected", 1);
    socket_destroy(socket, 0);
    return 1;
  }
  
  wb_user->socket = socket;
  socket->data = wb;

  // submit user's level
  // submit whiteboard size
  // submit whiteboard contents
  // notify other peers

  // now start socket reader
  socket->input =
    gdk_input_add(socket->fd, GDK_INPUT_READ,
		  GTK_SIGNAL_FUNC(whiteboard_get_input), socket);
  return 1;
}

gint whiteboard_send_info(gpointer data, gint source,
			  GdkInputCondition condition)
{
  char *temp_str = NULL;
  socket_t *socket;
  whiteboard_t* wb;

  socket = data;
  wb = socket->data;

  if (condition != GDK_INPUT_WRITE) {
    socket_destroy(socket, NULL);
    return 1;
  }

  gdk_input_remove(socket->input);

#ifdef WHITEBOARD_DEBUG
  printf("sending [WB_JOIN]\n");
#endif
  send(source, "WB_JOIN", 7, 0);
  temp_str = l_strdup_printf("%s \"%s\"", SERVER->nick, wb->name);

#ifdef WHITEBOARD_DEBUG
  printf("sending [%s]\n", temp_str);
#endif
  send(source, temp_str, strlen(temp_str), 0);
  l_free(temp_str);

  socket->input =
    gdk_input_add(socket->fd, GDK_INPUT_READ,
		  GTK_SIGNAL_FUNC(whiteboard_get_input), socket);
  
  return 1;
}

gint await_wb_conn_ack(gpointer data, gint source,
		       GdkInputCondition condition)
{
  int res;
  char c;
  socket_t *socket = data;

  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, NULL);
    return 1;
  }

  gdk_input_remove(socket->input);

  switch (res = recv(source, &c, 1, 0)) {
  case -1:
#ifdef WHITEBOARD_DEBUG
    printf("rec1 error\n");
#endif
    socket_destroy(socket, NULL);
    return 1;
  case 0:
#ifdef WHITEBOARD_DEBUG
    printf("received nothing\n");
#endif
    socket_destroy(socket, NULL);
    return 1;
  default:
    break;
  }

#ifdef WHITEBOARD_DEBUG
  printf("got [%c]\n", c);
#endif
  if (c != '1') {
    socket_destroy(socket, NULL);
    return 1;
  }

  socket->input =
      gdk_input_add(socket->fd, GDK_INPUT_WRITE,
		    GTK_SIGNAL_FUNC(whiteboard_send_info), socket);

  return 1;
}

void whiteboard_connect(socket_t * socket)
{
  if (!connect_socket(socket, "TCP", SOCK_STREAM)) {
    printf("could not connect to whiteboard\n");
    return;
  }

  socket->input =
    gdk_input_add(socket->fd, GDK_INPUT_READ,
		  GTK_SIGNAL_FUNC(await_wb_conn_ack), socket);
}


///////////////
GtkWidget* whiteboard_create(whiteboard_t* wb) {
  // create gui now.....
  return NULL;
}

whiteboard_t* whiteboard_new(char* name) {
  whiteboard_t* wb;

  wb = malloc(sizeof(whiteboard_t));
  wb->users = NULL;
  wb->level = WHITEBOARD_HOST;
  wb->name = strdup(name);
  wb->sizex = 700;
  wb->sizey = 500;
  wb->objects = NULL;
  wb->widget = whiteboard_create(wb);   // create_widget here
  global.whiteboards = g_list_append(global.whiteboards, wb);
  return wb;
}

whiteboard_t* whiteboard_search(char* name) {
  GList* dlist;
  whiteboard_t* wb;

  for (dlist = global.whiteboards; dlist; dlist = dlist->next) {
    wb = dlist->data;
    if (!strcmp(wb->name, name)) return wb;
  }
  return NULL;
}

wb_user_t* whiteboard_is_invited(whiteboard_t* wb, char* user) {
  GList* dlist;
  wb_user_t* wb_user;

  for (dlist = wb->users; dlist; dlist = dlist->next) {
    wb_user = dlist->data;
    if (!l_strcasecmp(wb_user->name, user)) return wb_user;
  }
  return NULL;
}

void whiteboard_invite_user(whiteboard_t* wb, char* user, int level) {
  wb_user_t* wb_user;
  char* message;
  unsigned long ip_long;
  struct sockaddr_in localaddr;
  int len = sizeof(struct sockaddr_in);

  if (wb->level < WHITEBOARD_HOST) return;
  
  if (whiteboard_is_invited(wb, user)) return;

  wb_user = malloc(sizeof(wb_user_t));
  wb_user->name = strdup(user);
  wb_user->level = level;
  wb_user->socket = NULL;
  wb->users = g_list_append(wb->users, wb_user);

  getsockname(global.napster->fd, (struct sockaddr *)&localaddr, &len);
  ip_long = (unsigned long) BSWAP32(localaddr.sin_addr.s_addr);
  if (global.my_ip && (global.my_ip != ip_long)) {
    client_message("Whiteboard", _("Lopster detected local ip [%s]"), ntoa(ip_long));
    client_message("Whitebaord", _("But the server browse reported ip [%s], using this one for Whiteboard"), ntoa(global.my_ip));
    ip_long = global.my_ip;
  }

  message = l_strdup_printf("%s %cINVITE \"%s\" %s %lu %d%c", 
			    user, WB_DELIM_CHAR, wb->name, SERVER->nick,
			    ip_long, global.network.port, WB_DELIM_CHAR);
  send_command(CMD_CLIENT_PRIVMSG, message);
  client_message("Whiteboard", _("Inviting <%s> to whitboard [%s]"),
		 user, wb->name);
  l_free(message);
}

void whiteboard_change_userlevel(whiteboard_t* wb, char* user, int level) {
  wb_user_t* wb_user;

  if (wb->level < WHITEBOARD_HOST) return;

  wb_user = whiteboard_is_invited(wb, user);
  if (!wb_user) return;

  wb_user->level = level;
  // report level to peers
}

int whiteboard_check_message(char *from, char *message)
{
  char *nick;
  char* wb_name;
  unsigned long ip_long;
  int port;
  char *command;
  whiteboard_t* wb;
  wb_user_t* user;

  if (!message || strlen(message) < 2)
    return 0;

  if (*message == WB_DELIM_CHAR &&
      message[strlen(message) - 1] == WB_DELIM_CHAR) {
    message++;
    message[strlen(message) - 1] = 0;

    command = arg(message, 0);
    if (command && strncmp(command, "INVITE", 4)) return 0;

    wb_name = arg(NULL, 0);
    nick = arg(NULL, 0);
    ip_long = strtoul(arg(NULL, 0), NULL, 10);
    port = atoi(arg(NULL, 0));

    client_message("Whiteboard", _("<%s> is inviting you to whiteboard %s"), nick, wb_name);
    if (port == 0) {
      client_message("Message", _("Peer is firewalled, can't connect to whiteboard"));
      return 1;
    }

    wb = whiteboard_new(wb_name);
    wb->level = WHITEBOARD_NOACCESS;

    user = malloc(sizeof(wb_user_t));
    user->name = strdup(nick);
    user->level = WHITEBOARD_READ;
    user->socket = socket_new(S_WHITEBOARD);
    user->socket->port = htons(port);
    user->socket->data = wb;
    user->socket->ip_long = BSWAP32(ip_long);
    wb->users = g_list_append(wb->users, user);
    
    whiteboard_connect(user->socket);
    return 1;
  }
  return 0;
}

void whiteboard_user_remove(whiteboard_t* wb, wb_user_t* wb_user) {
  wb->users = g_list_remove(wb->users, wb_user);

  // IMPLEMENT: remove from gui
  
  if (wb->level == WHITEBOARD_HOST) {
    // IMPLEMENT: notify other peers
  } else {
    // host has left.
    // IMPLEMENT: maybe set yourself to host, or deactivate whiteboard
  }

  l_free(wb_user->name);
  wb_user->socket = NULL;
  l_free(wb_user);
}

void whiteboard_socket_left(whiteboard_t* wb, socket_t* socket) {
  GList* dlist;
  wb_user_t* wb_user;

  for (dlist = wb->users; dlist; dlist = dlist->next) {
    wb_user = dlist->data;
    if (wb_user->socket == socket) {
      whiteboard_user_remove(wb, wb_user);
      break;
    }
  }
}

void whiteboard_send_user(wb_user_t* wb_user, gint command, void* data) {
  if (!wb_user) return;
  if (!wb_user->socket) return;
  // do something here.
}

void whiteboard_send_all(whiteboard_t* wb, gint command, void* data) {
  GList* dlist;
  wb_user_t* wb_user;

  for (dlist = wb->users; dlist; dlist = dlist->next) {
    wb_user = dlist->data;
    if (wb_user->socket)
      whiteboard_send_user(wb_user, command, data);
  }
}

#endif  /* ENABLE_WHITEBOARD */
