/* Copyright (C) 2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#define WHITEBOARD_NOACCESS     0
#define WHITEBOARD_READ         1
#define WHITEBOARD_READ_WRITE   2
#define WHITEBOARD_HOST         3

typedef struct _wb_user_t wb_user_t;
typedef struct _whiteboard_t whiteboard_t;

struct _wb_user_t {
  char* name;
  socket_t* socket;
  int level;
};

struct _whiteboard_t
{
  GList* users;         // connected and invited users
  int level;

  // whiteboard specification
  char* name;
  GtkWidget* widget;
  int sizex;
  int sizey;
  GList* objects;
};

gint whiteboard_get_input(gpointer data, gint source,
			  GdkInputCondition condition);
gint whiteboard_get_info(gpointer data, gint source,
			 GdkInputCondition condition);
gint whiteboard_send_info(gpointer data, gint source,
			  GdkInputCondition condition);
gint await_wb_conn_ack(gpointer data, gint source,
		       GdkInputCondition condition);
void whiteboard_connect(socket_t * socket);

GtkWidget* whiteboard_create(whiteboard_t* wb);
whiteboard_t* whiteboard_new(char* name);
whiteboard_t* whiteboard_search(char* name);
wb_user_t* whiteboard_is_invited(whiteboard_t* wb, char* user);
int whiteboard_check_message(char *from, char *message);
void whiteboard_invite_user(whiteboard_t* wb, char* user, int level);
void whiteboard_change_userlevel(whiteboard_t* wb, char* user, int level);
void whiteboard_socket_left(whiteboard_t* wb, socket_t* socket);
void whiteboard_send_user(wb_user_t* wb_user, gint command, void* data);
void whiteboard_send_all(whiteboard_t* wb, gint command, void* data);
