/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/utsname.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "wizard.h"
#include "string_list.h"

#define PAGES   5

int page;
GtkWidget *win;
int browse_mime;

void wizard_setup_page();
void wizard_print_help();
void wizard_apply_current();
int wizard_check_current();

void wizard_start()
{
  GtkWidget *temp;

  win = create_wizard();

  temp = lookup_widget(win, "label754");
  gtk_widget_set_style(temp, global.style[STYLE_PREF]);

  temp = lookup_widget(win, "label755");
  gtk_widget_set_style(temp, global.style[STYLE_LABEL]);
  temp = lookup_widget(win, "label756");
  gtk_widget_set_style(temp, global.style[STYLE_LABEL]);
  temp = lookup_widget(win, "label757");
  gtk_widget_set_style(temp, global.style[STYLE_LABEL]);
  temp = lookup_widget(win, "label760");
  gtk_widget_set_style(temp, global.style[STYLE_LABEL]);
  temp = lookup_widget(win, "label765");
  gtk_widget_set_style(temp, global.style[STYLE_LABEL]);

  page = 1;
  wizard_setup_page();

  gtk_my_widget_show(win);
}

void wizard_setup_page()
{
  GtkWidget *temp;
  GtkButton *button;

  temp = lookup_widget(win, "label754");
  switch (page) {
  case 1:
    gtk_label_set_text(GTK_LABEL(temp), _("User Settings"));
    break;
  case 2:
    gtk_label_set_text(GTK_LABEL(temp), _("Network Settings"));
    break;
  case 3:
    gtk_label_set_text(GTK_LABEL(temp), _("Suffixes for Mediatypes"));
    break;
  case 4:
    gtk_label_set_text(GTK_LABEL(temp), _("Download Paths"));
    break;
  case 5:
    gtk_label_set_text(GTK_LABEL(temp), _("Shared Folders"));
    break;
  }

  temp = lookup_widget(win, "button246");
  if (page == 1)
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);

  button = GTK_BUTTON(lookup_widget(win, "button247"));
  if (page == PAGES)
    gtk_label_set_text(GTK_LABEL(button->child), "Finish");
  else
    gtk_label_set_text(GTK_LABEL(button->child), "Next ->");

  wizard_print_help();
}

void wizard_previous()
{
  GtkWidget *temp;

  temp = lookup_widget(win, "notebook7");

  //  if (!wizard_check_current()) return;

  if (page > 1) {
    gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    page--;
  }

  wizard_setup_page();
}

void wizard_next()
{
  GtkWidget *temp;

  temp = lookup_widget(win, "notebook7");

  if (!wizard_check_current())
    return;
  wizard_apply_current();

  if (page < PAGES) {
    gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    page++;
    wizard_setup_page();
  } else {
    wizard_finish();
  }
}

void wizard_finish()
{
  server_t *server;

  autojoin_add("Lopster");

  server = server_new();
  server_set_address(server, "server.napster.com");
  server->port = 8875;
  server_set_description(server, "Official Meta Server");
  server->meta = 1;
  server->nick = NULL;
  server->passwd = NULL;
  server_set_nick(server, global.user.username);
  server_set_passwd(server, global.user.password);
  add_server_to_list(server);

  server = server_new();
  server_set_address(server, "server5.dtype.org");
  server->port = 8888;
  server_set_description(server, "OggVorbis Network");
  server->meta = 0;
  server->nick = NULL;
  server->passwd = NULL;
  server_set_nick(server, global.user.username);
  server_set_passwd(server, global.user.password);
  add_server_to_list(server);

  command_make_alias("msg", "whisper");
  command_make_alias("join", "j");
  command_make_alias("part", "p");
  command_make_alias("me", "emote");
  command_make_alias("away", "afk");

  if (global.incomplete_path)
    create_dir(global.incomplete_path);

  write_rc();
  lib_refresh();

  gtk_widget_destroy(win);
}

int wizard_check_current()
{
  GtkWidget *temp;
  char *text;
  char *text2;

  switch (page) {
  case 1:
    temp = lookup_widget(win, "entry86");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (strlen(text) < 2)
      return 0;
    if (strchr(text, ' '))
      return 0;

    temp = lookup_widget(win, "entry87");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    temp = lookup_widget(win, "entry88");
    text2 = gtk_entry_get_text(GTK_ENTRY(temp));
    if (strcmp(text, text2))
      return 0;
    if (strchr(text, ' '))
      return 0;
    return 1;
    break;
  case 2:
  case 3:
    return 1;
    break;
  case 4:
    temp = lookup_widget(win, "entry90");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    temp = lookup_widget(win, "entry91");
    text2 = gtk_entry_get_text(GTK_ENTRY(temp));
    if (strlen(text) < 1)
      return 0;
    if (strlen(text2) < 1)
      return 0;
    return 1;
    break;
  case 5:
  default:
    return 1;
    break;
  }
  return 1;
}

void wizard_apply_current()
{
  GtkWidget *temp;
  char *text;
  char *text2;
  suffix_t *suffix;
  int mime, i1;

  switch (page) {
  case 1:
    temp = lookup_widget(win, "entry86");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    temp = lookup_widget(win, "entry87");
    text2 = gtk_entry_get_text(GTK_ENTRY(temp));
    strcpy(global.user.username, text);
    strcpy(global.user.password, text2);
    break;
  case 2:
    temp = lookup_widget(win, "entry89");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    global.user.linespeed = speed2int(text);
    temp = lookup_widget(win, "checkbutton67");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      global.network.firewall = 1;
    } else
      global.network.firewall = 0;
    temp = lookup_widget(win, "spinbutton57");
    i1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    create_upload_port(i1, TRUE);
    break;
  case 3:
    clear_suffixes();
    temp = lookup_widget(win, "entry99");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 1;
      global.mimetype[MIME_MP3].suffixes =
	  g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    temp = lookup_widget(win, "entry100");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_VIDEO].suffixes =
	  g_list_append(global.mimetype[MIME_VIDEO].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    temp = lookup_widget(win, "entry101");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_AUDIO].suffixes =
	  g_list_append(global.mimetype[MIME_AUDIO].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    temp = lookup_widget(win, "entry102");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_APPLICATION].suffixes =
	  g_list_append(global.mimetype[MIME_APPLICATION].suffixes,
			suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    temp = lookup_widget(win, "entry103");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_IMAGE].suffixes =
	  g_list_append(global.mimetype[MIME_IMAGE].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    temp = lookup_widget(win, "entry104");
    text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
    text2 = arg(text, 0);
    while (text2) {
      suffix = (suffix_t *) malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_TEXT].suffixes =
	  g_list_append(global.mimetype[MIME_TEXT].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    break;
  case 4:
    temp = lookup_widget(win, "entry90");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.incomplete_path)
      l_free(global.incomplete_path);
    global.incomplete_path = l_strdup(text);
    temp = lookup_widget(win, "entry91");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_MP3].download)
      l_free(global.mimetype[MIME_MP3].download);
    global.mimetype[MIME_MP3].download = l_strdup(text);
    temp = lookup_widget(win, "entry92");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_VIDEO].download)
      l_free(global.mimetype[MIME_VIDEO].download);
    global.mimetype[MIME_VIDEO].download = l_strdup(text);
    temp = lookup_widget(win, "entry93");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_AUDIO].download)
      l_free(global.mimetype[MIME_AUDIO].download);
    global.mimetype[MIME_AUDIO].download = l_strdup(text);
    temp = lookup_widget(win, "entry94");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_APPLICATION].download)
      l_free(global.mimetype[MIME_APPLICATION].download);
    global.mimetype[MIME_APPLICATION].download = l_strdup(text);
    temp = lookup_widget(win, "entry95");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_IMAGE].download)
      l_free(global.mimetype[MIME_IMAGE].download);
    global.mimetype[MIME_IMAGE].download = l_strdup(text);
    temp = lookup_widget(win, "entry96");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_TEXT].download)
      l_free(global.mimetype[MIME_TEXT].download);
    global.mimetype[MIME_TEXT].download = l_strdup(text);
    temp = lookup_widget(win, "entry97");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (global.mimetype[MIME_NONE].download)
      l_free(global.mimetype[MIME_NONE].download);
    global.mimetype[MIME_NONE].download = l_strdup(text);
    break;
  case 5:
    clear_shared_folder();
    temp = lookup_widget(win, "clist22");
    for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
      gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &text);
      mime = mime2int(text);
      gtk_clist_get_text(GTK_CLIST(temp), i1, 1, &text);
      text2 = l_strdup(text);
      if (text2[strlen(text2) - 1] == '/')
	text2[strlen(text2) - 1] = 0;
      global.mimetype[mime].shared =
	  g_list_append(global.mimetype[mime].shared, text2);
    }
    break;
  }
}

void wizard_help()
{
  GtkWidget *temp;
  GtkButton *button;

  temp = lookup_widget(win, "frame276");
  button = GTK_BUTTON(lookup_widget(win, "button264"));

  if (GTK_WIDGET_VISIBLE(temp)) {
    gtk_widget_hide(temp);
    gtk_label_set_text(GTK_LABEL(button->child), _("Show Help"));
  } else {
    gtk_widget_show(temp);
    gtk_label_set_text(GTK_LABEL(button->child), _("Hide Help"));
  }
}

void wizard_print_help()
{
  GtkWidget *temp;

  temp = lookup_widget(win, "label781");
  switch (page) {
  case 1:
    gtk_label_set_text(GTK_LABEL(temp),
		       _
		       ("Just enter a username and a password, make sure that you do not include spaces!"));
    break;
  case 2:
    gtk_label_set_text(GTK_LABEL(temp),
		       _
		       ("The specified linespeed will be shown to others, if they request your information. It is not important to select the correct speed, but it would be fair to the others.\nYou may set the dataport to every port that is reachable for the rest of the world, if there is no such port (firewalled), then select 0 instead."));
    break;
  case 3:
    gtk_label_set_text(GTK_LABEL(temp),
		       _
		       ("This are the file suffixes that will be known by Lopster. You can bind each of them to an external application in the preferences later."));
    break;
  case 4:
    gtk_label_set_text(GTK_LABEL(temp),
		       _
		       ("Lopster needs to know where it should store the downloaded files. While downloading they will be saved in the incomplete Folder, when finished they will be moved to the folder according to its suffix. At least setup the folder for incomplete files and MP3 files."));
    break;
  case 5:
    gtk_label_set_text(GTK_LABEL(temp),
		       _
		       ("Setup your shared library here. Lopster will scan the specified directories recursively for files that are known (section Suffixes)."));
    break;
  }
}

void on_wizard_dir_select2(gchar * dir)
{
  GtkWidget *temp;

  temp = lookup_widget(win, "clist22");
  strcpy(list[0], MimeNames(browse_mime));
  strcpy(list[1], dir);
  if (list[1][strlen(list[1]) - 1] == '/')
    list[1][strlen(list[1]) - 1] = 0;
  gtk_clist_append(GTK_CLIST(temp), list);
}

void on_folder_add(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *win;

  browse_mime = (int) user_data;
  win = create_dir_browser(_("Select Directory"), g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_wizard_dir_select2);
  gtk_widget_show(win);
}

GtkWidget *create_wizard_popup()
{
  GtkWidget *popup;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;

  popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));

  item = gtk_menu_item_new_with_label(_("MP3"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), (gpointer) MIME_MP3);

  item = gtk_menu_item_new_with_label(_("Video"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_VIDEO);

  item = gtk_menu_item_new_with_label(_("Audio"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_AUDIO);

  item = gtk_menu_item_new_with_label(_("Application"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_APPLICATION);

  item = gtk_menu_item_new_with_label(_("Image"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_IMAGE);

  item = gtk_menu_item_new_with_label(_("Text"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), (gpointer) MIME_TEXT);

  item = gtk_menu_item_new_with_label(_("Any Files"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), (gpointer) MIME_NONE);

  return popup;
}

void wizard_clear_selected()
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(win, "clist22"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}

void on_wizard_dir_select(gchar * dir)
{
  GtkWidget *temp;
  gchar *dir2;

  switch (browse_mime) {
  case 0:
    temp = lookup_widget(win, "entry90");
    break;
  case 1:
    temp = lookup_widget(win, "entry91");
    break;
  case 2:
    temp = lookup_widget(win, "entry92");
    break;
  case 3:
    temp = lookup_widget(win, "entry93");
    break;
  case 4:
    temp = lookup_widget(win, "entry94");
    break;
  case 5:
    temp = lookup_widget(win, "entry95");
    break;
  case 6:
    temp = lookup_widget(win, "entry96");
    break;
  case 7:
    temp = lookup_widget(win, "entry97");
    break;
  default:
    return;
  }

  dir2 = l_strdup(dir);
  if (dir2[strlen(dir2) - 1] == '/')
    dir2[strlen(dir2) - 1] = 0;
  gtk_entry_set_text(GTK_ENTRY(temp), dir2);
}

void wizard_browse(int mime)
{
  GtkWidget *win;

  browse_mime = mime;
  win = create_dir_browser(_("Select Directory"), g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_wizard_dir_select);
  gtk_widget_show(win);
}
