/* Copyright (C) 2000-2004 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _USER_INFO_H_
#define _USER_INFO_H_

typedef void (*UserInfoFunc)(user_info_t*, void*);

user_info_t* user_info_new(char* user);
void user_info_save();
void user_info_load();
user_info_t *user_info_search(char *user);
void user_info_get(user_info_t* userinfo, net_t* net);
int user_info_priority(user_info_t* userinfo, int* class);
void user_info_show(user_info_t* userinfo, int download, int active);
user_info_t* user_info_detect(net_t* net, char* user);
void user_info_foreach(UserInfoFunc func, void* data);
int user_info_is_default(user_info_t* info);

#endif
