from qt import *
#from kdeui import KPushButton
from kdeemul import *
#
# a version of KPushButton that simply displays the largest version of the
# first element in its QIconSet
#
class LPixmapPushButton(KPushButton):
	def __init__(self,iconset,label,container):
		KPushButton.__init__(self,label,container)
		self.setIconSet(iconset)
		pixmap = self.pixmap()
		self.setFixedSize(pixmap.size())

	def doErase(self):
		p = QPainter(self)
		if self.backgroundMode() == Qt.X11ParentRelative:
			self.erase(0,0,self.width(),self.height())
		elif self.parentWidget() and self.parentWidget().erasePixmap():
			p.drawTiledPixmap(0,0,self.width(),self.height(),self.parentWidget().erasePixmap(),self.x(),self.y())
		else:
			p.fillRect(0,0,self.width(),self.height(),self.colorGroup().brush(QColorGroup.Background))
	
	def pixmap(self):
		return self.iconSet().pixmap(QIconSet.Large,QIconSet.Normal)

	def paintEvent(self,e):
		self.doErase()
		pixmap = self.pixmap()
		srcSize = pixmap.size()
		dstSize = self.size()
		posX = (dstSize.width()-srcSize.width())/2
		posY = (dstSize.height()-srcSize.height())/2
		bitBlt(self,QPoint(posX,posY),pixmap,pixmap.rect(),Qt.CopyROP)

class LSmallPixmapPushButton(LPixmapPushButton):
	def __init__(self,iconset,label,container):
		LPixmapPushButton.__init__(self,iconset,label,container)
	
	def pixmap(self):
		return self.iconSet().pixmap(QIconSet.Small,QIconSet.Normal)
