from qt import *
from qtgl import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from kdeemul import *
import sys
from math import *
from utils import *

		
class GLImage:
	def __init__(self, texture):
		self.texture = texture		

class GLShow(QGLWidget):
	def __init__(self, parent=None):
		QGLWidget.__init__(self, parent, None, None, Qt.WStyle_NoBorder|Qt.WType_TopLevel|Qt.WDestructiveClose|Qt.WRepaintNoErase|Qt.WResizeNoErase)
		self.grabKeyboard()
		self.setBackgroundMode(Qt.NoBackground)
		
		self.transList = None
		self.transIndex = 0
		self.fileIndex = 0
		self.trans = None
		self.repeat = True
		self.pause = False
		self.autoClose = True
		self.interval = 3000
		self.msg = ""
		self.delta = 0.04
		
		self.displayImages=(None, None)
				
	def keyPressEvent(self, event):
		if not(event.isAutoRepeat()): # ignore repeating events
			if event.state() == Qt.NoButton:
				if event.key() == Qt.Key_Right:
					self.slotNextSlide()
				elif event.key() == Qt.Key_Left:
					self.slotPrevSlide()
				elif event.key() == Qt.Key_Return or event.key() == Qt.Key_Enter or event.key() == Qt.Key_Escape:
					self.slotStopShow()
				elif event.key() == Qt.Key_Space:
					self.slotTogglePause()
				elif event.key() == Qt.Key_R:
					self.slotToggleRepeat()
	
	def slotNextSlide(self):
		#display next slide
		#load next texture
		self.stopTransition()
		self.updateGL()
		
	def slotPrevSlide(self):
		# move current texture to offscreen,
		# load previous image into other texture
		self.loadTexture(self.prevIndex(), self.images[1])
		self.images[0],self.images[1] = self.images[1],self.images[0]
##~ 		self.textures = (self.textures[1], self.textures[0])
##~ 		self.curTexs = self.textures
		self.fileIndex = self.prevIndex()
		self.percent = 0.0
		self.trans = None
		self.displayTimer.start(self.interval, True)
		self.msg = ""
		self.updateGL()
	
	def slotStopShow(self):
		self.close()

	def slotTogglePause(self):
		# stop transition and display orignal image
		if self.pause:
			self.pause = False
			self.startTransition()
			self.msg = i18n("Play")
		else:
			self.pause = True
			self.displayTimer.stop()
			self.transTimer.stop()
			self.percent = 0.0
			self.trans = None
			self.msg = i18n("Pause")
			self.updateGL()

	def slotToggleRepeat(self):
		self.repeat = not self.repeat
		self.msg = self.repeat and i18n("Repeat On") or i18n("Repeat Off")
		self.updateGL()

	def setImageList(self, keys, lib):
		self.files = [str(lib.getImage(key)['ImagePath']) for key in keys]
		pass
		
	def setFileList(self, files):
		self.files = files
	
	def loadTexture(self, fileIndex, image):
		import math
		pow2 = lambda f: int(math.pow(2.0,math.ceil(math.log(f)/math.log(2.0))))

		img = QImage(self.files[fileIndex])
		img = LUtils.downsizeImageNoWrite(img, QSize(1024,1024))
		
		r = LUtils.mapRect(self.rect(), img.rect())

		print "Loading...",fileIndex,
		width = pow2(img.width())
		height = pow2(img.height())

		image.width = img.width()
		image.height = img.height()
		image.ratiow = img.width() / float(width)
		image.ratioh = img.height() / float(height)
		
		image.surfacew = r.width() / float(self.rect().width())
		image.surfaceh = r.height() / float(self.rect().height())
		
		print "surface ratios",image.surfacew, image.surfaceh,

		if width != img.width() or height != img.height():
			img = img.copy(0,0,width,height)

		img = self.convertToGLFormat(img)
		
		data = img.bits().asstring(img.numBytes())
		glBindTexture(GL_TEXTURE_2D, image.texture)
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
		
		print "X"
		
	def nextIndex(self):
		return (self.fileIndex+1)%len(self.files)
	
	def prevIndex(self):
		return (self.fileIndex-1)%len(self.files)
		
	def startDisplay(self):
		s = LWaitCursor.getApp().desktop().size()
		self.setGeometry(0,0,s.width(),s.height())
		self.showFullScreen()
		self.repaint()
		self.updateGL()
		self.percent = 0.0
		self.fileIndex = len(self.files)-1
		self.loadTexture(0, self.images[1])
		self.transTimer = QTimer()
		self.displayTimer = QTimer()
		QObject.connect(self.transTimer, SIGNAL("timeout()"), self.transitionTimeout)
		QObject.connect(self.displayTimer, SIGNAL("timeout()"), self.displayTimeout)
		
		self.displayImages = (None, None)
		self.updateGL()

		self.startTransition()
		
		self.displayImages = (None, self.images[1])
		self.showMaximized()
		
	def startTransition(self):
		# assumes both textures are loaded
		
		# draw first frame of transition
		self.trans = self.transGen.next()
##~ 		self.trans = self.transList[self.transIndex]
		self.trans.setPercent(0.0)
		self.updateGL()
		
		# start transition timer()
		self.transTimer.start(30, False)
		
	def stopTransition(self):
		# stop timer
		self.transTimer.stop()
		# swap textures
		
		if not self.displayImages[1]:
			# we just finished transition to black, quit
			if self.autoClose:
				self.close()
			return
		
		self.images[0],self.images[1] = self.images[1],self.images[0]
		self.displayImages=(self.images[0],self.images[1])
		self.fileIndex = self.nextIndex()
		self.percent = 0.0
		self.trans = None

		self.msg = ""
		
		self.updateGL()
		
		# start timer for next image
		if self.pause:
			self.displayTimer.stop()
		else:
			self.displayTimer.start(self.interval, True)
	
		# if the slideshow isn't ending, load next texture
		if self.repeat or self.nextIndex() > 0:
			self.loadTexture(self.nextIndex(), self.images[1])
		else:
			self.displayImages = (self.images[0], None)			
		
	def transitionTimeout(self):
		if self.trans:
			self.percent = self.percent + self.delta
			
			if self.percent > 1.0:
				self.percent = 1.0				
			self.trans.setPercent(self.percent)
		self.update()
		if self.percent == 1.0:
			self.stopTransition()
			
	def displayTimeout(self):
		self.startTransition()

	def resizeGL(self, w, h):
		if h == 0:
			h = 1
		glMatrixMode(GL_PROJECTION)
		glLoadIdentity()
		glViewport(0, 0, w, h)
##~ 		glOrtho2D(0, w, 0, h)
		glMatrixMode(GL_MODELVIEW)
		glLoadIdentity()
		print "r",w,h

	def initializeGL(self):
		self.zoom = 1.0
		self.rotate = 0
		print "Init GL..."
		glEnable(GL_TEXTURE_2D)
		glClearColor(0,0,0,0)
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
		glEnable(GL_BLEND)
		glDisable(GL_DEPTH_TEST)
		glDisable(GL_LIGHTING)
		glMatrixMode(GL_MODELVIEW);

		self.initGLTextures(2)
##~ 		glutInit([])
		

	def initGLTextures(self, count = 2):
		self.images = []
		self.textures = glGenTextures(count)
		glPixelStorei(GL_UNPACK_ALIGNMENT, 1)
		for t in self.textures:
			glBindTexture(GL_TEXTURE_2D, t);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
			self.images.append(GLImage(t))
		
	def wheelEvent(self, we):
		print "wheel"
		if (we.delta() < 0):
			self.zoom = self.zoom * 1.05
		elif (we.delta() > 0):
			self.zoom = self.zoom / 1.05
		self.updateGL()

	def paintGL(self):
		glDisable(GL_LIGHTING)
		glLoadIdentity()
		glNormal3f(0.0, 0.0, 1.0)
		glClear(GL_COLOR_BUFFER_BIT)
		
		if self.trans:
			self.trans.paintGL(self.displayImages[1],self.displayImages[0])
		elif self.displayImages[0]:
			image = self.displayImages[0]
			rw = image.ratiow
			rh = 1.0 - image.ratioh
			sw = image.surfacew
			sh = image.surfaceh
			# paint texture 0
			glBindTexture(GL_TEXTURE_2D, image.texture)
			glBegin(GL_QUADS)
			glTexCoord2d	(0	,rh)
			glVertex2f		(-sw,-sh)
			glTexCoord2d	(0	,1)
			glVertex2f		(-sw,sh)
			glTexCoord2d	(rw	,1)
			glVertex2f		(sw	,sh)
			glTexCoord2d	(rw	,rh)
			glVertex2f		(sw	,-sh)
			glEnd()
		glLoadIdentity()
##~ 		self.printGL(-0.95,-0.95,self.msg)

##~ 	def printGL(self, x, y, string):
##~ 		return
##~ 		glDisable(GL_LIGHTING)
##~ 		glRasterPos2f(x, y)
##~ 		for c in str(string):
##~ 			glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, ord(c))
##~ 			
	
		
				
class simple:
	def __init__(self, matrix, alpha=1.0):
		self.m = matrix
		self.alpha = alpha
		self.setPercent(0.0)
		
	def setPercent(self, percent):
		self.percent = percent
		
	def mapTexture(self, image, m, t): 
		f = lambda s, e, t: (e - s) * t + s
			
		texL = f(m[0][0], 0.0, t) 
		texR = f(m[0][1], 1.0, t) * image.ratiow
		texB = f(m[1][0], 0.0, t) * image.ratioh + (1-image.ratioh)
		texT = f(m[1][1], 1.0, t) 

		polL = f(m[0][2], -1.0, t) * image.surfacew
		polR = f(m[0][3], 1.0, t) * image.surfacew
		polB = f(m[1][2], -1.0, t) * image.surfaceh
		polT = f(m[1][3], 1.0, t) * image.surfaceh

##~ 		glScaled(image.ratiow,image.ratioh,1.0);
		glPushMatrix()
##~ 		glTranslatef(1.0 - image.ratiow, image.ratioh - 1.0,0)

		glColor4d(1.0, 1.0, 1.0, f(self.alpha, 1.0 , t))
		glBindTexture(GL_TEXTURE_2D, image.texture)
		glBegin(GL_QUADS)
		glTexCoord2d(texL,texB)
		glVertex2f(polL, polB)
		glTexCoord2d(texL,texT)
		glVertex2f(polL,polT)
		glTexCoord2d(texR,texT)
		glVertex2f(polR,polT)
		glTexCoord2d(texR,texB)
		glVertex2f(polR,polB)
		glEnd()
		glColor4d(1.0, 1.0, 1.0, 1.0)
		glPopMatrix()

	def paintGL(self, imageIn, imageOut):
		
		if imageOut:
			self.mapTexture(imageOut, self.m[0], 1.0-self.percent)
		if imageIn:
			self.mapTexture(imageIn, self.m[1], self.percent)

class scaleTrans:
	def __init__(self, matrix, alpha=1.0):
		self.m = matrix
		self.alpha = alpha
		self.setPercent(0.0)
		
	def setPercent(self, percent):
		self.percent = percent
		
	def mapTexture(self, image, m, t): 
		f = lambda s, e, t: (e - s) * t + s
			
		texL = f(m[0][0], 0.0, t) 
		texR = f(m[0][1], 1.0, t) * image.ratiow
		texB = f(m[1][0], 0.0, t) * image.ratioh + (1-image.ratioh)
		texT = f(m[1][1], 1.0, t) 

		pL = -image.surfacew
		pR = image.surfacew
		pB = -image.surfaceh
		pT = image.surfaceh

		glPushMatrix()

		glColor4d(1.0, 1.0, 1.0, f(self.alpha, 1.0 , t))
		glTranslatef(f(m[0][3], 0.0, t), f(m[1][3], 0.0, t), 0.0)
		glScalef(f(m[0][2], 1.0, t), f(m[1][2], 1.0, t), 1.0)
		
		glBindTexture(GL_TEXTURE_2D, image.texture)
		glBegin(GL_QUADS)
		glTexCoord2d(texL,texB)
		glVertex2f(pL, pB)
		glTexCoord2d(texL,texT)
		glVertex2f(pL,pT)
		glTexCoord2d(texR,texT)
		glVertex2f(pR,pT)
		glTexCoord2d(texR,texB)
		glVertex2f(pR,pB)
		glEnd()
		glColor4d(1.0, 1.0, 1.0, 1.0)
		glPopMatrix()

	def paintGL(self, imageIn, imageOut):
		
		if imageOut:
			self.mapTexture(imageOut, self.m[0], 1.0-self.percent)
		if imageIn:
			self.mapTexture(imageIn, self.m[1], self.percent)

class LSlideShowDialog(QDialog):
	def __init__(self, lib, albumPath, parent=None):
		QDialog.__init__(self, parent)
		self.setCaption(i18n("Lphoto SlideShow Settings"))
		
		self.lib = lib
		self.albumPath = albumPath
		
		vl = QVBoxLayout(self, 10)
		gl = QGridLayout(vl, 3, 2, 5)
		
		l = QLabel(i18n("Transition:"), self)
		gl.addWidget(l,0,0)
		l = QLabel(i18n("Transition Direction:"), self)
		gl.addWidget(l,1,0)
		l = QLabel(i18n("Transition Speed:"), self)
		gl.addWidget(l,2,0)
		
		self.transCombo = QComboBox(self)
		gl.addWidget(self.transCombo, 0, 1)
		self.directionCombo = QComboBox(self)
		gl.addWidget(self.directionCombo, 1, 1)
		
		hb = QHBoxLayout()
		gl.addLayout(hb, 2, 1)
		l = QLabel(i18n("faster"), self)
		hb.addWidget(l)
		self.speedSlider = QSlider( 10, 80, 10, 10, QSlider.Horizontal, self)
		hb.addWidget(self.speedSlider)
		l = QLabel(i18n("slower"), self)
		hb.addWidget(l)

		vl.addSpacing(25)
		
		hb = QHBoxLayout()
		vl.addLayout(hb)
		l = QLabel(i18n("Display each image for: "),self)
		hb.addWidget(l)
		self.durationSpin = QSpinBox(self)
		self.durationSpin.setRange(0, 10 * 60) 
		hb.addWidget(self.durationSpin)
		l = QLabel(i18n(" seconds"),self)
		hb.addWidget(l)
		hb.setStretchFactor(l, 5)
		
		vl.addSpacing(5)
		
		self.repeatCheck = QCheckBox(i18n("Repeat SlideShow"), self)
		vl.addWidget(self.repeatCheck)
		
		self.pauseCheck = QCheckBox(i18n("Start Paused"), self)
		vl.addWidget(self.pauseCheck)

		vl.addSpacing(20)
		gl = QGridLayout(5,3,2)
		vl.addLayout(gl)
		gl.addWidget(QLabel(i18n("Keyboard Controls:    "),self),0,0)
		gl.addWidget(QLabel(i18n("Exit SlideShow:"),self),0,1)
		gl.addWidget(QLabel(i18n("Esc"),self),0,2)

		gl.addWidget(QLabel(i18n("Toggle Play / Pause:  "),self),1,1)
		gl.addWidget(QLabel(i18n("Space Bar"),self),1,2)

		gl.addWidget(QLabel(i18n("Previous Slide:"),self),2,1)
		gl.addWidget(QLabel(i18n("Left Arrow"),self),2,2)
		
		gl.addWidget(QLabel(i18n("Next Slide:"),self),3,1)
		gl.addWidget(QLabel(i18n("Right Arrow"),self),3,2)
		
		gl.addWidget(QLabel(i18n("Toggle Repeat:"),self),4,1)
		gl.addWidget(QLabel(i18n("R"),self),4,2)
		
##~ 		self.shuffleCheck = QCheckBox(i18n("Show Photos in Random Order"), self)
##~ 		vl.addWidget(self.shuffleCheck)
		
		vl.addSpacing(20)

		hl = QHBoxLayout(self)
		
		vl.addStretch()
		vl.addLayout(hl)
		
		self.saveButton = QPushButton(i18n("Save Settings"), self)
		hl.addWidget(self.saveButton)
		hl.addStretch()
		self.playButton = QPushButton(i18n("Play SlideShow..."), self)
		hl.addWidget(self.playButton)
		self.playButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)
		
		self.transList = self.buildTransitionList()
		
		QObject.connect(self.playButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
		QObject.connect(self.saveButton, SIGNAL("clicked()"), self.save)
		QObject.connect(self.transCombo, SIGNAL("activated(int)"), self.slotChangeTrans)

		self.loadTransitionCombo()
		
		self.__serialize(True)
		
	def save(self):
		self.__serialize(False)
		self.reject()
		
	def __serialize(self, bRestore):
		print "Serialize", bRestore
		self.lib.serializeAlbumCombo(self.albumPath, self.transCombo, "SlideShow", "trans", bRestore)
		self.lib.serializeAlbumRange(self.albumPath, self.speedSlider, "SlideShow", "speed", bRestore)
		self.lib.serializeAlbumCheckBox(self.albumPath, self.repeatCheck, "SlideShow", "repeat", bRestore, True)
		self.lib.serializeAlbumCheckBox(self.albumPath, self.pauseCheck, "SlideShow", "paused", bRestore, False)
		self.lib.serializeAlbumRange(self.albumPath, self.durationSpin, "SlideShow", "duration", bRestore, "4")
		if bRestore:
			self.slotChangeTrans(self.transCombo.currentItem())
		self.lib.serializeAlbumCombo(self.albumPath, self.directionCombo, "SlideShow", "transdir", bRestore)
			
			
	def getDuration(self):
		i = int(str(self.durationSpin.text()))
		if i < 0: 
			i = 0
		if i > 120:
			i = 120
		return i * 1000

	def getTransitions(self):
		self.__serialize(False)
		i = self.transCombo.currentItem()
		j = self.directionCombo.currentItem()
		l = self.transList[i][1]
		d = l[j][1]
		
		print i,j,"lambda=",d
		return [self.transList[i][1][j][1]()]		
		
	def getTransGen(self):
		def gen(list):
			if len(list):
				while True:
					for x in list:
						yield x()			
		self.__serialize(False)
		i = self.transCombo.currentItem()
		j = self.directionCombo.currentItem()
		l = self.transList[i][1]
		d = l[j][1]

		print i,j,"lambda=",d,self.transList[i][0]
		
		if self.transList[i][0] == "Random":
			import random
			l = [ j[1] for i in self.transList for j in i[1] if j[1] ]
			random.shuffle(l)
		elif not self.transList[i][1][j][1]:
			return None
		else:
			l = [self.transList[i][1][j][1]]
		return gen(l)

	def loadTransitionCombo(self):
		for x in self.transList:
			self.transCombo.insertItem(x[0])
			
	def slotChangeTrans(self, i):
		print "ChangeTrans"
		self.directionCombo.clear()
		l = self.transList[i][1]
		if len(l) > 0:
			# need to load direction combo:
			for x in l:
				self.directionCombo.insertItem(x[0])
			self.directionCombo.setEnabled(True)
		else:
			self.directionCombo.setEnabled(False)
		
	def buildTransitionList(self):
		const = [ 0.0, 1.0, -1.0, 1.0 ]
		expand = [ 0.0, 1.0, 0.0, 0.0 ]
		squeeze = [ 0.0, 1.0, -1.0, -1.0 ]
		wipe = [ 1.0, 1.0, 1.0, 1.0 ]
		roll = [ 0.0, 0.0, -0.5, -0.5 ]
		slide = [ 0.0, 0.0, 1.0, 1.0 ]
		drip = [ 0.0, 0.0, -1.0, 1.0 ]
		
		L2R = i18n("Left to Right")
		R2L = i18n("Right to Left")
		T2B = i18n("Top to Bottom")
		B2T = i18n("Bottom to Top")
		
		zoom2 = [ 0.0, 1.0, 0.0, 0.0 ]
		const2 = [ 0.0, 1.0, 1.0, 0.0 ]
		slide2 = [ 0.0, 1.0, 1.0, 2.0 ]
		squeeze2 = [ 0.0, 1.0, 0.0, -2.0 ]
		drip2 = [ 0.0, 0.0, 1.0, 0.0 ]
		
		
		flip = lambda m: [1.0-m[0],1.0-m[1], -m[2], -m[3]]
		flipP = lambda m: [m[0], m[1], -m[2], -m[3]]
		flipT = lambda m: [1.0-m[0],1.0-m[1], m[2], m[3]]
			
		flip2 = lambda m: [m[0], m[1], m[2], -m[3]]

##~ 				("spin", lambda: simple([[const2,flip2(slide2)],[const2,slide2]])),


		if LUtils.hasOpenGL():
			l = [
			("Simple (No OpenGL)", [("", None)]),
			("Dissolve", [("", lambda: simple([[const, const],[const,const]],0.0))]),
##~ 			("TEST", [
##~ 				("ZOOM", lambda: scaleTrans([[const2,const2],[zoom2,zoom2]])),
##~ 				("FADE", lambda: scaleTrans([[const2,const2],[const2,const2]])),
##~ 				("SQEEZE", lambda: scaleTrans([[flip2(squeeze2),const2],[squeeze2,const2]])),
##~ 				("DRIP", lambda: scaleTrans([[const2, const2],[const2,drip2]],0.0)),
##~ 				("SLIDE", lambda: scaleTrans([[const2,flip2(slide2)],[const2,slide2]]))
##~ 			]),
##~ 		("Zoom", [("", lambda: scaleTrans([[const2,const2],[zoom2,zoom2]]))]),
			("Zoom", [("", lambda: simple([[const,const],[expand,expand]],0.0))]),
			("Slide", [
				(L2R, lambda: scaleTrans([[slide2,const2],[flip2(slide2),const2]])),
				(R2L, lambda: scaleTrans([[flip2(slide2),const2],[slide2,const2]])),
				(T2B, lambda: scaleTrans([[const2,flip2(slide2)],[const2,slide2]])),
				(B2T, lambda: scaleTrans([[const2,slide2],[const2,flip2(slide2)]]))]),
			("Wipe", [
				(L2R, lambda: simple([[wipe,const],[flip(wipe),const]])),
				(R2L, lambda: simple([[flip(wipe),const],[wipe,const]])),
				(T2B, lambda: simple([[const,flip(wipe)],[const,wipe]])),
				(B2T, lambda: simple([[const,wipe],[const,flip(wipe)]]))]),
			("Squeeze", [
				(L2R, lambda: simple([[flipP(squeeze),const],[squeeze,const]])),
				(R2L, lambda: simple([[squeeze,const],[flipP(squeeze),const]])),
				(T2B, lambda: simple([[const,squeeze],[const,flipP(squeeze)]])),
				(B2T, lambda: simple([[const,flipP(squeeze)],[const,squeeze]]))]),
			("Drip", [
				(L2R, lambda: simple([[const,const],[flipT(drip),const]],0.0)),
				(R2L, lambda: simple([[const,const],[drip,const]],0.0)),
				(T2B, lambda: simple([[const,const],[const,drip]],0.0)),
				(B2T, lambda: simple([[const,const],[const,flipT(drip)]],0.0))]),
			("Flip", [("", lambda: simple([[const2,flip2(slide2)],[const2,slide2]]))]),
			("Random", [("", None)])
			]
		else:
			l = [
			("Simple (No OpenGL)", [("", None)])
			]
		
		return l



if __name__ == "__main__":
	def main():
		print "RUNNING..."
		app = QApplication(sys.argv)  
		if not QGLFormat.hasOpenGL():
			raise 'No Qt OpenGL support.'
		dialog = LSlideShowDialog()
		if dialog.exec_loop() == QDialog.Accepted:
			gl = GLShow()
			app.setMainWidget(gl)
	
			gl.repeat = dialog.repeatCheck.isChecked()
			gl.delta = 1.0 / dialog.speedSlider.value()
			gl.transList = dialog.getTransitions()
	
			gl.show()
			
			gl.startDisplay()
			app.exec_loop()

	main()



		
