from qt import *
import os,errno
from kdeemul import *

from LRatingWidget import *
from utils import *
from photo import *

class LInfoPanel(QWidget):
	def __init__(self, parent, lphoto):
		QWidget.__init__(self, parent)
		self.lphoto = lphoto
		hl = QHBoxLayout(self)
		hl.insertSpacing(-1, 3)
		vl = QVBoxLayout(hl)
		vl.insertSpacing(-1, 3)
		hl.insertSpacing(-1, 3)
		gl = QGridLayout(vl, 5, 2)
		vl.insertSpacing(-1, 3)

		gl.addWidget(QLabel(i18n("Title:"), self), 0, 0)
		self.titleEdit = QLineEdit(self)
		gl.addWidget(self.titleEdit, 0 , 1)
		QObject.connect(self.titleEdit, SIGNAL("lostFocus()"), self.slotChangeTitle)
		QToolTip.add(self.titleEdit, i18n("change the title of the current image")) 
		
		gl.addWidget(QLabel(i18n("Date:"), self), 1, 0)
		self.dateEdit = QDateTimeEdit(self)
		gl.addWidget(self.dateEdit, 1 , 1)
		QObject.connect(self.dateEdit, SIGNAL("lostFocus()"), self.slotChangeDate)
		QToolTip.add(self.dateEdit, i18n("change the date of the current image")) 
		
		gl.addWidget(QLabel(i18n("Size:"), self), 2, 0)
		self.sizeLabel = QLabel("1024 x 768", self)
		self.sizeLabel.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(self.sizeLabel, 2 , 1)
		QToolTip.add(self.sizeLabel, i18n("pixel size of the current image")) 

		gl.addWidget(QLabel(i18n("Bytes:"), self), 3, 0)
		self.bytesLabel = QLabel("190k", self)
		self.bytesLabel.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		gl.addWidget(self.bytesLabel, 3 , 1)
		QToolTip.add(self.bytesLabel, i18n("file size of the current image")) 
		
		gl.addWidget(QLabel(i18n("Rating:"), self), 4, 0)
		self.ratingWidget = LRatingWidget(self)
		gl.addWidget(self.ratingWidget, 4, 1)
		QToolTip.add(self.ratingWidget, i18n("change the rating of the current image")) 
		
		QObject.connect(self.ratingWidget, PYSIGNAL("ratingChanged"), self.slotChangeRating)
		
		self.commentsLabel = QLabel(i18n("Comments:"), self)
		vl.addWidget(self.commentsLabel)

		self.commentsEdit = QTextEdit(self)
		self.commentsEdit.setMinimumHeight(self.commentsLabel.height())
		QToolTip.add(self.commentsEdit, i18n("edit the comments of the current image")) 
		
		vl.addWidget(self.commentsEdit)

		self.setEnabled(False)
		self.key = None

	def setLibrary(self, lib):
		self.lib = lib
		QObject.connect(Photo.updateEvents, PYSIGNAL("photoUpdate"), self.slotUpdateImage)

	def setIconView(self, iv):
		QObject.connect(iv, PYSIGNAL("currentChanged"), self.slotItemChanged)
		QObject.connect(iv, PYSIGNAL("selectionStats"), self.slotSelChanged)
		
	def saveEdits(self):
		if self.key:
			if self.titleEdit.edited():
				self.slotChangeTitle()
			self.slotChangeDate()
			self.lib.setImageComment(self.key, self.commentsEdit.text())
	
	def setPhoto(self, photo):
		self.titleEdit.setText(photo['Caption'])
		if photo['Width']:
			self.sizeLabel.setText("%s x %s"%(photo['Width'], photo['Height']))
		else:
			self.sizeLabel.setText("")
		self.bytesLabel.setText(LUtils.humanByteOutput(photo.getFileSize()))
		self.ratingWidget.setRating(photo['Rating'])
		if photo['Date']:
			dt = QDateTime()
			dt.setTime_t(photo['Date'])
			self.dateEdit.setDateTime(dt)
			
	def slotUpdateImage(self, key):
		if self.key and self.key == key:
			photo = self.lib.getPhoto(key)
			self.setPhoto(photo)
			
	def slotItemChanged(self, key):
		self.saveEdits()
		if key:
			self.setEnabled(True)
			self.key = key
			photo = self.lib.getPhoto(key)
			self.setPhoto(photo)

			self.commentsEdit.setText("")
			self.commentsEdit.setText(photo['Comments'])
		else:
			self.setEnabled(False)
	
			
	def slotSelChanged(self, total, count):
		many = count > 1
		self.titleEdit.setEnabled(not many)
		self.dateEdit.setEnabled(not many)

	def slotChangeTitle(self):
		if self.key:
			self.lib.setImageCaption(self.key, self.titleEdit.text())
			
	def slotChangeRating(self, source, rating):
		keys = self.lphoto.getSelection()
		for key in keys:
			self.lib.setImageRating(key, rating)

	def slotChangeDate(self):
		if self.key:
			dt = self.dateEdit.dateTime()
			self.lib.setImageDate(self.key, dt.toTime_t())

	def slotDisplayToggle(self):
		if self.isVisible():
				self.hide()
		else:
			self.show()
		return
		
