import sys
import os, errno
from kdeemul import *
from kio import *

from photolibrary import *
from organizeview import *
from slideshow import *
from albumlist import *
from editview import *
from infopanel import *
from importpanel import *
from printer import *
from utils import *
from about import *
from preferences import *
from config import *
from export import *
from glshow import *
from cdrecord import *
from vcd import *

import paths

class LStartAppEvent(QCustomEvent):
	id = QEvent.User+100
	def __init__(self):
		QCustomEvent.__init__(self, self.id)
		
class LMainPhoto(KMainWindow):
	def __init__(self, app):
		KMainWindow.__init__(self)
		self.settings = LConfig("lphoto")
		self.lib = LPhotoLibrary(self)
		self.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
		self.mainView = QVBox(self)
		self.setCentralWidget(self.mainView)
		self.album = None
		self.vcdDialog = None
		self.burnDialog = None
		#create layout
		sp = QSplitter(Qt.Horizontal, self.mainView, "main view")
		sp.setOpaqueResize(True)
		sp.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
		sp2 = QSplitter(Qt.Vertical, sp)
		self.mainSplitter = sp
		self.infoSplitter = sp2
#		vb = QVBox(sp)
		self.initAlbumList(sp2)
		self.infoPanel = LInfoPanel(sp2, self)
		self.mainStack = QWidgetStack(sp)
		self.initModePanel(self.mainView)
		self.toolsStack = QWidgetStack(self.mainView)
		self.editString = i18n("Edit")
		self.organizeString = i18n("Organize")
		self.importString = i18n("Import")

		self.initModeStacks()

		self.initActions()
		self.initMenus()
		self.albumList.initPopupMenu(self.actionCollection())
		self.organizeView.initPopupMenu(self.actionCollection())
		
		self.editString = i18n("Edit")
		self.organizeString = i18n("Organize")
		self.importString = i18n("Import")

		#make connetions that couldn't be made during constuction
		self.infoPanel.setIconView(self.organizeView)
		self.infoPanel.setLibrary(self.lib)
		QObject.connect(self.infoButton, SIGNAL("pressed()"), self.infoPanel.slotDisplayToggle)
		QObject.connect(self.organizeView, PYSIGNAL("doubleClicked"), self.slotSetModeEdit)
		QObject.connect(self.organizeView, PYSIGNAL("returnPressed"), self.slotSetModeEdit)
		QObject.connect(self.organizeView, PYSIGNAL("currentChanged"), self.editView.slotSetItem)
		QObject.connect(self.organizeView, PYSIGNAL("selectionStats"), self.slotSelectionStats)
		QObject.connect(self.newAlbumButton, SIGNAL("clicked()"), self.slotNewAlbum)
		QObject.connect(self.rotateButton, SIGNAL("pressed()"), self.organizeView.slotRotateSelection)
		QObject.connect(self.lib, PYSIGNAL("error"), self.slotErrorMessage)
		QObject.connect(self.organizeView, PYSIGNAL("dragImport"), self.importPanel.slotStartSourceImport)
		QObject.connect(self.albumList, PYSIGNAL("dragImport"), self.importPanel.slotStartSourceImport)
		QObject.connect(self.lib, PYSIGNAL("dragImport"), self.importPanel.slotStartSourceImport)
		QObject.connect(self.albumList, PYSIGNAL("dragImportNewAlbum"), self.lib.slotDragSourceImport)
		QObject.connect(self.organizeView, PYSIGNAL("updateUI"), self.slotUpdateUI)

		sp.setResizeMode(sp2, QSplitter.KeepSize)
		sp.setSizes([190,300])

		sp2.setResizeMode(self.infoPanel, QSplitter.KeepSize)
				
		QObject.connect(app, SIGNAL("lastWindowClosed()"), self.slotAppQuiting)
				
	def initActions(self):
		KAction(i18n("&Remove Album"), KShortcut.null(), self.albumList.slotRemoveAlbum, self.actionCollection(), "removeAlbum")
		KAction(i18n("Re&name Album"), KShortcut.null(), self.albumList.slotRenameAlbum, self.actionCollection(), "renameAlbum")

	def initMenus(self):
		self.fileMenu = QPopupMenu()
		a = KAction(i18n("&New Album"), KShortcut(Qt.CTRL+Qt.Key_N), self.slotNewAlbum, self.actionCollection(), "newAlbum")
		a.plug(self.fileMenu)
		a = KAction(i18n("New &Album From Selection"), KShortcut.null(), self.organizeView.slotNewAlbumFromSelection, self.actionCollection(), "newAlbumFromSelection")
		a.plug(self.fileMenu)
##~ 		a = KAction(i18n("New &Smart Album"), KShortcut.null(), self.slotNotImplemented, self.actionCollection(), "newSmartAlbum")
##~ 		a.plug(self.fileMenu)
##~ 		a = KAction(i18n("E&dit Smart Album"), KShortcut.null(), self.slotNotImplemented, self.actionCollection(), "editSmartAlbum")
##~ 		a.plug(self.fileMenu)
##~ 		a = KAction(i18n("New Film &Roll From Selection"), KShortcut.null(), self.slotNotImplemented, self.actionCollection(), "newFilmRollFromSelection")
##~ 		a.plug(self.fileMenu)
		self.fileMenu.insertSeparator()
		a = KAction(i18n("Add File To Photo Library..."), KShortcut(Qt.CTRL+Qt.Key_O), self.slotImportFile, self.actionCollection(), "importFiles")
		a.plug(self.fileMenu)
		a = KAction(i18n("&Add Folder To Photo Library..."), KShortcut(Qt.SHIFT+Qt.CTRL+Qt.Key_O), self.slotImportFolder, self.actionCollection(), "importFolder")
		a.plug(self.fileMenu)
		a = KAction(i18n("Add &Folder As Albums..."), KShortcut(Qt.SHIFT+Qt.CTRL+Qt.Key_A), self.slotImportAsAlbum, self.actionCollection(), "importAsAlbum")
		a.plug(self.fileMenu)
##~ 		a = KAction(i18n("&Export..."), KShortcut.null(), self.slotImportFolder, self.actionCollection(), "export")
##~ 		a.plug(self.fileMenu)
		self.fileMenu.insertSeparator()
		a = KAction(i18n("Export Selection To Folder..."), KShortcut(Qt.SHIFT+Qt.CTRL+Qt.Key_S), self.slotExportSelection, self.actionCollection(), "exportSelection")
		a.plug(self.fileMenu)
		a = KAction(i18n("Export Album To Folder..."), KShortcut(Qt.SHIFT+Qt.CTRL+Qt.Key_E), self.slotExportFolder, self.actionCollection(), "exportAlbum")
		a.plug(self.fileMenu)
		a = KAction(i18n("Export All Albums..."), KShortcut.null(), self.slotExportAllAlbums, self.actionCollection(), "exportAlbum")
		a.plug(self.fileMenu)
		self.fileMenu.insertSeparator()
		a = KAction(i18n("Empty &Trash"), KShortcut.null(), self.slotEmptyTrash, self.actionCollection(), "emptyTrash")
		a.plug(self.fileMenu)
		self.fileMenu.insertSeparator()
		
##~ 		a = KAction(i18n("Page Setup"), KShortcut.null(), self.slotNotImplemented, self.actionCollection(), "pageSetup")
##~ 		a.plug(self.fileMenu)
		a = KStdAction.print_(self.slotPrint, self.actionCollection())
		a.plug(self.fileMenu)
# 		self.saveLibraryAction = KAction(i18n("Save &Library"),KShortcut(Qt.CTRL+Qt.Key_L),self.slotSaveLibrary,self.actionCollection(),"saveLibrary")
# 		self.saveLibraryAction.plug(self.fileMenu)
		self.fileMenu.insertSeparator()
		a = KStdAction.quit(self.slotQuit, self.actionCollection())
		a.plug(self.fileMenu)
		self.menuBar().insertItem(i18n("&File"),self.fileMenu)

##~ 		self.editMenu = QPopupMenu()		
##~ 		a = KStdAction.undo(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		a = KStdAction.redo(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		a = KStdAction.cut(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		a = KStdAction.copy(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		a = KStdAction.paste(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		a = KStdAction.selectAll(self.slotSelectAll, self.actionCollection())
##~ 		a.plug(self.editMenu)
		a = KAction(i18n("Select All"), KShortcut(Qt.CTRL+Qt.Key_A), self.slotSelectAll, self.actionCollection(), "selectAll")
		a.setEnabled(True)
##~ 		a = KStdAction.deselect(self.slotNotImplemented, self.actionCollection())
##~ 		a.plug(self.editMenu)
##~ 		self.menuBar().insertItem(i18n("&Edit"),self.editMenu)

		self.photosMenu = QPopupMenu()		
##~ 		a = KAction(i18n("Show Info"), KShortcut.null(), self.slotNotImplemented, self.actionCollection(), "showInfo")
##~ 		a.plug(self.photosMenu)
		a = KAction(i18n("Rotate Clockwise"), KShortcut(Qt.CTRL+Qt.Key_R), self.organizeView.slotRotateSelection, self.actionCollection(), "rotateClockwise")
		a.plug(self.photosMenu)
		a = KAction(i18n("Rotate Counter Clockwise"), KShortcut(Qt.CTRL+Qt.SHIFT+Qt.Key_R), self.organizeView.slotRotateCCSelection, self.actionCollection(), "rotateCounterClockwise")
		a.plug(self.photosMenu)
		a = KAction(i18n("Duplicate"), KShortcut.null(), self.organizeView.slotDuplicate, self.actionCollection(), "duplicate")
		a.plug(self.photosMenu)
		a = KAction(i18n("Move To Trash"), KShortcut.null(), self.organizeView.slotTrash, self.actionCollection(), "moveToTrash")
		a.plug(self.photosMenu)
		a = KAction(i18n("Use Import Date for Date"), KShortcut.null(), self.organizeView.slotDateSwap, self.actionCollection(), "dateSwap")
		a.plug(self.photosMenu)
		a = KAction(i18n("Revert To Original"), KShortcut.null(), self.organizeView.slotRevert, self.actionCollection(), "revert")
		a.plug(self.photosMenu)
		self.menuBar().insertItem(i18n("&Photos"),self.photosMenu)

		self.viewMenu = QPopupMenu()		
		a = KToggleAction(i18n("Titles"), KShortcut.null(), self.organizeView.slotViewTitle, self.actionCollection(), "viewTitle")
		a.plug(self.viewMenu)
		a = KToggleAction(i18n("Rating"), KShortcut.null(), self.organizeView.slotViewRating, self.actionCollection(), "viewRating")
		a.plug(self.viewMenu)
		self.arrangeMenu = QPopupMenu()
		a = KRadioAction(i18n("by Date"), KShortcut.null(), self.organizeView.slotArrangeByDate, self.actionCollection(), "arrangeDate")
		a.plug(self.arrangeMenu)
		a.setExclusiveGroup("arrange")
		a = KRadioAction(i18n("by Title"), KShortcut.null(), self.organizeView.slotArrangeByTitle, self.actionCollection(), "arrangeTitle")
		a.plug(self.arrangeMenu)
		a.setExclusiveGroup("arrange")
		a = KRadioAction(i18n("by Rating"), KShortcut.null(), self.organizeView.slotArrangeByRating, self.actionCollection(), "arrangeRating")
		a.plug(self.arrangeMenu)
		a.setExclusiveGroup("arrange")
		a = KRadioAction(i18n("Manually"), KShortcut.null(), self.organizeView.slotArrangeManually, self.actionCollection(), "arrangeManually")
		a.plug(self.arrangeMenu)
		a.setExclusiveGroup("arrange")
		self.viewMenu.insertItem(i18n("Arrange Photos"), self.arrangeMenu)
		self.menuBar().insertItem(i18n("&View"),self.viewMenu)
		
		self.screensaverMenu = QPopupMenu()
		a = KAction(i18n("Set Screensaver Album"), KShortcut.null(), self.slotSetScreensaver, self.actionCollection(), "setScreensaver")
		a.plug(self.screensaverMenu)
		a = KAction(i18n("Launch Screensaver"), KShortcut.null(), self.slotLaunchScreensaver, self.actionCollection(), "launchScreensaver")
		a.plug(self.screensaverMenu)
		self.menuBar().insertItem(i18n("&Screensaver"),self.screensaverMenu)

##~ 		self.debugMenu = QPopupMenu()
##~ 		a = KAction(i18n("&SaveLibrary"), KShortcut.null(), self.slotDebugQuit, self.actionCollection(), "debugSave")
##~ 		a.plug(self.debugMenu)
##~ 		a = KAction(i18n("&Create Album Links"), KShortcut.null(), self.slotDebugLinks, self.actionCollection(), "debugLinks")
##~ 		a.plug(self.debugMenu)
##~ 		a = KAction(i18n("&Screensaver Album"), KShortcut.null(), self.slotDebugSetScreensaver, self.actionCollection(), "debugScreensaver")
##~ 		a.plug(self.debugMenu)
##~ 		self.menuBar().insertItem(i18n("&Tools"),self.debugMenu)
		self.settingsMenu = QPopupMenu()
		a = KStdAction.preferences(self.slotPreferences, self.actionCollection())
		a.plug(self.settingsMenu)
##~ 		self.menuBar().insertItem(i18n("&Settings"), self.settingsMenu)
		self.burnMenu = QPopupMenu()
		self.menuBar().insertItem(i18n("&Burn CD"), self.burnMenu)
		a = KAction(i18n("Copy Album To CD"), KShortcut.null(), self.slotBurnAlbum, self.actionCollection(), "burnAlbum")
		a.plug(self.burnMenu)
		a = KAction(i18n("Burn Album To Video CD"), KShortcut.null(), self.slotBurnVCD, self.actionCollection(), "burnVCD")
		a.plug(self.burnMenu)

		self.menuBar().insertItem(i18n("&Help"), self.helpMenu(""))
		
	def about(self):
		global Program, Title, Version, Copyright, Url, BugEmail, Author, AuthorEmail
		QMessageBox.about(self,  
			i18n("About %s")%(Program), 
			i18n(
				"""<h3> About %s</h3>"""
				"""Version %s<br/>"""
				"""%s<br/>"""
				"""<p>By %s</p>"""
				"""<p>For more infomation visit: <tt>%s</tt></p>"""
				"""<p>Please send bugreports to: <tt>%s</tt></p>"""
				%(Program, Version, Copyright, Author, Url, BugEmail)))
		
	def initModeStacks(self):
		self.importPanel = LImportPanel(self.toolsStack)
		self.importPanel.setLibrary(self.lib)
		self.addMode(None, self.importPanel, None, self.importString)
		
		self.organizeView = self.initOrganizeView(self.mainStack)
		self.organizePanel = self.initOrganizePanel(self.toolsStack)
		self.organizeSlider = QSlider( 60, 500, 30, 100, QSlider.Horizontal, self.sliderStack)
		self.addMode(self.organizeView, self.organizePanel, self.organizeSlider, self.organizeString)
		QToolTip.add(self.organizeSlider,i18n("change thumbnail scale")) 
		QObject.connect(self.organizeSlider, SIGNAL("valueChanged(int)"), self.organizeView.slotSetThumbScale)
		
		self.editView = self.initEditView(self.mainStack)
		self.editPanel = self.initEditPanel(self.toolsStack)
		hb = QHBox(self.sliderStack)
		self.editSlider = QSlider( 10, 100, 5, 1, QSlider.Horizontal, hb)
		l = QLabel("100.0%", hb)
		self.addMode(self.editView, self.editPanel, hb, self.editString)
		self.editView.setSlider(self.editSlider)
		self.editView.setSliderLabel(l)
		
		QToolTip.add(self.editSlider,i18n("zoom in/out")) 
		QObject.connect(self.editSlider, SIGNAL("valueChanged(int)"), self.editView.slotZoomChanged)
		QObject.connect(self.editSlider, SIGNAL("sliderReleased()"), self.editView.slotEndZoom)

		self.modeTab.setCurrentTab(1)

		QObject.connect(self.modeTab, SIGNAL("selected(int)"), self.mainStack, SLOT("raiseWidget(int)"))
		QObject.connect(self.modeTab, SIGNAL("selected(int)"), self.toolsStack, SLOT("raiseWidget(int)"))
		QObject.connect(self.modeTab, SIGNAL("selected(int)"), self.sliderStack, SLOT("raiseWidget(int)"))
		QObject.connect(self.mainStack, SIGNAL("aboutToShow(int)"), self.slotAboutToShow)
		QObject.connect(self.toolsStack, SIGNAL("aboutToShow(int)"), self.slotAboutToShowPanel)
		QObject.connect(self.editPanel.nextButton, SIGNAL("clicked()"), self.organizeView.slotNextItem)
		QObject.connect(self.editPanel.prevButton, SIGNAL("clicked()"), self.organizeView.slotPrevItem)
		QObject.connect(self.editPanel.cropButton, SIGNAL("clicked()"), self.editView.slotCrop)
		QObject.connect(self.editPanel.redeyeButton, SIGNAL("clicked()"), self.editView.slotRedeye)
		QObject.connect(self.editPanel.bandwButton, SIGNAL("clicked()"), self.editView.slotBandw)
		QObject.connect(self.editPanel.revertButton, SIGNAL("clicked()"), self.editView.slotRevert)
		QObject.connect(self.editPanel.enhanceButton, SIGNAL("clicked()"), self.editView.slotEnhance)

		QObject.connect(self.organizePanel.printButton, SIGNAL("clicked()"), self.slotPrint)
		QObject.connect(self.organizePanel.emailButton, SIGNAL("clicked()"), self.slotEmail)
		QObject.connect(self.organizePanel.homepageButton, SIGNAL("clicked()"), self.slotExportHTML)
		QObject.connect(self.organizePanel.desktopButton, SIGNAL("clicked()"), self.slotSetDesktop)
		QObject.connect(self.organizePanel.slideShowButton, SIGNAL("clicked()"), self.slotStartSlideShow)

	def slotAboutToShow(self, i):
		oldMode = self.modeTab.tab(self.modeTab.currentTab()).text()
		mode = self.modeTab.tab(i).text()
		print "About to show",mode,"from",oldMode
		if mode == self.editString:
			key = self.organizeView.currentKey()
			if key:
				self.editView.setImageKey(key)
				self.organizeView.selectKey(key)
			else:
				self.organizeView.slotNextItem()
				key = self.organizeView.currentKey()
				self.editView.setImageKey(key)

	def slotAboutToShowPanel(self, i):
		oldMode = self.modeTab.tab(self.modeTab.currentTab()).text()
		mode = self.modeTab.tab(i).text()
		print "About to show panel",mode,"from",oldMode
		if mode == self.importString:
			self.importPanel.slotShowPanel()

	def initOrganizeView(self, container):
		ov = LOrganizeView(container)
		ov.setLibrary(self.lib)
		return ov

	def initEditView(self, container):
		ev = LEditView(container)
		ev.setLibrary(self.lib)
		return ev

	def createToolBarButton(self, label, imageName, parent, tooltip):
		vb = QVBox(parent)
		b = QPushButton(label, vb)
		b.setPixmap(QPixmap(paths.art(imageName)))
		b.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.MinimumExpanding)
		if label:
			l = QLabel(label, vb)
			l.setAlignment(Qt.AlignHCenter)
		QToolTip.add(b, tooltip) 		
		return b

	def initOrganizePanel(self, container):
		hb = QHBox(container)
		hb.printButton = self.createToolBarButton(i18n("Print"), "serviceprint.png", hb, i18n("print the selected images"))
		hb.slideShowButton = self.createToolBarButton(i18n("Slide Show"), "serviceslideshow.png", hb, i18n("start a slideshow"))
		hb.emailButton = self.createToolBarButton(i18n("Send EMail"), "serviceemail.png", hb, i18n("email the selected images"))
		hb.homepageButton = self.createToolBarButton(i18n("Create Web Pages"), "servicehtml.png", hb, i18n("export the selected images as html"))
		hb.desktopButton = self.createToolBarButton(i18n("Desktop"), "servicedesktop.png", hb, i18n("make the selected image your  desktop wallpaper"))
		return hb

	def initEditPanel(self, container):
		hb = QHBox(container)
		hb.prevButton = self.createToolBarButton(i18n("Prev"), "editprev.png", hb, i18n("go to the previous image"))
		hb.nextButton = self.createToolBarButton(i18n("Next"), "editnext.png", hb, i18n("go to the next image"))
		hb.cropButton = self.createToolBarButton(i18n("Crop"), "editcrop.png", hb, i18n("crop the image to the selection"))
		hb.redeyeButton = self.createToolBarButton(i18n("Red-Eye"), "editredeye.png", hb, i18n("apply a red-eye filter to the selection"))
		hb.enhanceButton = self.createToolBarButton(i18n("Enhance"), "editenhance.png", hb, i18n("enhance the image"))
		hb.bandwButton = self.createToolBarButton(i18n("B & W"), "editb&w.png", hb, i18n("convert the image to black and white"))
		hb.revertButton = self.createToolBarButton(i18n("Revert"), "editrevert.png", hb, i18n("revert to the original image"))
		return hb

	def initAlbumList(self, container):
		self.albumList = LAlbumListView(container, "Album List", self)
		self.albumList.setLibrary(self.lib)
		QObject.connect(self.albumList, SIGNAL("selectionChanged()"), self.slotAlbumChanged)

	def initPhotoInfo(self, container):
		self.infoPanel = LInfoPanel(container)

	def initModePanel(self, container):
		hb = QHBox(container)
		l = QLabel("  ", hb)
		l.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)
		self.newAlbumButton = self.createToolBarButton("", "buttonadd.png", hb, i18n("add a new album"))
		self.newAlbumButton.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)
		l = QLabel("    ", hb)
		l.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)

		self.playButton = self.createToolBarButton("", "buttonplay.png", hb, i18n("start a slideshow"))
		self.playButton.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)
		QObject.connect(self.playButton, SIGNAL("clicked()"), self.slotStartSlideShow)
		l = QLabel("    ", hb)
		l.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)
		
		self.infoButton = self.createToolBarButton("", "buttoninfo.png", hb, i18n("show/hide the info panel"))
		self.infoButton.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)
		l = QLabel("    ", hb)
		l.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)

		self.rotateButton = self.createToolBarButton("", "buttonrotate.png", hb, i18n("rotate the selected images"))
		self.rotateButton.setSizePolicy(QSizePolicy.Fixed,QSizePolicy.Fixed)

		self.selectionLabel = QLabel("", hb)
		self.selectionLabel.setAlignment(Qt.AlignHCenter)
		self.selectionLabel.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)

		self.modeTab = QTabBar(hb)

		l = QLabel("   ", hb)
		l.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
		self.sliderStack = QWidgetStack(hb)
		self.sliderStack.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)

	def addMode(self, mainWidget, toolsWidget, sliderWidget, label):
		t = QTab()
		t.setText(label)
		id = self.modeTab.addTab(t)
		if mainWidget:
			self.mainStack.addWidget(mainWidget, id)
		if toolsWidget:
			self.toolsStack.addWidget(toolsWidget, id)
		if sliderWidget:
			self.sliderStack.addWidget(sliderWidget, id)
			
	def slotQuit(self):
		self.close()
		
	def slotImportMyPhotos(self):
		source = LAlbumImport([str(os.path.join(os.path.expanduser('~'),'My Documents','My Photos'))])
		files = source.expandFileList([source.path])
		if len(files) < 20:
			self.importPanel.slotStartSourceImport(source)
		else:
			result = QMessageBox.question(self, 
				i18n("Lphoto:  Welcome"), 
				i18n(
					"""<center><h3> Welcome to Lphoto</h3>"""
					"""Lphoto will help you share and organize your digital pictures.  <br/>"""
					"""Would you like Lphoto to scan your 'My Photos' folder right now?<br/>"""
					"""<br/>You can always add pictures later using the File Menu or import them directly from your digital camera.</center>"""
					),
				i18n("Scan 'My Photos' for pictures"), 
				i18n("Don't import anything right now"),  None,  0, 1)
			if result == 0:
				self.importPanel.slotStartSourceImport(source)

	def slotImportFile(self):
		filter = " ".join(["*."+x for x in LSettings.validFileTypes()]) + "| All Image Formats\n*.jpg *.jpeg|JPEG Files (*.jpg, *.jpeg)"
##		filter = "*.jpg " + " ".join(["*."+x.lower() for x in QImage.inputFormats()]) + "| All Image Formats\n*.jpg *.jpeg|JPEG Files (*.jpg, *.jpeg)"
		print filter
		filenames = KFileDialog.getOpenFileNames(str(os.path.join(os.path.expanduser('~'),'My Documents','My Photos')),
				filter,
				self,
				i18n("Select files."))
		if filenames:
			cam = LDirImport(filenames)
			self.importPanel.slotStartSourceImport(cam)
			# show the import panel
			self.setMode(self.importString)

	def slotImportFolder(self):
		filename = KFileDialog.getExistingDirectory(str(os.path.join(os.path.expanduser('~'),'My Documents','My Photos')), 
				None, 
				i18n("Select an image directory."))
		if filename:
			cam = LDirImport([filename])
			self.importPanel.slotStartSourceImport(cam)
			# show the import panel
			self.setMode(self.importString)
			
	def slotImportAsAlbum(self):
		filename = KFileDialog.getExistingDirectory(str(os.path.join(os.path.expanduser('~'),'My Documents','My Photos')), None, i18n("Select an image directory."))
		if filename:
			cam = LAlbumImport([filename])
			self.importPanel.slotStartSourceImport(cam)
			self.setMode(self.importString)
			
	def slotExportFolder(self):
		dialog = LAlbumExport(self, self.lib, self.organizeView.albumPath)
		if dialog.exec_loop() == QDialog.Accepted:
			dialog.export()

	def slotExportAllAlbums(self):
		dialog = LAlbumExport(self, self.lib, [])
		if dialog.exec_loop() == QDialog.Accepted:
			dialog.export()
	
		
	def slotExportSelection(self):
		dialog = LSelectionExport(self, self.lib, self.organizeView.getWorkingSet())
		if dialog.exec_loop() == QDialog.Accepted:
			dialog.export()
			
	def slotStartSlideShow(self):
		dialog = LSlideShowDialog(self.lib, self.organizeView.albumPath)
		if dialog.exec_loop() == QDialog.Accepted:
			t = dialog.getTransGen()
			if t:
				gl = GLShow(LWaitCursor.getApp().desktop())
				gl.interval = dialog.getDuration()
				gl.repeat = dialog.repeatCheck.isChecked()
				gl.delta = 1.0 / dialog.speedSlider.value()
				gl.transGen = t
				gl.setImageList(self.organizeView.getSlideshowWorkingSet(), self.lib) 		
				gl.pause = dialog.pauseCheck.isChecked()
				gl.show()
				gl.startDisplay()
			else:
				self.ss = LSlideShow()
				self.ss.lib = self.lib
				self.ss.interval = dialog.getDuration()
				self.ss.repeat = dialog.repeatCheck.isChecked()
				self.ss.pause = dialog.pauseCheck.isChecked()
				self.ss.setImageList(self.organizeView.getSlideshowWorkingSet())
				self.ss.startSlideShow()

	def slotAlbumChanged(self):
		lvi = self.albumList.selectedItem()
		if lvi:
			print "AlbumChanged", lvi.path
			self.setAlbum(lvi.path)

	def setAlbum(self, path):
		print "setAlbum", path
		self.album = self.lib.getAlbum(path)
		self.organizeView.setAlbumPath(path)
		self.setMode(self.organizeString)

	def setMode(self, mode):
		# set mode tab from mode string name
		print "lphoto::setMode",mode
		for i in range(self.modeTab.count()):
			tab = self.modeTab.tabAt(i)
			if tab.text() == mode:
				self.modeTab.setCurrentTab(tab.identifier())
				break

	def slotSetModeEdit(self):
		self.setMode(self.editString)

	def slotSaveLibrary(self):
		self.lib.writeLibrary()

	def slotNotImplemented(self):
		print "Not Implemented"

	def slotDebugSetScreensaver(self):
		lvi = self.albumList.selectedItem()
		if lvi:
			self.lib.setScreensaverAlbum(lvi.path)
		
	def slotSelectionStats(self, total, selTotal):
		self.slotUpdateUI()
		if selTotal > 0:
			self.selectionLabel.setText(i18n("%d of %d" % (selTotal,total)))
		elif total == 1:
			self.selectionLabel.setText(i18n("1 photo"))
		else:
			self.selectionLabel.setText(i18n("%d photos" % (total)))
		
	def slotErrorMessage(self, text):
		KMessageBox.error(self, text)

	def slotPrint(self):
		# get current selection
		keys = self.organizeView.getWorkingSet()
		imagePaths = [self.lib.getImage(key)['ImagePath'] for key in keys]
		if imagePaths:
			p = LPrinter(self)
			p.doPrint(imagePaths)
			
	def slotSelectAll(self):
		self.organizeView.selectAll()
		
	def slotEmail(self):
		# get current selection
		keys = self.organizeView.getWorkingSet()
##~ 		dialog = LEmail(self, self.lib, len(keys))
##~ 		if dialog.exec_loop() == QDialog.Accepted:
##~ 			dialog.composeEmail(app, keys)
		dialog = LEmailExport(self, keys)
		if dialog.exec_loop() == QDialog.Accepted:
			dialog.export()
		

	def slotUpdateUI(self):
		(total, sel) = self.organizeView.getSelCount()
		bHasPhotos = total > 0
		bHasSel = sel > 0
		dict = self.organizeView.getAlbum()
		if dict:
			sort = dict['Sort']
			writeable = dict['W']
			trash = dict['AlbumName'] == self.lib.strTrash 
			
		bPhotoOps = bHasSel and not trash
		bHasPhotos = bHasPhotos and not trash
		
		# album has selection?
		a = self.actionCollection().action("newAlbumFromSelection")
		a.setEnabled(bHasSel)
##~ 		a = self.actionCollection().action("showInfo")
##~ 		a.setEnabled(bHasSel)
		a = self.actionCollection().action("rotateClockwise")
		a.setEnabled(bPhotoOps)
		a = self.actionCollection().action("rotateCounterClockwise")
		a.setEnabled(bPhotoOps)
		a = self.actionCollection().action("duplicate")
		a.setEnabled(bPhotoOps)
		a = self.actionCollection().action("dateSwap")
		a.setEnabled(bPhotoOps)
		a = self.actionCollection().action("moveToTrash")
		a.setEnabled(bPhotoOps)
		a = self.actionCollection().action("revert")
		a.setEnabled(bPhotoOps)
		
		self.rotateButton.setEnabled(bPhotoOps)

		# album has photos?
		a = self.actionCollection().action("file_print")
		a.setEnabled(bHasPhotos)
		a = self.actionCollection().action("burnAlbum")
		a.setEnabled(bHasPhotos)
		a = self.actionCollection().action("burnVCD")
		a.setEnabled(bHasPhotos)
		
		a = self.actionCollection().action("exportSelection")
		a.setEnabled(bHasPhotos)

		self.playButton.setEnabled(bHasPhotos)
		self.infoButton.setEnabled(bHasPhotos)
		self.organizePanel.emailButton.setEnabled(bHasPhotos)
		self.organizePanel.printButton.setEnabled(bHasPhotos)
		self.organizePanel.slideShowButton.setEnabled(bHasPhotos)
		self.organizePanel.homepageButton.setEnabled(bHasPhotos)
		self.organizePanel.desktopButton.setEnabled(sel == 1 and not trash)
		
		a = self.actionCollection().action("viewTitle")
		a.setChecked(self.organizeView.viewTitle)
		a = self.actionCollection().action("viewRating")
		a.setChecked(self.organizeView.viewRating)
		a = self.actionCollection().action("arrangeTitle")
		a.setChecked(sort=="Caption")
		a = self.actionCollection().action("arrangeDate")
		a.setChecked(sort=="Date")
		a = self.actionCollection().action("arrangeRating")
		a.setChecked(sort=="Rating")
		a = self.actionCollection().action("arrangeManually")
		a.setChecked(sort=="Manual")
		a.setEnabled(writeable and not trash)
		
		a = self.actionCollection().action("setScreensaver")
		a.setEnabled(bHasPhotos)
		
	def slotExportHTML(self):
##~ 		dialog = LHTMLExport(self, self.lib, name)
##~ 		if dialog.exec_loop() == QDialog.Accepted:
##~ 			keys = self.organizeView.getWorkingSet()
##~ 			dialog.exportHTML(keys)
			
		dialog = LHtmlExport(self, self.organizeView.albumPath, self.organizeView.getWorkingSet())
		if dialog.exec_loop() == QDialog.Accepted:
			dialog.export()
			
			
	def slotSetDesktop(self):
		key = self.organizeView.currentKey()
		if key:
			dict = self.lib.getImage(key)
			os.system("dcop kdesktop KBackgroundIface setWallpaper \"%s\" 1"%(dict['ImagePath']))
			os.system("dcop kdesktop KBackgroundIface setWallpaper \"%s\" 6"%(dict['ImagePath']))
			
	def slotAppQuiting(self):
		self.lib.writeLibrary()
		self.saveWindowPosition()
		self.settings = None
		
	def slotSetScreensaver(self):
		self.lib.setScreensaverAlbum(self.organizeView.albumPath)
		
	def slotLaunchScreensaver(self):
		os.system("dcop kdesktop KScreensaverIface save")
		
	def slotEmptyTrash(self):
		result = QMessageBox.warning(None, i18n("Lphoto: Empty Trash"), i18n("Do you want to delete the contents of the Trash?"), i18n("Yes, delete the images."), i18n("No"),  None,  1, 1)
		if result == 0:
			self.lib.trashEmptyTrash()
			
	def slotPreferences(self):
		dialog = LPrefsDialog()
		dialog.exec_loop()
		
	def slotNewAlbum(self):
		# create a new album as a child of selected album, if current album 
		writeable = self.organizeView.getAlbum()['W']
		self.lib.slotNewAlbum(writeable and self.organizeView.albumPath or [])
		
	def slotBurnAlbum(self):
		if self.burnDialog:
			return
			
		self.burnDialog = LCDRecordDialog(self.lib, self.organizeView.albumPath)
		QObject.connect(self.burnDialog, PYSIGNAL("complete"), self.slotCloseBurn)		
		if self.burnDialog.exec_loop() == QDialog.Accepted:
			self.burnDialog.burn()
		else:
			self.burnDialog = None
		
	def slotCloseBurn(self):
		self.burnDialog = None

	def slotBurnVCD(self):
		if self.vcdDialog:
			return
			
		self.vcdDialog = LVCDDialog(self.lib, self.organizeView.albumPath)
		QObject.connect(self.vcdDialog, PYSIGNAL("complete"), self.slotCloseVCD)		
		if self.vcdDialog.exec_loop() == QDialog.Accepted:
			self.vcdDialog.burn()
		else:
			self.vcdDialog = None
			
	def slotCloseVCD(self):
		self.vcdDialog = None

	def getAction(self, name):
		return self.actionCollection().action(name)
		
	def getSelection(self):
		# return the list of selected items
		return [ i.key for i in self.organizeView.itemsSel ]
		
	def saveWindowPosition(self):
		r = QRect(self.pos(), self.size())
		self.settings.writeEntryRect("Geometry", "mainwindow", r)
		self.settings.writeEntryList("Geometry", "infosplitter", self.infoSplitter.sizes())
		self.settings.writeEntryList("Geometry", "mainsplitter", self.mainSplitter.sizes())
		self.settings.writeEntryBool("Geometry", "infovisible", self.infoPanel.isShown())
		self.settings.writeEntry("Organize", "scale", self.organizeSlider.value())
		self.settings.writeEntryBool("Organize", "viewtitle", self.organizeView.viewTitle)
		self.settings.writeEntryBool("Organize", "viewrating", self.organizeView.viewRating)
		self.settings.writeEntryList("Organize", "albumPath", self.organizeView.albumPath)
		
		
	def restoreWindowPosition(self):
		r = self.settings.readEntryRect("Geometry", "mainwindow", None)
		if r:
			self.resize(r.size())
			self.move(r.topLeft())
		else:
			self.showMaximized()
		self.infoSplitter.setSizes(self.settings.readEntryList("Geometry", "infosplitter"))
		self.mainSplitter.setSizes(self.settings.readEntryList("Geometry", "mainsplitter"))
		if self.settings.readEntryBool("Geometry", "infovisible", True):
			self.infoPanel.show()
		else:
			self.infoPanel.hide()
			
		self.organizeSlider.setValue(int(self.settings.readEntry("Organize", "scale", self.organizeSlider.value())))
		self.organizeView.viewTitle = self.settings.readEntryBool("Organize", "viewtitle", True)
		self.organizeView.viewRating = self.settings.readEntryBool("Organize", "viewrating", True)
		
		path = self.settings.readEntryList("Organize", "albumPath", [self.lib.strMasterAlbum])
		album = self.lib.getAlbum(path)
		if album:
			self.albumList.selectFromPath(path)
		else:
			self.albumList.selectFromPath([self.lib.strMasterAlbum])

		self.slotUpdateUI()
		
	def event(self, e):
		if e.type() == LStartAppEvent.id:
			if self.lib.firstTime:
				self.slotImportMyPhotos()
			return True
		else:
			return KMainWindow.event(self, e)


if __name__ == "__main__":
	global DesktopName, Program, Title, Version, Copyright, Url, BugEmail, Author, AuthorEmail
	about = KAboutData(DesktopName, Program, Version, Title,	KAboutData.License_GPL,Copyright, "", Url, BugEmail)
	about.addAuthor(Author, "", AuthorEmail,"")
	
	paths.basePath()
	KCmdLineArgs.init(sys.argv,about)
	#KUniqueApplication.addCmdLineOptions()
	#app = KApplication(sys.argv, "Lphoto")
	app = KUniqueApplication(True,True,False)
	LWaitCursor.setApp(app)
	mw = LMainPhoto(app)
	mw.setIcon(QPixmap(paths.art("icon.png")))
	mw.restoreWindowPosition()
	mw.show()
	app.setMainWidget(mw)
	app.postEvent(mw, LStartAppEvent())
	KImageIO.registerFormats()
	app.exec_loop()
