import os

__basePath = None

def basePath():
	global __basePath
	if __basePath==None:
		(__basePath,file) = os.path.split(os.sys.argv[0])
		if len(__basePath)==0:
			__basePath = '.'
	return __basePath

__imagePath = None

def art(name):
	global __imagePath
	if __imagePath==None:
		__imagePath = os.path.join(basePath(),'images')
	return os.path.join(__imagePath,name)

__templatePath = None

def template(name):
	global __templatePath
	if __templatePath==None:
		__templatePath = os.path.join(basePath(),'templates')
	return os.path.join(__templatePath,name)
	
def templatePath():
	global __templatePath
	if __templatePath==None:
		__templatePath = os.path.join(basePath(),'templates')
	return __templatePath
	

def script(name):
	return os.path.join(basePath(),name)
	
