from qt import *
from utils import *
from kdeprint import *

class LPrinter(QObject):
	def __init__(self, parent):
		QObject.__init__(self, parent)
		
	def doPrint(self, images):
		printer = KPrinter()
		printer.setResolution(100)
		myPage = LPrinterSizePage(self.parent())
		myPage.serializeOptions(self.parent().settings, True)
		printer.addDialogPage(myPage)
		if printer.setup(None, "Print Photos", True):
			myPage.serializeOptions(self.parent().settings, False)
			p = QPainter()
			p.begin(printer)

			s = myPage.getPictureSize()
			rects = self.optimizeLayout(p.viewport(), s)
			i = 0
			#p.drawRect(p.viewport())
			while i < len(images):
				self.drawImage(images[i], p, rects[i%len(rects)])
				i = i + 1
				if i % len(rects) == 0 and i < len(images):
					printer.newPage()
			p.end()

	def drawImage(self, imagepath, p, r):
		#p.drawRect(r)
		i = QImage(imagepath)
		ri = i.rect()
		# determine orientation of rects
		ratioR = r.width()/float(r.height())
		ratioI = ri.width()/float(ri.height())
		if ratioR > 1 and ratioI < 1 or ratioR < 1 and ratioI > 1:
			#rotate image 90 counter clockwise
			m = QWMatrix()
			m.rotate(-90)
			i = i.xForm(m)
			ri = i.rect()
		ro = LUtils.mapRect(r, ri)
		p.drawImage(ro,i)
		
	def optimizeLayout(self, pageRect, s):
		l1 = self.computePageLayout(pageRect, s)
		s.transpose()
		l2 = self.computePageLayout(pageRect, s)
		print "layout choice l1=",len(l1),"l2=",len(l2),pageRect.width(),pageRect.height()
		if len(l1)==0 and len(l2)==0:
			return [pageRect] # if no rects fit in this page, return a single rect, the page size
		elif len(l1) > len(l2):
			return l1
		else:
			return l2
	
	def computePageLayout(self, pageRect, s):
		list = []
		spaces = []
		r = QRect(QPoint(0,0), s)
		ph = pageRect.height()# - 20 # corrects for printer incorrectly reporting margins
		pw = pageRect.width()
		sx = pw/(r.width())
		sy = ph/(r.height())
		if sy == 0 or sx == 0:
			return list
		w = pw/sx
		h = ph/sy
		r1 = QRect(0,0,w,h) # start with initial offset
		
		for j in range(sy):
			for i in range(sx):
				spaces.append(QRect(r1))
				r1.moveBy(w,0)
			r1.moveBy(-r1.x(),h)
			
		for space in spaces: 
			print "space",space.x(),space.y(),space.width(),space.height()
			LUtils.centerRect(r, space.center(), space)
			list.append(QRect(r))
		return list
		
class LPrinterSizePage(KPrintDialogPage):
	def __init__(self, parent):
		KPrintDialogPage.__init__(self, parent)
		self.setTitle("Photo Options")
		hl = QHBoxLayout(self)##~ import _kdesip

		l = QLabel("Photo Size:  ", self)
		hl.addWidget(l)
		self.formatList = QComboBox(self)
		hl.addWidget(self.formatList)
		hl.addStretch()
		
		self.sizes=[]
		self.sizes.append(["Thumbnails", QSize(120,150)])
		self.sizes.append(["2 x 2.5", QSize(200,250)])
		self.sizes.append(["3 x 5", QSize(300,500)])
		self.sizes.append(["4 x 5", QSize(400,600)])
		self.sizes.append(["5 x 7", QSize(500,700)])
		self.sizes.append(["8 x 10", QSize(800,1000)])
		for size in self.sizes:
			self.formatList.insertItem(size[0])
			
		self.sizeIndex = 0

		QObject.connect(self.formatList, SIGNAL("activated(int)"), self.slotTextChanged)
	
	def serializeOptions(self, settings, bRestore):
		category = "PrintOptions"
		key = "size"
		if bRestore:
			s = settings.readEntry(category, key, None)
			if s:
				i = self.formatList.listBox().index(self.formatList.listBox().findItem(s))
				self.formatList.setCurrentItem(i)
		else:
			# combo box is already destroyed by the time we call this
			settings.writeEntry(category, key, self.sizes[self.sizeIndex][0])

	def getPictureSize(self):
		return self.sizes[self.sizeIndex][1]

	def slotTextChanged(self, i):
		self.sizeIndex = i
		
# getOptions and setOptions don't work because the map isn't passed back to to QT	
##~ 	def getOptions(self, map, bDefault):
##~ 		# map is a dict like {<QString>:<QString>} so we can't use normal python access
##~ 		destKey = QString("kde-lphoto-printsize")
##~ 		for key,value in map.iteritems():
##~ 			print key,"=", value
##~ 			if str(key)=="kde-lphoto-printsize":
##~ 				destKey = key
##~ 				break;
##~ 		
##~ 		if bDefault:
##~ 			map[destKey]=QString(self.sizes[2][0])
##~ 		else:
##~ 			map[destKey]=QString(self.formatList.currentText())
##~ 			
##~ 	def setOptions(self, map):
##~ 		# map is a dict like {<QString>:<QString>} so we can't use normal python access
##~ 		for key,value in map.iteritems():
##~ 			if str(key)=="kde-lphoto-printsize":
##~ 				self.formatList.setEditText(str(value))
				
# this is the old dialog for non-kde printing	
##~ class LPrintDialog(QDialog):
##~ 	def __init__(self, parent):
##~ 		QDialog.__init__(self, parent, "Lphoto", True)
##~ 		vl = QVBoxLayout(self)
##~ 		hl = QHBoxLayout(vl)
##~ 		l = QLabel("Photo Size:", self)
##~ 		hl.addWidget(l)
##~ 		self.formatList = QComboBox(self)
##~ 		hl.addWidget(self.formatList)
##~ 		hl.addStretch()
##~ 		
##~ 		self.sizes=[]
##~ 		self.sizes.append(["Thumbnails", QSize(120,150)])
##~ 		self.sizes.append(["2 x 2.5", QSize(200,250)])
##~ 		self.sizes.append(["3 x 5", QSize(300,500)])
##~ 		self.sizes.append(["4 x 5", QSize(400,600)])
##~ 		self.sizes.append(["5 x 7", QSize(500,700)])
##~ 		self.sizes.append(["8 x 10", QSize(800,1000)])
##~ 		for size in self.sizes:
##~ 			self.formatList.insertItem(size[0])
##~ 			
##~ 		self.size = self.sizes[0][1]
##~ 		
##~ 		hl = QHBoxLayout(vl)
##~ 		hl.addStretch()
##~ 		self.printButton = QPushButton("Print", self)
##~ 		hl.addWidget(self.printButton)
##~ 		self.printButton.setDefault(True)
##~ 		hl.addSpacing(5)
##~ 		self.cancelButton = QPushButton("Cancel", self)
##~ 		hl.addWidget(self.cancelButton)
##~ 		QObject.connect(self.printButton, SIGNAL("clicked()"), self, SLOT("accept()"))
##~ 		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))
##~ 
##~ 	def done(self, result):
##~ 		self.size = self.sizes[self.formatList.currentItem()][1]
##~ 		return QDialog.done(self, result)
