#ifndef H_FRAGMENT
#define H_FRAGMENT

#include <sys/time.h>
#include <net/bpf.h>

struct fragment {
	struct bpf_insn *insns;				/* array of instructions */
	int numinsns;									/* number of instructions */
	int *true, *false;						/* arrays of offsets of fixups for
																	 true and false branches */
	int numtrue, numfalse;				/* lengths of offset arrays */
	int *ftrue, *tfalse;					/* arrays of offsets of fixups for
																	 true and false branches that aren't */
	int numftrue, numtfalse;
};

struct fragment *frag_new();
void frag_free(struct fragment *);
void frag_fixupt(struct fragment *, int);
void frag_fixupf(struct fragment *, int);
void frag_append(struct fragment *, struct fragment *);
void frag_add(struct fragment *, struct bpf_insn *);
void frag_sett(struct fragment *);
void frag_setf(struct fragment *);
void frag_setft(struct fragment *);
void frag_settf(struct fragment *);

#endif /* !H_FRAGMENT */
