/*
 * dslk.h -- SCO header file for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: dlslk.h,v 1.6 99/11/10 15:01:08 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_SCO)
#define	DLSLK_H_SCO	1

# if	OSRV>=500
#include <dirent.h>
#include <sys/utsname.h>
# endif	/* OSRV>=500 */

#include <fcntl.h>
#include <mnttab.h>
#include <nlist.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

# if	OSRV>=500
#include <strings.h>
# endif	/* OSRV>=500 */

#include <sys/dir.h>
#include <sys/flock.h>
#include <sys/inode.h>
#include <sys/socket.h>
#include <sys/netinet/in.h>
#include <arpa/inet.h>
#include <sys/immu.h>
#include <sys/region.h>
#include <sys/proc.h>
#include <sys/sysi86.h>
#include <sys/user.h>
#include <sys/var.h>

# if	defined(HAS_NFS)
#include <sys/fs/nfs/types.h>
#include <sys/fs/nfs/xdr.h>

#  if	OSRV<500
/*
 * Structure for kernel's NFS lock information in Release 3.0
 */

struct NFS_lock_info {
	struct inode *ip;		/* the inode that has a lock */
	pid_t l_pid;			/* the pseudo-PID assigned to the flock
					 * structure's l_pid element */
	short dummy;			/* unknown */
	struct netobj ci;		/* the NFS client identity */
	unsigned long f_pid;		/* the foreign PID */
	struct NFS_lock_info *forw;	/* forward reference */
};
#  else	/* OSRV>=500 */
#include <sys/select.h>
#include <sys/tiuser.h>
#include <sys/fs/nfs/nfs.h>
#include <sys/fs/nfs/lockd.h>
#include <sys/fs/nfs/nlm_prot.h>
#include <sys/fs/nfs/klm.h>
#  endif	/* OSRV<500 */
# endif	/* defined(HAS_NFS) */


/*
 * This confusing sequence of redefinitions of xdevmap allows lslk to size
 * its copy of the kernel's xdevmap[] table dynamically, based on the
 * kernel's nxdevmaps value.
 *
 * The net result is that there is a dummy struct XDEVMAP[1], defined in
 * dstore.c, that is never used.  The copy of the kernel's xdevmap[] table
 * is stored in the space malloc()'d in dproc.c and addressed by Xdevmap.
 * The last redefinition of xdevmap to Xdevmap causes the macroes of
 * <sys/sysmacros.h> to use Xdevmap.
 *
 * All this is done: 1) to avoid having to allocate a large amount of fixed
 * space in advance to a copy of the kernel's xdevmap; and 2) to keep CC from
 * complaining about the absence of a "struct xdevmap xdevmap[]," matching
 * the "extern struct xdevmap xdevmap[]" declaration in <sys/sysmacros.h>,
 * while still allowing lslk to use the equivalent of a "struct xdevmap *"
 * construct instead, particularly with the kernel forms of the major() and
 * minor() macroes.
 */

#define	xdevmap	XDEVMAP
#define	_INKERNEL
#include <sys/sysmacros.h>
#undef	_INKERNEL
extern struct XDEVMAP *Xdevmap;
#undef	xdevmap
#define	xdevmap	Xdevmap


/*
 * Local definitions
 */

#define	COMP_P		const void	/* qsort() compare pointer type */
#define	KA_T		off_t		/* kernel address type for kread() */
#define	KMEM		"/dev/kmem"
#define	LMEMCPY_P	char		/* local memcpy() type */
#define	lmemcpy		memcpy		/* local memcpy() */
#define	MALLOC_P	void		/* malloc() pointer cast */
#define	MALLOC_S	size_t		/* malloc() size cast */

# if	!defined(MAXPATHLEN)
#define	MAXPATHLEN	1024
# endif	/* !defined(MAXPATHLEN) */

#define	MNTTAB		"/etc/mnttab"	/* mount table path */

# if	OSRV<500
#define	N_UNIX		"/unix"		/* name list path */
# endif	/* OSRV<500 */

#define	QSORT_P		void		/* qsort() table pointer type */

/*
 * Nl indexes
 */

#define	X_HINODE	0

# if	defined(HAS_NFS)
#define X_LCKSVR	1
#define	X_NXD		2
#define	X_PROC		3
#define	X_VAR		4
#define	X_XDEV		5
#define	X_SCOUTS	6		/* *MUST* be last */
# else	/* !defined(HAS_NFS) */
#define	X_NXD		1
#define	X_PROC		2
#define	X_VAR		3
#define	X_XDEV		4
#define	X_SCOUTS	5		/* *MUST* be last */
# endif	/* defined(HAS_NFS) */


/*
 * Local structure definitions
 */


/*
 * Local global variables
 */

extern int Kd;
extern struct nlist Nl[];
extern int nxdevmaps;

# endif	/* defined(DLSLK_H_SCO) */
