/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * ipcshm.h - common definitions for the IPC shared memory tests
 */

#ifndef __IPCSHM_H
#define __IPCSHM_H

#include <errno.h>
#include <wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "test.h"
#include "usctest.h"

void cleanup(void);
void setup(void);

#define SHM_RD	0400
#define SHM_WR	0200
#define SHM_RW	SHM_RD | SHM_WR

#ifndef SHM_HUGETLB
#define SHM_HUGETLB   04000    /* segment is mapped via hugetlb */
#endif

#define HUGE_SHM_SIZE	(256UL*1024UL*1024UL)	/* a resonable size for a large page segment */

#define MODE_MASK	0x01FF			/* to get the lower nine permission bits */
						/* from shmid_ds.ipc_perm.mode		 */

key_t shmkey;					/* an IPC key generated by ftok() */

void rm_shm(int shm_id);
void check_root();

int getipckey();
int getuserid(char*);

#endif /* ipcshm.h */
