
/* some dummy functions and variables so that a few ff source files can be ignored */

#define FONTFORGE_CONFIG_NO_WINDOWING_UI 1

#include "pfaeditui.h"
#include <unistd.h>
#include <math.h>
#include <time.h>
#include <locale.h>
#include <utype.h>
#include <chardata.h>
#include <ustring.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sd.h"

#include "ttf.h" /* for macsettingname */

void _gwwv_post_error(const char *fmt, va_list ap) ;

/* some Gdraw routines for filesystem access */


int GFileIsDir(const char *file) {
    char buffer[1000];
    sprintf(buffer,"%s/.",file);
return( access(buffer,0)==0 );
}

int GFileExists(const char *file) {
return( access(file,0)==0 );
}

char *GFileNameTail(const char *oldname) {
    char *pt;

    pt = strrchr(oldname,'/');
    if ( pt !=NULL )
return( pt+1);
    else
return( (char *)oldname );
}


char *GFileAppendFile(char *dir,char *name,int isdir) {
    char *ret, *pt;

    ret = galloc((strlen(dir)+strlen(name)+3));
    strcpy(ret,dir);
    pt = ret+strlen(ret);
    if ( pt>ret && pt[-1]!='/' )
        *pt++ = '/';
    strcpy(pt,name);
    if ( isdir ) {
        pt += strlen(pt);
        if ( pt>ret && pt[-1]!='/' ) {
            *pt++ = '/';
            *pt = '\0';
        }
    }
return(ret);
}

int GFileReadable(char *file) {
return( access(file,04)==0 );
}

static char dirname_[1024];


char *GFileGetAbsoluteName(char *name, char *result, int rsiz) {
    /* result may be the same as name */
    char buffer[1000];

    if ( *name!='/' ) {
        char *pt, *spt, *rpt, *bpt;

        if ( dirname_[0]=='\0' ) {
            getcwd(dirname_,sizeof(dirname_));
        }
        strcpy(buffer,dirname_);
        if ( buffer[strlen(buffer)-1]!='/' )
            strcat(buffer,"/");
        strcat(buffer,name);

        /* Normalize out any .. */
        spt = rpt = buffer;
        while ( *spt!='\0' ) {
            if ( *spt=='/' ) ++spt;
            for ( pt = spt; *pt!='\0' && *pt!='/'; ++pt );
            if ( pt==spt )      /* Found // in a path spec, reduce to / (we've*/
                strcpy(spt,pt); /*  skipped past the :// of the machine name) */
            else if ( pt==spt+1 && spt[0]=='.' )        /* Noop */
                strcpy(spt,pt);
            else if ( pt==spt+2 && spt[0]=='.' && spt[1]=='.' ) {
                for ( bpt=spt-2 ; bpt>rpt && *bpt!='/'; --bpt );
                if ( bpt>=rpt && *bpt=='/' ) {
                    strcpy(bpt,pt);
                    spt = bpt;
                } else {
                    rpt = pt;
                    spt = pt;
                }
            } else
                spt = pt;
        }
        name = buffer;
        if ( rsiz>sizeof(buffer)) rsiz = sizeof(buffer);        /* Else valgrind gets unhappy */
    }
    if (result!=name) {
        strncpy(result,name,rsiz);
        result[rsiz-1]='\0';
    }
return(result);
}



/* a gettext miss */

char *sgettext(const char *msgid) {
    const char *msgval = msgid;
    char *found;
    if ( (found = strrchr (msgid, '|'))!=NULL )
      msgval = found+1;
    return (char *) msgval;
}

/* some utype.c macros, in function from */

int unic_isrighttoleft (int c) {
  /* most of the holes are combining chars */
  if ((c==0x05be) || (c==0x05c0) || (c==0x05c3) || (c==0x05c6) ||
	  (c>=0x05d0 && c<=0x05ea) ||
	  (c>=0x05f0 && c<=0x05f4) ||
	  (c>=0x0600 && c<=0x0603) ||
	  (c==0x060b) || (c==0x060d) || (c==0x061b) ||
	  (c>=0x061e && c<=0x061f) ||
	  (c>=0x0621 && c<=0x063a) ||
	  (c>=0x0640 && c<=0x064a) ||
	  (c>=0x066d && c<=0x066f) ||
	  (c>=0x0671 && c<=0x06d5) ||
	  (c==0x06dd) ||
	  (c>=0x06e5 && c<=0x06e6) ||
	  (c>=0x06ee && c<=0x06ef) ||
	  (c>=0x06fa && c<=0x070d) ||
	  (c==0x0710) ||
	  (c>=0x0712 && c<=0x072f) ||
	  (c>=0x074d && c<=0x076d) ||
	  (c>=0x0780 && c<=0x07a5) ||
	  (c==0x07b1) ||
	  (c>=0x07c0 && c<=0x07ea) ||
	  (c>=0x07f4 && c<=0x07f5) ||
	  (c==0x07fa) ||
	  (c==0x200f) || (c==0x202b) || (c==0x202e) || 
	  (c>=0xfb1d && c<=0xfb3c) ||
	  (c==0xfb3e) ||
	  (c>=0xfb40 && c<=0xfbb1) ||
	  (c>=0xfbd3 && c<=0xfd3d) || 
	  (c>=0xfd50 && c<=0xfd8f) ||
	  (c>=0xfd92 && c<=0xfdc7) || 
	  (c>=0xfdf0 && c<=0xfdfc) ||
	  (c>=0xfe70 && c<=0xfefc)) {
	if ((c==0xfe75) || (c==0xfb42) || 
		(c==0xfb45) || (c==0xfb29) || 
		(c==0xfb37) || (c==0xfb1e)) {
	  return 0;
	}
	return 1;
  }
  return 0;
}

int unic_islefttoright (int c) {
  if((c>=0x0041 && c<=0x005a) || 
	 (c>=0x0061 && c<=0x007a) || 
	 (c==0x00aa) || (c==0x00b5) || (c==0x00ba) || 
	 (c>=0x00c0 && c<=0x00d6) || 
	 (c>=0x00d8 && c<=0x00f6) || 
	 (c>=0x00f8 && c<=0x02b8) || 
	 (c>=0x02bb && c<=0x02c1) || 
	 (c>=0x02d0 && c<=0x02d1) || 
	 (c>=0x02e0 && c<=0x02e4) || 
	 (c==0x02ee) || 
	 (c>=0x037a && c<=0x037d) || 
	 (c==0x0386) || 
	 (c>=0x0388 && c<=0x038a) || 
	 (c==0x038c) || 
	 (c>=0x038e && c<=0x03a1) || 
	 (c>=0x03a3 && c<=0x03ce) || 
	 (c>=0x03d0 && c<=0x03f5) || 
	 (c>=0x03f7 && c<=0x0482) || 
	 (c>=0x048a && c<=0x0513) || 
	 (c>=0x0531 && c<=0x0556) || 
	 (c>=0x0559 && c<=0x055f) || 
	 (c>=0x0561 && c<=0x0587) || 
	 (c==0x0589) || 
	 (c>=0x0903 && c<=0x0939) || 
	 (c>=0x093d && c<=0x0940) || 
	 (c>=0x0949 && c<=0x094c) || 
	 (c==0x0950) || 
	 (c>=0x0958 && c<=0x0961) || 
	 (c>=0x0964 && c<=0x0970) || 
	 (c>=0x097b && c<=0x097f) || 
	 (c>=0x0982 && c<=0x0983) || 
	 (c>=0x0985 && c<=0x098c) || 
	 (c>=0x098f && c<=0x0990) || 
	 (c>=0x0993 && c<=0x09a8) || 
	 (c>=0x09aa && c<=0x09b0) || 
	 (c==0x09b2) || 
	 (c>=0x09b6 && c<=0x09b9) || 
	 (c>=0x09bd && c<=0x09c0) || 
	 (c>=0x09c7 && c<=0x09c8) || 
	 (c>=0x09cb && c<=0x09cc) || 
	 (c==0x09ce) || 
	 (c==0x09d7) || 
	 (c>=0x09dc && c<=0x09dd) || 
	 (c>=0x09df && c<=0x09e1) || 
	 (c>=0x09e6 && c<=0x09f1) || 
	 (c>=0x09f4 && c<=0x09fa) || 
	 (c==0x0a03) || 
	 (c>=0x0a05 && c<=0x0a0a) || 
	 (c>=0x0a0f && c<=0x0a10) || 
	 (c>=0x0a13 && c<=0x0a28) || 
	 (c>=0x0a2a && c<=0x0a30) || 
	 (c>=0x0a32 && c<=0x0a33) || 
	 (c>=0x0a35 && c<=0x0a36) || 
	 (c>=0x0a38 && c<=0x0a39) || 
	 (c>=0x0a3e && c<=0x0a40) || 
	 (c>=0x0a59 && c<=0x0a5c) || 
	 (c==0x0a5e) || 
	 (c>=0x0a66 && c<=0x0a6f) || 
	 (c>=0x0a72 && c<=0x0a74) || 
	 (c==0x0a83) || 
	 (c>=0x0a85 && c<=0x0a8d) || 
	 (c>=0x0a8f && c<=0x0a91) || 
	 (c>=0x0a93 && c<=0x0aa8) || 
	 (c>=0x0aaa && c<=0x0ab0) || 
	 (c>=0x0ab2 && c<=0x0ab3) || 
	 (c>=0x0ab5 && c<=0x0ab9) || 
	 (c>=0x0abd && c<=0x0ac0) || 
	 (c==0x0ac9) || 
	 (c>=0x0acb && c<=0x0acc) || 
	 (c==0x0ad0) || 
	 (c>=0x0ae0 && c<=0x0ae1) || 
	 (c>=0x0ae6 && c<=0x0aef) || 
	 (c>=0x0b02 && c<=0x0b03) || 
	 (c>=0x0b05 && c<=0x0b0c) || 
	 (c>=0x0b0f && c<=0x0b10) || 
	 (c>=0x0b13 && c<=0x0b28) || 
	 (c>=0x0b2a && c<=0x0b30) || 
	 (c>=0x0b32 && c<=0x0b33) || 
	 (c>=0x0b35 && c<=0x0b39) || 
	 (c>=0x0b3d && c<=0x0b3e) || 
	 (c==0x0b40) || 
	 (c>=0x0b47 && c<=0x0b48) || 
	 (c>=0x0b4b && c<=0x0b4c) || 
	 (c==0x0b57) || 
	 (c>=0x0b5c && c<=0x0b5d) || 
	 (c>=0x0b5f && c<=0x0b61) || 
	 (c>=0x0b66 && c<=0x0b71) || 
	 (c==0x0b83) || 
	 (c>=0x0b85 && c<=0x0b8a) || 
	 (c>=0x0b8e && c<=0x0b90) || 
	 (c>=0x0b92 && c<=0x0b95) || 
	 (c>=0x0b99 && c<=0x0b9a) || 
	 (c==0x0b9c) || 
	 (c>=0x0b9e && c<=0x0b9f) || 
	 (c>=0x0ba3 && c<=0x0ba4) || 
	 (c>=0x0ba8 && c<=0x0baa) || 
	 (c>=0x0bae && c<=0x0bb9) || 
	 (c>=0x0bbe && c<=0x0bbf) || 
	 (c>=0x0bc1 && c<=0x0bc2) || 
	 (c>=0x0bc6 && c<=0x0bc8) || 
	 (c>=0x0bca && c<=0x0bcc) || 
	 (c==0x0bd7) || 
	 (c>=0x0be6 && c<=0x0bf2) || 
	 (c>=0x0c01 && c<=0x0c03) || 
	 (c>=0x0c05 && c<=0x0c0c) || 
	 (c>=0x0c0e && c<=0x0c10) || 
	 (c>=0x0c12 && c<=0x0c28) || 
	 (c>=0x0c2a && c<=0x0c33) || 
	 (c>=0x0c35 && c<=0x0c39) || 
	 (c>=0x0c41 && c<=0x0c44) || 
	 (c>=0x0c60 && c<=0x0c61) || 
	 (c>=0x0c66 && c<=0x0c6f) || 
	 (c>=0x0c82 && c<=0x0c83) || 
	 (c>=0x0c85 && c<=0x0c8c) || 
	 (c>=0x0c8e && c<=0x0c90) || 
	 (c>=0x0c92 && c<=0x0ca8) || 
	 (c>=0x0caa && c<=0x0cb3) || 
	 (c>=0x0cb5 && c<=0x0cb9) || 
	 (c>=0x0cbd && c<=0x0cc4) || 
	 (c>=0x0cc6 && c<=0x0cc8) || 
	 (c>=0x0cca && c<=0x0ccb) || 
	 (c>=0x0cd5 && c<=0x0cd6) || 
	 (c==0x0cde) || 
	 (c>=0x0ce0 && c<=0x0ce1) || 
	 (c>=0x0ce6 && c<=0x0cef) || 
	 (c>=0x0d02 && c<=0x0d03) || 
	 (c>=0x0d05 && c<=0x0d0c) || 
	 (c>=0x0d0e && c<=0x0d10) || 
	 (c>=0x0d12 && c<=0x0d28) || 
	 (c>=0x0d2a && c<=0x0d39) || 
	 (c>=0x0d3e && c<=0x0d40) || 
	 (c>=0x0d46 && c<=0x0d48) || 
	 (c>=0x0d4a && c<=0x0d4c) || 
	 (c==0x0d57) || 
	 (c>=0x0d60 && c<=0x0d61) || 
	 (c>=0x0d66 && c<=0x0d6f) || 
	 (c>=0x0d82 && c<=0x0d83) || 
	 (c>=0x0d85 && c<=0x0d96) || 
	 (c>=0x0d9a && c<=0x0db1) || 
	 (c>=0x0db3 && c<=0x0dbb) || 
	 (c==0x0dbd) || 
	 (c>=0x0dc0 && c<=0x0dc6) || 
	 (c>=0x0dcf && c<=0x0dd1) || 
	 (c>=0x0dd8 && c<=0x0ddf) || 
	 (c>=0x0df2 && c<=0x0df4) || 
	 (c>=0x0e01 && c<=0x0e30) || 
	 (c>=0x0e32 && c<=0x0e33) || 
	 (c>=0x0e40 && c<=0x0e46) || 
	 (c>=0x0e4f && c<=0x0e5b) || 
	 (c>=0x0e81 && c<=0x0e82) || 
	 (c==0x0e84) || 
	 (c>=0x0e87 && c<=0x0e88) || 
	 (c==0x0e8a) || 
	 (c==0x0e8d) || 
	 (c>=0x0e94 && c<=0x0e97) || 
	 (c>=0x0e99 && c<=0x0e9f) || 
	 (c>=0x0ea1 && c<=0x0ea3) || 
	 (c==0x0ea5) || 
	 (c==0x0ea7) || 
	 (c>=0x0eaa && c<=0x0eab) || 
	 (c>=0x0ead && c<=0x0eb0) || 
	 (c>=0x0eb2 && c<=0x0eb3) || 
	 (c==0x0ebd) || 
	 (c>=0x0ec0 && c<=0x0ec4) || 
	 (c==0x0ec6) || 
	 (c>=0x0ed0 && c<=0x0ed9) || 
	 (c>=0x0edc && c<=0x0edd) || 
	 (c>=0x0f00 && c<=0x0f17) || 
	 (c>=0x0f1a && c<=0x0f34) || 
	 (c==0x0f36) || 
	 (c==0x0f38) || 
	 (c>=0x0f3e && c<=0x0f47) || 
	 (c>=0x0f49 && c<=0x0f6a) || 
	 (c==0x0f7f) || 
	 (c==0x0f85) || 
	 (c>=0x0f88 && c<=0x0f8b) || 
	 (c>=0x0fbe && c<=0x0fc5) || 
	 (c>=0x0fc7 && c<=0x0fcc) || 
	 (c>=0x0fcf && c<=0x0fd1) || 
	 (c>=0x1000 && c<=0x1021) || 
	 (c>=0x1023 && c<=0x1027) || 
	 (c>=0x1029 && c<=0x102a) || 
	 (c==0x102c) || 
	 (c==0x1031) || 
	 (c==0x1038) || 
	 (c>=0x1040 && c<=0x1057) || 
	 (c>=0x10a0 && c<=0x10c5) || 
	 (c>=0x10d0 && c<=0x10fc) || 
	 (c>=0x1100 && c<=0x1159) || 
	 (c>=0x115f && c<=0x11a2) || 
	 (c>=0x11a8 && c<=0x11f9) || 
	 (c>=0x1200 && c<=0x1248) || 
	 (c>=0x124a && c<=0x124d) || 
	 (c>=0x1250 && c<=0x1256) || 
	 (c==0x1258) || 
	 (c>=0x125a && c<=0x125d) || 
	 (c>=0x1260 && c<=0x1288) || 
	 (c>=0x128a && c<=0x128d) || 
	 (c>=0x1290 && c<=0x12b0) || 
	 (c>=0x12b2 && c<=0x12b5) || 
	 (c>=0x12b8 && c<=0x12be) || 
	 (c==0x12c0) || 
	 (c>=0x12c2 && c<=0x12c5) || 
	 (c>=0x12c8 && c<=0x12d6) || 
	 (c>=0x12d8 && c<=0x1310) || 
	 (c>=0x1312 && c<=0x1315) || 
	 (c>=0x1318 && c<=0x135a) || 
	 (c>=0x1360 && c<=0x137c) || 
	 (c>=0x1380 && c<=0x138f) || 
	 (c>=0x13a0 && c<=0x13f4) || 
	 (c>=0x1401 && c<=0x1676) || 
	 (c>=0x1681 && c<=0x169a) || 
	 (c>=0x16a0 && c<=0x16f0) || 
	 (c>=0x1700 && c<=0x170c) || 
	 (c>=0x170e && c<=0x1711) || 
	 (c>=0x1720 && c<=0x1731) || 
	 (c>=0x1735 && c<=0x1736) || 
	 (c>=0x1740 && c<=0x1751) || 
	 (c>=0x1760 && c<=0x176c) || 
	 (c>=0x176e && c<=0x1770) || 
	 (c>=0x1780 && c<=0x17b6) || 
	 (c>=0x17be && c<=0x17c5) || 
	 (c>=0x17c7 && c<=0x17c8) || 
	 (c>=0x17d4 && c<=0x17da) || 
	 (c==0x17dc) || 
	 (c>=0x17e0 && c<=0x17e9) || 
	 (c>=0x1810 && c<=0x1819) || 
	 (c>=0x1820 && c<=0x1877) || 
	 (c>=0x1880 && c<=0x18a8) || 
	 (c>=0x1900 && c<=0x191c) || 
	 (c>=0x1923 && c<=0x1926) || 
	 (c>=0x1930 && c<=0x1931) || 
	 (c>=0x1933 && c<=0x1938) || 
	 (c>=0x1946 && c<=0x196d) || 
	 (c>=0x1970 && c<=0x1974) || 
	 (c>=0x1980 && c<=0x19a9) || 
	 (c>=0x19b0 && c<=0x19c9) || 
	 (c>=0x19d0 && c<=0x19d9) || 
	 (c>=0x1a00 && c<=0x1a16) || 
	 (c>=0x1a19 && c<=0x1a1b) || 
	 (c>=0x1a1e && c<=0x1a1f) || 
	 (c>=0x1b04 && c<=0x1b33) || 
	 (c==0x1b35) || 
	 (c==0x1b3b) || 
	 (c>=0x1b3d && c<=0x1b41) || 
	 (c>=0x1b43 && c<=0x1b4b) || 
	 (c>=0x1b50 && c<=0x1b6a) || 
	 (c>=0x1b74 && c<=0x1b7c) || 
	 (c>=0x1d00 && c<=0x1dbf) || 
	 (c>=0x1e00 && c<=0x1e9b) || 
	 (c>=0x1ea0 && c<=0x1ef9) || 
	 (c>=0x1f00 && c<=0x1f15) || 
	 (c>=0x1f18 && c<=0x1f1d) || 
	 (c>=0x1f20 && c<=0x1f45) || 
	 (c>=0x1f48 && c<=0x1f4d) || 
	 (c>=0x1f50 && c<=0x1f57) || 
	 (c==0x1f59) || 
	 (c==0x1f5b) || 
	 (c==0x1f5d) || 
	 (c>=0x1f5f && c<=0x1f7d) || 
	 (c>=0x1f80 && c<=0x1fb4) || 
	 (c>=0x1fb6 && c<=0x1fbc) || 
	 (c==0x1fbe) || 
	 (c>=0x1fc2 && c<=0x1fc4) || 
	 (c>=0x1fc6 && c<=0x1fcc) || 
	 (c>=0x1fd0 && c<=0x1fd3) || 
	 (c>=0x1fd6 && c<=0x1fdb) || 
	 (c>=0x1fe0 && c<=0x1fec) || 
	 (c>=0x1ff2 && c<=0x1ff4) || 
	 (c>=0x1ff6 && c<=0x1ffc) || 
	 (c==0x200e) || 
	 (c==0x202a) || 
	 (c==0x202d) || 
	 (c==0x2071) || 
	 (c==0x207f) || 
	 (c>=0x2090 && c<=0x2094) || 
	 (c==0x2102) || 
	 (c==0x2107) || 
	 (c>=0x210a && c<=0x2113) || 
	 (c==0x2115) || 
	 (c>=0x2119 && c<=0x211d) || 
	 (c==0x2124) || 
	 (c==0x2126) || 
	 (c==0x2128) || 
	 (c>=0x212a && c<=0x212d) || 
	 (c>=0x212f && c<=0x2139) || 
	 (c>=0x213c && c<=0x213f) || 
	 (c>=0x2145 && c<=0x2149) || 
	 (c==0x214e) || 
	 (c>=0x2160 && c<=0x2184) || 
	 (c>=0x2336 && c<=0x237a) || 
	 (c==0x2395) || 
	 (c>=0x249c && c<=0x24e9) || 
	 (c==0x26ac) || 
	 (c>=0x2800 && c<=0x28ff) || 
	 (c>=0x2c00 && c<=0x2c2e) || 
	 (c>=0x2c30 && c<=0x2c5e) || 
	 (c>=0x2c60 && c<=0x2c6c) || 
	 (c>=0x2c74 && c<=0x2c77) || 
	 (c>=0x2c80 && c<=0x2ce4) || 
	 (c>=0x2d00 && c<=0x2d25) || 
	 (c>=0x2d30 && c<=0x2d65) || 
	 (c==0x2d6f) || 
	 (c>=0x2d80 && c<=0x2d96) || 
	 (c>=0x2da0 && c<=0x2da6) || 
	 (c>=0x2da8 && c<=0x2dae) || 
	 (c>=0x2db0 && c<=0x2db6) || 
	 (c>=0x2db8 && c<=0x2dbe) || 
	 (c>=0x2dc0 && c<=0x2dc6) || 
	 (c>=0x2dc8 && c<=0x2dce) || 
	 (c>=0x2dd0 && c<=0x2dd6) || 
	 (c>=0x2dd8 && c<=0x2dde) || 
	 (c>=0x3005 && c<=0x3007) || 
	 (c>=0x3021 && c<=0x3029) || 
	 (c>=0x3031 && c<=0x3035) || 
	 (c>=0x3038 && c<=0x303c) || 
	 (c>=0x3041 && c<=0x3096) || 
	 (c>=0x309d && c<=0x309f) || 
	 (c>=0x30a1 && c<=0x30fa) || 
	 (c>=0x30fc && c<=0x30ff) || 
	 (c>=0x3105 && c<=0x312c) || 
	 (c>=0x3131 && c<=0x318e) || 
	 (c>=0x3190 && c<=0x31b7) || 
	 (c>=0x31f0 && c<=0x321c) || 
	 (c>=0x3220 && c<=0x3243) || 
	 (c>=0x3260 && c<=0x327b) || 
	 (c>=0x327f && c<=0x32b0) || 
	 (c>=0x32c0 && c<=0x32cb) || 
	 (c>=0x32d0 && c<=0x32fe) || 
	 (c>=0x3300 && c<=0x3376) || 
	 (c>=0x337b && c<=0x33dd) || 
	 (c>=0x33e0 && c<=0x33fe) || 
	 (c>=0x3400 && c<=0x4db5) || 
	 (c>=0x4e00 && c<=0x9fbb) || 
	 (c>=0xa000 && c<=0xa48c) || 
	 (c>=0xa800 && c<=0xa801) || 
	 (c>=0xa803 && c<=0xa805) || 
	 (c>=0xa807 && c<=0xa80a) || 
	 (c>=0xa80c && c<=0xa824) || 
	 (c==0xa827) || 
	 (c>=0xa840 && c<=0xa873) || 
	 (c>=0xac00 && c<=0xd7a3) || 
	 (c>=0xd800 && c<=0xfa2d) || 
	 (c>=0xfa30 && c<=0xfa6a) || 
	 (c>=0xfa70 && c<=0xfad9) || 
	 (c>=0xfb00 && c<=0xfb06) || 
	 (c>=0xfb13 && c<=0xfb17) || 
	 (c>=0xff21 && c<=0xff3a) || 
	 (c>=0xff41 && c<=0xff5a) || 
	 (c>=0xff66 && c<=0xffbe) || 
	 (c>=0xffc2 && c<=0xffc7) || 
	 (c>=0xffca && c<=0xffcf) || 
	 (c>=0xffd2 && c<=0xffd7) || 
	 (c>=0xffda && c<=0xffdc)) {
	return 1;
  }
  return 0;
}

int unic_isdigit (int c) {
  if ((c>=0x0030 && c<=0x0039) ||
	  (c>=0x0660 && c<=0x0669) ||
	  (c>=0x06f0 && c<=0x06f9) ||
	  (c>=0x07c0 && c<=0x07c9) ||
	  (c>=0x0966 && c<=0x096f) ||
	  (c>=0x09e6 && c<=0x09ef) ||
	  (c>=0x0a66 && c<=0x0a6f) ||
	  (c>=0x0ae6 && c<=0x0aef) ||
	  (c>=0x0b66 && c<=0x0b6f) ||
	  (c>=0x0be6 && c<=0x0bef) ||
	  (c>=0x0c66 && c<=0x0c6f) ||
	  (c>=0x0ce6 && c<=0x0cef) ||
	  (c>=0x0d66 && c<=0x0d6f) ||
	  (c>=0x0e50 && c<=0x0e59) ||
	  (c>=0x0ed0 && c<=0x0ed9) ||
	  (c>=0x0f20 && c<=0x0f29) ||
	  (c>=0x1040 && c<=0x1049) ||
	  (c>=0x17e0 && c<=0x17e9) ||
	  (c>=0x1810 && c<=0x1819) ||
	  (c>=0x1946 && c<=0x194f) ||
	  (c>=0x19d0 && c<=0x19d9) ||
	  (c>=0x1b50 && c<=0x1b59) ||
	  (c>=0xff10 && c<=0xff19))
	return 1;
  return 0;
}


int unic_iscombining (int c) {
  if ((c>=0x0300 && c<=0x0357) ||
      (c>=0x035d && c<=0x0362) ||
      (c>=0x0483 && c<=0x0486) ||
      (c>=0x07eb && c<=0x07f3) ||
      (c>=0x1b6b && c<=0x1b73) ||
      (c>=0x1dc4 && c<=0x1dca) ||
      (c>=0x1dfe && c<=0x1dff) ||
      (c==0x202a) ||
      (c>=0x20d0 && c<=0x20dc) ||
      (c==0x20e1) ||
      (c>=0x20e5 && c<=0x20e6) ||
      (c>=0x20ec && c<=0x20ef) ||
      (c>=0x3099 && c<=0x309a) ||
      (c>=0xfe20 && c<=0xfe23) )
    return 1;
  return 0;
}

/* cleaned out some of the incidental holes in ranges already, but
   there are more */

int unic_isalpha (int c) {
  if((c>=0x0041&&c<=0x005a) || 
     (c>=0x0061&&c<=0x007a) || 
     (c==0x00aa) || 
     (c==0x00b5) || 
     (c==0x00ba) || 
     (c>=0x00c0&&c<=0x01bf) || 
     (c>=0x01c4&&c<=0x02af) || 
     (c==0x0345) || 
     (c>=0x037b&&c<=0x037d) || 
     (c==0x0386) || 
     (c>=0x0388&&c<=0x038a) || 
     (c==0x038c) || 
     (c>=0x038e&&c<=0x0481) || 
     (c>=0x048a&&c<=0x0513) || 
     (c>=0x0531&&c<=0x0556) || 
     (c>=0x0561&&c<=0x0587) || 
     (c>=0x05b0&&c<=0x05bd) || 
     (c==0x05bf) || 
     (c>=0x05c1&&c<=0x05c2) ||
     (c>=0x05c4&&c<=0x05c5) || 
     (c==0x05c7) || 
     (c>=0x0610&&c<=0x0615) || 
     (c>=0x064b&&c<=0x0657) || 
     (c>=0x0659&&c<=0x065e) || 
     (c==0x0670) || 
     (c>=0x06d6&&c<=0x06dc) || 
     (c>=0x06e1&&c<=0x06e4) || 
     (c>=0x06e7&&c<=0x06e8) || 
     (c==0x06ed) || 
     (c==0x0711) || 
     (c>=0x0730&&c<=0x073f) || 
     (c>=0x07a6&&c<=0x07b0) || 
     (c>=0x0901&&c<=0x0903) || 
     (c>=0x093e&&c<=0x094c) || 
     (c>=0x0962&&c<=0x0963) || 
     (c>=0x0981&&c<=0x0983) || 
     (c>=0x09be&&c<=0x09c4) || 
     (c>=0x09c7&&c<=0x09c8) || 
     (c>=0x09cb&&c<=0x09cc) || 
     (c==0x09d7) || 
     (c>=0x09e2&&c<=0x09e3) || 
     (c>=0x0a01&&c<=0x0a03) || 
     (c>=0x0a3e&&c<=0x0a42) || 
     (c>=0x0a47&&c<=0x0a48) || 
     (c>=0x0a4b&&c<=0x0a4c) || 
     (c>=0x0a70&&c<=0x0a71) || 
     (c>=0x0a81&&c<=0x0a83) || 
     (c>=0x0abe&&c<=0x0ac5) || 
     (c>=0x0ac7&&c<=0x0ac9) || 
     (c>=0x0acb&&c<=0x0acc) || 
     (c>=0x0ae2&&c<=0x0ae3) || 
     (c>=0x0b01&&c<=0x0b03) || 
     (c>=0x0b3e&&c<=0x0b43) || 
     (c>=0x0b47&&c<=0x0b48) || 
     (c>=0x0b4b&&c<=0x0b4c) || 
     (c>=0x0b56&&c<=0x0b57) || 
     (c==0x0b82) || 
     (c>=0x0bbe&&c<=0x0bc2) || 
     (c>=0x0bc6&&c<=0x0bc8) || 
     (c>=0x0bca&&c<=0x0bcc) || 
     (c==0x0bd7) || 
     (c>=0x0c01&&c<=0x0c03) || 
     (c>=0x0c3e&&c<=0x0c44) || 
     (c>=0x0c46&&c<=0x0c48) || 
     (c>=0x0c4a&&c<=0x0c4c) || 
     (c>=0x0c55&&c<=0x0c56) || 
     (c>=0x0c82&&c<=0x0c83) || 
     (c>=0x0cbe&&c<=0x0cc4) || 
     (c>=0x0cc6&&c<=0x0cc8) || 
     (c>=0x0cca&&c<=0x0ccc) || 
     (c>=0x0cd5&&c<=0x0cd6) || 
     (c>=0x0ce2&&c<=0x0ce3) || 
     (c>=0x0d02&&c<=0x0d03) || 
     (c>=0x0d3e&&c<=0x0d43) || 
     (c>=0x0d46&&c<=0x0d48) || 
     (c>=0x0d4a&&c<=0x0d4c) || 
     (c==0x0d57) || 
     (c>=0x0d82&&c<=0x0d83) || 
     (c>=0x0dcf&&c<=0x0dd4) || 
     (c==0x0dd6) || 
     (c>=0x0dd8&&c<=0x0ddf) || 
     (c>=0x0df2&&c<=0x0df3) || 
     (c==0x0e31) || 
     (c>=0x0e34&&c<=0x0e3a) || 
     (c==0x0e4d) || 
     (c==0x0eb1) || 
     (c>=0x0eb4&&c<=0x0eb9) || 
     (c>=0x0ebb&&c<=0x0ebc) || 
     (c==0x0ecd) || 
     (c>=0x0f71&&c<=0x0f81) || 
     (c>=0x0f90&&c<=0x0f97) || 
     (c>=0x0f99&&c<=0x0fbc) || 
     (c>=0x102c&&c<=0x1032) || 
     (c==0x1036) || 
     (c==0x1038) || 
     (c>=0x1056&&c<=0x1059) || 
     (c>=0x10a0&&c<=0x10c5) || 
     (c==0x135f) || 
     (c>=0x1712&&c<=0x1713) || 
     (c>=0x1732&&c<=0x1733) || 
     (c>=0x1752&&c<=0x1753) || 
     (c>=0x1772&&c<=0x1773) || 
     (c>=0x17b6&&c<=0x17c8) || 
     (c==0x18a9) || 
     (c>=0x1920&&c<=0x192b) || 
     (c>=0x1930&&c<=0x1938) || 
     (c>=0x19b0&&c<=0x19c0) || 
     (c>=0x19c8&&c<=0x19c9) || 
     (c>=0x1a17&&c<=0x1a1b) || 
     (c>=0x1b00&&c<=0x1b04) || 
     (c>=0x1b35&&c<=0x1b43) || 
     (c>=0x1d00&&c<=0x1d2b) || 
     (c>=0x1d62&&c<=0x1d77) || 
     (c>=0x1d79&&c<=0x1d9a) || 
     (c>=0x1e00&&c<=0x1e9b) || 
     (c>=0x1ea0&&c<=0x1ef9) || 
     (c>=0x1f00&&c<=0x1f15) || 
     (c>=0x1f18&&c<=0x1f1d) || 
     (c>=0x1f20&&c<=0x1f45) || 
     (c>=0x1f48&&c<=0x1f4d) || 
     (c>=0x1f50&&c<=0x1f57) || 
     (c==0x1f59) || 
     (c==0x1f5b) || 
     (c==0x1f5d) || 
     (c>=0x1f5f&&c<=0x1f7d) || 
     (c>=0x1f80&&c<=0x1fb4) || 
     (c>=0x1fb6&&c<=0x1fbc) || 
     (c==0x1fbe) || 
     (c>=0x1fc2&&c<=0x1fc4) || 
     (c>=0x1fc6&&c<=0x1fcc) || 
     (c>=0x1fd0&&c<=0x1fd3) || 
     (c>=0x1fd6&&c<=0x1fdb) || 
     (c>=0x1fe0&&c<=0x1fec) || 
     (c>=0x1ff2&&c<=0x1ff4) || 
     (c>=0x1ff6&&c<=0x1ffc) || 
     (c==0x2071) || 
     (c==0x207f) || 
     (c==0x2102) || 
     (c==0x2107) || 
     (c>=0x210a&&c<=0x2113) || 
     (c==0x2115) || 
     (c>=0x2119&&c<=0x211d) || 
     (c==0x2124) || 
     (c==0x2126) || 
     (c==0x2128) || 
     (c>=0x212a&&c<=0x212d) || 
     (c>=0x212f&&c<=0x2134) || 
     (c==0x2139) || 
     (c>=0x213c&&c<=0x213f) || 
     (c>=0x2145&&c<=0x2149) || 
     (c==0x214e) || 
     (c>=0x2183&&c<=0x2184) || 
     (c>=0x24b6&&c<=0x24e9) || 
     (c>=0x2c00&&c<=0x2c2e) || 
     (c>=0x2c30&&c<=0x2c5e) || 
     (c>=0x2c60&&c<=0x2c6c) || 
     (c>=0x2c74&&c<=0x2c77) || 
     (c>=0x2c80&&c<=0x2ce4) || 
     (c>=0x2d00&&c<=0x2d25) || 
     (c>=0xa823&&c<=0xa827) || 
     (c>=0xfb00&&c<=0xfb06) || 
     (c>=0xfb13&&c<=0xfb17) || 
     (c==0xfb1e) || 
     (c>=0xff21&&c<=0xff3a) || 
     (c>=0xff41&&c<=0xff5a)) {
    if (c==0x00d7||c==0x00f7||c==0x01bb||c==0x0294||c==0x03a2||c==0x03cf||c==0x03f6)
      return 0;
    else
      return 1;
  }
  return 0;
}

const unsigned short ____tolower[]= { 0,
  0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
  0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
  0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
  0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
  0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
  0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
  0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
  0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
  0x0040, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
  0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
  0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
  0x0078, 0x0079, 0x007a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
  0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
  0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
  0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
  0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f,
  0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
  0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x008d, 0x008e, 0x008f,
  0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
  0x0098, 0x0099, 0x009a, 0x009b, 0x009c, 0x009d, 0x009e, 0x009f,
  0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
  0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
  0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
  0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
  0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
  0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
  0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00d7,
  0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00df,
  0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
  0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
  0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
  0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff,
  0x0101, 0x0101, 0x0103, 0x0103, 0x0105, 0x0105, 0x0107, 0x0107,
  0x0109, 0x0109, 0x010b, 0x010b, 0x010d, 0x010d, 0x010f, 0x010f,
  0x0111, 0x0111, 0x0113, 0x0113, 0x0115, 0x0115, 0x0117, 0x0117,
  0x0119, 0x0119, 0x011b, 0x011b, 0x011d, 0x011d, 0x011f, 0x011f,
  0x0121, 0x0121, 0x0123, 0x0123, 0x0125, 0x0125, 0x0127, 0x0127,
  0x0129, 0x0129, 0x012b, 0x012b, 0x012d, 0x012d, 0x012f, 0x012f,
  0x0069, 0x0131, 0x0133, 0x0133, 0x0135, 0x0135, 0x0137, 0x0137,
  0x0138, 0x013a, 0x013a, 0x013c, 0x013c, 0x013e, 0x013e, 0x0140,
  0x0140, 0x0142, 0x0142, 0x0144, 0x0144, 0x0146, 0x0146, 0x0148,
  0x0148, 0x0149, 0x014b, 0x014b, 0x014d, 0x014d, 0x014f, 0x014f,
  0x0151, 0x0151, 0x0153, 0x0153, 0x0155, 0x0155, 0x0157, 0x0157,
  0x0159, 0x0159, 0x015b, 0x015b, 0x015d, 0x015d, 0x015f, 0x015f,
  0x0161, 0x0161, 0x0163, 0x0163, 0x0165, 0x0165, 0x0167, 0x0167,
  0x0169, 0x0169, 0x016b, 0x016b, 0x016d, 0x016d, 0x016f, 0x016f,
  0x0171, 0x0171, 0x0173, 0x0173, 0x0175, 0x0175, 0x0177, 0x0177,
  0x00ff, 0x017a, 0x017a, 0x017c, 0x017c, 0x017e, 0x017e, 0x017f,
  0x0180, 0x0253, 0x0183, 0x0183, 0x0185, 0x0185, 0x0254, 0x0188,
  0x0188, 0x0256, 0x0257, 0x018c, 0x018c, 0x018d, 0x01dd, 0x0259,
  0x025b, 0x0192, 0x0192, 0x0260, 0x0263, 0x0195, 0x0269, 0x0268,
  0x0199, 0x0199, 0x019a, 0x019b, 0x026f, 0x0272, 0x019e, 0x0275,
  0x01a1, 0x01a1, 0x01a3, 0x01a3, 0x01a5, 0x01a5, 0x0280, 0x01a8,
  0x01a8, 0x0283, 0x01aa, 0x01ab, 0x01ad, 0x01ad, 0x0288, 0x01b0,
  0x01b0, 0x028a, 0x028b, 0x01b4, 0x01b4, 0x01b6, 0x01b6, 0x0292,
  0x01b9, 0x01b9, 0x01ba, 0x01bb, 0x01bd, 0x01bd, 0x01be, 0x01bf,
  0x01c0, 0x01c1, 0x01c2, 0x01c3, 0x01c6, 0x01c6, 0x01c6, 0x01c9,
  0x01c9, 0x01c9, 0x01cc, 0x01cc, 0x01cc, 0x01ce, 0x01ce, 0x01d0,
  0x01d0, 0x01d2, 0x01d2, 0x01d4, 0x01d4, 0x01d6, 0x01d6, 0x01d8,
  0x01d8, 0x01da, 0x01da, 0x01dc, 0x01dc, 0x01dd, 0x01df, 0x01df,
  0x01e1, 0x01e1, 0x01e3, 0x01e3, 0x01e5, 0x01e5, 0x01e7, 0x01e7,
  0x01e9, 0x01e9, 0x01eb, 0x01eb, 0x01ed, 0x01ed, 0x01ef, 0x01ef,
  0x01f0, 0x01f3, 0x01f3, 0x01f3, 0x01f5, 0x01f5, 0x0195, 0x01bf,
  0x01f9, 0x01f9, 0x01fb, 0x01fb, 0x01fd, 0x01fd, 0x01ff, 0x01ff,
  0x0201, 0x0201, 0x0203, 0x0203, 0x0205, 0x0205, 0x0207, 0x0207,
  0x0209, 0x0209, 0x020b, 0x020b, 0x020d, 0x020d, 0x020f, 0x020f,
  0x0211, 0x0211, 0x0213, 0x0213, 0x0215, 0x0215, 0x0217, 0x0217,
  0x0219, 0x0219, 0x021b, 0x021b, 0x021d, 0x021d, 0x021f, 0x021f,
  0x019e, 0x0221, 0x0223, 0x0223, 0x0225, 0x0225, 0x0227, 0x0227,
  0x0229, 0x0229, 0x022b, 0x022b, 0x022d, 0x022d, 0x022f, 0x022f,
  0x0231, 0x0231, 0x0233, 0x0233, 0x0234, 0x0235, 0x0236, 0x0237,
  0x0238, 0x0239, 0x2c65, 0x023c, 0x023c, 0x019a, 0x2c66, 0x023f,
  0x0240, 0x0242, 0x0242, 0x0180, 0x0289, 0x028c, 0x0247, 0x0247,
  0x0249, 0x0249, 0x024b, 0x024b, 0x024d, 0x024d, 0x024f, 0x024f,
  0x0250, 0x0251, 0x0252, 0x0253, 0x0254, 0x0255, 0x0256, 0x0257,
  0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x025e, 0x025f,
  0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 0x0265, 0x0266, 0x0267,
  0x0268, 0x0269, 0x026a, 0x026b, 0x026c, 0x026d, 0x026e, 0x026f,
  0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0275, 0x0276, 0x0277,
  0x0278, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f,
  0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287,
  0x0288, 0x0289, 0x028a, 0x028b, 0x028c, 0x028d, 0x028e, 0x028f,
  0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296, 0x0297,
  0x0298, 0x0299, 0x029a, 0x029b, 0x029c, 0x029d, 0x029e, 0x029f,
  0x02a0, 0x02a1, 0x02a2, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7,
  0x02a8, 0x02a9, 0x02aa, 0x02ab, 0x02ac, 0x02ad, 0x02ae, 0x02af,
  0x02b0, 0x02b1, 0x02b2, 0x02b3, 0x02b4, 0x02b5, 0x02b6, 0x02b7,
  0x02b8, 0x02b9, 0x02ba, 0x02bb, 0x02bc, 0x02bd, 0x02be, 0x02bf,
  0x02c0, 0x02c1, 0x02c2, 0x02c3, 0x02c4, 0x02c5, 0x02c6, 0x02c7,
  0x02c8, 0x02c9, 0x02ca, 0x02cb, 0x02cc, 0x02cd, 0x02ce, 0x02cf,
  0x02d0, 0x02d1, 0x02d2, 0x02d3, 0x02d4, 0x02d5, 0x02d6, 0x02d7,
  0x02d8, 0x02d9, 0x02da, 0x02db, 0x02dc, 0x02dd, 0x02de, 0x02df,
  0x02e0, 0x02e1, 0x02e2, 0x02e3, 0x02e4, 0x02e5, 0x02e6, 0x02e7,
  0x02e8, 0x02e9, 0x02ea, 0x02eb, 0x02ec, 0x02ed, 0x02ee, 0x02ef,
  0x02f0, 0x02f1, 0x02f2, 0x02f3, 0x02f4, 0x02f5, 0x02f6, 0x02f7,
  0x02f8, 0x02f9, 0x02fa, 0x02fb, 0x02fc, 0x02fd, 0x02fe, 0x02ff,
  0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0307,
  0x0308, 0x0309, 0x030a, 0x030b, 0x030c, 0x030d, 0x030e, 0x030f,
  0x0310, 0x0311, 0x0312, 0x0313, 0x0314, 0x0315, 0x0316, 0x0317,
  0x0318, 0x0319, 0x031a, 0x031b, 0x031c, 0x031d, 0x031e, 0x031f,
  0x0320, 0x0321, 0x0322, 0x0323, 0x0324, 0x0325, 0x0326, 0x0327,
  0x0328, 0x0329, 0x032a, 0x032b, 0x032c, 0x032d, 0x032e, 0x032f,
  0x0330, 0x0331, 0x0332, 0x0333, 0x0334, 0x0335, 0x0336, 0x0337,
  0x0338, 0x0339, 0x033a, 0x033b, 0x033c, 0x033d, 0x033e, 0x033f,
  0x0340, 0x0341, 0x0342, 0x0343, 0x0344, 0x0345, 0x0346, 0x0347,
  0x0348, 0x0349, 0x034a, 0x034b, 0x034c, 0x034d, 0x034e, 0x034f,
  0x0350, 0x0351, 0x0352, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357,
  0x0358, 0x0359, 0x035a, 0x035b, 0x035c, 0x035d, 0x035e, 0x035f,
  0x0360, 0x0361, 0x0362, 0x0363, 0x0364, 0x0365, 0x0366, 0x0367,
  0x0368, 0x0369, 0x036a, 0x036b, 0x036c, 0x036d, 0x036e, 0x036f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0374, 0x0375, 0x0000, 0x0000,
  0x0000, 0x0000, 0x037a, 0x037b, 0x037c, 0x037d, 0x037e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0384, 0x0385, 0x03ac, 0x0387,
  0x03ad, 0x03ae, 0x03af, 0x0000, 0x03cc, 0x0000, 0x03cd, 0x03ce,
  0x0390, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
  0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
  0x03c0, 0x03c1, 0x0000, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
  0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03ac, 0x03ad, 0x03ae, 0x03af,
  0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
  0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
  0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7,
  0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce, 0x0000,
  0x03d0, 0x03d1, 0x03d2, 0x03d3, 0x03d4, 0x03d5, 0x03d6, 0x03d7,
  0x03d9, 0x03d9, 0x03db, 0x03db, 0x03dd, 0x03dd, 0x03df, 0x03df,
  0x03e1, 0x03e1, 0x03e3, 0x03e3, 0x03e5, 0x03e5, 0x03e7, 0x03e7,
  0x03e9, 0x03e9, 0x03eb, 0x03eb, 0x03ed, 0x03ed, 0x03ef, 0x03ef,
  0x03f0, 0x03f1, 0x03f2, 0x03f3, 0x03b8, 0x03f5, 0x03f6, 0x03f8,
  0x03f8, 0x03f2, 0x03fb, 0x03fb, 0x03fc, 0x037b, 0x037c, 0x037d,
  0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
  0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x045d, 0x045e, 0x045f,
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
  0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
  0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
  0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
  0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
  0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
  0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x045d, 0x045e, 0x045f,
  0x0461, 0x0461, 0x0463, 0x0463, 0x0465, 0x0465, 0x0467, 0x0467,
  0x0469, 0x0469, 0x046b, 0x046b, 0x046d, 0x046d, 0x046f, 0x046f,
  0x0471, 0x0471, 0x0473, 0x0473, 0x0475, 0x0475, 0x0477, 0x0477,
  0x0479, 0x0479, 0x047b, 0x047b, 0x047d, 0x047d, 0x047f, 0x047f,
  0x0481, 0x0481, 0x0482, 0x0483, 0x0484, 0x0485, 0x0486, 0x0000,
  0x0488, 0x0489, 0x048b, 0x048b, 0x048d, 0x048d, 0x048f, 0x048f,
  0x0491, 0x0491, 0x0493, 0x0493, 0x0495, 0x0495, 0x0497, 0x0497,
  0x0499, 0x0499, 0x049b, 0x049b, 0x049d, 0x049d, 0x049f, 0x049f,
  0x04a1, 0x04a1, 0x04a3, 0x04a3, 0x04a5, 0x04a5, 0x04a7, 0x04a7,
  0x04a9, 0x04a9, 0x04ab, 0x04ab, 0x04ad, 0x04ad, 0x04af, 0x04af,
  0x04b1, 0x04b1, 0x04b3, 0x04b3, 0x04b5, 0x04b5, 0x04b7, 0x04b7,
  0x04b9, 0x04b9, 0x04bb, 0x04bb, 0x04bd, 0x04bd, 0x04bf, 0x04bf,
  0x04cf, 0x04c2, 0x04c2, 0x04c4, 0x04c4, 0x04c6, 0x04c6, 0x04c8,
  0x04c8, 0x04ca, 0x04ca, 0x04cc, 0x04cc, 0x04ce, 0x04ce, 0x04cf,
  0x04d1, 0x04d1, 0x04d3, 0x04d3, 0x04d5, 0x04d5, 0x04d7, 0x04d7,
  0x04d9, 0x04d9, 0x04db, 0x04db, 0x04dd, 0x04dd, 0x04df, 0x04df,
  0x04e1, 0x04e1, 0x04e3, 0x04e3, 0x04e5, 0x04e5, 0x04e7, 0x04e7,
  0x04e9, 0x04e9, 0x04eb, 0x04eb, 0x04ed, 0x04ed, 0x04ef, 0x04ef,
  0x04f1, 0x04f1, 0x04f3, 0x04f3, 0x04f5, 0x04f5, 0x04f7, 0x04f7,
  0x04f9, 0x04f9, 0x04fb, 0x04fb, 0x04fd, 0x04fd, 0x04ff, 0x04ff,
  0x0501, 0x0501, 0x0503, 0x0503, 0x0505, 0x0505, 0x0507, 0x0507,
  0x0509, 0x0509, 0x050b, 0x050b, 0x050d, 0x050d, 0x050f, 0x050f,
  0x0511, 0x0511, 0x0513, 0x0513, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567,
  0x0568, 0x0569, 0x056a, 0x056b, 0x056c, 0x056d, 0x056e, 0x056f,
  0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577,
  0x0578, 0x0579, 0x057a, 0x057b, 0x057c, 0x057d, 0x057e, 0x057f,
  0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0000,
  0x0000, 0x0559, 0x055a, 0x055b, 0x055c, 0x055d, 0x055e, 0x055f,
  0x0000, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565, 0x0566, 0x0567,
  0x0568, 0x0569, 0x056a, 0x056b, 0x056c, 0x056d, 0x056e, 0x056f,
  0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577,
  0x0578, 0x0579, 0x057a, 0x057b, 0x057c, 0x057d, 0x057e, 0x057f,
  0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585, 0x0586, 0x0587,
  0x0000, 0x0589, 0x058a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0591, 0x0592, 0x0593, 0x0594, 0x0595, 0x0596, 0x0597,
  0x0598, 0x0599, 0x059a, 0x059b, 0x059c, 0x059d, 0x059e, 0x059f,
  0x05a0, 0x05a1, 0x05a2, 0x05a3, 0x05a4, 0x05a5, 0x05a6, 0x05a7,
  0x05a8, 0x05a9, 0x05aa, 0x05ab, 0x05ac, 0x05ad, 0x05ae, 0x05af,
  0x05b0, 0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7,
  0x05b8, 0x05b9, 0x05ba, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf,
  0x05c0, 0x05c1, 0x05c2, 0x05c3, 0x05c4, 0x05c5, 0x05c6, 0x05c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
  0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
  0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
  0x05e8, 0x05e9, 0x05ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x05f0, 0x05f1, 0x05f2, 0x05f3, 0x05f4, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0600, 0x0601, 0x0602, 0x0603, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x060b, 0x060c, 0x060d, 0x060e, 0x060f,
  0x0610, 0x0611, 0x0612, 0x0613, 0x0614, 0x0615, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x061b, 0x0000, 0x0000, 0x061e, 0x061f,
  0x0000, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
  0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f,
  0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637,
  0x0638, 0x0639, 0x063a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647,
  0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f,
  0x0650, 0x0651, 0x0652, 0x0653, 0x0654, 0x0655, 0x0656, 0x0657,
  0x0658, 0x0659, 0x065a, 0x065b, 0x065c, 0x065d, 0x065e, 0x0000,
  0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667,
  0x0668, 0x0669, 0x066a, 0x066b, 0x066c, 0x066d, 0x066e, 0x066f,
  0x0670, 0x0671, 0x0672, 0x0673, 0x0674, 0x0675, 0x0676, 0x0677,
  0x0678, 0x0679, 0x067a, 0x067b, 0x067c, 0x067d, 0x067e, 0x067f,
  0x0680, 0x0681, 0x0682, 0x0683, 0x0684, 0x0685, 0x0686, 0x0687,
  0x0688, 0x0689, 0x068a, 0x068b, 0x068c, 0x068d, 0x068e, 0x068f,
  0x0690, 0x0691, 0x0692, 0x0693, 0x0694, 0x0695, 0x0696, 0x0697,
  0x0698, 0x0699, 0x069a, 0x069b, 0x069c, 0x069d, 0x069e, 0x069f,
  0x06a0, 0x06a1, 0x06a2, 0x06a3, 0x06a4, 0x06a5, 0x06a6, 0x06a7,
  0x06a8, 0x06a9, 0x06aa, 0x06ab, 0x06ac, 0x06ad, 0x06ae, 0x06af,
  0x06b0, 0x06b1, 0x06b2, 0x06b3, 0x06b4, 0x06b5, 0x06b6, 0x06b7,
  0x06b8, 0x06b9, 0x06ba, 0x06bb, 0x06bc, 0x06bd, 0x06be, 0x06bf,
  0x06c0, 0x06c1, 0x06c2, 0x06c3, 0x06c4, 0x06c5, 0x06c6, 0x06c7,
  0x06c8, 0x06c9, 0x06ca, 0x06cb, 0x06cc, 0x06cd, 0x06ce, 0x06cf,
  0x06d0, 0x06d1, 0x06d2, 0x06d3, 0x06d4, 0x06d5, 0x06d6, 0x06d7,
  0x06d8, 0x06d9, 0x06da, 0x06db, 0x06dc, 0x06dd, 0x06de, 0x06df,
  0x06e0, 0x06e1, 0x06e2, 0x06e3, 0x06e4, 0x06e5, 0x06e6, 0x06e7,
  0x06e8, 0x06e9, 0x06ea, 0x06eb, 0x06ec, 0x06ed, 0x06ee, 0x06ef,
  0x06f0, 0x06f1, 0x06f2, 0x06f3, 0x06f4, 0x06f5, 0x06f6, 0x06f7,
  0x06f8, 0x06f9, 0x06fa, 0x06fb, 0x06fc, 0x06fd, 0x06fe, 0x06ff,
  0x0700, 0x0701, 0x0702, 0x0703, 0x0704, 0x0705, 0x0706, 0x0707,
  0x0708, 0x0709, 0x070a, 0x070b, 0x070c, 0x070d, 0x0000, 0x070f,
  0x0710, 0x0711, 0x0712, 0x0713, 0x0714, 0x0715, 0x0716, 0x0717,
  0x0718, 0x0719, 0x071a, 0x071b, 0x071c, 0x071d, 0x071e, 0x071f,
  0x0720, 0x0721, 0x0722, 0x0723, 0x0724, 0x0725, 0x0726, 0x0727,
  0x0728, 0x0729, 0x072a, 0x072b, 0x072c, 0x072d, 0x072e, 0x072f,
  0x0730, 0x0731, 0x0732, 0x0733, 0x0734, 0x0735, 0x0736, 0x0737,
  0x0738, 0x0739, 0x073a, 0x073b, 0x073c, 0x073d, 0x073e, 0x073f,
  0x0740, 0x0741, 0x0742, 0x0743, 0x0744, 0x0745, 0x0746, 0x0747,
  0x0748, 0x0749, 0x074a, 0x0000, 0x0000, 0x074d, 0x074e, 0x074f,
  0x0750, 0x0751, 0x0752, 0x0753, 0x0754, 0x0755, 0x0756, 0x0757,
  0x0758, 0x0759, 0x075a, 0x075b, 0x075c, 0x075d, 0x075e, 0x075f,
  0x0760, 0x0761, 0x0762, 0x0763, 0x0764, 0x0765, 0x0766, 0x0767,
  0x0768, 0x0769, 0x076a, 0x076b, 0x076c, 0x076d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0780, 0x0781, 0x0782, 0x0783, 0x0784, 0x0785, 0x0786, 0x0787,
  0x0788, 0x0789, 0x078a, 0x078b, 0x078c, 0x078d, 0x078e, 0x078f,
  0x0790, 0x0791, 0x0792, 0x0793, 0x0794, 0x0795, 0x0796, 0x0797,
  0x0798, 0x0799, 0x079a, 0x079b, 0x079c, 0x079d, 0x079e, 0x079f,
  0x07a0, 0x07a1, 0x07a2, 0x07a3, 0x07a4, 0x07a5, 0x07a6, 0x07a7,
  0x07a8, 0x07a9, 0x07aa, 0x07ab, 0x07ac, 0x07ad, 0x07ae, 0x07af,
  0x07b0, 0x07b1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x07c0, 0x07c1, 0x07c2, 0x07c3, 0x07c4, 0x07c5, 0x07c6, 0x07c7,
  0x07c8, 0x07c9, 0x07ca, 0x07cb, 0x07cc, 0x07cd, 0x07ce, 0x07cf,
  0x07d0, 0x07d1, 0x07d2, 0x07d3, 0x07d4, 0x07d5, 0x07d6, 0x07d7,
  0x07d8, 0x07d9, 0x07da, 0x07db, 0x07dc, 0x07dd, 0x07de, 0x07df,
  0x07e0, 0x07e1, 0x07e2, 0x07e3, 0x07e4, 0x07e5, 0x07e6, 0x07e7,
  0x07e8, 0x07e9, 0x07ea, 0x07eb, 0x07ec, 0x07ed, 0x07ee, 0x07ef,
  0x07f0, 0x07f1, 0x07f2, 0x07f3, 0x07f4, 0x07f5, 0x07f6, 0x07f7,
  0x07f8, 0x07f9, 0x07fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0901, 0x0902, 0x0903, 0x0904, 0x0905, 0x0906, 0x0907,
  0x0908, 0x0909, 0x090a, 0x090b, 0x090c, 0x090d, 0x090e, 0x090f,
  0x0910, 0x0911, 0x0912, 0x0913, 0x0914, 0x0915, 0x0916, 0x0917,
  0x0918, 0x0919, 0x091a, 0x091b, 0x091c, 0x091d, 0x091e, 0x091f,
  0x0920, 0x0921, 0x0922, 0x0923, 0x0924, 0x0925, 0x0926, 0x0927,
  0x0928, 0x0929, 0x092a, 0x092b, 0x092c, 0x092d, 0x092e, 0x092f,
  0x0930, 0x0931, 0x0932, 0x0933, 0x0934, 0x0935, 0x0936, 0x0937,
  0x0938, 0x0939, 0x0000, 0x0000, 0x093c, 0x093d, 0x093e, 0x093f,
  0x0940, 0x0941, 0x0942, 0x0943, 0x0944, 0x0945, 0x0946, 0x0947,
  0x0948, 0x0949, 0x094a, 0x094b, 0x094c, 0x094d, 0x0000, 0x0000,
  0x0950, 0x0951, 0x0952, 0x0953, 0x0954, 0x0000, 0x0000, 0x0000,
  0x0958, 0x0959, 0x095a, 0x095b, 0x095c, 0x095d, 0x095e, 0x095f,
  0x0960, 0x0961, 0x0962, 0x0963, 0x0964, 0x0965, 0x0966, 0x0967,
  0x0968, 0x0969, 0x096a, 0x096b, 0x096c, 0x096d, 0x096e, 0x096f,
  0x0970, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x097b, 0x097c, 0x097d, 0x097e, 0x097f,
  0x0000, 0x0981, 0x0982, 0x0983, 0x0000, 0x0985, 0x0986, 0x0987,
  0x0988, 0x0989, 0x098a, 0x098b, 0x098c, 0x0000, 0x0000, 0x098f,
  0x0990, 0x0000, 0x0000, 0x0993, 0x0994, 0x0995, 0x0996, 0x0997,
  0x0998, 0x0999, 0x099a, 0x099b, 0x099c, 0x099d, 0x099e, 0x099f,
  0x09a0, 0x09a1, 0x09a2, 0x09a3, 0x09a4, 0x09a5, 0x09a6, 0x09a7,
  0x09a8, 0x0000, 0x09aa, 0x09ab, 0x09ac, 0x09ad, 0x09ae, 0x09af,
  0x09b0, 0x0000, 0x09b2, 0x0000, 0x0000, 0x0000, 0x09b6, 0x09b7,
  0x09b8, 0x09b9, 0x0000, 0x0000, 0x09bc, 0x09bd, 0x09be, 0x09bf,
  0x09c0, 0x09c1, 0x09c2, 0x09c3, 0x09c4, 0x0000, 0x0000, 0x09c7,
  0x09c8, 0x0000, 0x0000, 0x09cb, 0x09cc, 0x09cd, 0x09ce, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x09d7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x09dc, 0x09dd, 0x0000, 0x09df,
  0x09e0, 0x09e1, 0x09e2, 0x09e3, 0x0000, 0x0000, 0x09e6, 0x09e7,
  0x09e8, 0x09e9, 0x09ea, 0x09eb, 0x09ec, 0x09ed, 0x09ee, 0x09ef,
  0x09f0, 0x09f1, 0x09f2, 0x09f3, 0x09f4, 0x09f5, 0x09f6, 0x09f7,
  0x09f8, 0x09f9, 0x09fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0a01, 0x0a02, 0x0a03, 0x0000, 0x0a05, 0x0a06, 0x0a07,
  0x0a08, 0x0a09, 0x0a0a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a0f,
  0x0a10, 0x0000, 0x0000, 0x0a13, 0x0a14, 0x0a15, 0x0a16, 0x0a17,
  0x0a18, 0x0a19, 0x0a1a, 0x0a1b, 0x0a1c, 0x0a1d, 0x0a1e, 0x0a1f,
  0x0a20, 0x0a21, 0x0a22, 0x0a23, 0x0a24, 0x0a25, 0x0a26, 0x0a27,
  0x0a28, 0x0000, 0x0a2a, 0x0a2b, 0x0a2c, 0x0a2d, 0x0a2e, 0x0a2f,
  0x0a30, 0x0000, 0x0a32, 0x0a33, 0x0000, 0x0a35, 0x0a36, 0x0000,
  0x0a38, 0x0a39, 0x0000, 0x0000, 0x0a3c, 0x0000, 0x0a3e, 0x0a3f,
  0x0a40, 0x0a41, 0x0a42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a47,
  0x0a48, 0x0000, 0x0000, 0x0a4b, 0x0a4c, 0x0a4d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0a59, 0x0a5a, 0x0a5b, 0x0a5c, 0x0000, 0x0a5e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a66, 0x0a67,
  0x0a68, 0x0a69, 0x0a6a, 0x0a6b, 0x0a6c, 0x0a6d, 0x0a6e, 0x0a6f,
  0x0a70, 0x0a71, 0x0a72, 0x0a73, 0x0a74, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0a81, 0x0a82, 0x0a83, 0x0000, 0x0a85, 0x0a86, 0x0a87,
  0x0a88, 0x0a89, 0x0a8a, 0x0a8b, 0x0a8c, 0x0a8d, 0x0000, 0x0a8f,
  0x0a90, 0x0a91, 0x0000, 0x0a93, 0x0a94, 0x0a95, 0x0a96, 0x0a97,
  0x0a98, 0x0a99, 0x0a9a, 0x0a9b, 0x0a9c, 0x0a9d, 0x0a9e, 0x0a9f,
  0x0aa0, 0x0aa1, 0x0aa2, 0x0aa3, 0x0aa4, 0x0aa5, 0x0aa6, 0x0aa7,
  0x0aa8, 0x0000, 0x0aaa, 0x0aab, 0x0aac, 0x0aad, 0x0aae, 0x0aaf,
  0x0ab0, 0x0000, 0x0ab2, 0x0ab3, 0x0000, 0x0ab5, 0x0ab6, 0x0ab7,
  0x0ab8, 0x0ab9, 0x0000, 0x0000, 0x0abc, 0x0abd, 0x0abe, 0x0abf,
  0x0ac0, 0x0ac1, 0x0ac2, 0x0ac3, 0x0ac4, 0x0ac5, 0x0000, 0x0ac7,
  0x0ac8, 0x0ac9, 0x0000, 0x0acb, 0x0acc, 0x0acd, 0x0000, 0x0000,
  0x0ad0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0ae0, 0x0ae1, 0x0ae2, 0x0ae3, 0x0000, 0x0000, 0x0ae6, 0x0ae7,
  0x0ae8, 0x0ae9, 0x0aea, 0x0aeb, 0x0aec, 0x0aed, 0x0aee, 0x0aef,
  0x0000, 0x0af1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0b01, 0x0b02, 0x0b03, 0x0000, 0x0b05, 0x0b06, 0x0b07,
  0x0b08, 0x0b09, 0x0b0a, 0x0b0b, 0x0b0c, 0x0000, 0x0000, 0x0b0f,
  0x0b10, 0x0000, 0x0000, 0x0b13, 0x0b14, 0x0b15, 0x0b16, 0x0b17,
  0x0b18, 0x0b19, 0x0b1a, 0x0b1b, 0x0b1c, 0x0b1d, 0x0b1e, 0x0b1f,
  0x0b20, 0x0b21, 0x0b22, 0x0b23, 0x0b24, 0x0b25, 0x0b26, 0x0b27,
  0x0b28, 0x0000, 0x0b2a, 0x0b2b, 0x0b2c, 0x0b2d, 0x0b2e, 0x0b2f,
  0x0b30, 0x0000, 0x0b32, 0x0b33, 0x0000, 0x0b35, 0x0b36, 0x0b37,
  0x0b38, 0x0b39, 0x0000, 0x0000, 0x0b3c, 0x0b3d, 0x0b3e, 0x0b3f,
  0x0b40, 0x0b41, 0x0b42, 0x0b43, 0x0000, 0x0000, 0x0000, 0x0b47,
  0x0b48, 0x0000, 0x0000, 0x0b4b, 0x0b4c, 0x0b4d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b56, 0x0b57,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0b5c, 0x0b5d, 0x0000, 0x0b5f,
  0x0b60, 0x0b61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b66, 0x0b67,
  0x0b68, 0x0b69, 0x0b6a, 0x0b6b, 0x0b6c, 0x0b6d, 0x0b6e, 0x0b6f,
  0x0b70, 0x0b71, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0b82, 0x0b83, 0x0000, 0x0b85, 0x0b86, 0x0b87,
  0x0b88, 0x0b89, 0x0b8a, 0x0000, 0x0000, 0x0000, 0x0b8e, 0x0b8f,
  0x0b90, 0x0000, 0x0b92, 0x0b93, 0x0b94, 0x0b95, 0x0000, 0x0000,
  0x0000, 0x0b99, 0x0b9a, 0x0000, 0x0b9c, 0x0000, 0x0b9e, 0x0b9f,
  0x0000, 0x0000, 0x0000, 0x0ba3, 0x0ba4, 0x0000, 0x0000, 0x0000,
  0x0ba8, 0x0ba9, 0x0baa, 0x0000, 0x0000, 0x0000, 0x0bae, 0x0baf,
  0x0bb0, 0x0bb1, 0x0bb2, 0x0bb3, 0x0bb4, 0x0bb5, 0x0bb6, 0x0bb7,
  0x0bb8, 0x0bb9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bbe, 0x0bbf,
  0x0bc0, 0x0bc1, 0x0bc2, 0x0000, 0x0000, 0x0000, 0x0bc6, 0x0bc7,
  0x0bc8, 0x0000, 0x0bca, 0x0bcb, 0x0bcc, 0x0bcd, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bd7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0be6, 0x0be7,
  0x0be8, 0x0be9, 0x0bea, 0x0beb, 0x0bec, 0x0bed, 0x0bee, 0x0bef,
  0x0bf0, 0x0bf1, 0x0bf2, 0x0bf3, 0x0bf4, 0x0bf5, 0x0bf6, 0x0bf7,
  0x0bf8, 0x0bf9, 0x0bfa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0c01, 0x0c02, 0x0c03, 0x0000, 0x0c05, 0x0c06, 0x0c07,
  0x0c08, 0x0c09, 0x0c0a, 0x0c0b, 0x0c0c, 0x0000, 0x0c0e, 0x0c0f,
  0x0c10, 0x0000, 0x0c12, 0x0c13, 0x0c14, 0x0c15, 0x0c16, 0x0c17,
  0x0c18, 0x0c19, 0x0c1a, 0x0c1b, 0x0c1c, 0x0c1d, 0x0c1e, 0x0c1f,
  0x0c20, 0x0c21, 0x0c22, 0x0c23, 0x0c24, 0x0c25, 0x0c26, 0x0c27,
  0x0c28, 0x0000, 0x0c2a, 0x0c2b, 0x0c2c, 0x0c2d, 0x0c2e, 0x0c2f,
  0x0c30, 0x0c31, 0x0c32, 0x0c33, 0x0000, 0x0c35, 0x0c36, 0x0c37,
  0x0c38, 0x0c39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c3e, 0x0c3f,
  0x0c40, 0x0c41, 0x0c42, 0x0c43, 0x0c44, 0x0000, 0x0c46, 0x0c47,
  0x0c48, 0x0000, 0x0c4a, 0x0c4b, 0x0c4c, 0x0c4d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c55, 0x0c56, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0c60, 0x0c61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c66, 0x0c67,
  0x0c68, 0x0c69, 0x0c6a, 0x0c6b, 0x0c6c, 0x0c6d, 0x0c6e, 0x0c6f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0c82, 0x0c83, 0x0000, 0x0c85, 0x0c86, 0x0c87,
  0x0c88, 0x0c89, 0x0c8a, 0x0c8b, 0x0c8c, 0x0000, 0x0c8e, 0x0c8f,
  0x0c90, 0x0000, 0x0c92, 0x0c93, 0x0c94, 0x0c95, 0x0c96, 0x0c97,
  0x0c98, 0x0c99, 0x0c9a, 0x0c9b, 0x0c9c, 0x0c9d, 0x0c9e, 0x0c9f,
  0x0ca0, 0x0ca1, 0x0ca2, 0x0ca3, 0x0ca4, 0x0ca5, 0x0ca6, 0x0ca7,
  0x0ca8, 0x0000, 0x0caa, 0x0cab, 0x0cac, 0x0cad, 0x0cae, 0x0caf,
  0x0cb0, 0x0cb1, 0x0cb2, 0x0cb3, 0x0000, 0x0cb5, 0x0cb6, 0x0cb7,
  0x0cb8, 0x0cb9, 0x0000, 0x0000, 0x0cbc, 0x0cbd, 0x0cbe, 0x0cbf,
  0x0cc0, 0x0cc1, 0x0cc2, 0x0cc3, 0x0cc4, 0x0000, 0x0cc6, 0x0cc7,
  0x0cc8, 0x0000, 0x0cca, 0x0ccb, 0x0ccc, 0x0ccd, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cd5, 0x0cd6, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cde, 0x0000,
  0x0ce0, 0x0ce1, 0x0ce2, 0x0ce3, 0x0000, 0x0000, 0x0ce6, 0x0ce7,
  0x0ce8, 0x0ce9, 0x0cea, 0x0ceb, 0x0cec, 0x0ced, 0x0cee, 0x0cef,
  0x0000, 0x0cf1, 0x0cf2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d02, 0x0d03, 0x0000, 0x0d05, 0x0d06, 0x0d07,
  0x0d08, 0x0d09, 0x0d0a, 0x0d0b, 0x0d0c, 0x0000, 0x0d0e, 0x0d0f,
  0x0d10, 0x0000, 0x0d12, 0x0d13, 0x0d14, 0x0d15, 0x0d16, 0x0d17,
  0x0d18, 0x0d19, 0x0d1a, 0x0d1b, 0x0d1c, 0x0d1d, 0x0d1e, 0x0d1f,
  0x0d20, 0x0d21, 0x0d22, 0x0d23, 0x0d24, 0x0d25, 0x0d26, 0x0d27,
  0x0d28, 0x0000, 0x0d2a, 0x0d2b, 0x0d2c, 0x0d2d, 0x0d2e, 0x0d2f,
  0x0d30, 0x0d31, 0x0d32, 0x0d33, 0x0d34, 0x0d35, 0x0d36, 0x0d37,
  0x0d38, 0x0d39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d3e, 0x0d3f,
  0x0d40, 0x0d41, 0x0d42, 0x0d43, 0x0000, 0x0000, 0x0d46, 0x0d47,
  0x0d48, 0x0000, 0x0d4a, 0x0d4b, 0x0d4c, 0x0d4d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d57,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0d60, 0x0d61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d66, 0x0d67,
  0x0d68, 0x0d69, 0x0d6a, 0x0d6b, 0x0d6c, 0x0d6d, 0x0d6e, 0x0d6f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d82, 0x0d83, 0x0000, 0x0d85, 0x0d86, 0x0d87,
  0x0d88, 0x0d89, 0x0d8a, 0x0d8b, 0x0d8c, 0x0d8d, 0x0d8e, 0x0d8f,
  0x0d90, 0x0d91, 0x0d92, 0x0d93, 0x0d94, 0x0d95, 0x0d96, 0x0000,
  0x0000, 0x0000, 0x0d9a, 0x0d9b, 0x0d9c, 0x0d9d, 0x0d9e, 0x0d9f,
  0x0da0, 0x0da1, 0x0da2, 0x0da3, 0x0da4, 0x0da5, 0x0da6, 0x0da7,
  0x0da8, 0x0da9, 0x0daa, 0x0dab, 0x0dac, 0x0dad, 0x0dae, 0x0daf,
  0x0db0, 0x0db1, 0x0000, 0x0db3, 0x0db4, 0x0db5, 0x0db6, 0x0db7,
  0x0db8, 0x0db9, 0x0dba, 0x0dbb, 0x0000, 0x0dbd, 0x0000, 0x0000,
  0x0dc0, 0x0dc1, 0x0dc2, 0x0dc3, 0x0dc4, 0x0dc5, 0x0dc6, 0x0000,
  0x0000, 0x0000, 0x0dca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0dcf,
  0x0dd0, 0x0dd1, 0x0dd2, 0x0dd3, 0x0dd4, 0x0000, 0x0dd6, 0x0000,
  0x0dd8, 0x0dd9, 0x0dda, 0x0ddb, 0x0ddc, 0x0ddd, 0x0dde, 0x0ddf,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0df2, 0x0df3, 0x0df4, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0e01, 0x0e02, 0x0e03, 0x0e04, 0x0e05, 0x0e06, 0x0e07,
  0x0e08, 0x0e09, 0x0e0a, 0x0e0b, 0x0e0c, 0x0e0d, 0x0e0e, 0x0e0f,
  0x0e10, 0x0e11, 0x0e12, 0x0e13, 0x0e14, 0x0e15, 0x0e16, 0x0e17,
  0x0e18, 0x0e19, 0x0e1a, 0x0e1b, 0x0e1c, 0x0e1d, 0x0e1e, 0x0e1f,
  0x0e20, 0x0e21, 0x0e22, 0x0e23, 0x0e24, 0x0e25, 0x0e26, 0x0e27,
  0x0e28, 0x0e29, 0x0e2a, 0x0e2b, 0x0e2c, 0x0e2d, 0x0e2e, 0x0e2f,
  0x0e30, 0x0e31, 0x0e32, 0x0e33, 0x0e34, 0x0e35, 0x0e36, 0x0e37,
  0x0e38, 0x0e39, 0x0e3a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e3f,
  0x0e40, 0x0e41, 0x0e42, 0x0e43, 0x0e44, 0x0e45, 0x0e46, 0x0e47,
  0x0e48, 0x0e49, 0x0e4a, 0x0e4b, 0x0e4c, 0x0e4d, 0x0e4e, 0x0e4f,
  0x0e50, 0x0e51, 0x0e52, 0x0e53, 0x0e54, 0x0e55, 0x0e56, 0x0e57,
  0x0e58, 0x0e59, 0x0e5a, 0x0e5b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0e81, 0x0e82, 0x0000, 0x0e84, 0x0000, 0x0000, 0x0e87,
  0x0e88, 0x0000, 0x0e8a, 0x0000, 0x0000, 0x0e8d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0e94, 0x0e95, 0x0e96, 0x0e97,
  0x0000, 0x0e99, 0x0e9a, 0x0e9b, 0x0e9c, 0x0e9d, 0x0e9e, 0x0e9f,
  0x0000, 0x0ea1, 0x0ea2, 0x0ea3, 0x0000, 0x0ea5, 0x0000, 0x0ea7,
  0x0000, 0x0000, 0x0eaa, 0x0eab, 0x0000, 0x0ead, 0x0eae, 0x0eaf,
  0x0eb0, 0x0eb1, 0x0eb2, 0x0eb3, 0x0eb4, 0x0eb5, 0x0eb6, 0x0eb7,
  0x0eb8, 0x0eb9, 0x0000, 0x0ebb, 0x0ebc, 0x0ebd, 0x0000, 0x0000,
  0x0ec0, 0x0ec1, 0x0ec2, 0x0ec3, 0x0ec4, 0x0000, 0x0ec6, 0x0000,
  0x0ec8, 0x0ec9, 0x0eca, 0x0ecb, 0x0ecc, 0x0ecd, 0x0000, 0x0000,
  0x0ed0, 0x0ed1, 0x0ed2, 0x0ed3, 0x0ed4, 0x0ed5, 0x0ed6, 0x0ed7,
  0x0ed8, 0x0ed9, 0x0000, 0x0000, 0x0edc, 0x0edd, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0f00, 0x0f01, 0x0f02, 0x0f03, 0x0f04, 0x0f05, 0x0f06, 0x0f07,
  0x0f08, 0x0f09, 0x0f0a, 0x0f0b, 0x0f0c, 0x0f0d, 0x0f0e, 0x0f0f,
  0x0f10, 0x0f11, 0x0f12, 0x0f13, 0x0f14, 0x0f15, 0x0f16, 0x0f17,
  0x0f18, 0x0f19, 0x0f1a, 0x0f1b, 0x0f1c, 0x0f1d, 0x0f1e, 0x0f1f,
  0x0f20, 0x0f21, 0x0f22, 0x0f23, 0x0f24, 0x0f25, 0x0f26, 0x0f27,
  0x0f28, 0x0f29, 0x0f2a, 0x0f2b, 0x0f2c, 0x0f2d, 0x0f2e, 0x0f2f,
  0x0f30, 0x0f31, 0x0f32, 0x0f33, 0x0f34, 0x0f35, 0x0f36, 0x0f37,
  0x0f38, 0x0f39, 0x0f3a, 0x0f3b, 0x0f3c, 0x0f3d, 0x0f3e, 0x0f3f,
  0x0f40, 0x0f41, 0x0f42, 0x0f43, 0x0f44, 0x0f45, 0x0f46, 0x0f47,
  0x0000, 0x0f49, 0x0f4a, 0x0f4b, 0x0f4c, 0x0f4d, 0x0f4e, 0x0f4f,
  0x0f50, 0x0f51, 0x0f52, 0x0f53, 0x0f54, 0x0f55, 0x0f56, 0x0f57,
  0x0f58, 0x0f59, 0x0f5a, 0x0f5b, 0x0f5c, 0x0f5d, 0x0f5e, 0x0f5f,
  0x0f60, 0x0f61, 0x0f62, 0x0f63, 0x0f64, 0x0f65, 0x0f66, 0x0f67,
  0x0f68, 0x0f69, 0x0f6a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0f71, 0x0f72, 0x0f73, 0x0f74, 0x0f75, 0x0f76, 0x0f77,
  0x0f78, 0x0f79, 0x0f7a, 0x0f7b, 0x0f7c, 0x0f7d, 0x0f7e, 0x0f7f,
  0x0f80, 0x0f81, 0x0f82, 0x0f83, 0x0f84, 0x0f85, 0x0f86, 0x0f87,
  0x0f88, 0x0f89, 0x0f8a, 0x0f8b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0f90, 0x0f91, 0x0f92, 0x0f93, 0x0f94, 0x0f95, 0x0f96, 0x0f97,
  0x0000, 0x0f99, 0x0f9a, 0x0f9b, 0x0f9c, 0x0f9d, 0x0f9e, 0x0f9f,
  0x0fa0, 0x0fa1, 0x0fa2, 0x0fa3, 0x0fa4, 0x0fa5, 0x0fa6, 0x0fa7,
  0x0fa8, 0x0fa9, 0x0faa, 0x0fab, 0x0fac, 0x0fad, 0x0fae, 0x0faf,
  0x0fb0, 0x0fb1, 0x0fb2, 0x0fb3, 0x0fb4, 0x0fb5, 0x0fb6, 0x0fb7,
  0x0fb8, 0x0fb9, 0x0fba, 0x0fbb, 0x0fbc, 0x0000, 0x0fbe, 0x0fbf,
  0x0fc0, 0x0fc1, 0x0fc2, 0x0fc3, 0x0fc4, 0x0fc5, 0x0fc6, 0x0fc7,
  0x0fc8, 0x0fc9, 0x0fca, 0x0fcb, 0x0fcc, 0x0000, 0x0000, 0x0fcf,
  0x0fd0, 0x0fd1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1000, 0x1001, 0x1002, 0x1003, 0x1004, 0x1005, 0x1006, 0x1007,
  0x1008, 0x1009, 0x100a, 0x100b, 0x100c, 0x100d, 0x100e, 0x100f,
  0x1010, 0x1011, 0x1012, 0x1013, 0x1014, 0x1015, 0x1016, 0x1017,
  0x1018, 0x1019, 0x101a, 0x101b, 0x101c, 0x101d, 0x101e, 0x101f,
  0x1020, 0x1021, 0x0000, 0x1023, 0x1024, 0x1025, 0x1026, 0x1027,
  0x0000, 0x1029, 0x102a, 0x0000, 0x102c, 0x102d, 0x102e, 0x102f,
  0x1030, 0x1031, 0x1032, 0x0000, 0x0000, 0x0000, 0x1036, 0x1037,
  0x1038, 0x1039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047,
  0x1048, 0x1049, 0x104a, 0x104b, 0x104c, 0x104d, 0x104e, 0x104f,
  0x1050, 0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057,
  0x1058, 0x1059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2d00, 0x2d01, 0x2d02, 0x2d03, 0x2d04, 0x2d05, 0x2d06, 0x2d07,
  0x2d08, 0x2d09, 0x2d0a, 0x2d0b, 0x2d0c, 0x2d0d, 0x2d0e, 0x2d0f,
  0x2d10, 0x2d11, 0x2d12, 0x2d13, 0x2d14, 0x2d15, 0x2d16, 0x2d17,
  0x2d18, 0x2d19, 0x2d1a, 0x2d1b, 0x2d1c, 0x2d1d, 0x2d1e, 0x2d1f,
  0x2d20, 0x2d21, 0x2d22, 0x2d23, 0x2d24, 0x2d25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x10d0, 0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5, 0x10d6, 0x10d7,
  0x10d8, 0x10d9, 0x10da, 0x10db, 0x10dc, 0x10dd, 0x10de, 0x10df,
  0x10e0, 0x10e1, 0x10e2, 0x10e3, 0x10e4, 0x10e5, 0x10e6, 0x10e7,
  0x10e8, 0x10e9, 0x10ea, 0x10eb, 0x10ec, 0x10ed, 0x10ee, 0x10ef,
  0x10f0, 0x10f1, 0x10f2, 0x10f3, 0x10f4, 0x10f5, 0x10f6, 0x10f7,
  0x10f8, 0x10f9, 0x10fa, 0x10fb, 0x10fc, 0x0000, 0x0000, 0x0000,
  0x1100, 0x1101, 0x1102, 0x1103, 0x1104, 0x1105, 0x1106, 0x1107,
  0x1108, 0x1109, 0x110a, 0x110b, 0x110c, 0x110d, 0x110e, 0x110f,
  0x1110, 0x1111, 0x1112, 0x1113, 0x1114, 0x1115, 0x1116, 0x1117,
  0x1118, 0x1119, 0x111a, 0x111b, 0x111c, 0x111d, 0x111e, 0x111f,
  0x1120, 0x1121, 0x1122, 0x1123, 0x1124, 0x1125, 0x1126, 0x1127,
  0x1128, 0x1129, 0x112a, 0x112b, 0x112c, 0x112d, 0x112e, 0x112f,
  0x1130, 0x1131, 0x1132, 0x1133, 0x1134, 0x1135, 0x1136, 0x1137,
  0x1138, 0x1139, 0x113a, 0x113b, 0x113c, 0x113d, 0x113e, 0x113f,
  0x1140, 0x1141, 0x1142, 0x1143, 0x1144, 0x1145, 0x1146, 0x1147,
  0x1148, 0x1149, 0x114a, 0x114b, 0x114c, 0x114d, 0x114e, 0x114f,
  0x1150, 0x1151, 0x1152, 0x1153, 0x1154, 0x1155, 0x1156, 0x1157,
  0x1158, 0x1159, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x115f,
  0x1160, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167,
  0x1168, 0x1169, 0x116a, 0x116b, 0x116c, 0x116d, 0x116e, 0x116f,
  0x1170, 0x1171, 0x1172, 0x1173, 0x1174, 0x1175, 0x1176, 0x1177,
  0x1178, 0x1179, 0x117a, 0x117b, 0x117c, 0x117d, 0x117e, 0x117f,
  0x1180, 0x1181, 0x1182, 0x1183, 0x1184, 0x1185, 0x1186, 0x1187,
  0x1188, 0x1189, 0x118a, 0x118b, 0x118c, 0x118d, 0x118e, 0x118f,
  0x1190, 0x1191, 0x1192, 0x1193, 0x1194, 0x1195, 0x1196, 0x1197,
  0x1198, 0x1199, 0x119a, 0x119b, 0x119c, 0x119d, 0x119e, 0x119f,
  0x11a0, 0x11a1, 0x11a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x11a8, 0x11a9, 0x11aa, 0x11ab, 0x11ac, 0x11ad, 0x11ae, 0x11af,
  0x11b0, 0x11b1, 0x11b2, 0x11b3, 0x11b4, 0x11b5, 0x11b6, 0x11b7,
  0x11b8, 0x11b9, 0x11ba, 0x11bb, 0x11bc, 0x11bd, 0x11be, 0x11bf,
  0x11c0, 0x11c1, 0x11c2, 0x11c3, 0x11c4, 0x11c5, 0x11c6, 0x11c7,
  0x11c8, 0x11c9, 0x11ca, 0x11cb, 0x11cc, 0x11cd, 0x11ce, 0x11cf,
  0x11d0, 0x11d1, 0x11d2, 0x11d3, 0x11d4, 0x11d5, 0x11d6, 0x11d7,
  0x11d8, 0x11d9, 0x11da, 0x11db, 0x11dc, 0x11dd, 0x11de, 0x11df,
  0x11e0, 0x11e1, 0x11e2, 0x11e3, 0x11e4, 0x11e5, 0x11e6, 0x11e7,
  0x11e8, 0x11e9, 0x11ea, 0x11eb, 0x11ec, 0x11ed, 0x11ee, 0x11ef,
  0x11f0, 0x11f1, 0x11f2, 0x11f3, 0x11f4, 0x11f5, 0x11f6, 0x11f7,
  0x11f8, 0x11f9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1200, 0x1201, 0x1202, 0x1203, 0x1204, 0x1205, 0x1206, 0x1207,
  0x1208, 0x1209, 0x120a, 0x120b, 0x120c, 0x120d, 0x120e, 0x120f,
  0x1210, 0x1211, 0x1212, 0x1213, 0x1214, 0x1215, 0x1216, 0x1217,
  0x1218, 0x1219, 0x121a, 0x121b, 0x121c, 0x121d, 0x121e, 0x121f,
  0x1220, 0x1221, 0x1222, 0x1223, 0x1224, 0x1225, 0x1226, 0x1227,
  0x1228, 0x1229, 0x122a, 0x122b, 0x122c, 0x122d, 0x122e, 0x122f,
  0x1230, 0x1231, 0x1232, 0x1233, 0x1234, 0x1235, 0x1236, 0x1237,
  0x1238, 0x1239, 0x123a, 0x123b, 0x123c, 0x123d, 0x123e, 0x123f,
  0x1240, 0x1241, 0x1242, 0x1243, 0x1244, 0x1245, 0x1246, 0x1247,
  0x1248, 0x0000, 0x124a, 0x124b, 0x124c, 0x124d, 0x0000, 0x0000,
  0x1250, 0x1251, 0x1252, 0x1253, 0x1254, 0x1255, 0x1256, 0x0000,
  0x1258, 0x0000, 0x125a, 0x125b, 0x125c, 0x125d, 0x0000, 0x0000,
  0x1260, 0x1261, 0x1262, 0x1263, 0x1264, 0x1265, 0x1266, 0x1267,
  0x1268, 0x1269, 0x126a, 0x126b, 0x126c, 0x126d, 0x126e, 0x126f,
  0x1270, 0x1271, 0x1272, 0x1273, 0x1274, 0x1275, 0x1276, 0x1277,
  0x1278, 0x1279, 0x127a, 0x127b, 0x127c, 0x127d, 0x127e, 0x127f,
  0x1280, 0x1281, 0x1282, 0x1283, 0x1284, 0x1285, 0x1286, 0x1287,
  0x1288, 0x0000, 0x128a, 0x128b, 0x128c, 0x128d, 0x0000, 0x0000,
  0x1290, 0x1291, 0x1292, 0x1293, 0x1294, 0x1295, 0x1296, 0x1297,
  0x1298, 0x1299, 0x129a, 0x129b, 0x129c, 0x129d, 0x129e, 0x129f,
  0x12a0, 0x12a1, 0x12a2, 0x12a3, 0x12a4, 0x12a5, 0x12a6, 0x12a7,
  0x12a8, 0x12a9, 0x12aa, 0x12ab, 0x12ac, 0x12ad, 0x12ae, 0x12af,
  0x12b0, 0x0000, 0x12b2, 0x12b3, 0x12b4, 0x12b5, 0x0000, 0x0000,
  0x12b8, 0x12b9, 0x12ba, 0x12bb, 0x12bc, 0x12bd, 0x12be, 0x0000,
  0x12c0, 0x0000, 0x12c2, 0x12c3, 0x12c4, 0x12c5, 0x0000, 0x0000,
  0x12c8, 0x12c9, 0x12ca, 0x12cb, 0x12cc, 0x12cd, 0x12ce, 0x12cf,
  0x12d0, 0x12d1, 0x12d2, 0x12d3, 0x12d4, 0x12d5, 0x12d6, 0x0000,
  0x12d8, 0x12d9, 0x12da, 0x12db, 0x12dc, 0x12dd, 0x12de, 0x12df,
  0x12e0, 0x12e1, 0x12e2, 0x12e3, 0x12e4, 0x12e5, 0x12e6, 0x12e7,
  0x12e8, 0x12e9, 0x12ea, 0x12eb, 0x12ec, 0x12ed, 0x12ee, 0x12ef,
  0x12f0, 0x12f1, 0x12f2, 0x12f3, 0x12f4, 0x12f5, 0x12f6, 0x12f7,
  0x12f8, 0x12f9, 0x12fa, 0x12fb, 0x12fc, 0x12fd, 0x12fe, 0x12ff,
  0x1300, 0x1301, 0x1302, 0x1303, 0x1304, 0x1305, 0x1306, 0x1307,
  0x1308, 0x1309, 0x130a, 0x130b, 0x130c, 0x130d, 0x130e, 0x130f,
  0x1310, 0x0000, 0x1312, 0x1313, 0x1314, 0x1315, 0x0000, 0x0000,
  0x1318, 0x1319, 0x131a, 0x131b, 0x131c, 0x131d, 0x131e, 0x131f,
  0x1320, 0x1321, 0x1322, 0x1323, 0x1324, 0x1325, 0x1326, 0x1327,
  0x1328, 0x1329, 0x132a, 0x132b, 0x132c, 0x132d, 0x132e, 0x132f,
  0x1330, 0x1331, 0x1332, 0x1333, 0x1334, 0x1335, 0x1336, 0x1337,
  0x1338, 0x1339, 0x133a, 0x133b, 0x133c, 0x133d, 0x133e, 0x133f,
  0x1340, 0x1341, 0x1342, 0x1343, 0x1344, 0x1345, 0x1346, 0x1347,
  0x1348, 0x1349, 0x134a, 0x134b, 0x134c, 0x134d, 0x134e, 0x134f,
  0x1350, 0x1351, 0x1352, 0x1353, 0x1354, 0x1355, 0x1356, 0x1357,
  0x1358, 0x1359, 0x135a, 0x0000, 0x0000, 0x0000, 0x0000, 0x135f,
  0x1360, 0x1361, 0x1362, 0x1363, 0x1364, 0x1365, 0x1366, 0x1367,
  0x1368, 0x1369, 0x136a, 0x136b, 0x136c, 0x136d, 0x136e, 0x136f,
  0x1370, 0x1371, 0x1372, 0x1373, 0x1374, 0x1375, 0x1376, 0x1377,
  0x1378, 0x1379, 0x137a, 0x137b, 0x137c, 0x0000, 0x0000, 0x0000,
  0x1380, 0x1381, 0x1382, 0x1383, 0x1384, 0x1385, 0x1386, 0x1387,
  0x1388, 0x1389, 0x138a, 0x138b, 0x138c, 0x138d, 0x138e, 0x138f,
  0x1390, 0x1391, 0x1392, 0x1393, 0x1394, 0x1395, 0x1396, 0x1397,
  0x1398, 0x1399, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x13a0, 0x13a1, 0x13a2, 0x13a3, 0x13a4, 0x13a5, 0x13a6, 0x13a7,
  0x13a8, 0x13a9, 0x13aa, 0x13ab, 0x13ac, 0x13ad, 0x13ae, 0x13af,
  0x13b0, 0x13b1, 0x13b2, 0x13b3, 0x13b4, 0x13b5, 0x13b6, 0x13b7,
  0x13b8, 0x13b9, 0x13ba, 0x13bb, 0x13bc, 0x13bd, 0x13be, 0x13bf,
  0x13c0, 0x13c1, 0x13c2, 0x13c3, 0x13c4, 0x13c5, 0x13c6, 0x13c7,
  0x13c8, 0x13c9, 0x13ca, 0x13cb, 0x13cc, 0x13cd, 0x13ce, 0x13cf,
  0x13d0, 0x13d1, 0x13d2, 0x13d3, 0x13d4, 0x13d5, 0x13d6, 0x13d7,
  0x13d8, 0x13d9, 0x13da, 0x13db, 0x13dc, 0x13dd, 0x13de, 0x13df,
  0x13e0, 0x13e1, 0x13e2, 0x13e3, 0x13e4, 0x13e5, 0x13e6, 0x13e7,
  0x13e8, 0x13e9, 0x13ea, 0x13eb, 0x13ec, 0x13ed, 0x13ee, 0x13ef,
  0x13f0, 0x13f1, 0x13f2, 0x13f3, 0x13f4, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1401, 0x1402, 0x1403, 0x1404, 0x1405, 0x1406, 0x1407,
  0x1408, 0x1409, 0x140a, 0x140b, 0x140c, 0x140d, 0x140e, 0x140f,
  0x1410, 0x1411, 0x1412, 0x1413, 0x1414, 0x1415, 0x1416, 0x1417,
  0x1418, 0x1419, 0x141a, 0x141b, 0x141c, 0x141d, 0x141e, 0x141f,
  0x1420, 0x1421, 0x1422, 0x1423, 0x1424, 0x1425, 0x1426, 0x1427,
  0x1428, 0x1429, 0x142a, 0x142b, 0x142c, 0x142d, 0x142e, 0x142f,
  0x1430, 0x1431, 0x1432, 0x1433, 0x1434, 0x1435, 0x1436, 0x1437,
  0x1438, 0x1439, 0x143a, 0x143b, 0x143c, 0x143d, 0x143e, 0x143f,
  0x1440, 0x1441, 0x1442, 0x1443, 0x1444, 0x1445, 0x1446, 0x1447,
  0x1448, 0x1449, 0x144a, 0x144b, 0x144c, 0x144d, 0x144e, 0x144f,
  0x1450, 0x1451, 0x1452, 0x1453, 0x1454, 0x1455, 0x1456, 0x1457,
  0x1458, 0x1459, 0x145a, 0x145b, 0x145c, 0x145d, 0x145e, 0x145f,
  0x1460, 0x1461, 0x1462, 0x1463, 0x1464, 0x1465, 0x1466, 0x1467,
  0x1468, 0x1469, 0x146a, 0x146b, 0x146c, 0x146d, 0x146e, 0x146f,
  0x1470, 0x1471, 0x1472, 0x1473, 0x1474, 0x1475, 0x1476, 0x1477,
  0x1478, 0x1479, 0x147a, 0x147b, 0x147c, 0x147d, 0x147e, 0x147f,
  0x1480, 0x1481, 0x1482, 0x1483, 0x1484, 0x1485, 0x1486, 0x1487,
  0x1488, 0x1489, 0x148a, 0x148b, 0x148c, 0x148d, 0x148e, 0x148f,
  0x1490, 0x1491, 0x1492, 0x1493, 0x1494, 0x1495, 0x1496, 0x1497,
  0x1498, 0x1499, 0x149a, 0x149b, 0x149c, 0x149d, 0x149e, 0x149f,
  0x14a0, 0x14a1, 0x14a2, 0x14a3, 0x14a4, 0x14a5, 0x14a6, 0x14a7,
  0x14a8, 0x14a9, 0x14aa, 0x14ab, 0x14ac, 0x14ad, 0x14ae, 0x14af,
  0x14b0, 0x14b1, 0x14b2, 0x14b3, 0x14b4, 0x14b5, 0x14b6, 0x14b7,
  0x14b8, 0x14b9, 0x14ba, 0x14bb, 0x14bc, 0x14bd, 0x14be, 0x14bf,
  0x14c0, 0x14c1, 0x14c2, 0x14c3, 0x14c4, 0x14c5, 0x14c6, 0x14c7,
  0x14c8, 0x14c9, 0x14ca, 0x14cb, 0x14cc, 0x14cd, 0x14ce, 0x14cf,
  0x14d0, 0x14d1, 0x14d2, 0x14d3, 0x14d4, 0x14d5, 0x14d6, 0x14d7,
  0x14d8, 0x14d9, 0x14da, 0x14db, 0x14dc, 0x14dd, 0x14de, 0x14df,
  0x14e0, 0x14e1, 0x14e2, 0x14e3, 0x14e4, 0x14e5, 0x14e6, 0x14e7,
  0x14e8, 0x14e9, 0x14ea, 0x14eb, 0x14ec, 0x14ed, 0x14ee, 0x14ef,
  0x14f0, 0x14f1, 0x14f2, 0x14f3, 0x14f4, 0x14f5, 0x14f6, 0x14f7,
  0x14f8, 0x14f9, 0x14fa, 0x14fb, 0x14fc, 0x14fd, 0x14fe, 0x14ff,
  0x1500, 0x1501, 0x1502, 0x1503, 0x1504, 0x1505, 0x1506, 0x1507,
  0x1508, 0x1509, 0x150a, 0x150b, 0x150c, 0x150d, 0x150e, 0x150f,
  0x1510, 0x1511, 0x1512, 0x1513, 0x1514, 0x1515, 0x1516, 0x1517,
  0x1518, 0x1519, 0x151a, 0x151b, 0x151c, 0x151d, 0x151e, 0x151f,
  0x1520, 0x1521, 0x1522, 0x1523, 0x1524, 0x1525, 0x1526, 0x1527,
  0x1528, 0x1529, 0x152a, 0x152b, 0x152c, 0x152d, 0x152e, 0x152f,
  0x1530, 0x1531, 0x1532, 0x1533, 0x1534, 0x1535, 0x1536, 0x1537,
  0x1538, 0x1539, 0x153a, 0x153b, 0x153c, 0x153d, 0x153e, 0x153f,
  0x1540, 0x1541, 0x1542, 0x1543, 0x1544, 0x1545, 0x1546, 0x1547,
  0x1548, 0x1549, 0x154a, 0x154b, 0x154c, 0x154d, 0x154e, 0x154f,
  0x1550, 0x1551, 0x1552, 0x1553, 0x1554, 0x1555, 0x1556, 0x1557,
  0x1558, 0x1559, 0x155a, 0x155b, 0x155c, 0x155d, 0x155e, 0x155f,
  0x1560, 0x1561, 0x1562, 0x1563, 0x1564, 0x1565, 0x1566, 0x1567,
  0x1568, 0x1569, 0x156a, 0x156b, 0x156c, 0x156d, 0x156e, 0x156f,
  0x1570, 0x1571, 0x1572, 0x1573, 0x1574, 0x1575, 0x1576, 0x1577,
  0x1578, 0x1579, 0x157a, 0x157b, 0x157c, 0x157d, 0x157e, 0x157f,
  0x1580, 0x1581, 0x1582, 0x1583, 0x1584, 0x1585, 0x1586, 0x1587,
  0x1588, 0x1589, 0x158a, 0x158b, 0x158c, 0x158d, 0x158e, 0x158f,
  0x1590, 0x1591, 0x1592, 0x1593, 0x1594, 0x1595, 0x1596, 0x1597,
  0x1598, 0x1599, 0x159a, 0x159b, 0x159c, 0x159d, 0x159e, 0x159f,
  0x15a0, 0x15a1, 0x15a2, 0x15a3, 0x15a4, 0x15a5, 0x15a6, 0x15a7,
  0x15a8, 0x15a9, 0x15aa, 0x15ab, 0x15ac, 0x15ad, 0x15ae, 0x15af,
  0x15b0, 0x15b1, 0x15b2, 0x15b3, 0x15b4, 0x15b5, 0x15b6, 0x15b7,
  0x15b8, 0x15b9, 0x15ba, 0x15bb, 0x15bc, 0x15bd, 0x15be, 0x15bf,
  0x15c0, 0x15c1, 0x15c2, 0x15c3, 0x15c4, 0x15c5, 0x15c6, 0x15c7,
  0x15c8, 0x15c9, 0x15ca, 0x15cb, 0x15cc, 0x15cd, 0x15ce, 0x15cf,
  0x15d0, 0x15d1, 0x15d2, 0x15d3, 0x15d4, 0x15d5, 0x15d6, 0x15d7,
  0x15d8, 0x15d9, 0x15da, 0x15db, 0x15dc, 0x15dd, 0x15de, 0x15df,
  0x15e0, 0x15e1, 0x15e2, 0x15e3, 0x15e4, 0x15e5, 0x15e6, 0x15e7,
  0x15e8, 0x15e9, 0x15ea, 0x15eb, 0x15ec, 0x15ed, 0x15ee, 0x15ef,
  0x15f0, 0x15f1, 0x15f2, 0x15f3, 0x15f4, 0x15f5, 0x15f6, 0x15f7,
  0x15f8, 0x15f9, 0x15fa, 0x15fb, 0x15fc, 0x15fd, 0x15fe, 0x15ff,
  0x1600, 0x1601, 0x1602, 0x1603, 0x1604, 0x1605, 0x1606, 0x1607,
  0x1608, 0x1609, 0x160a, 0x160b, 0x160c, 0x160d, 0x160e, 0x160f,
  0x1610, 0x1611, 0x1612, 0x1613, 0x1614, 0x1615, 0x1616, 0x1617,
  0x1618, 0x1619, 0x161a, 0x161b, 0x161c, 0x161d, 0x161e, 0x161f,
  0x1620, 0x1621, 0x1622, 0x1623, 0x1624, 0x1625, 0x1626, 0x1627,
  0x1628, 0x1629, 0x162a, 0x162b, 0x162c, 0x162d, 0x162e, 0x162f,
  0x1630, 0x1631, 0x1632, 0x1633, 0x1634, 0x1635, 0x1636, 0x1637,
  0x1638, 0x1639, 0x163a, 0x163b, 0x163c, 0x163d, 0x163e, 0x163f,
  0x1640, 0x1641, 0x1642, 0x1643, 0x1644, 0x1645, 0x1646, 0x1647,
  0x1648, 0x1649, 0x164a, 0x164b, 0x164c, 0x164d, 0x164e, 0x164f,
  0x1650, 0x1651, 0x1652, 0x1653, 0x1654, 0x1655, 0x1656, 0x1657,
  0x1658, 0x1659, 0x165a, 0x165b, 0x165c, 0x165d, 0x165e, 0x165f,
  0x1660, 0x1661, 0x1662, 0x1663, 0x1664, 0x1665, 0x1666, 0x1667,
  0x1668, 0x1669, 0x166a, 0x166b, 0x166c, 0x166d, 0x166e, 0x166f,
  0x1670, 0x1671, 0x1672, 0x1673, 0x1674, 0x1675, 0x1676, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1680, 0x1681, 0x1682, 0x1683, 0x1684, 0x1685, 0x1686, 0x1687,
  0x1688, 0x1689, 0x168a, 0x168b, 0x168c, 0x168d, 0x168e, 0x168f,
  0x1690, 0x1691, 0x1692, 0x1693, 0x1694, 0x1695, 0x1696, 0x1697,
  0x1698, 0x1699, 0x169a, 0x169b, 0x169c, 0x0000, 0x0000, 0x0000,
  0x16a0, 0x16a1, 0x16a2, 0x16a3, 0x16a4, 0x16a5, 0x16a6, 0x16a7,
  0x16a8, 0x16a9, 0x16aa, 0x16ab, 0x16ac, 0x16ad, 0x16ae, 0x16af,
  0x16b0, 0x16b1, 0x16b2, 0x16b3, 0x16b4, 0x16b5, 0x16b6, 0x16b7,
  0x16b8, 0x16b9, 0x16ba, 0x16bb, 0x16bc, 0x16bd, 0x16be, 0x16bf,
  0x16c0, 0x16c1, 0x16c2, 0x16c3, 0x16c4, 0x16c5, 0x16c6, 0x16c7,
  0x16c8, 0x16c9, 0x16ca, 0x16cb, 0x16cc, 0x16cd, 0x16ce, 0x16cf,
  0x16d0, 0x16d1, 0x16d2, 0x16d3, 0x16d4, 0x16d5, 0x16d6, 0x16d7,
  0x16d8, 0x16d9, 0x16da, 0x16db, 0x16dc, 0x16dd, 0x16de, 0x16df,
  0x16e0, 0x16e1, 0x16e2, 0x16e3, 0x16e4, 0x16e5, 0x16e6, 0x16e7,
  0x16e8, 0x16e9, 0x16ea, 0x16eb, 0x16ec, 0x16ed, 0x16ee, 0x16ef,
  0x16f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1700, 0x1701, 0x1702, 0x1703, 0x1704, 0x1705, 0x1706, 0x1707,
  0x1708, 0x1709, 0x170a, 0x170b, 0x170c, 0x0000, 0x170e, 0x170f,
  0x1710, 0x1711, 0x1712, 0x1713, 0x1714, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1720, 0x1721, 0x1722, 0x1723, 0x1724, 0x1725, 0x1726, 0x1727,
  0x1728, 0x1729, 0x172a, 0x172b, 0x172c, 0x172d, 0x172e, 0x172f,
  0x1730, 0x1731, 0x1732, 0x1733, 0x1734, 0x1735, 0x1736, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1740, 0x1741, 0x1742, 0x1743, 0x1744, 0x1745, 0x1746, 0x1747,
  0x1748, 0x1749, 0x174a, 0x174b, 0x174c, 0x174d, 0x174e, 0x174f,
  0x1750, 0x1751, 0x1752, 0x1753, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1760, 0x1761, 0x1762, 0x1763, 0x1764, 0x1765, 0x1766, 0x1767,
  0x1768, 0x1769, 0x176a, 0x176b, 0x176c, 0x0000, 0x176e, 0x176f,
  0x1770, 0x0000, 0x1772, 0x1773, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1780, 0x1781, 0x1782, 0x1783, 0x1784, 0x1785, 0x1786, 0x1787,
  0x1788, 0x1789, 0x178a, 0x178b, 0x178c, 0x178d, 0x178e, 0x178f,
  0x1790, 0x1791, 0x1792, 0x1793, 0x1794, 0x1795, 0x1796, 0x1797,
  0x1798, 0x1799, 0x179a, 0x179b, 0x179c, 0x179d, 0x179e, 0x179f,
  0x17a0, 0x17a1, 0x17a2, 0x17a3, 0x17a4, 0x17a5, 0x17a6, 0x17a7,
  0x17a8, 0x17a9, 0x17aa, 0x17ab, 0x17ac, 0x17ad, 0x17ae, 0x17af,
  0x17b0, 0x17b1, 0x17b2, 0x17b3, 0x17b4, 0x17b5, 0x17b6, 0x17b7,
  0x17b8, 0x17b9, 0x17ba, 0x17bb, 0x17bc, 0x17bd, 0x17be, 0x17bf,
  0x17c0, 0x17c1, 0x17c2, 0x17c3, 0x17c4, 0x17c5, 0x17c6, 0x17c7,
  0x17c8, 0x17c9, 0x17ca, 0x17cb, 0x17cc, 0x17cd, 0x17ce, 0x17cf,
  0x17d0, 0x17d1, 0x17d2, 0x17d3, 0x17d4, 0x17d5, 0x17d6, 0x17d7,
  0x17d8, 0x17d9, 0x17da, 0x17db, 0x17dc, 0x17dd, 0x0000, 0x0000,
  0x17e0, 0x17e1, 0x17e2, 0x17e3, 0x17e4, 0x17e5, 0x17e6, 0x17e7,
  0x17e8, 0x17e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x17f0, 0x17f1, 0x17f2, 0x17f3, 0x17f4, 0x17f5, 0x17f6, 0x17f7,
  0x17f8, 0x17f9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1800, 0x1801, 0x1802, 0x1803, 0x1804, 0x1805, 0x1806, 0x1807,
  0x1808, 0x1809, 0x180a, 0x180b, 0x180c, 0x180d, 0x180e, 0x0000,
  0x1810, 0x1811, 0x1812, 0x1813, 0x1814, 0x1815, 0x1816, 0x1817,
  0x1818, 0x1819, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1820, 0x1821, 0x1822, 0x1823, 0x1824, 0x1825, 0x1826, 0x1827,
  0x1828, 0x1829, 0x182a, 0x182b, 0x182c, 0x182d, 0x182e, 0x182f,
  0x1830, 0x1831, 0x1832, 0x1833, 0x1834, 0x1835, 0x1836, 0x1837,
  0x1838, 0x1839, 0x183a, 0x183b, 0x183c, 0x183d, 0x183e, 0x183f,
  0x1840, 0x1841, 0x1842, 0x1843, 0x1844, 0x1845, 0x1846, 0x1847,
  0x1848, 0x1849, 0x184a, 0x184b, 0x184c, 0x184d, 0x184e, 0x184f,
  0x1850, 0x1851, 0x1852, 0x1853, 0x1854, 0x1855, 0x1856, 0x1857,
  0x1858, 0x1859, 0x185a, 0x185b, 0x185c, 0x185d, 0x185e, 0x185f,
  0x1860, 0x1861, 0x1862, 0x1863, 0x1864, 0x1865, 0x1866, 0x1867,
  0x1868, 0x1869, 0x186a, 0x186b, 0x186c, 0x186d, 0x186e, 0x186f,
  0x1870, 0x1871, 0x1872, 0x1873, 0x1874, 0x1875, 0x1876, 0x1877,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1880, 0x1881, 0x1882, 0x1883, 0x1884, 0x1885, 0x1886, 0x1887,
  0x1888, 0x1889, 0x188a, 0x188b, 0x188c, 0x188d, 0x188e, 0x188f,
  0x1890, 0x1891, 0x1892, 0x1893, 0x1894, 0x1895, 0x1896, 0x1897,
  0x1898, 0x1899, 0x189a, 0x189b, 0x189c, 0x189d, 0x189e, 0x189f,
  0x18a0, 0x18a1, 0x18a2, 0x18a3, 0x18a4, 0x18a5, 0x18a6, 0x18a7,
  0x18a8, 0x18a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1900, 0x1901, 0x1902, 0x1903, 0x1904, 0x1905, 0x1906, 0x1907,
  0x1908, 0x1909, 0x190a, 0x190b, 0x190c, 0x190d, 0x190e, 0x190f,
  0x1910, 0x1911, 0x1912, 0x1913, 0x1914, 0x1915, 0x1916, 0x1917,
  0x1918, 0x1919, 0x191a, 0x191b, 0x191c, 0x0000, 0x0000, 0x0000,
  0x1920, 0x1921, 0x1922, 0x1923, 0x1924, 0x1925, 0x1926, 0x1927,
  0x1928, 0x1929, 0x192a, 0x192b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1930, 0x1931, 0x1932, 0x1933, 0x1934, 0x1935, 0x1936, 0x1937,
  0x1938, 0x1939, 0x193a, 0x193b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1940, 0x0000, 0x0000, 0x0000, 0x1944, 0x1945, 0x1946, 0x1947,
  0x1948, 0x1949, 0x194a, 0x194b, 0x194c, 0x194d, 0x194e, 0x194f,
  0x1950, 0x1951, 0x1952, 0x1953, 0x1954, 0x1955, 0x1956, 0x1957,
  0x1958, 0x1959, 0x195a, 0x195b, 0x195c, 0x195d, 0x195e, 0x195f,
  0x1960, 0x1961, 0x1962, 0x1963, 0x1964, 0x1965, 0x1966, 0x1967,
  0x1968, 0x1969, 0x196a, 0x196b, 0x196c, 0x196d, 0x0000, 0x0000,
  0x1970, 0x1971, 0x1972, 0x1973, 0x1974, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1980, 0x1981, 0x1982, 0x1983, 0x1984, 0x1985, 0x1986, 0x1987,
  0x1988, 0x1989, 0x198a, 0x198b, 0x198c, 0x198d, 0x198e, 0x198f,
  0x1990, 0x1991, 0x1992, 0x1993, 0x1994, 0x1995, 0x1996, 0x1997,
  0x1998, 0x1999, 0x199a, 0x199b, 0x199c, 0x199d, 0x199e, 0x199f,
  0x19a0, 0x19a1, 0x19a2, 0x19a3, 0x19a4, 0x19a5, 0x19a6, 0x19a7,
  0x19a8, 0x19a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19b0, 0x19b1, 0x19b2, 0x19b3, 0x19b4, 0x19b5, 0x19b6, 0x19b7,
  0x19b8, 0x19b9, 0x19ba, 0x19bb, 0x19bc, 0x19bd, 0x19be, 0x19bf,
  0x19c0, 0x19c1, 0x19c2, 0x19c3, 0x19c4, 0x19c5, 0x19c6, 0x19c7,
  0x19c8, 0x19c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d0, 0x19d1, 0x19d2, 0x19d3, 0x19d4, 0x19d5, 0x19d6, 0x19d7,
  0x19d8, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x19de, 0x19df,
  0x19e0, 0x19e1, 0x19e2, 0x19e3, 0x19e4, 0x19e5, 0x19e6, 0x19e7,
  0x19e8, 0x19e9, 0x19ea, 0x19eb, 0x19ec, 0x19ed, 0x19ee, 0x19ef,
  0x19f0, 0x19f1, 0x19f2, 0x19f3, 0x19f4, 0x19f5, 0x19f6, 0x19f7,
  0x19f8, 0x19f9, 0x19fa, 0x19fb, 0x19fc, 0x19fd, 0x19fe, 0x19ff,
  0x1a00, 0x1a01, 0x1a02, 0x1a03, 0x1a04, 0x1a05, 0x1a06, 0x1a07,
  0x1a08, 0x1a09, 0x1a0a, 0x1a0b, 0x1a0c, 0x1a0d, 0x1a0e, 0x1a0f,
  0x1a10, 0x1a11, 0x1a12, 0x1a13, 0x1a14, 0x1a15, 0x1a16, 0x1a17,
  0x1a18, 0x1a19, 0x1a1a, 0x1a1b, 0x0000, 0x0000, 0x1a1e, 0x1a1f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1b00, 0x1b01, 0x1b02, 0x1b03, 0x1b04, 0x1b05, 0x1b06, 0x1b07,
  0x1b08, 0x1b09, 0x1b0a, 0x1b0b, 0x1b0c, 0x1b0d, 0x1b0e, 0x1b0f,
  0x1b10, 0x1b11, 0x1b12, 0x1b13, 0x1b14, 0x1b15, 0x1b16, 0x1b17,
  0x1b18, 0x1b19, 0x1b1a, 0x1b1b, 0x1b1c, 0x1b1d, 0x1b1e, 0x1b1f,
  0x1b20, 0x1b21, 0x1b22, 0x1b23, 0x1b24, 0x1b25, 0x1b26, 0x1b27,
  0x1b28, 0x1b29, 0x1b2a, 0x1b2b, 0x1b2c, 0x1b2d, 0x1b2e, 0x1b2f,
  0x1b30, 0x1b31, 0x1b32, 0x1b33, 0x1b34, 0x1b35, 0x1b36, 0x1b37,
  0x1b38, 0x1b39, 0x1b3a, 0x1b3b, 0x1b3c, 0x1b3d, 0x1b3e, 0x1b3f,
  0x1b40, 0x1b41, 0x1b42, 0x1b43, 0x1b44, 0x1b45, 0x1b46, 0x1b47,
  0x1b48, 0x1b49, 0x1b4a, 0x1b4b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1b50, 0x1b51, 0x1b52, 0x1b53, 0x1b54, 0x1b55, 0x1b56, 0x1b57,
  0x1b58, 0x1b59, 0x1b5a, 0x1b5b, 0x1b5c, 0x1b5d, 0x1b5e, 0x1b5f,
  0x1b60, 0x1b61, 0x1b62, 0x1b63, 0x1b64, 0x1b65, 0x1b66, 0x1b67,
  0x1b68, 0x1b69, 0x1b6a, 0x1b6b, 0x1b6c, 0x1b6d, 0x1b6e, 0x1b6f,
  0x1b70, 0x1b71, 0x1b72, 0x1b73, 0x1b74, 0x1b75, 0x1b76, 0x1b77,
  0x1b78, 0x1b79, 0x1b7a, 0x1b7b, 0x1b7c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1d00, 0x1d01, 0x1d02, 0x1d03, 0x1d04, 0x1d05, 0x1d06, 0x1d07,
  0x1d08, 0x1d09, 0x1d0a, 0x1d0b, 0x1d0c, 0x1d0d, 0x1d0e, 0x1d0f,
  0x1d10, 0x1d11, 0x1d12, 0x1d13, 0x1d14, 0x1d15, 0x1d16, 0x1d17,
  0x1d18, 0x1d19, 0x1d1a, 0x1d1b, 0x1d1c, 0x1d1d, 0x1d1e, 0x1d1f,
  0x1d20, 0x1d21, 0x1d22, 0x1d23, 0x1d24, 0x1d25, 0x1d26, 0x1d27,
  0x1d28, 0x1d29, 0x1d2a, 0x1d2b, 0x1d2c, 0x1d2d, 0x1d2e, 0x1d2f,
  0x1d30, 0x1d31, 0x1d32, 0x1d33, 0x1d34, 0x1d35, 0x1d36, 0x1d37,
  0x1d38, 0x1d39, 0x1d3a, 0x1d3b, 0x1d3c, 0x1d3d, 0x1d3e, 0x1d3f,
  0x1d40, 0x1d41, 0x1d42, 0x1d43, 0x1d44, 0x1d45, 0x1d46, 0x1d47,
  0x1d48, 0x1d49, 0x1d4a, 0x1d4b, 0x1d4c, 0x1d4d, 0x1d4e, 0x1d4f,
  0x1d50, 0x1d51, 0x1d52, 0x1d53, 0x1d54, 0x1d55, 0x1d56, 0x1d57,
  0x1d58, 0x1d59, 0x1d5a, 0x1d5b, 0x1d5c, 0x1d5d, 0x1d5e, 0x1d5f,
  0x1d60, 0x1d61, 0x1d62, 0x1d63, 0x1d64, 0x1d65, 0x1d66, 0x1d67,
  0x1d68, 0x1d69, 0x1d6a, 0x1d6b, 0x1d6c, 0x1d6d, 0x1d6e, 0x1d6f,
  0x1d70, 0x1d71, 0x1d72, 0x1d73, 0x1d74, 0x1d75, 0x1d76, 0x1d77,
  0x1d78, 0x1d79, 0x1d7a, 0x1d7b, 0x1d7c, 0x1d7d, 0x1d7e, 0x1d7f,
  0x1d80, 0x1d81, 0x1d82, 0x1d83, 0x1d84, 0x1d85, 0x1d86, 0x1d87,
  0x1d88, 0x1d89, 0x1d8a, 0x1d8b, 0x1d8c, 0x1d8d, 0x1d8e, 0x1d8f,
  0x1d90, 0x1d91, 0x1d92, 0x1d93, 0x1d94, 0x1d95, 0x1d96, 0x1d97,
  0x1d98, 0x1d99, 0x1d9a, 0x1d9b, 0x1d9c, 0x1d9d, 0x1d9e, 0x1d9f,
  0x1da0, 0x1da1, 0x1da2, 0x1da3, 0x1da4, 0x1da5, 0x1da6, 0x1da7,
  0x1da8, 0x1da9, 0x1daa, 0x1dab, 0x1dac, 0x1dad, 0x1dae, 0x1daf,
  0x1db0, 0x1db1, 0x1db2, 0x1db3, 0x1db4, 0x1db5, 0x1db6, 0x1db7,
  0x1db8, 0x1db9, 0x1dba, 0x1dbb, 0x1dbc, 0x1dbd, 0x1dbe, 0x1dbf,
  0x1dc0, 0x1dc1, 0x1dc2, 0x1dc3, 0x1dc4, 0x1dc5, 0x1dc6, 0x1dc7,
  0x1dc8, 0x1dc9, 0x1dca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1dfe, 0x1dff,
  0x1e01, 0x1e01, 0x1e03, 0x1e03, 0x1e05, 0x1e05, 0x1e07, 0x1e07,
  0x1e09, 0x1e09, 0x1e0b, 0x1e0b, 0x1e0d, 0x1e0d, 0x1e0f, 0x1e0f,
  0x1e11, 0x1e11, 0x1e13, 0x1e13, 0x1e15, 0x1e15, 0x1e17, 0x1e17,
  0x1e19, 0x1e19, 0x1e1b, 0x1e1b, 0x1e1d, 0x1e1d, 0x1e1f, 0x1e1f,
  0x1e21, 0x1e21, 0x1e23, 0x1e23, 0x1e25, 0x1e25, 0x1e27, 0x1e27,
  0x1e29, 0x1e29, 0x1e2b, 0x1e2b, 0x1e2d, 0x1e2d, 0x1e2f, 0x1e2f,
  0x1e31, 0x1e31, 0x1e33, 0x1e33, 0x1e35, 0x1e35, 0x1e37, 0x1e37,
  0x1e39, 0x1e39, 0x1e3b, 0x1e3b, 0x1e3d, 0x1e3d, 0x1e3f, 0x1e3f,
  0x1e41, 0x1e41, 0x1e43, 0x1e43, 0x1e45, 0x1e45, 0x1e47, 0x1e47,
  0x1e49, 0x1e49, 0x1e4b, 0x1e4b, 0x1e4d, 0x1e4d, 0x1e4f, 0x1e4f,
  0x1e51, 0x1e51, 0x1e53, 0x1e53, 0x1e55, 0x1e55, 0x1e57, 0x1e57,
  0x1e59, 0x1e59, 0x1e5b, 0x1e5b, 0x1e5d, 0x1e5d, 0x1e5f, 0x1e5f,
  0x1e61, 0x1e61, 0x1e63, 0x1e63, 0x1e65, 0x1e65, 0x1e67, 0x1e67,
  0x1e69, 0x1e69, 0x1e6b, 0x1e6b, 0x1e6d, 0x1e6d, 0x1e6f, 0x1e6f,
  0x1e71, 0x1e71, 0x1e73, 0x1e73, 0x1e75, 0x1e75, 0x1e77, 0x1e77,
  0x1e79, 0x1e79, 0x1e7b, 0x1e7b, 0x1e7d, 0x1e7d, 0x1e7f, 0x1e7f,
  0x1e81, 0x1e81, 0x1e83, 0x1e83, 0x1e85, 0x1e85, 0x1e87, 0x1e87,
  0x1e89, 0x1e89, 0x1e8b, 0x1e8b, 0x1e8d, 0x1e8d, 0x1e8f, 0x1e8f,
  0x1e91, 0x1e91, 0x1e93, 0x1e93, 0x1e95, 0x1e95, 0x1e96, 0x1e97,
  0x1e98, 0x1e99, 0x1e9a, 0x1e9b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1ea1, 0x1ea1, 0x1ea3, 0x1ea3, 0x1ea5, 0x1ea5, 0x1ea7, 0x1ea7,
  0x1ea9, 0x1ea9, 0x1eab, 0x1eab, 0x1ead, 0x1ead, 0x1eaf, 0x1eaf,
  0x1eb1, 0x1eb1, 0x1eb3, 0x1eb3, 0x1eb5, 0x1eb5, 0x1eb7, 0x1eb7,
  0x1eb9, 0x1eb9, 0x1ebb, 0x1ebb, 0x1ebd, 0x1ebd, 0x1ebf, 0x1ebf,
  0x1ec1, 0x1ec1, 0x1ec3, 0x1ec3, 0x1ec5, 0x1ec5, 0x1ec7, 0x1ec7,
  0x1ec9, 0x1ec9, 0x1ecb, 0x1ecb, 0x1ecd, 0x1ecd, 0x1ecf, 0x1ecf,
  0x1ed1, 0x1ed1, 0x1ed3, 0x1ed3, 0x1ed5, 0x1ed5, 0x1ed7, 0x1ed7,
  0x1ed9, 0x1ed9, 0x1edb, 0x1edb, 0x1edd, 0x1edd, 0x1edf, 0x1edf,
  0x1ee1, 0x1ee1, 0x1ee3, 0x1ee3, 0x1ee5, 0x1ee5, 0x1ee7, 0x1ee7,
  0x1ee9, 0x1ee9, 0x1eeb, 0x1eeb, 0x1eed, 0x1eed, 0x1eef, 0x1eef,
  0x1ef1, 0x1ef1, 0x1ef3, 0x1ef3, 0x1ef5, 0x1ef5, 0x1ef7, 0x1ef7,
  0x1ef9, 0x1ef9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
  0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
  0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0x0000, 0x0000,
  0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0x0000, 0x0000,
  0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
  0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
  0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
  0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
  0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0x0000, 0x0000,
  0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0x0000, 0x0000,
  0x1f50, 0x1f51, 0x1f52, 0x1f53, 0x1f54, 0x1f55, 0x1f56, 0x1f57,
  0x0000, 0x1f51, 0x0000, 0x1f53, 0x0000, 0x1f55, 0x0000, 0x1f57,
  0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
  0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
  0x1f70, 0x1f71, 0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1f76, 0x1f77,
  0x1f78, 0x1f79, 0x1f7a, 0x1f7b, 0x1f7c, 0x1f7d, 0x0000, 0x0000,
  0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
  0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
  0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
  0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
  0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
  0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
  0x1fb0, 0x1fb1, 0x1fb2, 0x1fb3, 0x1fb4, 0x0000, 0x1fb6, 0x1fb7,
  0x1fb0, 0x1fb1, 0x1f70, 0x1f71, 0x1fb3, 0x1fbd, 0x1fbe, 0x1fbf,
  0x1fc0, 0x1fc1, 0x1fc2, 0x1fc3, 0x1fc4, 0x0000, 0x1fc6, 0x1fc7,
  0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1fc3, 0x1fcd, 0x1fce, 0x1fcf,
  0x1fd0, 0x1fd1, 0x1fd2, 0x1fd3, 0x0000, 0x0000, 0x1fd6, 0x1fd7,
  0x1fd0, 0x1fd1, 0x1f76, 0x1f77, 0x0000, 0x1fdd, 0x1fde, 0x1fdf,
  0x1fe0, 0x1fe1, 0x1fe2, 0x1fe3, 0x1fe4, 0x1fe5, 0x1fe6, 0x1fe7,
  0x1fe0, 0x1fe1, 0x1f7a, 0x1f7b, 0x1fe5, 0x1fed, 0x1fee, 0x1fef,
  0x0000, 0x0000, 0x1ff2, 0x1ff3, 0x1ff4, 0x0000, 0x1ff6, 0x1ff7,
  0x1f78, 0x1f79, 0x1f7c, 0x1f7d, 0x1ff3, 0x1ffd, 0x1ffe, 0x0000,
  0x2000, 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007,
  0x2008, 0x2009, 0x200a, 0x200b, 0x200c, 0x200d, 0x200e, 0x200f,
  0x2010, 0x2011, 0x2012, 0x2013, 0x2014, 0x2015, 0x2016, 0x2017,
  0x2018, 0x2019, 0x201a, 0x201b, 0x201c, 0x201d, 0x201e, 0x201f,
  0x2020, 0x2021, 0x2022, 0x2023, 0x2024, 0x2025, 0x2026, 0x2027,
  0x2028, 0x2029, 0x202a, 0x202b, 0x202c, 0x202d, 0x202e, 0x202f,
  0x2030, 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037,
  0x2038, 0x2039, 0x203a, 0x203b, 0x203c, 0x203d, 0x203e, 0x203f,
  0x2040, 0x2041, 0x2042, 0x2043, 0x2044, 0x2045, 0x2046, 0x2047,
  0x2048, 0x2049, 0x204a, 0x204b, 0x204c, 0x204d, 0x204e, 0x204f,
  0x2050, 0x2051, 0x2052, 0x2053, 0x2054, 0x2055, 0x2056, 0x2057,
  0x2058, 0x2059, 0x205a, 0x205b, 0x205c, 0x205d, 0x205e, 0x205f,
  0x2060, 0x2061, 0x2062, 0x2063, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x206a, 0x206b, 0x206c, 0x206d, 0x206e, 0x206f,
  0x2070, 0x2071, 0x0000, 0x0000, 0x2074, 0x2075, 0x2076, 0x2077,
  0x2078, 0x2079, 0x207a, 0x207b, 0x207c, 0x207d, 0x207e, 0x207f,
  0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
  0x2088, 0x2089, 0x208a, 0x208b, 0x208c, 0x208d, 0x208e, 0x0000,
  0x2090, 0x2091, 0x2092, 0x2093, 0x2094, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x20a0, 0x20a1, 0x20a2, 0x20a3, 0x20a4, 0x20a5, 0x20a6, 0x20a7,
  0x20a8, 0x20a9, 0x20aa, 0x20ab, 0x20ac, 0x20ad, 0x20ae, 0x20af,
  0x20b0, 0x20b1, 0x20b2, 0x20b3, 0x20b4, 0x20b5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x20d0, 0x20d1, 0x20d2, 0x20d3, 0x20d4, 0x20d5, 0x20d6, 0x20d7,
  0x20d8, 0x20d9, 0x20da, 0x20db, 0x20dc, 0x20dd, 0x20de, 0x20df,
  0x20e0, 0x20e1, 0x20e2, 0x20e3, 0x20e4, 0x20e5, 0x20e6, 0x20e7,
  0x20e8, 0x20e9, 0x20ea, 0x20eb, 0x20ec, 0x20ed, 0x20ee, 0x20ef,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2100, 0x2101, 0x2102, 0x2103, 0x2104, 0x2105, 0x2106, 0x2107,
  0x2108, 0x2109, 0x210a, 0x210b, 0x210c, 0x210d, 0x210e, 0x210f,
  0x2110, 0x2111, 0x2112, 0x2113, 0x2114, 0x2115, 0x2116, 0x2117,
  0x2118, 0x2119, 0x211a, 0x211b, 0x211c, 0x211d, 0x211e, 0x211f,
  0x2120, 0x2121, 0x2122, 0x2123, 0x2124, 0x2125, 0x03c9, 0x2127,
  0x2128, 0x2129, 0x006b, 0x00e5, 0x212c, 0x212d, 0x212e, 0x212f,
  0x2130, 0x2131, 0x214e, 0x2133, 0x2134, 0x2135, 0x2136, 0x2137,
  0x2138, 0x2139, 0x213a, 0x213b, 0x213c, 0x213d, 0x213e, 0x213f,
  0x2140, 0x2141, 0x2142, 0x2143, 0x2144, 0x2145, 0x2146, 0x2147,
  0x2148, 0x2149, 0x214a, 0x214b, 0x214c, 0x214d, 0x214e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2153, 0x2154, 0x2155, 0x2156, 0x2157,
  0x2158, 0x2159, 0x215a, 0x215b, 0x215c, 0x215d, 0x215e, 0x215f,
  0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
  0x2178, 0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 0x217e, 0x217f,
  0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
  0x2178, 0x2179, 0x217a, 0x217b, 0x217c, 0x217d, 0x217e, 0x217f,
  0x2180, 0x2181, 0x2182, 0x2184, 0x2184, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2190, 0x2191, 0x2192, 0x2193, 0x2194, 0x2195, 0x2196, 0x2197,
  0x2198, 0x2199, 0x219a, 0x219b, 0x219c, 0x219d, 0x219e, 0x219f,
  0x21a0, 0x21a1, 0x21a2, 0x21a3, 0x21a4, 0x21a5, 0x21a6, 0x21a7,
  0x21a8, 0x21a9, 0x21aa, 0x21ab, 0x21ac, 0x21ad, 0x21ae, 0x21af,
  0x21b0, 0x21b1, 0x21b2, 0x21b3, 0x21b4, 0x21b5, 0x21b6, 0x21b7,
  0x21b8, 0x21b9, 0x21ba, 0x21bb, 0x21bc, 0x21bd, 0x21be, 0x21bf,
  0x21c0, 0x21c1, 0x21c2, 0x21c3, 0x21c4, 0x21c5, 0x21c6, 0x21c7,
  0x21c8, 0x21c9, 0x21ca, 0x21cb, 0x21cc, 0x21cd, 0x21ce, 0x21cf,
  0x21d0, 0x21d1, 0x21d2, 0x21d3, 0x21d4, 0x21d5, 0x21d6, 0x21d7,
  0x21d8, 0x21d9, 0x21da, 0x21db, 0x21dc, 0x21dd, 0x21de, 0x21df,
  0x21e0, 0x21e1, 0x21e2, 0x21e3, 0x21e4, 0x21e5, 0x21e6, 0x21e7,
  0x21e8, 0x21e9, 0x21ea, 0x21eb, 0x21ec, 0x21ed, 0x21ee, 0x21ef,
  0x21f0, 0x21f1, 0x21f2, 0x21f3, 0x21f4, 0x21f5, 0x21f6, 0x21f7,
  0x21f8, 0x21f9, 0x21fa, 0x21fb, 0x21fc, 0x21fd, 0x21fe, 0x21ff,
  0x2200, 0x2201, 0x2202, 0x2203, 0x2204, 0x2205, 0x2206, 0x2207,
  0x2208, 0x2209, 0x220a, 0x220b, 0x220c, 0x220d, 0x220e, 0x220f,
  0x2210, 0x2211, 0x2212, 0x2213, 0x2214, 0x2215, 0x2216, 0x2217,
  0x2218, 0x2219, 0x221a, 0x221b, 0x221c, 0x221d, 0x221e, 0x221f,
  0x2220, 0x2221, 0x2222, 0x2223, 0x2224, 0x2225, 0x2226, 0x2227,
  0x2228, 0x2229, 0x222a, 0x222b, 0x222c, 0x222d, 0x222e, 0x222f,
  0x2230, 0x2231, 0x2232, 0x2233, 0x2234, 0x2235, 0x2236, 0x2237,
  0x2238, 0x2239, 0x223a, 0x223b, 0x223c, 0x223d, 0x223e, 0x223f,
  0x2240, 0x2241, 0x2242, 0x2243, 0x2244, 0x2245, 0x2246, 0x2247,
  0x2248, 0x2249, 0x224a, 0x224b, 0x224c, 0x224d, 0x224e, 0x224f,
  0x2250, 0x2251, 0x2252, 0x2253, 0x2254, 0x2255, 0x2256, 0x2257,
  0x2258, 0x2259, 0x225a, 0x225b, 0x225c, 0x225d, 0x225e, 0x225f,
  0x2260, 0x2261, 0x2262, 0x2263, 0x2264, 0x2265, 0x2266, 0x2267,
  0x2268, 0x2269, 0x226a, 0x226b, 0x226c, 0x226d, 0x226e, 0x226f,
  0x2270, 0x2271, 0x2272, 0x2273, 0x2274, 0x2275, 0x2276, 0x2277,
  0x2278, 0x2279, 0x227a, 0x227b, 0x227c, 0x227d, 0x227e, 0x227f,
  0x2280, 0x2281, 0x2282, 0x2283, 0x2284, 0x2285, 0x2286, 0x2287,
  0x2288, 0x2289, 0x228a, 0x228b, 0x228c, 0x228d, 0x228e, 0x228f,
  0x2290, 0x2291, 0x2292, 0x2293, 0x2294, 0x2295, 0x2296, 0x2297,
  0x2298, 0x2299, 0x229a, 0x229b, 0x229c, 0x229d, 0x229e, 0x229f,
  0x22a0, 0x22a1, 0x22a2, 0x22a3, 0x22a4, 0x22a5, 0x22a6, 0x22a7,
  0x22a8, 0x22a9, 0x22aa, 0x22ab, 0x22ac, 0x22ad, 0x22ae, 0x22af,
  0x22b0, 0x22b1, 0x22b2, 0x22b3, 0x22b4, 0x22b5, 0x22b6, 0x22b7,
  0x22b8, 0x22b9, 0x22ba, 0x22bb, 0x22bc, 0x22bd, 0x22be, 0x22bf,
  0x22c0, 0x22c1, 0x22c2, 0x22c3, 0x22c4, 0x22c5, 0x22c6, 0x22c7,
  0x22c8, 0x22c9, 0x22ca, 0x22cb, 0x22cc, 0x22cd, 0x22ce, 0x22cf,
  0x22d0, 0x22d1, 0x22d2, 0x22d3, 0x22d4, 0x22d5, 0x22d6, 0x22d7,
  0x22d8, 0x22d9, 0x22da, 0x22db, 0x22dc, 0x22dd, 0x22de, 0x22df,
  0x22e0, 0x22e1, 0x22e2, 0x22e3, 0x22e4, 0x22e5, 0x22e6, 0x22e7,
  0x22e8, 0x22e9, 0x22ea, 0x22eb, 0x22ec, 0x22ed, 0x22ee, 0x22ef,
  0x22f0, 0x22f1, 0x22f2, 0x22f3, 0x22f4, 0x22f5, 0x22f6, 0x22f7,
  0x22f8, 0x22f9, 0x22fa, 0x22fb, 0x22fc, 0x22fd, 0x22fe, 0x22ff,
  0x2300, 0x2301, 0x2302, 0x2303, 0x2304, 0x2305, 0x2306, 0x2307,
  0x2308, 0x2309, 0x230a, 0x230b, 0x230c, 0x230d, 0x230e, 0x230f,
  0x2310, 0x2311, 0x2312, 0x2313, 0x2314, 0x2315, 0x2316, 0x2317,
  0x2318, 0x2319, 0x231a, 0x231b, 0x231c, 0x231d, 0x231e, 0x231f,
  0x2320, 0x2321, 0x2322, 0x2323, 0x2324, 0x2325, 0x2326, 0x2327,
  0x2328, 0x2329, 0x232a, 0x232b, 0x232c, 0x232d, 0x232e, 0x232f,
  0x2330, 0x2331, 0x2332, 0x2333, 0x2334, 0x2335, 0x2336, 0x2337,
  0x2338, 0x2339, 0x233a, 0x233b, 0x233c, 0x233d, 0x233e, 0x233f,
  0x2340, 0x2341, 0x2342, 0x2343, 0x2344, 0x2345, 0x2346, 0x2347,
  0x2348, 0x2349, 0x234a, 0x234b, 0x234c, 0x234d, 0x234e, 0x234f,
  0x2350, 0x2351, 0x2352, 0x2353, 0x2354, 0x2355, 0x2356, 0x2357,
  0x2358, 0x2359, 0x235a, 0x235b, 0x235c, 0x235d, 0x235e, 0x235f,
  0x2360, 0x2361, 0x2362, 0x2363, 0x2364, 0x2365, 0x2366, 0x2367,
  0x2368, 0x2369, 0x236a, 0x236b, 0x236c, 0x236d, 0x236e, 0x236f,
  0x2370, 0x2371, 0x2372, 0x2373, 0x2374, 0x2375, 0x2376, 0x2377,
  0x2378, 0x2379, 0x237a, 0x237b, 0x237c, 0x237d, 0x237e, 0x237f,
  0x2380, 0x2381, 0x2382, 0x2383, 0x2384, 0x2385, 0x2386, 0x2387,
  0x2388, 0x2389, 0x238a, 0x238b, 0x238c, 0x238d, 0x238e, 0x238f,
  0x2390, 0x2391, 0x2392, 0x2393, 0x2394, 0x2395, 0x2396, 0x2397,
  0x2398, 0x2399, 0x239a, 0x239b, 0x239c, 0x239d, 0x239e, 0x239f,
  0x23a0, 0x23a1, 0x23a2, 0x23a3, 0x23a4, 0x23a5, 0x23a6, 0x23a7,
  0x23a8, 0x23a9, 0x23aa, 0x23ab, 0x23ac, 0x23ad, 0x23ae, 0x23af,
  0x23b0, 0x23b1, 0x23b2, 0x23b3, 0x23b4, 0x23b5, 0x23b6, 0x23b7,
  0x23b8, 0x23b9, 0x23ba, 0x23bb, 0x23bc, 0x23bd, 0x23be, 0x23bf,
  0x23c0, 0x23c1, 0x23c2, 0x23c3, 0x23c4, 0x23c5, 0x23c6, 0x23c7,
  0x23c8, 0x23c9, 0x23ca, 0x23cb, 0x23cc, 0x23cd, 0x23ce, 0x23cf,
  0x23d0, 0x23d1, 0x23d2, 0x23d3, 0x23d4, 0x23d5, 0x23d6, 0x23d7,
  0x23d8, 0x23d9, 0x23da, 0x23db, 0x23dc, 0x23dd, 0x23de, 0x23df,
  0x23e0, 0x23e1, 0x23e2, 0x23e3, 0x23e4, 0x23e5, 0x23e6, 0x23e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2400, 0x2401, 0x2402, 0x2403, 0x2404, 0x2405, 0x2406, 0x2407,
  0x2408, 0x2409, 0x240a, 0x240b, 0x240c, 0x240d, 0x240e, 0x240f,
  0x2410, 0x2411, 0x2412, 0x2413, 0x2414, 0x2415, 0x2416, 0x2417,
  0x2418, 0x2419, 0x241a, 0x241b, 0x241c, 0x241d, 0x241e, 0x241f,
  0x2420, 0x2421, 0x2422, 0x2423, 0x2424, 0x2425, 0x2426, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2440, 0x2441, 0x2442, 0x2443, 0x2444, 0x2445, 0x2446, 0x2447,
  0x2448, 0x2449, 0x244a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
  0x2468, 0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x246f,
  0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x2475, 0x2476, 0x2477,
  0x2478, 0x2479, 0x247a, 0x247b, 0x247c, 0x247d, 0x247e, 0x247f,
  0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2487,
  0x2488, 0x2489, 0x248a, 0x248b, 0x248c, 0x248d, 0x248e, 0x248f,
  0x2490, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497,
  0x2498, 0x2499, 0x249a, 0x249b, 0x249c, 0x249d, 0x249e, 0x249f,
  0x24a0, 0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 0x24a6, 0x24a7,
  0x24a8, 0x24a9, 0x24aa, 0x24ab, 0x24ac, 0x24ad, 0x24ae, 0x24af,
  0x24b0, 0x24b1, 0x24b2, 0x24b3, 0x24b4, 0x24b5, 0x24d0, 0x24d1,
  0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9,
  0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1,
  0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9,
  0x24d0, 0x24d1, 0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7,
  0x24d8, 0x24d9, 0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df,
  0x24e0, 0x24e1, 0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7,
  0x24e8, 0x24e9, 0x24ea, 0x24eb, 0x24ec, 0x24ed, 0x24ee, 0x24ef,
  0x24f0, 0x24f1, 0x24f2, 0x24f3, 0x24f4, 0x24f5, 0x24f6, 0x24f7,
  0x24f8, 0x24f9, 0x24fa, 0x24fb, 0x24fc, 0x24fd, 0x24fe, 0x24ff,
  0x2500, 0x2501, 0x2502, 0x2503, 0x2504, 0x2505, 0x2506, 0x2507,
  0x2508, 0x2509, 0x250a, 0x250b, 0x250c, 0x250d, 0x250e, 0x250f,
  0x2510, 0x2511, 0x2512, 0x2513, 0x2514, 0x2515, 0x2516, 0x2517,
  0x2518, 0x2519, 0x251a, 0x251b, 0x251c, 0x251d, 0x251e, 0x251f,
  0x2520, 0x2521, 0x2522, 0x2523, 0x2524, 0x2525, 0x2526, 0x2527,
  0x2528, 0x2529, 0x252a, 0x252b, 0x252c, 0x252d, 0x252e, 0x252f,
  0x2530, 0x2531, 0x2532, 0x2533, 0x2534, 0x2535, 0x2536, 0x2537,
  0x2538, 0x2539, 0x253a, 0x253b, 0x253c, 0x253d, 0x253e, 0x253f,
  0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 0x2545, 0x2546, 0x2547,
  0x2548, 0x2549, 0x254a, 0x254b, 0x254c, 0x254d, 0x254e, 0x254f,
  0x2550, 0x2551, 0x2552, 0x2553, 0x2554, 0x2555, 0x2556, 0x2557,
  0x2558, 0x2559, 0x255a, 0x255b, 0x255c, 0x255d, 0x255e, 0x255f,
  0x2560, 0x2561, 0x2562, 0x2563, 0x2564, 0x2565, 0x2566, 0x2567,
  0x2568, 0x2569, 0x256a, 0x256b, 0x256c, 0x256d, 0x256e, 0x256f,
  0x2570, 0x2571, 0x2572, 0x2573, 0x2574, 0x2575, 0x2576, 0x2577,
  0x2578, 0x2579, 0x257a, 0x257b, 0x257c, 0x257d, 0x257e, 0x257f,
  0x2580, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 0x2587,
  0x2588, 0x2589, 0x258a, 0x258b, 0x258c, 0x258d, 0x258e, 0x258f,
  0x2590, 0x2591, 0x2592, 0x2593, 0x2594, 0x2595, 0x2596, 0x2597,
  0x2598, 0x2599, 0x259a, 0x259b, 0x259c, 0x259d, 0x259e, 0x259f,
  0x25a0, 0x25a1, 0x25a2, 0x25a3, 0x25a4, 0x25a5, 0x25a6, 0x25a7,
  0x25a8, 0x25a9, 0x25aa, 0x25ab, 0x25ac, 0x25ad, 0x25ae, 0x25af,
  0x25b0, 0x25b1, 0x25b2, 0x25b3, 0x25b4, 0x25b5, 0x25b6, 0x25b7,
  0x25b8, 0x25b9, 0x25ba, 0x25bb, 0x25bc, 0x25bd, 0x25be, 0x25bf,
  0x25c0, 0x25c1, 0x25c2, 0x25c3, 0x25c4, 0x25c5, 0x25c6, 0x25c7,
  0x25c8, 0x25c9, 0x25ca, 0x25cb, 0x25cc, 0x25cd, 0x25ce, 0x25cf,
  0x25d0, 0x25d1, 0x25d2, 0x25d3, 0x25d4, 0x25d5, 0x25d6, 0x25d7,
  0x25d8, 0x25d9, 0x25da, 0x25db, 0x25dc, 0x25dd, 0x25de, 0x25df,
  0x25e0, 0x25e1, 0x25e2, 0x25e3, 0x25e4, 0x25e5, 0x25e6, 0x25e7,
  0x25e8, 0x25e9, 0x25ea, 0x25eb, 0x25ec, 0x25ed, 0x25ee, 0x25ef,
  0x25f0, 0x25f1, 0x25f2, 0x25f3, 0x25f4, 0x25f5, 0x25f6, 0x25f7,
  0x25f8, 0x25f9, 0x25fa, 0x25fb, 0x25fc, 0x25fd, 0x25fe, 0x25ff,
  0x2600, 0x2601, 0x2602, 0x2603, 0x2604, 0x2605, 0x2606, 0x2607,
  0x2608, 0x2609, 0x260a, 0x260b, 0x260c, 0x260d, 0x260e, 0x260f,
  0x2610, 0x2611, 0x2612, 0x2613, 0x2614, 0x2615, 0x2616, 0x2617,
  0x2618, 0x2619, 0x261a, 0x261b, 0x261c, 0x261d, 0x261e, 0x261f,
  0x2620, 0x2621, 0x2622, 0x2623, 0x2624, 0x2625, 0x2626, 0x2627,
  0x2628, 0x2629, 0x262a, 0x262b, 0x262c, 0x262d, 0x262e, 0x262f,
  0x2630, 0x2631, 0x2632, 0x2633, 0x2634, 0x2635, 0x2636, 0x2637,
  0x2638, 0x2639, 0x263a, 0x263b, 0x263c, 0x263d, 0x263e, 0x263f,
  0x2640, 0x2641, 0x2642, 0x2643, 0x2644, 0x2645, 0x2646, 0x2647,
  0x2648, 0x2649, 0x264a, 0x264b, 0x264c, 0x264d, 0x264e, 0x264f,
  0x2650, 0x2651, 0x2652, 0x2653, 0x2654, 0x2655, 0x2656, 0x2657,
  0x2658, 0x2659, 0x265a, 0x265b, 0x265c, 0x265d, 0x265e, 0x265f,
  0x2660, 0x2661, 0x2662, 0x2663, 0x2664, 0x2665, 0x2666, 0x2667,
  0x2668, 0x2669, 0x266a, 0x266b, 0x266c, 0x266d, 0x266e, 0x266f,
  0x2670, 0x2671, 0x2672, 0x2673, 0x2674, 0x2675, 0x2676, 0x2677,
  0x2678, 0x2679, 0x267a, 0x267b, 0x267c, 0x267d, 0x267e, 0x267f,
  0x2680, 0x2681, 0x2682, 0x2683, 0x2684, 0x2685, 0x2686, 0x2687,
  0x2688, 0x2689, 0x268a, 0x268b, 0x268c, 0x268d, 0x268e, 0x268f,
  0x2690, 0x2691, 0x2692, 0x2693, 0x2694, 0x2695, 0x2696, 0x2697,
  0x2698, 0x2699, 0x269a, 0x269b, 0x269c, 0x0000, 0x0000, 0x0000,
  0x26a0, 0x26a1, 0x26a2, 0x26a3, 0x26a4, 0x26a5, 0x26a6, 0x26a7,
  0x26a8, 0x26a9, 0x26aa, 0x26ab, 0x26ac, 0x26ad, 0x26ae, 0x26af,
  0x26b0, 0x26b1, 0x26b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2701, 0x2702, 0x2703, 0x2704, 0x0000, 0x2706, 0x2707,
  0x2708, 0x2709, 0x0000, 0x0000, 0x270c, 0x270d, 0x270e, 0x270f,
  0x2710, 0x2711, 0x2712, 0x2713, 0x2714, 0x2715, 0x2716, 0x2717,
  0x2718, 0x2719, 0x271a, 0x271b, 0x271c, 0x271d, 0x271e, 0x271f,
  0x2720, 0x2721, 0x2722, 0x2723, 0x2724, 0x2725, 0x2726, 0x2727,
  0x0000, 0x2729, 0x272a, 0x272b, 0x272c, 0x272d, 0x272e, 0x272f,
  0x2730, 0x2731, 0x2732, 0x2733, 0x2734, 0x2735, 0x2736, 0x2737,
  0x2738, 0x2739, 0x273a, 0x273b, 0x273c, 0x273d, 0x273e, 0x273f,
  0x2740, 0x2741, 0x2742, 0x2743, 0x2744, 0x2745, 0x2746, 0x2747,
  0x2748, 0x2749, 0x274a, 0x274b, 0x0000, 0x274d, 0x0000, 0x274f,
  0x2750, 0x2751, 0x2752, 0x0000, 0x0000, 0x0000, 0x2756, 0x0000,
  0x2758, 0x2759, 0x275a, 0x275b, 0x275c, 0x275d, 0x275e, 0x0000,
  0x0000, 0x2761, 0x2762, 0x2763, 0x2764, 0x2765, 0x2766, 0x2767,
  0x2768, 0x2769, 0x276a, 0x276b, 0x276c, 0x276d, 0x276e, 0x276f,
  0x2770, 0x2771, 0x2772, 0x2773, 0x2774, 0x2775, 0x2776, 0x2777,
  0x2778, 0x2779, 0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 0x277f,
  0x2780, 0x2781, 0x2782, 0x2783, 0x2784, 0x2785, 0x2786, 0x2787,
  0x2788, 0x2789, 0x278a, 0x278b, 0x278c, 0x278d, 0x278e, 0x278f,
  0x2790, 0x2791, 0x2792, 0x2793, 0x2794, 0x0000, 0x0000, 0x0000,
  0x2798, 0x2799, 0x279a, 0x279b, 0x279c, 0x279d, 0x279e, 0x279f,
  0x27a0, 0x27a1, 0x27a2, 0x27a3, 0x27a4, 0x27a5, 0x27a6, 0x27a7,
  0x27a8, 0x27a9, 0x27aa, 0x27ab, 0x27ac, 0x27ad, 0x27ae, 0x27af,
  0x0000, 0x27b1, 0x27b2, 0x27b3, 0x27b4, 0x27b5, 0x27b6, 0x27b7,
  0x27b8, 0x27b9, 0x27ba, 0x27bb, 0x27bc, 0x27bd, 0x27be, 0x0000,
  0x27c0, 0x27c1, 0x27c2, 0x27c3, 0x27c4, 0x27c5, 0x27c6, 0x27c7,
  0x27c8, 0x27c9, 0x27ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x27d0, 0x27d1, 0x27d2, 0x27d3, 0x27d4, 0x27d5, 0x27d6, 0x27d7,
  0x27d8, 0x27d9, 0x27da, 0x27db, 0x27dc, 0x27dd, 0x27de, 0x27df,
  0x27e0, 0x27e1, 0x27e2, 0x27e3, 0x27e4, 0x27e5, 0x27e6, 0x27e7,
  0x27e8, 0x27e9, 0x27ea, 0x27eb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x27f0, 0x27f1, 0x27f2, 0x27f3, 0x27f4, 0x27f5, 0x27f6, 0x27f7,
  0x27f8, 0x27f9, 0x27fa, 0x27fb, 0x27fc, 0x27fd, 0x27fe, 0x27ff,
  0x2800, 0x2801, 0x2802, 0x2803, 0x2804, 0x2805, 0x2806, 0x2807,
  0x2808, 0x2809, 0x280a, 0x280b, 0x280c, 0x280d, 0x280e, 0x280f,
  0x2810, 0x2811, 0x2812, 0x2813, 0x2814, 0x2815, 0x2816, 0x2817,
  0x2818, 0x2819, 0x281a, 0x281b, 0x281c, 0x281d, 0x281e, 0x281f,
  0x2820, 0x2821, 0x2822, 0x2823, 0x2824, 0x2825, 0x2826, 0x2827,
  0x2828, 0x2829, 0x282a, 0x282b, 0x282c, 0x282d, 0x282e, 0x282f,
  0x2830, 0x2831, 0x2832, 0x2833, 0x2834, 0x2835, 0x2836, 0x2837,
  0x2838, 0x2839, 0x283a, 0x283b, 0x283c, 0x283d, 0x283e, 0x283f,
  0x2840, 0x2841, 0x2842, 0x2843, 0x2844, 0x2845, 0x2846, 0x2847,
  0x2848, 0x2849, 0x284a, 0x284b, 0x284c, 0x284d, 0x284e, 0x284f,
  0x2850, 0x2851, 0x2852, 0x2853, 0x2854, 0x2855, 0x2856, 0x2857,
  0x2858, 0x2859, 0x285a, 0x285b, 0x285c, 0x285d, 0x285e, 0x285f,
  0x2860, 0x2861, 0x2862, 0x2863, 0x2864, 0x2865, 0x2866, 0x2867,
  0x2868, 0x2869, 0x286a, 0x286b, 0x286c, 0x286d, 0x286e, 0x286f,
  0x2870, 0x2871, 0x2872, 0x2873, 0x2874, 0x2875, 0x2876, 0x2877,
  0x2878, 0x2879, 0x287a, 0x287b, 0x287c, 0x287d, 0x287e, 0x287f,
  0x2880, 0x2881, 0x2882, 0x2883, 0x2884, 0x2885, 0x2886, 0x2887,
  0x2888, 0x2889, 0x288a, 0x288b, 0x288c, 0x288d, 0x288e, 0x288f,
  0x2890, 0x2891, 0x2892, 0x2893, 0x2894, 0x2895, 0x2896, 0x2897,
  0x2898, 0x2899, 0x289a, 0x289b, 0x289c, 0x289d, 0x289e, 0x289f,
  0x28a0, 0x28a1, 0x28a2, 0x28a3, 0x28a4, 0x28a5, 0x28a6, 0x28a7,
  0x28a8, 0x28a9, 0x28aa, 0x28ab, 0x28ac, 0x28ad, 0x28ae, 0x28af,
  0x28b0, 0x28b1, 0x28b2, 0x28b3, 0x28b4, 0x28b5, 0x28b6, 0x28b7,
  0x28b8, 0x28b9, 0x28ba, 0x28bb, 0x28bc, 0x28bd, 0x28be, 0x28bf,
  0x28c0, 0x28c1, 0x28c2, 0x28c3, 0x28c4, 0x28c5, 0x28c6, 0x28c7,
  0x28c8, 0x28c9, 0x28ca, 0x28cb, 0x28cc, 0x28cd, 0x28ce, 0x28cf,
  0x28d0, 0x28d1, 0x28d2, 0x28d3, 0x28d4, 0x28d5, 0x28d6, 0x28d7,
  0x28d8, 0x28d9, 0x28da, 0x28db, 0x28dc, 0x28dd, 0x28de, 0x28df,
  0x28e0, 0x28e1, 0x28e2, 0x28e3, 0x28e4, 0x28e5, 0x28e6, 0x28e7,
  0x28e8, 0x28e9, 0x28ea, 0x28eb, 0x28ec, 0x28ed, 0x28ee, 0x28ef,
  0x28f0, 0x28f1, 0x28f2, 0x28f3, 0x28f4, 0x28f5, 0x28f6, 0x28f7,
  0x28f8, 0x28f9, 0x28fa, 0x28fb, 0x28fc, 0x28fd, 0x28fe, 0x28ff,
  0x2900, 0x2901, 0x2902, 0x2903, 0x2904, 0x2905, 0x2906, 0x2907,
  0x2908, 0x2909, 0x290a, 0x290b, 0x290c, 0x290d, 0x290e, 0x290f,
  0x2910, 0x2911, 0x2912, 0x2913, 0x2914, 0x2915, 0x2916, 0x2917,
  0x2918, 0x2919, 0x291a, 0x291b, 0x291c, 0x291d, 0x291e, 0x291f,
  0x2920, 0x2921, 0x2922, 0x2923, 0x2924, 0x2925, 0x2926, 0x2927,
  0x2928, 0x2929, 0x292a, 0x292b, 0x292c, 0x292d, 0x292e, 0x292f,
  0x2930, 0x2931, 0x2932, 0x2933, 0x2934, 0x2935, 0x2936, 0x2937,
  0x2938, 0x2939, 0x293a, 0x293b, 0x293c, 0x293d, 0x293e, 0x293f,
  0x2940, 0x2941, 0x2942, 0x2943, 0x2944, 0x2945, 0x2946, 0x2947,
  0x2948, 0x2949, 0x294a, 0x294b, 0x294c, 0x294d, 0x294e, 0x294f,
  0x2950, 0x2951, 0x2952, 0x2953, 0x2954, 0x2955, 0x2956, 0x2957,
  0x2958, 0x2959, 0x295a, 0x295b, 0x295c, 0x295d, 0x295e, 0x295f,
  0x2960, 0x2961, 0x2962, 0x2963, 0x2964, 0x2965, 0x2966, 0x2967,
  0x2968, 0x2969, 0x296a, 0x296b, 0x296c, 0x296d, 0x296e, 0x296f,
  0x2970, 0x2971, 0x2972, 0x2973, 0x2974, 0x2975, 0x2976, 0x2977,
  0x2978, 0x2979, 0x297a, 0x297b, 0x297c, 0x297d, 0x297e, 0x297f,
  0x2980, 0x2981, 0x2982, 0x2983, 0x2984, 0x2985, 0x2986, 0x2987,
  0x2988, 0x2989, 0x298a, 0x298b, 0x298c, 0x298d, 0x298e, 0x298f,
  0x2990, 0x2991, 0x2992, 0x2993, 0x2994, 0x2995, 0x2996, 0x2997,
  0x2998, 0x2999, 0x299a, 0x299b, 0x299c, 0x299d, 0x299e, 0x299f,
  0x29a0, 0x29a1, 0x29a2, 0x29a3, 0x29a4, 0x29a5, 0x29a6, 0x29a7,
  0x29a8, 0x29a9, 0x29aa, 0x29ab, 0x29ac, 0x29ad, 0x29ae, 0x29af,
  0x29b0, 0x29b1, 0x29b2, 0x29b3, 0x29b4, 0x29b5, 0x29b6, 0x29b7,
  0x29b8, 0x29b9, 0x29ba, 0x29bb, 0x29bc, 0x29bd, 0x29be, 0x29bf,
  0x29c0, 0x29c1, 0x29c2, 0x29c3, 0x29c4, 0x29c5, 0x29c6, 0x29c7,
  0x29c8, 0x29c9, 0x29ca, 0x29cb, 0x29cc, 0x29cd, 0x29ce, 0x29cf,
  0x29d0, 0x29d1, 0x29d2, 0x29d3, 0x29d4, 0x29d5, 0x29d6, 0x29d7,
  0x29d8, 0x29d9, 0x29da, 0x29db, 0x29dc, 0x29dd, 0x29de, 0x29df,
  0x29e0, 0x29e1, 0x29e2, 0x29e3, 0x29e4, 0x29e5, 0x29e6, 0x29e7,
  0x29e8, 0x29e9, 0x29ea, 0x29eb, 0x29ec, 0x29ed, 0x29ee, 0x29ef,
  0x29f0, 0x29f1, 0x29f2, 0x29f3, 0x29f4, 0x29f5, 0x29f6, 0x29f7,
  0x29f8, 0x29f9, 0x29fa, 0x29fb, 0x29fc, 0x29fd, 0x29fe, 0x29ff,
  0x2a00, 0x2a01, 0x2a02, 0x2a03, 0x2a04, 0x2a05, 0x2a06, 0x2a07,
  0x2a08, 0x2a09, 0x2a0a, 0x2a0b, 0x2a0c, 0x2a0d, 0x2a0e, 0x2a0f,
  0x2a10, 0x2a11, 0x2a12, 0x2a13, 0x2a14, 0x2a15, 0x2a16, 0x2a17,
  0x2a18, 0x2a19, 0x2a1a, 0x2a1b, 0x2a1c, 0x2a1d, 0x2a1e, 0x2a1f,
  0x2a20, 0x2a21, 0x2a22, 0x2a23, 0x2a24, 0x2a25, 0x2a26, 0x2a27,
  0x2a28, 0x2a29, 0x2a2a, 0x2a2b, 0x2a2c, 0x2a2d, 0x2a2e, 0x2a2f,
  0x2a30, 0x2a31, 0x2a32, 0x2a33, 0x2a34, 0x2a35, 0x2a36, 0x2a37,
  0x2a38, 0x2a39, 0x2a3a, 0x2a3b, 0x2a3c, 0x2a3d, 0x2a3e, 0x2a3f,
  0x2a40, 0x2a41, 0x2a42, 0x2a43, 0x2a44, 0x2a45, 0x2a46, 0x2a47,
  0x2a48, 0x2a49, 0x2a4a, 0x2a4b, 0x2a4c, 0x2a4d, 0x2a4e, 0x2a4f,
  0x2a50, 0x2a51, 0x2a52, 0x2a53, 0x2a54, 0x2a55, 0x2a56, 0x2a57,
  0x2a58, 0x2a59, 0x2a5a, 0x2a5b, 0x2a5c, 0x2a5d, 0x2a5e, 0x2a5f,
  0x2a60, 0x2a61, 0x2a62, 0x2a63, 0x2a64, 0x2a65, 0x2a66, 0x2a67,
  0x2a68, 0x2a69, 0x2a6a, 0x2a6b, 0x2a6c, 0x2a6d, 0x2a6e, 0x2a6f,
  0x2a70, 0x2a71, 0x2a72, 0x2a73, 0x2a74, 0x2a75, 0x2a76, 0x2a77,
  0x2a78, 0x2a79, 0x2a7a, 0x2a7b, 0x2a7c, 0x2a7d, 0x2a7e, 0x2a7f,
  0x2a80, 0x2a81, 0x2a82, 0x2a83, 0x2a84, 0x2a85, 0x2a86, 0x2a87,
  0x2a88, 0x2a89, 0x2a8a, 0x2a8b, 0x2a8c, 0x2a8d, 0x2a8e, 0x2a8f,
  0x2a90, 0x2a91, 0x2a92, 0x2a93, 0x2a94, 0x2a95, 0x2a96, 0x2a97,
  0x2a98, 0x2a99, 0x2a9a, 0x2a9b, 0x2a9c, 0x2a9d, 0x2a9e, 0x2a9f,
  0x2aa0, 0x2aa1, 0x2aa2, 0x2aa3, 0x2aa4, 0x2aa5, 0x2aa6, 0x2aa7,
  0x2aa8, 0x2aa9, 0x2aaa, 0x2aab, 0x2aac, 0x2aad, 0x2aae, 0x2aaf,
  0x2ab0, 0x2ab1, 0x2ab2, 0x2ab3, 0x2ab4, 0x2ab5, 0x2ab6, 0x2ab7,
  0x2ab8, 0x2ab9, 0x2aba, 0x2abb, 0x2abc, 0x2abd, 0x2abe, 0x2abf,
  0x2ac0, 0x2ac1, 0x2ac2, 0x2ac3, 0x2ac4, 0x2ac5, 0x2ac6, 0x2ac7,
  0x2ac8, 0x2ac9, 0x2aca, 0x2acb, 0x2acc, 0x2acd, 0x2ace, 0x2acf,
  0x2ad0, 0x2ad1, 0x2ad2, 0x2ad3, 0x2ad4, 0x2ad5, 0x2ad6, 0x2ad7,
  0x2ad8, 0x2ad9, 0x2ada, 0x2adb, 0x2adc, 0x2add, 0x2ade, 0x2adf,
  0x2ae0, 0x2ae1, 0x2ae2, 0x2ae3, 0x2ae4, 0x2ae5, 0x2ae6, 0x2ae7,
  0x2ae8, 0x2ae9, 0x2aea, 0x2aeb, 0x2aec, 0x2aed, 0x2aee, 0x2aef,
  0x2af0, 0x2af1, 0x2af2, 0x2af3, 0x2af4, 0x2af5, 0x2af6, 0x2af7,
  0x2af8, 0x2af9, 0x2afa, 0x2afb, 0x2afc, 0x2afd, 0x2afe, 0x2aff,
  0x2b00, 0x2b01, 0x2b02, 0x2b03, 0x2b04, 0x2b05, 0x2b06, 0x2b07,
  0x2b08, 0x2b09, 0x2b0a, 0x2b0b, 0x2b0c, 0x2b0d, 0x2b0e, 0x2b0f,
  0x2b10, 0x2b11, 0x2b12, 0x2b13, 0x2b14, 0x2b15, 0x2b16, 0x2b17,
  0x2b18, 0x2b19, 0x2b1a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2b20, 0x2b21, 0x2b22, 0x2b23, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c30, 0x2c31, 0x2c32, 0x2c33, 0x2c34, 0x2c35, 0x2c36, 0x2c37,
  0x2c38, 0x2c39, 0x2c3a, 0x2c3b, 0x2c3c, 0x2c3d, 0x2c3e, 0x2c3f,
  0x2c40, 0x2c41, 0x2c42, 0x2c43, 0x2c44, 0x2c45, 0x2c46, 0x2c47,
  0x2c48, 0x2c49, 0x2c4a, 0x2c4b, 0x2c4c, 0x2c4d, 0x2c4e, 0x2c4f,
  0x2c50, 0x2c51, 0x2c52, 0x2c53, 0x2c54, 0x2c55, 0x2c56, 0x2c57,
  0x2c58, 0x2c59, 0x2c5a, 0x2c5b, 0x2c5c, 0x2c5d, 0x2c5e, 0x0000,
  0x2c30, 0x2c31, 0x2c32, 0x2c33, 0x2c34, 0x2c35, 0x2c36, 0x2c37,
  0x2c38, 0x2c39, 0x2c3a, 0x2c3b, 0x2c3c, 0x2c3d, 0x2c3e, 0x2c3f,
  0x2c40, 0x2c41, 0x2c42, 0x2c43, 0x2c44, 0x2c45, 0x2c46, 0x2c47,
  0x2c48, 0x2c49, 0x2c4a, 0x2c4b, 0x2c4c, 0x2c4d, 0x2c4e, 0x2c4f,
  0x2c50, 0x2c51, 0x2c52, 0x2c53, 0x2c54, 0x2c55, 0x2c56, 0x2c57,
  0x2c58, 0x2c59, 0x2c5a, 0x2c5b, 0x2c5c, 0x2c5d, 0x2c5e, 0x0000,
  0x2c61, 0x2c61, 0x026b, 0x1d7d, 0x027d, 0x2c65, 0x2c66, 0x2c68,
  0x2c68, 0x2c6a, 0x2c6a, 0x2c6c, 0x2c6c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2c74, 0x2c76, 0x2c76, 0x2c77,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c81, 0x2c81, 0x2c83, 0x2c83, 0x2c85, 0x2c85, 0x2c87, 0x2c87,
  0x2c89, 0x2c89, 0x2c8b, 0x2c8b, 0x2c8d, 0x2c8d, 0x2c8f, 0x2c8f,
  0x2c91, 0x2c91, 0x2c93, 0x2c93, 0x2c95, 0x2c95, 0x2c97, 0x2c97,
  0x2c99, 0x2c99, 0x2c9b, 0x2c9b, 0x2c9d, 0x2c9d, 0x2c9f, 0x2c9f,
  0x2ca1, 0x2ca1, 0x2ca3, 0x2ca3, 0x2ca5, 0x2ca5, 0x2ca7, 0x2ca7,
  0x2ca9, 0x2ca9, 0x2cab, 0x2cab, 0x2cad, 0x2cad, 0x2caf, 0x2caf,
  0x2cb1, 0x2cb1, 0x2cb3, 0x2cb3, 0x2cb5, 0x2cb5, 0x2cb7, 0x2cb7,
  0x2cb9, 0x2cb9, 0x2cbb, 0x2cbb, 0x2cbd, 0x2cbd, 0x2cbf, 0x2cbf,
  0x2cc1, 0x2cc1, 0x2cc3, 0x2cc3, 0x2cc5, 0x2cc5, 0x2cc7, 0x2cc7,
  0x2cc9, 0x2cc9, 0x2ccb, 0x2ccb, 0x2ccd, 0x2ccd, 0x2ccf, 0x2ccf,
  0x2cd1, 0x2cd1, 0x2cd3, 0x2cd3, 0x2cd5, 0x2cd5, 0x2cd7, 0x2cd7,
  0x2cd9, 0x2cd9, 0x2cdb, 0x2cdb, 0x2cdd, 0x2cdd, 0x2cdf, 0x2cdf,
  0x2ce1, 0x2ce1, 0x2ce3, 0x2ce3, 0x2ce4, 0x2ce5, 0x2ce6, 0x2ce7,
  0x2ce8, 0x2ce9, 0x2cea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2cf9, 0x2cfa, 0x2cfb, 0x2cfc, 0x2cfd, 0x2cfe, 0x2cff,
  0x2d00, 0x2d01, 0x2d02, 0x2d03, 0x2d04, 0x2d05, 0x2d06, 0x2d07,
  0x2d08, 0x2d09, 0x2d0a, 0x2d0b, 0x2d0c, 0x2d0d, 0x2d0e, 0x2d0f,
  0x2d10, 0x2d11, 0x2d12, 0x2d13, 0x2d14, 0x2d15, 0x2d16, 0x2d17,
  0x2d18, 0x2d19, 0x2d1a, 0x2d1b, 0x2d1c, 0x2d1d, 0x2d1e, 0x2d1f,
  0x2d20, 0x2d21, 0x2d22, 0x2d23, 0x2d24, 0x2d25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2d30, 0x2d31, 0x2d32, 0x2d33, 0x2d34, 0x2d35, 0x2d36, 0x2d37,
  0x2d38, 0x2d39, 0x2d3a, 0x2d3b, 0x2d3c, 0x2d3d, 0x2d3e, 0x2d3f,
  0x2d40, 0x2d41, 0x2d42, 0x2d43, 0x2d44, 0x2d45, 0x2d46, 0x2d47,
  0x2d48, 0x2d49, 0x2d4a, 0x2d4b, 0x2d4c, 0x2d4d, 0x2d4e, 0x2d4f,
  0x2d50, 0x2d51, 0x2d52, 0x2d53, 0x2d54, 0x2d55, 0x2d56, 0x2d57,
  0x2d58, 0x2d59, 0x2d5a, 0x2d5b, 0x2d5c, 0x2d5d, 0x2d5e, 0x2d5f,
  0x2d60, 0x2d61, 0x2d62, 0x2d63, 0x2d64, 0x2d65, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d6f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2d80, 0x2d81, 0x2d82, 0x2d83, 0x2d84, 0x2d85, 0x2d86, 0x2d87,
  0x2d88, 0x2d89, 0x2d8a, 0x2d8b, 0x2d8c, 0x2d8d, 0x2d8e, 0x2d8f,
  0x2d90, 0x2d91, 0x2d92, 0x2d93, 0x2d94, 0x2d95, 0x2d96, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2da0, 0x2da1, 0x2da2, 0x2da3, 0x2da4, 0x2da5, 0x2da6, 0x0000,
  0x2da8, 0x2da9, 0x2daa, 0x2dab, 0x2dac, 0x2dad, 0x2dae, 0x0000,
  0x2db0, 0x2db1, 0x2db2, 0x2db3, 0x2db4, 0x2db5, 0x2db6, 0x0000,
  0x2db8, 0x2db9, 0x2dba, 0x2dbb, 0x2dbc, 0x2dbd, 0x2dbe, 0x0000,
  0x2dc0, 0x2dc1, 0x2dc2, 0x2dc3, 0x2dc4, 0x2dc5, 0x2dc6, 0x0000,
  0x2dc8, 0x2dc9, 0x2dca, 0x2dcb, 0x2dcc, 0x2dcd, 0x2dce, 0x0000,
  0x2dd0, 0x2dd1, 0x2dd2, 0x2dd3, 0x2dd4, 0x2dd5, 0x2dd6, 0x0000,
  0x2dd8, 0x2dd9, 0x2dda, 0x2ddb, 0x2ddc, 0x2ddd, 0x2dde, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2e00, 0x2e01, 0x2e02, 0x2e03, 0x2e04, 0x2e05, 0x2e06, 0x2e07,
  0x2e08, 0x2e09, 0x2e0a, 0x2e0b, 0x2e0c, 0x2e0d, 0x2e0e, 0x2e0f,
  0x2e10, 0x2e11, 0x2e12, 0x2e13, 0x2e14, 0x2e15, 0x2e16, 0x2e17,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2e1c, 0x2e1d, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2e80, 0x2e81, 0x2e82, 0x2e83, 0x2e84, 0x2e85, 0x2e86, 0x2e87,
  0x2e88, 0x2e89, 0x2e8a, 0x2e8b, 0x2e8c, 0x2e8d, 0x2e8e, 0x2e8f,
  0x2e90, 0x2e91, 0x2e92, 0x2e93, 0x2e94, 0x2e95, 0x2e96, 0x2e97,
  0x2e98, 0x2e99, 0x0000, 0x2e9b, 0x2e9c, 0x2e9d, 0x2e9e, 0x2e9f,
  0x2ea0, 0x2ea1, 0x2ea2, 0x2ea3, 0x2ea4, 0x2ea5, 0x2ea6, 0x2ea7,
  0x2ea8, 0x2ea9, 0x2eaa, 0x2eab, 0x2eac, 0x2ead, 0x2eae, 0x2eaf,
  0x2eb0, 0x2eb1, 0x2eb2, 0x2eb3, 0x2eb4, 0x2eb5, 0x2eb6, 0x2eb7,
  0x2eb8, 0x2eb9, 0x2eba, 0x2ebb, 0x2ebc, 0x2ebd, 0x2ebe, 0x2ebf,
  0x2ec0, 0x2ec1, 0x2ec2, 0x2ec3, 0x2ec4, 0x2ec5, 0x2ec6, 0x2ec7,
  0x2ec8, 0x2ec9, 0x2eca, 0x2ecb, 0x2ecc, 0x2ecd, 0x2ece, 0x2ecf,
  0x2ed0, 0x2ed1, 0x2ed2, 0x2ed3, 0x2ed4, 0x2ed5, 0x2ed6, 0x2ed7,
  0x2ed8, 0x2ed9, 0x2eda, 0x2edb, 0x2edc, 0x2edd, 0x2ede, 0x2edf,
  0x2ee0, 0x2ee1, 0x2ee2, 0x2ee3, 0x2ee4, 0x2ee5, 0x2ee6, 0x2ee7,
  0x2ee8, 0x2ee9, 0x2eea, 0x2eeb, 0x2eec, 0x2eed, 0x2eee, 0x2eef,
  0x2ef0, 0x2ef1, 0x2ef2, 0x2ef3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2f00, 0x2f01, 0x2f02, 0x2f03, 0x2f04, 0x2f05, 0x2f06, 0x2f07,
  0x2f08, 0x2f09, 0x2f0a, 0x2f0b, 0x2f0c, 0x2f0d, 0x2f0e, 0x2f0f,
  0x2f10, 0x2f11, 0x2f12, 0x2f13, 0x2f14, 0x2f15, 0x2f16, 0x2f17,
  0x2f18, 0x2f19, 0x2f1a, 0x2f1b, 0x2f1c, 0x2f1d, 0x2f1e, 0x2f1f,
  0x2f20, 0x2f21, 0x2f22, 0x2f23, 0x2f24, 0x2f25, 0x2f26, 0x2f27,
  0x2f28, 0x2f29, 0x2f2a, 0x2f2b, 0x2f2c, 0x2f2d, 0x2f2e, 0x2f2f,
  0x2f30, 0x2f31, 0x2f32, 0x2f33, 0x2f34, 0x2f35, 0x2f36, 0x2f37,
  0x2f38, 0x2f39, 0x2f3a, 0x2f3b, 0x2f3c, 0x2f3d, 0x2f3e, 0x2f3f,
  0x2f40, 0x2f41, 0x2f42, 0x2f43, 0x2f44, 0x2f45, 0x2f46, 0x2f47,
  0x2f48, 0x2f49, 0x2f4a, 0x2f4b, 0x2f4c, 0x2f4d, 0x2f4e, 0x2f4f,
  0x2f50, 0x2f51, 0x2f52, 0x2f53, 0x2f54, 0x2f55, 0x2f56, 0x2f57,
  0x2f58, 0x2f59, 0x2f5a, 0x2f5b, 0x2f5c, 0x2f5d, 0x2f5e, 0x2f5f,
  0x2f60, 0x2f61, 0x2f62, 0x2f63, 0x2f64, 0x2f65, 0x2f66, 0x2f67,
  0x2f68, 0x2f69, 0x2f6a, 0x2f6b, 0x2f6c, 0x2f6d, 0x2f6e, 0x2f6f,
  0x2f70, 0x2f71, 0x2f72, 0x2f73, 0x2f74, 0x2f75, 0x2f76, 0x2f77,
  0x2f78, 0x2f79, 0x2f7a, 0x2f7b, 0x2f7c, 0x2f7d, 0x2f7e, 0x2f7f,
  0x2f80, 0x2f81, 0x2f82, 0x2f83, 0x2f84, 0x2f85, 0x2f86, 0x2f87,
  0x2f88, 0x2f89, 0x2f8a, 0x2f8b, 0x2f8c, 0x2f8d, 0x2f8e, 0x2f8f,
  0x2f90, 0x2f91, 0x2f92, 0x2f93, 0x2f94, 0x2f95, 0x2f96, 0x2f97,
  0x2f98, 0x2f99, 0x2f9a, 0x2f9b, 0x2f9c, 0x2f9d, 0x2f9e, 0x2f9f,
  0x2fa0, 0x2fa1, 0x2fa2, 0x2fa3, 0x2fa4, 0x2fa5, 0x2fa6, 0x2fa7,
  0x2fa8, 0x2fa9, 0x2faa, 0x2fab, 0x2fac, 0x2fad, 0x2fae, 0x2faf,
  0x2fb0, 0x2fb1, 0x2fb2, 0x2fb3, 0x2fb4, 0x2fb5, 0x2fb6, 0x2fb7,
  0x2fb8, 0x2fb9, 0x2fba, 0x2fbb, 0x2fbc, 0x2fbd, 0x2fbe, 0x2fbf,
  0x2fc0, 0x2fc1, 0x2fc2, 0x2fc3, 0x2fc4, 0x2fc5, 0x2fc6, 0x2fc7,
  0x2fc8, 0x2fc9, 0x2fca, 0x2fcb, 0x2fcc, 0x2fcd, 0x2fce, 0x2fcf,
  0x2fd0, 0x2fd1, 0x2fd2, 0x2fd3, 0x2fd4, 0x2fd5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 
};


int unic_tolower (int c) {
  if (c<0x3000) {
    return ____tolower[(c)+1];
  } else {
    if (c>=0xff21&&c<=0xff3a) {
      return c+ 32;
    } else if ((c>=0x3000 && c<=0x303f) || (c>=0x3041 && c<=0x3096) ||
	       (c>=0x3099 && c<=0x30ff) || (c>=0x3105 && c<=0x312c) ||
	       (c>=0x3131 && c<=0x318e) || (c>=0x3190 && c<=0x31b7) ||
	       (c>=0x31c0 && c<=0x31cf) || (c>=0x31f0 && c<=0x321e) ||
	       (c>=0x3220 && c<=0x3243) || (c>=0x3250 && c<=0x32fe) ||
	       (c>=0x3300 && c<=0x4db5) || (c>=0x4dc0 && c<=0x9fbb) ||
	       (c>=0xa000 && c<=0xa48c) || (c>=0xa490 && c<=0xa4c6) ||
	       (c>=0xa700 && c<=0xa71a) || (c>=0xa720 && c<=0xa721) ||
	       (c>=0xa800 && c<=0xa82b) || (c>=0xa840 && c<=0xa877) ||
	       (c>=0xac00 && c<=0xd7a3) || (c>=0xd800 && c<=0xfa2d) ||
	       (c>=0xfa30 && c<=0xfa6a) || (c>=0xfa70 && c<=0xfad9) ||
	       (c>=0xfb00 && c<=0xfb06) || (c>=0xfb13 && c<=0xfb17) ||
	       (c>=0xfb1d && c<=0xfb36) || (c>=0xfb38 && c<=0xfb3c) ||
	       c==0xfb3e ||
	       (c>=0xfb40 && c<=0xfb41) || (c>=0xfb43 && c<=0xfb44) ||
	       (c>=0xfb46 && c<=0xfbb1) || (c>=0xfbd3 && c<=0xfd3f) ||
	       (c>=0xfd50 && c<=0xfd8f) || (c>=0xfd92 && c<=0xfdc7) ||
	       (c>=0xfdf0 && c<=0xfdfd) || (c>=0xfe00 && c<=0xfe19) ||
	       (c>=0xfe20 && c<=0xfe23) || (c>=0xfe30 && c<=0xfe52) ||
	       (c>=0xfe54 && c<=0xfe66) || (c>=0xfe68 && c<=0xfe6b) ||
	       (c>=0xfe70 && c<=0xfe74) || (c>=0xfe76 && c<=0xfefc) ||
	       c==0xfeff ||
	       (c>=0xff01 && c<=0xff20) || (c>=0xff3b && c<=0xffbe) ||
	       (c>=0xffc2 && c<=0xffc7) || (c>=0xffca && c<=0xffcf) ||
	       (c>=0xffd2 && c<=0xffd7) || (c>=0xffda && c<=0xffdc) ||
	       (c>=0xffe0 && c<=0xffe6) || (c>=0xffe8 && c<=0xffee) ||
	       (c>=0xfff9 && c<=0xfffd)){
      return c;
    } else {
      return 0;
    }
  }
}

/* some error and process reporting stuff */

char **gww_errors = NULL;
int gww_error_count = 0;

void _gwwv_post_error(const char *fmt, va_list args) { 
  char *buf;
  buf = malloc(1024);
  if (buf==NULL) {
	perror("memory allocation failed");
	exit(EXIT_FAILURE);
  }
  vsnprintf(buf,1024,fmt,args);
  gww_errors = realloc(gww_errors, (gww_error_count+2)*sizeof(char *));
  if (gww_errors==NULL) {
	perror("memory allocation failed");
	exit(EXIT_FAILURE);
  }
  gww_errors[gww_error_count ] = buf ;
  gww_error_count ++;
  gww_errors[gww_error_count ] = NULL;

}

void gwwv_post_error(const char *fmt, ...) { 
  va_list args;
  va_start (args, fmt);
  _gwwv_post_error(fmt,args);
  va_end (args);
}


void gwwv_errors_free (void) { 
  int i;
  if (gww_error_count>0) {
	for (i=0;i<gww_error_count;i++) {
	  free(gww_errors[i]);
	}
	free(gww_errors);
	gww_error_count = 0;
	gww_errors = NULL;
  }
}

void gwwv_post_notice (char *fmt, ...) { }
void gwwv_ask (char *a) { }
void gwwv_progress_change_line1 (char *a) { }
void gwwv_progress_change_line2 (char *b) { }
void gwwv_progress_next (void){ }
void gwwv_progress_start_indicator (void) { }
void gwwv_progress_end_indicator (void) { }
void gwwv_progress_enable_stop (void) { }
void gwwv_progress_resume_timer (void) { }
void gwwv_progress_pause_timer (void) { }
void gwwv_progress_next_stage (void) { }
void gwwv_progress_change_stages (void) { }
void gwwv_progress_change_total (void) { }
void gwwv_progress_increment (void) { }

void GWidgetError8(char *a, char *b) { }

void GProgressChangeLine1_8 (char *a) { }
void GProgressChangeLine2_8 (char *b) { }
void GProgressChangeTotal (void) { }
void GProgressNext (void){ }
void GProgressStartIndicator (void) { }
void GProgressEndIndicator (void) { }
void GProgressEnableStop (void) { }
void GProgressResumeTimer (void) { }
void GProgressPauseTimer (void) { }
void GProgressNextStage (void) { }
void GProgressChangeStages (void) { }
void GProgressIncrement (void) { }

/* from plugins.c */

void LoadPluginDir(void *a) { }

/* from scripting.c */

int no_windowing_ui = 1;
int running_script = 1;
int use_utf8_in_script = 1;

void ScriptError( void *c, const char *msg ) { }

void ScriptErrorString( void *c, const char *msg, const char *name) { }

void ScriptErrorF( void *c, const char *format, ... ) { }

void CheckIsScript(int argc, char *argv[]) { }

void ExecuteScriptFile(FontView *fv, char *filename) { }

void ScriptDlg(FontView *fv) { }

struct dictentry {
    char *name;
    Val val;
};

struct dictionary {
    struct dictentry *entries;
    int cnt, max;
};


typedef struct array {
    int argc;
    Val *vals;
} Array;

static void arrayfree(Array *a) {
    int i;

    for ( i=0; i<a->argc; ++i ) {
	if ( a->vals[i].type==v_str )
	    free(a->vals[i].u.sval);
	else if ( a->vals[i].type==v_arr )
	    arrayfree(a->vals[i].u.aval);
    }
    free(a->vals);
    free(a);
}


void DictionaryFree(struct dictionary *dica) {
    int i;

    if ( dica==NULL )
return;

    for ( i=0; i<dica->cnt; ++i ) {
	free(dica->entries[i].name );
	if ( dica->entries[i].val.type == v_str )
	    free( dica->entries[i].val.u.sval );
	if ( dica->entries[i].val.type == v_arr )
	    arrayfree( dica->entries[i].val.u.aval );
    }
    free( dica->entries );
}


char **GetFontNames(char *filename) {
    FILE *foo;
    char **ret = NULL;

    if ( GFileIsDir(filename)) {
#if 0
	char *temp = galloc(strlen(filename)+strlen("/glyphs/contents.plist")+1);
	strcpy(temp,filename);
	strcat(temp,"/glyphs/contents.plist");
	if ( GFileExists(temp))
	    ret = NamesReadUFO(filename);
	else
	  {
	    strcpy(temp,filename);
	    strcat(temp,"/font.props");
	    if ( GFileExists(temp))
		ret = NamesReadSFD(temp);
		/* The fonts.prop file will look just like an sfd file as far */
		/* as fontnames are concerned, we don't need a separate routine*/
	}
	free(temp);
#endif 
    } else {
	foo = fopen(filename,"rb");
	if ( foo!=NULL ) {
	    /* Try to guess the file type from the first few characters... */
	    int ch1 = getc(foo);
	    int ch2 = getc(foo);
	    int ch3 = getc(foo);
	    int ch4 = getc(foo);
	    int ch5, ch6;
	    fseek(foo, 98, SEEK_SET);
	    ch5 = getc(foo);
	    ch6 = getc(foo);
	    fclose(foo);
	    if (( ch1==0 && ch2==1 && ch3==0 && ch4==0 ) ||
		    (ch1=='O' && ch2=='T' && ch3=='T' && ch4=='O') ||
		    (ch1=='t' && ch2=='r' && ch3=='u' && ch4=='e') ||
		    (ch1=='t' && ch2=='t' && ch3=='c' && ch4=='f') ) {
		ret = NamesReadTTF(filename);
	    } else if (( ch1=='%' && ch2=='!' ) ||
			( ch1==0x80 && ch2=='\01' ) ) {	/* PFB header */
		ret = NamesReadPostscript(filename);
#if 0
	    } else if ( ch1=='<' && ch2=='?' && (ch3=='x'||ch3=='X') && (ch4=='m'||ch4=='M') ) {
		ret = NamesReadSVG(filename);
	    } else if ( ch1=='S' && ch2=='p' && ch3=='l' && ch4=='i' ) {
		ret = NamesReadSFD(filename);
#endif
	    } else if ( ch1==1 && ch2==0 && ch3==4 ) {
		ret = NamesReadCFF(filename);
	    } else /* Too hard to figure out a valid mark for a mac resource file */
		ret = NamesReadMacBinary(filename);
	}
    }
return( ret );
}


/* from svg.c */

SplineChar *SCHasSubs(SplineChar *sc, uint32 tag) {
    PST *pst;

    for ( pst=sc->possub; pst!=NULL; pst=pst->next ) {
        if ( pst->type==pst_substitution &&
                FeatureTagInFeatureScriptList(tag,pst->subtable->lookup->features) )
return( SFGetChar(sc->parent,-1,pst->u.subs.variant));
    }
return( NULL );
}

int _ExportSVG(FILE *svg,SplineChar *sc) {
  return 0;
}

int WriteSVGFont(char *fontname,SplineFont *sf,enum fontformat format,int flags,
	EncMap *map) {
  return 1;
}

int HasSVG(void) { return 0; }


SplineFont *SFReadSVG(char *filename, int flags) {
return( NULL );
}

SplineSet *SplinePointListInterpretSVG(char *filename,char *memory, int memlen,
	int em_size,int ascent,int is_stroked) {
return( NULL );
}

/* from ufo.c */

int HasUFO(void) {
return( false );
}

SplineFont *SFReadUFO(char *filename, int flags) {
return( NULL );
}

SplineSet *SplinePointListInterpretGlif(char *filename,char *memory, int memlen,
	int em_size,int ascent,int is_stroked) {
return( NULL );
}

int WriteUFOFont(char *basedir,SplineFont *sf,enum fontformat ff,int flags,
	EncMap *map) {
  return 1;
}

int _ExportGlif(FILE *glif,SplineChar *sc) {
return 0;
}

/* from autosave.c, but much shortened */

char *getPfaEditDir(char *buffer) {
  return( NULL );
}

void DoAutoSaves (void ) {}

/* from dumppfa.c, but much shortened */

const char *GetAuthor(void) {
  static char author[200] = { '\0' };
  const char *ret = NULL, *pt;

  if ((pt=getenv("USER"))!=NULL ) {
    strncpy(author,pt,sizeof(author));
    author[sizeof(author)-1] = '\0';
    ret = author;
  }
  return ret;
}

double BlueScaleFigure(struct psdict *private,real bluevalues[], real otherblues[]) {
    double max_diff=0, p1, p2;
    char *pt, *end;
    int i;

    if ( PSDictHasEntry(private,"BlueScale")!=NULL )
return( -1 );

    pt = PSDictHasEntry(private,"BlueValues");
    if ( pt!=NULL ) {
	while ( *pt==' ' || *pt=='[' ) ++pt;
	forever {
	    p1 = strtod(pt,&end);
	    if ( end==pt )
	break;
	    pt = end;
	    p2 = strtod(pt,&end);
	    if ( end==pt )
	break;
	    if ( p2-p1 >max_diff ) max_diff = p2-p1;
	    pt = end;
	}
    } else {
	for ( i=0; i<14 && (bluevalues[i]!=0 || bluevalues[i+1])!=0; i+=2 ) {
	    if ( bluevalues[i+1] - bluevalues[i]>=max_diff )
		max_diff = bluevalues[i+1] - bluevalues[i];
	}
    }

    pt = PSDictHasEntry(private,"OtherBlues");
    if ( pt!=NULL ) {
	while ( *pt==' ' || *pt=='[' ) ++pt;
	forever {
	    p1 = strtod(pt,&end);
	    if ( end==pt )
	break;
	    pt = end;
	    p2 = strtod(pt,&end);
	    if ( end==pt )
	break;
	    if ( p2-p1 >max_diff ) max_diff = p2-p1;
	    pt = end;
	}
    } else {
	for ( i=0; i<10 && (otherblues[i]!=0 || otherblues[i+1]!=0); i+=2 ) {
	    if ( otherblues[i+1] - otherblues[i]>=max_diff )
		max_diff = otherblues[i+1] - otherblues[i];
	}
    }
    if ( max_diff<=0 )
return( -1 );
    if ( 1/max_diff > .039625 )
return( -1 );

return( .99/max_diff );
}

/* from dumpbdf.c */

int IsntBDFChar(BDFChar *bdfc) {
    if ( bdfc==NULL )
return( true );

return( !SCWorthOutputting(bdfc->sc));
}

/* form bitmapdlg.c (stubbed) */

void SFOrderBitmapList(SplineFont *sf) {
}

/* from metafont.c, whole */

void SCCopyFgToBg(SplineChar *sc, int show) {
    SplinePointList *fore, *end;

    SCPreserveBackground(sc);
    fore = SplinePointListCopy(sc->layers[ly_fore].splines);
    if ( fore!=NULL ) {
	SplinePointListsFree(sc->layers[ly_back].splines);
	sc->layers[ly_back].splines = NULL;
	for ( end = fore; end->next!=NULL; end = end->next );
	end->next = sc->layers[ly_back].splines;
	sc->layers[ly_back].splines = fore;
	if ( show )
	    SCCharChangedUpdate(sc);
    }
}


/* from tottf.c, whole */
#if 0

void putshort(FILE *file,int sval) {
    putc((sval>>8)&0xff,file);
    putc(sval&0xff,file);
}

void putlong(FILE *file,int val) {
    putc((val>>24)&0xff,file);
    putc((val>>16)&0xff,file);
    putc((val>>8)&0xff,file);
    putc(val&0xff,file);
}

char *utf8_verify_copy(const char *str) {
    /* When given a postscript string it SHOULD be in ASCII. But it will often*/
    /* contain a copyright symbol (sometimes in latin1, sometimes in macroman)*/
    /* unfortunately both encodings use 0xa9 for copyright so we can't distinguish */
    /* guess that it's latin1 (or that copyright is the only odd char which */
    /* means a latin1 conversion will work for macs too). */

    if ( str==NULL )
return( NULL );

    if ( utf8_valid(str))
return( copy(str));		/* Either in ASCII (good) or appears to be utf8*/
return( latin1_2_utf8_copy(str));
}

const char *ttfstandardnames[258] = {
".notdef",
".null",
"nonmarkingreturn",
"space",
"exclam",
"quotedbl",
"numbersign",
"dollar",
"percent",
"ampersand",
"quotesingle",
"parenleft",
"parenright",
"asterisk",
"plus",
"comma",
"hyphen",
"period",
"slash",
"zero",
"one",
"two",
"three",
"four",
"five",
"six",
"seven",
"eight",
"nine",
"colon",
"semicolon",
"less",
"equal",
"greater",
"question",
"at",
"A",
"B",
"C",
"D",
"E",
"F",
"G",
"H",
"I",
"J",
"K",
"L",
"M",
"N",
"O",
"P",
"Q",
"R",
"S",
"T",
"U",
"V",
"W",
"X",
"Y",
"Z",
"bracketleft",
"backslash",
"bracketright",
"asciicircum",
"underscore",
"grave",
"a",
"b",
"c",
"d",
"e",
"f",
"g",
"h",
"i",
"j",
"k",
"l",
"m",
"n",
"o",
"p",
"q",
"r",
"s",
"t",
"u",
"v",
"w",
"x",
"y",
"z",
"braceleft",
"bar",
"braceright",
"asciitilde",
"Adieresis",
"Aring",
"Ccedilla",
"Eacute",
"Ntilde",
"Odieresis",
"Udieresis",
"aacute",
"agrave",
"acircumflex",
"adieresis",
"atilde",
"aring",
"ccedilla",
"eacute",
"egrave",
"ecircumflex",
"edieresis",
"iacute",
"igrave",
"icircumflex",
"idieresis",
"ntilde",
"oacute",
"ograve",
"ocircumflex",
"odieresis",
"otilde",
"uacute",
"ugrave",
"ucircumflex",
"udieresis",
"dagger",
"degree",
"cent",
"sterling",
"section",
"bullet",
"paragraph",
"germandbls",
"registered",
"copyright",
"trademark",
"acute",
"dieresis",
"notequal",
"AE",
"Oslash",
"infinity",
"plusminus",
"lessequal",
"greaterequal",
"yen",
"mu",
"partialdiff",
"summation",
"product",
"pi",
"integral",
"ordfeminine",
"ordmasculine",
"Omega",
"ae",
"oslash",
"questiondown",
"exclamdown",
"logicalnot",
"radical",
"florin",
"approxequal",
"Delta",
"guillemotleft",
"guillemotright",
"ellipsis",
"nonbreakingspace",
"Agrave",
"Atilde",
"Otilde",
"OE",
"oe",
"endash",
"emdash",
"quotedblleft",
"quotedblright",
"quoteleft",
"quoteright",
"divide",
"lozenge",
"ydieresis",
"Ydieresis",
"fraction",
"currency",
"guilsinglleft",
"guilsinglright",
"fi",
"fl",
"daggerdbl",
"periodcentered",
"quotesinglbase",
"quotedblbase",
"perthousand",
"Acircumflex",
"Ecircumflex",
"Aacute",
"Edieresis",
"Egrave",
"Iacute",
"Icircumflex",
"Idieresis",
"Igrave",
"Oacute",
"Ocircumflex",
"apple",
"Ograve",
"Uacute",
"Ucircumflex",
"Ugrave",
"dotlessi",
"circumflex",
"tilde",
"macron",
"breve",
"dotaccent",
"ring",
"cedilla",
"hungarumlaut",
"ogonek",
"caron",
"Lslash",
"lslash",
"Scaron",
"scaron",
"Zcaron",
"zcaron",
"brokenbar",
"Eth",
"eth",
"Yacute",
"yacute",
"Thorn",
"thorn",
"minus",
"multiply",
"onesuperior",
"twosuperior",
"threesuperior",
"onehalf",
"onequarter",
"threequarters",
"franc",
"Gbreve",
"gbreve",
"Idotaccent",
"Scedilla",
"scedilla",
"Cacute",
"cacute",
"Ccaron",
"ccaron",
"dcroat"
};

int ttfcopyfile(FILE *ttf, FILE *other, int pos, char *tab_name) {
    int ch;
    int ret = 1;

    if ( ferror(ttf) || ferror(other)) {
	IError("Disk error of some nature. Perhaps no space on device?\nGenerated font will be unusable" );
    } else if ( pos!=ftell(ttf)) {
	IError("File Offset wrong for ttf table (%s), %d expected %d", tab_name, ftell(ttf), pos );
    }
    rewind(other);
    while (( ch = getc(other))!=EOF )
	putc(ch,ttf);
    if ( ferror(other)) ret = 0;
    if ( fclose(other)) ret = 0;
return( ret );
}



static void OS2WeightCheck(struct pfminfo *pfminfo,char *weight) {
    if ( weight==NULL ) {
	/* default it */
    } else if ( strstrmatch(weight,"medi")!=NULL ) {
	pfminfo->weight = 500;
	pfminfo->panose[2] = 6;
    } else if ( strstrmatch(weight,"demi")!=NULL ||
		strstrmatch(weight,"halb")!=NULL ||
		(strstrmatch(weight,"semi")!=NULL &&
		    strstrmatch(weight,"bold")!=NULL) ) {
	pfminfo->weight = 600;
	pfminfo->panose[2] = 7;
    } else if ( strstrmatch(weight,"bold")!=NULL ||
		strstrmatch(weight,"fett")!=NULL ||
		strstrmatch(weight,"gras")!=NULL ) {
	pfminfo->weight = 700;
	pfminfo->panose[2] = 8;
    } else if ( strstrmatch(weight,"heavy")!=NULL ) {
	pfminfo->weight = 800;
	pfminfo->panose[2] = 9;
    } else if ( strstrmatch(weight,"black")!=NULL ) {
	pfminfo->weight = 900;
	pfminfo->panose[2] = 10;
    } else if ( strstrmatch(weight,"nord")!=NULL ) {
	pfminfo->weight = 950;
	pfminfo->panose[2] = 11;
    } else if ( strstrmatch(weight,"thin")!=NULL ) {
	pfminfo->weight = 100;
	pfminfo->panose[2] = 2;
    } else if ( strstrmatch(weight,"extra")!=NULL ||
	    strstrmatch(weight,"light")!=NULL ) {
	pfminfo->weight = 200;
	pfminfo->panose[2] = 3;
    } else if ( strstrmatch(weight,"light")!=NULL ) {
	pfminfo->weight = 300;
	pfminfo->panose[2] = 4;
    }
}

void SFDefaultOS2Simple(struct pfminfo *pfminfo,SplineFont *sf) {
    pfminfo->pfmfamily = 0x11;
    pfminfo->panose[0] = 2;
    pfminfo->weight = 400;
    pfminfo->panose[2] = 5;
    pfminfo->width = 5;
    pfminfo->panose[3] = 3;
    pfminfo->winascent_add = pfminfo->windescent_add = true;
    pfminfo->hheadascent_add = pfminfo->hheaddescent_add = true;
    pfminfo->typoascent_add = pfminfo->typodescent_add = true;
    pfminfo->os2_winascent = pfminfo->os2_windescent = 0;

    if ( sf->subfonts!=NULL ) sf = sf->subfonts[0];
    pfminfo->linegap = pfminfo->vlinegap = pfminfo->os2_typolinegap = 
	    rint(.09*(sf->ascent+sf->descent));
}

void SFDefaultOS2SubSuper(struct pfminfo *pfminfo,int emsize,double italic_angle) {
    double s = sin(italic_angle*3.1415926535897932/180.0);
    pfminfo->os2_supysize = pfminfo->os2_subysize = .7*emsize;
    pfminfo->os2_supxsize = pfminfo->os2_subxsize = .65*emsize;
    pfminfo->os2_subyoff = .14*emsize;
    pfminfo->os2_supyoff = .48*emsize;
    pfminfo->os2_supxoff =  s*pfminfo->os2_supyoff;
    pfminfo->os2_subxoff = -s*pfminfo->os2_subyoff;
    pfminfo->os2_strikeysize = 102*emsize/2048;
    pfminfo->os2_strikeypos = 530*emsize/2048;
}

void SFDefaultOS2Info(struct pfminfo *pfminfo,SplineFont *sf,char *fontname) {
    int samewid= -1;
    char *weight = sf->cidmaster==NULL ? sf->weight : sf->cidmaster->weight;

    if ( sf->pfminfo.pfmset ) {
	if ( pfminfo!=&sf->pfminfo )
	    *pfminfo = sf->pfminfo;
	if ( !pfminfo->panose_set ) {
	    struct pfminfo info;
	    memset(&info,0,sizeof(info));
	    sf->pfminfo.pfmset = false;
	    SFDefaultOS2Info(&info,sf,fontname);
	    sf->pfminfo.pfmset = true;
	    memcpy(pfminfo->panose,info.panose,sizeof(info.panose));
	}
    } else {
	struct pfminfo hold;
	if ( pfminfo->hheadset || pfminfo->vheadset )
	    hold = *pfminfo;
	else
	    hold.hheadset = hold.vheadset = false;
	memset(pfminfo,'\0',sizeof(*pfminfo));
	SFDefaultOS2Simple(pfminfo,sf);
	samewid = CIDOneWidth(sf);

	pfminfo->pfmfamily = 0x10;
	if ( samewid>0 ) {
	    pfminfo->pfmfamily = 0x30;
	    /* pfminfo->panose[3] = 9; */ /* This is done later */
	} else if ( strstrmatch(fontname,"sans")!=NULL )
	    pfminfo->pfmfamily = 0x20;
	else if ( strstrmatch(fontname,"script")!=NULL ) {
	    pfminfo->pfmfamily = 0x40;
	    pfminfo->panose[0] = 3;
	}
	if ( samewid==-1 )
	    pfminfo->pfmfamily |= 0x1;	/* Else it assumes monospace */

/* urw uses 4 character abreviations */
	if ( weight!=NULL )
	    OS2WeightCheck(pfminfo,weight);
	OS2WeightCheck(pfminfo,fontname);

	if ( strstrmatch(fontname,"ultra")!=NULL &&
		strstrmatch(fontname,"condensed")!=NULL ) {
	    pfminfo->width = 1;
	    pfminfo->panose[3] = 8;
	} else if ( strstrmatch(fontname,"extra")!=NULL &&
		strstrmatch(fontname,"condensed")!=NULL ) {
	    pfminfo->width = 2;
	    pfminfo->panose[3] = 8;
	} else if ( strstrmatch(fontname,"semi")!=NULL &&
		strstrmatch(fontname,"condensed")!=NULL ) {
	    pfminfo->width = 4;
	    pfminfo->panose[3] = 6;
	} else if ( strstrmatch(fontname,"condensed")!=NULL ||
		strstrmatch(fontname,"narrow")!=NULL ) {
	    pfminfo->width = 3;
	    pfminfo->panose[3] = 6;
	} else if ( strstrmatch(fontname,"ultra")!=NULL &&
		strstrmatch(fontname,"expanded")!=NULL ) {
	    pfminfo->width = 9;
	    pfminfo->panose[3] = 7;
	} else if ( strstrmatch(fontname,"extra")!=NULL &&
		strstrmatch(fontname,"expanded")!=NULL ) {
	    pfminfo->width = 8;
	    pfminfo->panose[3] = 7;
	} else if ( strstrmatch(fontname,"semi")!=NULL &&
		strstrmatch(fontname,"expanded")!=NULL ) {
	    pfminfo->width = 6;
	    pfminfo->panose[3] = 5;
	} else if ( strstrmatch(fontname,"expanded")!=NULL ) {
	    pfminfo->width = 7;
	    pfminfo->panose[3] = 5;
	}
	if ( samewid>0 )
	    pfminfo->panose[3] = 9;
	if ( hold.hheadset ) {
	    pfminfo->hheadset = true;
	    pfminfo->hheadascent_add = hold.hheadascent_add;
	    pfminfo->hheaddescent_add = hold.hheaddescent_add;
	    pfminfo->hhead_ascent = hold.hhead_ascent;
	    pfminfo->hhead_descent = hold.hhead_descent;
	    pfminfo->linegap = hold.linegap;
	}
	if ( hold.vheadset ) {
	    pfminfo->vheadset = true;
	    pfminfo->vlinegap = hold.vlinegap;
	}
    }
    if ( !pfminfo->subsuper_set )
	SFDefaultOS2SubSuper(pfminfo,sf->ascent+sf->descent,sf->italicangle);
}

void OS2FigureCodePages(SplineFont *sf, uint32 CodePage[2]) {
    int i;
    uint32 latin1[8];
    int has_ascii, has_latin1;

    memset(latin1,0,sizeof(latin1));
    for ( i=0; i<sf->glyphcnt; ++i ) if ( sf->glyphs[i]!=NULL ) {
	if ( sf->glyphs[i]->unicodeenc<256 && sf->glyphs[i]->unicodeenc>=0 )
	    latin1[(sf->glyphs[i]->unicodeenc>>5)] |= 1<<(sf->glyphs[i]->unicodeenc&31);
    }

    has_ascii = latin1[1]==0xffffffff && latin1[2]==0xffffffff &&
	    (latin1[3]&0x7fffffff)==0x7fffffff;		/* DEL is not a char */
    has_latin1 = has_ascii && (latin1[5]&~1&~(1<<0xd))== (~1&~(1<<0xd))	&& /* Ignore nobreak space, softhyphen */
	    latin1[6]==0xffffffff && latin1[7] == 0xffffffff;
    CodePage[0] = CodePage[1] = 0;
    if ( has_ascii ) CodePage[1] |= 1U<<31;		/* US (Ascii I assume) */
    if ( has_latin1 ) CodePage[0] |= 1U<<30;		/* WE/latin1 */

    for ( i=0; i<sf->glyphcnt; ++i ) if ( sf->glyphs[i]!=NULL ) {
	if ( sf->glyphs[i]->unicodeenc==0xde && has_ascii )
	    CodePage[0] |= 1<<0;		/* (ANSI) Latin1 */
	else if ( sf->glyphs[i]->unicodeenc==0x13d && has_ascii ) {
	    CodePage[0] |= 1<<1;		/* latin2 */
	    CodePage[1] |= 1<<26;		/* latin2 */
	} else if ( sf->glyphs[i]->unicodeenc==0x411 ) {
	    CodePage[0] |= 1<<2;		/* cyrillic */
	    CodePage[1] |= 1<<17;		/* MS DOS Russian */
	    CodePage[1] |= 1<<25;		/* IBM Cyrillic */
	} else if ( sf->glyphs[i]->unicodeenc==0x386 ) {
	    CodePage[0] |= 1<<3;		/* greek */
	    CodePage[1] |= 1<<16;		/* IBM Greek */
	    CodePage[1] |= 1<<28;		/* Greek, former 437 G */
	} else if ( sf->glyphs[i]->unicodeenc==0x130 && has_ascii ) {
	    CodePage[0] |= 1<<4;		/* turkish */
	    CodePage[1] |= 1<<24;		/* IBM turkish */
	} else if ( sf->glyphs[i]->unicodeenc==0x5d0 ) {
	    CodePage[0] |= 1<<5;		/* hebrew */
	    CodePage[1] |= 1<<21;		/* hebrew */
	} else if ( sf->glyphs[i]->unicodeenc==0x631 ) {
	    CodePage[0] |= 1<<6;		/* arabic */
	    CodePage[1] |= 1<<19;		/* arabic */
	    CodePage[1] |= 1<<29;		/* arabic; ASMO 708 */
	} else if ( sf->glyphs[i]->unicodeenc==0x157 && has_ascii ) {
	    CodePage[0] |= 1<<7;		/* baltic */
	    CodePage[1] |= 1<<27;		/* baltic */
	} else if ( sf->glyphs[i]->unicodeenc==0x20AB && has_ascii ) {
	    CodePage[0] |= 1<<8;		/* vietnamese */
	} else if ( sf->glyphs[i]->unicodeenc==0xe45 )
	    CodePage[0] |= 1<<16;		/* thai */
	else if ( sf->glyphs[i]->unicodeenc==0x30a8 )
	    CodePage[0] |= 1<<17;		/* japanese */
	else if ( sf->glyphs[i]->unicodeenc==0x3105 )
	    CodePage[0] |= 1<<18;		/* simplified chinese */
	else if ( sf->glyphs[i]->unicodeenc==0x3131 )
	    CodePage[0] |= 1<<19;		/* korean wansung */
	else if ( sf->glyphs[i]->unicodeenc==0x592E )
	    CodePage[0] |= 1<<20;		/* traditional chinese */
	else if ( sf->glyphs[i]->unicodeenc==0xacf4 )
	    CodePage[0] |= 1<<21;		/* korean Johab */
	else if ( sf->glyphs[i]->unicodeenc==0x2030 && has_ascii )
	    CodePage[0] |= 1U<<29;		/* mac roman */
	else if ( sf->glyphs[i]->unicodeenc==0x2665 && has_ascii )
	    CodePage[0] |= 1U<<30;		/* OEM */
#if 0	/* the symbol bit doesn't mean it contains the glyphs in symbol */
	/* rather that one is using a symbol encoding. Or that there are */
	/* glyphs with unicode encoding between 0xf000 and 0xf0ff, in which */
	/* case those guys should be given a symbol encoding */
	/* There's a bug in the way otf fonts handle this (but not ttf) and */
	/*  they only seem to list the symbol glyphs */
	else if ( sf->glyphs[i]->unicodeenc==0x21d4 )
	    CodePage[0] |= 1U<<31;		/* symbol */
#else
	/* This doesn't work well either. In ttf fonts the bit is ignored */
	/*  in otf fonts the bit means "ignore all other bits" */
	else if ( sf->glyphs[i]->unicodeenc>=0xf000 && sf->glyphs[i]->unicodeenc<=0xf0ff )
	    CodePage[0] |= 1U<<31;		/* symbol */
#endif
	else if ( sf->glyphs[i]->unicodeenc==0xc3 && has_ascii )
	    CodePage[1] |= 1<<18;		/* MS-DOS Nordic */
	else if ( sf->glyphs[i]->unicodeenc==0xe9 && has_ascii )
	    CodePage[1] |= 1<<20;		/* MS-DOS Canadian French */
	else if ( sf->glyphs[i]->unicodeenc==0xf5 && has_ascii )
	    CodePage[1] |= 1<<23;		/* MS-DOS Portuguese */
	else if ( sf->glyphs[i]->unicodeenc==0xfe && has_ascii )
	    CodePage[1] |= 1<<22;		/* MS-DOS Icelandic */
    }
}

#define _On_Curve	1
#define _X_Short	2
#define _Y_Short	4
#define _Repeat		8
#define _X_Same		0x10
#define _Y_Same		0x20

int SSAddPoints(SplineSet *ss,int ptcnt,BasePoint *bp, char *flags) {
    SplinePoint *sp, *first, *nextsp;
    int startcnt = ptcnt;

    if ( ss->first->prev!=NULL &&
	    ss->first->prev->from->nextcpindex==startcnt ) {
	if ( flags!=NULL ) flags[ptcnt] = 0;
	bp[ptcnt].x = rint(ss->first->prevcp.x);
	bp[ptcnt++].y = rint(ss->first->prevcp.y);
    } else if ( ss->first->ttfindex!=ptcnt && ss->first->ttfindex!=0xfffe )
	IError("Unexpected point count in SSAddPoints" );

    first = NULL;
    for ( sp=ss->first; sp!=first ; ) {
	if ( sp->ttfindex!=0xffff ) {
	    if ( flags!=NULL ) flags[ptcnt] = _On_Curve;
	    bp[ptcnt].x = rint(sp->me.x);
	    bp[ptcnt].y = rint(sp->me.y);
	    sp->ttfindex = ptcnt++;
	} else if ( !SPInterpolate( sp ) ) {
	    /* If an on curve point is midway between two off curve points*/
	    /*  it may be omitted and will be interpolated on read in */
	    if ( flags!=NULL ) flags[ptcnt] = _On_Curve;
	    bp[ptcnt].x = rint(sp->me.x);
	    bp[ptcnt].y = rint(sp->me.y);
	    sp->ttfindex = ptcnt++;
	}
	nextsp = sp->next!=NULL ? sp->next->to : NULL;
	if ( sp->nextcpindex == startcnt )
	    /* This control point is actually our first point, not our last */
    break;
	if ( (sp->nextcpindex !=0xffff && sp->nextcpindex!=0xfffe ) ||
		!sp->nonextcp ) {
	    if ( flags!=NULL ) flags[ptcnt] = 0;
	    bp[ptcnt].x = rint(sp->nextcp.x);
	    bp[ptcnt++].y = rint(sp->nextcp.y);
	}
	if ( nextsp==NULL )
    break;
	if ( first==NULL ) first = sp;
	sp = nextsp;
    }
return( ptcnt );
}


#ifdef _HAS_LONGLONG
void cvt_unix_to_1904( long long time, int32 result[2]) {
    uint32 date1970[4], tm[4];
    uint32 year[2];
    int i;

    tm[0] =  time     &0xffff;
    tm[1] = (time>>16)&0xffff;
    tm[2] = (time>>32)&0xffff;
    tm[3] = (time>>48)&0xffff;
#else
void cvt_unix_to_1904( long time, int32 result[2]) {
    int32 date1970[4], tm[4];
    uint32 year[2];
    int i;

    tm[0] =  time     &0xffff;
    tm[1] = (time>>16)&0xffff;
    tm[2] = 0;
    tm[3] = 0;
#endif
    memset(date1970,0,sizeof(date1970));
    year[0] = (60*60*24*365L)&0xffff;
    year[1] = (60*60*24*365L)>>16;
    for ( i=1904; i<1970; ++i ) {
	date1970[0] += year[0];
	date1970[1] += year[1];
	if ( (i&3)==0 && (i%100!=0 || i%400==0))
	    date1970[0] += 24*60*60L;		/* Leap year */
	date1970[1] += (date1970[0]>>16);
	date1970[0] &= 0xffff;
	date1970[2] += date1970[1]>>16;
	date1970[1] &= 0xffff;
	date1970[3] += date1970[2]>>16;
	date1970[2] &= 0xffff;
    }

    for ( i=0; i<3; ++i ) {
	tm[i] += date1970[i];
	tm[i+1] += tm[i]>>16;
	tm[i] &= 0xffff;
    }
    tm[3] -= date1970[3];

    result[0] = (tm[1]<<16) | tm[0];
    result[1] = (tm[3]<<16) | tm[2];
}

#endif /* for tottf.c */

/* from fvimportbdf.c */
 
void SFCheckPSBitmap(SplineFont *sf) {
  /* full, was empty */
}

 void SFDefaultAscent(SplineFont *sf) {
  /* stubbed */
}


/* from bdfinfo.c */

int BdfPropHasInt(BDFFont *font,const char *key, int def ) {
    int i;

    for ( i=0; i<font->prop_cnt; ++i ) if ( strcmp(font->props[i].name,key)==0 ) {
	switch ( font->props[i].type&~prt_property ) {
	  case prt_int: case prt_uint:
return( font->props[i].u.val );
	  break;
	}
    }
return( def );
}

/* from tottfaat.c */

int scriptsHaveDefault(struct scriptlanglist *sl) {
    int i;

    for ( ; sl!=NULL; sl=sl->next ) {
	for ( i=0; i<sl->lang_cnt; ++i ) {
	    if ( (i<MAX_LANG && sl->langs[i]==DEFAULT_LANG) ||
		    (i>=MAX_LANG && sl->morelangs[i-MAX_LANG]==DEFAULT_LANG)) {
return( true );
	    }
	}
    }
return( false );
}

uint32 MacFeatureToOTTag(int featureType,int featureSetting) {
    int i;
    struct macsettingname *msn = user_macfeat_otftag ? user_macfeat_otftag : macfeat_otftag;

    for ( i=0; msn[i].otf_tag!=0; ++i )
	if ( msn[i].mac_feature_type == featureType &&
		msn[i].mac_feature_setting == featureSetting )
return( msn[i].otf_tag );

return( 0 );
}

int OTTagToMacFeature(uint32 tag, int *featureType,int *featureSetting) {
    int i;
    struct macsettingname *msn = user_macfeat_otftag ? user_macfeat_otftag : macfeat_otftag;

    for ( i=0; msn[i].otf_tag!=0; ++i )
	if ( msn[i].otf_tag == tag ) {
	    *featureType = msn[i].mac_feature_type;
	    *featureSetting = msn[i].mac_feature_setting;
return( true );
	}

    *featureType = 0;
    *featureSetting = 0;
return( false );
}

static void DumpKernClass(FILE *file, uint16 *class,int cnt,int add,int mul) {
    int i, first=-1, last=-1;

    for ( i=0; i<cnt; ++i ) {
	if ( class[i] ) last = i;
	if ( class[i] && first==-1 ) first = i;
    }
    putshort(file,first);
    putshort(file,last-first+1);
    for ( i=first; i<=last; ++i )
	putshort(file,class[i]*mul+add);
}

struct kerncounts {
    int cnt;
    int vcnt;
    int mh, mv;
    int kccnt;
    int vkccnt;
    int ksm;
    int hsubs;
    int *hbreaks;
    int vsubs;
    int *vbreaks;
};

static int CountKerns(struct alltabs *at, SplineFont *sf, struct kerncounts *kcnt) {
    int i, cnt, vcnt, j, kccnt=0, vkccnt=0, ksm=0, mh, mv;
    KernPair *kp;
    KernClass *kc;
    ASM *sm;

    cnt = mh = vcnt = mv = 0;
    for ( i=0; i<at->gi.gcnt; ++i ) if ( at->gi.bygid[i]!=-1 ) {
	j = 0;
	for ( kp = sf->glyphs[at->gi.bygid[i]]->kerns; kp!=NULL; kp=kp->next )
	    if ( kp->off!=0 && LookupHasDefault(kp->subtable->lookup ))
		++cnt, ++j;
	if ( j>mh ) mh=j;
	j=0;
	for ( kp = sf->glyphs[at->gi.bygid[i]]->vkerns; kp!=NULL; kp=kp->next )
	    if ( kp->off!=0 && LookupHasDefault(kp->subtable->lookup ))
		++vcnt, ++j;
	if ( j>mv ) mv=j;
    }
    kcnt->cnt = cnt;
    kcnt->vcnt = vcnt;
    kcnt->mh = mh;
    kcnt->mv = mv;
    kcnt->hbreaks = kcnt->vbreaks = NULL;
    if ( cnt>=10000 ) {
	/* the sub-table size is 6*cnt+14 or so and needs to be less 65535 */
	/*  so break it up into little bits */
	/* We might not need this when applemode is set because the subtable */
	/*  length is a long. BUT... there's a damn binsearch header with */
	/*  shorts in it still */
	int b=0;
	kcnt->hbreaks = galloc((at->gi.gcnt+1)*sizeof(int));
	cnt = 0;
	for ( i=0; i<at->gi.gcnt; ++i ) if ( at->gi.bygid[i]!=-1 ) {
	    j = 0;
	    for ( kp = sf->glyphs[at->gi.bygid[i]]->kerns; kp!=NULL; kp=kp->next )
		if ( kp->off!=0 && LookupHasDefault(kp->subtable->lookup ))
		    ++j;
	    if ( (cnt+j)*6>64000L && cnt!=0 ) {
		kcnt->hbreaks[b++] = cnt;
		cnt = 0;
	    }
	    cnt += j;
	}
	kcnt->hbreaks[b++] = cnt;
	kcnt->hsubs = b;
    } else if ( cnt!=0 )
	kcnt->hsubs = 1;
    else
	kcnt->hsubs = 0;
    if ( vcnt>=10000 ) {
	int b=0;
	kcnt->vbreaks = galloc((at->gi.gcnt+1)*sizeof(int));
	vcnt = 0;
	for ( i=0; i<at->gi.gcnt; ++i ) if ( at->gi.bygid[i]!=-1 ) {
	    j = 0;
	    for ( kp = sf->glyphs[at->gi.bygid[i]]->vkerns; kp!=NULL; kp=kp->next )
		if ( kp->off!=0 && LookupHasDefault(kp->subtable->lookup))
		    ++j;
	    if ( (vcnt+j)*6>64000L && vcnt!=0 ) {
		kcnt->vbreaks[b++] = vcnt;
		vcnt = 0;
	    }
	    vcnt += j;
	}
	kcnt->vbreaks[b++] = vcnt;
	kcnt->vsubs = b;
    } else if ( vcnt!=0 )
	kcnt->vsubs = 1;
    else
	kcnt->vsubs = 0;

    if ( at->applemode ) {	/* if we aren't outputting Apple's extensions to kerning (by classes, and by state machine) then don't check for those extensions */
	for ( kc=sf->kerns; kc!=NULL; kc = kc->next ) if ( LookupHasDefault(kc->subtable->lookup) )
	    ++kccnt;
	for ( kc=sf->vkerns; kc!=NULL; kc = kc->next ) if ( LookupHasDefault(kc->subtable->lookup) )
	    ++vkccnt;
	for ( sm=sf->sm; sm!=NULL; sm=sm->next )
	    if ( sm->type == asm_kern )
		++ksm;
    }
    kcnt->kccnt = kccnt;
    kcnt->vkccnt = vkccnt;
    kcnt->ksm = ksm;
return( kcnt->hsubs + kcnt->vsubs + kccnt + vkccnt + ksm );
}

static void ttf_dumpsfkerns(struct alltabs *at, SplineFont *sf, int tupleIndex, int version) {
    struct kerncounts kcnt;
    int i, j, k, m, c, gid, tot, km;
    KernPair *kp;
    KernClass *kc;
    /*ASM *sm;*/
    uint16 *glnum, *offsets;
    int isv;
    int tupleMask = tupleIndex==-1 ? 0 : 0x2000;
    int b, bmax;
    int *breaks;

    if ( CountKerns(at,sf,&kcnt)==0 )
return;

    if ( tupleIndex==-1 ) tupleIndex = 0;
    
    for ( isv=0; isv<2; ++isv ) {
	c = isv ? kcnt.vcnt : kcnt.cnt;
	bmax = isv ? kcnt.vsubs : kcnt.hsubs;
	breaks = isv ? kcnt.vbreaks : kcnt.hbreaks;
	if ( c!=0 ) {
	    km = isv ? kcnt.mv : kcnt.mh;
	    glnum = galloc(km*sizeof(uint16));
	    offsets = galloc(km*sizeof(uint16));
	    gid = 0;
	    for ( b=0; b<bmax; ++b ) {
		c = bmax==1 ? c : breaks[b];
		if ( version==0 ) {
		    putshort(at->kern,0);		/* subtable version */
		    putshort(at->kern,(7+3*c)*sizeof(uint16)); /* subtable length */
		    putshort(at->kern,!isv);	/* coverage, flags=hor/vert&format=0 */
		} else {
		    putlong(at->kern,(8+3*c)*sizeof(uint16)); /* subtable length */
		    /* Apple's new format has a completely different coverage format */
		    putshort(at->kern,(isv?0x8000:0)| /* format 0, horizontal/vertical flags (coverage) */
				    tupleMask);
		    putshort(at->kern,tupleIndex);
		}
		putshort(at->kern,c);
		for ( i=1,j=0; i<=c; i<<=1, ++j );
		i>>=1; --j;
		putshort(at->kern,i*6);		/* binary search headers */
		putshort(at->kern,j);
		putshort(at->kern,6*(c-i));

		for ( tot = 0; gid<at->gi.gcnt && tot<c; ++gid ) if ( at->gi.bygid[gid]!=-1 ) {
		    SplineChar *sc = sf->glyphs[at->gi.bygid[gid]];
		    m = 0;
		    for ( kp = isv ? sc->vkerns : sc->kerns; kp!=NULL; kp=kp->next ) {
			if ( kp->off!=0 && LookupHasDefault(kp->subtable->lookup)) {
			    /* order the pairs */
			    for ( j=0; j<m; ++j )
				if ( kp->sc->ttf_glyph<glnum[j] )
			    break;
			    for ( k=m; k>j; --k ) {
				glnum[k] = glnum[k-1];
				offsets[k] = offsets[k-1];
			    }
			    glnum[j] = kp->sc->ttf_glyph;
			    offsets[j] = kp->off;
			    ++m;
			}
		    }
		    for ( j=0; j<m; ++j ) {
			putshort(at->kern,gid);
			putshort(at->kern,glnum[j]);
			putshort(at->kern,offsets[j]);
		    }
		    tot += m;
		}
	    }
	    free(offsets);
	    free(glnum);
	}
    }
    free(kcnt.hbreaks); free(kcnt.vbreaks);

    if ( at->applemode ) for ( isv=0; isv<2; ++isv ) {
	for ( kc=isv ? sf->vkerns : sf->kerns; kc!=NULL; kc=kc->next ) if ( LookupHasDefault(kc->subtable->lookup) ) {
	    /* If we are here, we must be using version 1 */
	    uint32 len_pos = ftell(at->kern), pos;
	    uint16 *class1, *class2;
	    int first_cnt = kc->first_cnt;

	    /* OpenType fonts can actually have a set of glyphs in class[0] of*/
	    /*  the first class. This happens when there are glyphs in the */
	    /*  coverage table which are not in any of the classes. Otherwise */
	    /*  class 0 is sort of useless in opentype */
	    if ( kc->firsts[0]!=NULL )
		++first_cnt;

	    putlong(at->kern,0); /* subtable length */
	    putshort(at->kern,(isv?0x8002:2)|	/* format 2, horizontal/vertical flags (coverage) */
			    tupleMask);
	    putshort(at->kern,tupleIndex);

	    putshort(at->kern,sizeof(uint16)*kc->second_cnt);
	    putshort(at->kern,0);		/* left classes */
	    putshort(at->kern,0);		/* right classes */
	    putshort(at->kern,16);		/* Offset to array, next byte */

	    if ( kc->firsts[0]!=NULL ) {
		/* Create a dummy class to correspond to the mac's class 0 */
		/*  all entries will be 0 */
		for ( i=0 ; i<kc->second_cnt; ++i )
		    putshort(at->kern,0);
	    }
	    for ( i=0; i<kc->first_cnt*kc->second_cnt; ++i )
		putshort(at->kern,kc->offsets[i]);

	    pos = ftell(at->kern);
	    fseek(at->kern,len_pos+10,SEEK_SET);
	    putshort(at->kern,pos-len_pos);
	    fseek(at->kern,pos,SEEK_SET);
	    class1 = ClassesFromNames(sf,kc->firsts,kc->first_cnt,at->maxp.numGlyphs,NULL,true);
	    DumpKernClass(at->kern,class1,at->maxp.numGlyphs,16,sizeof(uint16)*kc->second_cnt);
	    free(class1);

	    pos = ftell(at->kern);
	    fseek(at->kern,len_pos+12,SEEK_SET);
	    putshort(at->kern,pos-len_pos);
	    fseek(at->kern,pos,SEEK_SET);
	    class2 = ClassesFromNames(sf,kc->seconds,kc->second_cnt,at->maxp.numGlyphs,NULL,true);
	    DumpKernClass(at->kern,class2,at->maxp.numGlyphs,0,sizeof(uint16));
	    free(class2);

	    pos = ftell(at->kern);
	    fseek(at->kern,len_pos,SEEK_SET);
	    putlong(at->kern,pos-len_pos);
	    fseek(at->kern,pos,SEEK_SET);
	}
    }

    if ( at->applemode ) if ( kcnt.ksm!=0 ) {
#ifndef LUA_FF_LIB
	for ( sm=sf->sm; sm!=NULL; sm=sm->next ) if ( sm->type == asm_kern ) {
	    uint32 len_pos = ftell(at->kern), pos;

	    putlong(at->kern,0); 		/* subtable length */
	    putshort(at->kern,((sm->flags&0x8000)?0x8001:1)|	/* format 1, horizontal/vertical flags (coverage) */
			    tupleMask);
	    putshort(at->kern,tupleIndex);
	    morx_dumpASM(at->kern,sm,at,sf);

	    pos = ftell(at->kern);
	    fseek(at->kern,len_pos,SEEK_SET);
	    putlong(at->kern,pos-len_pos);
	    fseek(at->kern,pos,SEEK_SET);
	}
#endif
    }
}

void ttf_dumpkerns(struct alltabs *at, SplineFont *sf) {
    int i, mmcnt=0, sum;
    int version;
    MMSet *mm = at->dovariations ? sf->mm : NULL;
    struct kerncounts kcnt;
    int must_use_old_style = 0;

    if ( !at->applemode && (!at->opentypemode || (at->gi.flags&ttf_flag_oldkern)) ) {
	must_use_old_style = true;
	SFKernClassTempDecompose(sf,false);
	mm = NULL;
    } else {
	if ( mm!=NULL ) {
	    for ( i=0; i<mm->instance_count; ++i ) {
		mmcnt += CountKerns(at,mm->instances[i],&kcnt);
		free(kcnt.hbreaks); free(kcnt.vbreaks);
	    }
	    sf = mm->normal;
	}
    }

    sum = CountKerns(at,sf,&kcnt);
    free(kcnt.hbreaks); free(kcnt.vbreaks);
    if ( sum==0 && mmcnt==0 ) {
	if ( must_use_old_style )
	    SFKernCleanup(sf,false);
return;
    }

    /* Old kerning format (version 0) uses 16 bit quantities */
    /* Apple's new format (version 0x00010000) uses 32 bit quantities */
    at->kern = tmpfile();
    if ( must_use_old_style  ||
	    ( kcnt.kccnt==0 && kcnt.vkccnt==0 && kcnt.ksm==0 && mmcnt==0 )) {
	/* MS does not support format 1,2,3 kern sub-tables so if we have them */
	/*  we might as well admit that this table is for apple only and use */
	/*  the new format apple recommends. Otherwise, use the old format */
	/* If we might need to store tuple data, use the new format */
	putshort(at->kern,0);			/* version */
	putshort(at->kern,sum);			/* number of subtables */
	version = 0;
    } else {
	putlong(at->kern,0x00010000);		/* version */
	putlong(at->kern,sum+mmcnt);		/* number of subtables */
	version = 1;
    }

    ttf_dumpsfkerns(at, sf, -1, version);
    if ( mm!=NULL ) {
	for ( i=0; i<mm->instance_count; ++i )
	    ttf_dumpsfkerns(at, mm->instances[i], i, version);
    }
    if ( must_use_old_style )
	SFKernCleanup(sf,false);

    at->kernlen = ftell(at->kern);
    if ( at->kernlen&2 )
	putshort(at->kern,0);		/* pad it */
}


int LookupHasDefault(OTLookup *otl) {
    FeatureScriptLangList *feats;

    if ( otl->def_lang_checked )
return( otl->def_lang_found );

    otl->def_lang_checked = true;
    for ( feats=otl->features; feats!=NULL; feats = feats->next ) {
	if ( scriptsHaveDefault(feats->scripts) ) {
	    otl->def_lang_found = true;
return( true );
	}
    }
    otl->def_lang_found = false;
return( false );
}


/* from sfd1.c, full */

enum uni_interp interp_from_encoding(Encoding *enc,enum uni_interp interp) {

    if ( enc==NULL )
return( interp );

    if ( enc->is_japanese )
	interp = ui_japanese;
    else if ( enc->is_korean )
	interp = ui_korean;
    else if ( enc->is_tradchinese )
	interp = ui_trad_chinese;
    else if ( enc->is_simplechinese )
	interp = ui_simp_chinese;
return( interp );
}

/* from bitmapview.c */

void BCCharChangedUpdate(BDFChar *bc) {
  /* full */
  bc->changed = true;
}

BDFChar *BDFMakeGID(BDFFont *bdf,int gid) {
    SplineFont *sf=bdf->sf;
    SplineChar *sc;
    BDFChar *bc;
    int i;

    if ( gid==-1 )
return( NULL );

    if ( sf->cidmaster!=NULL || sf->subfonts!=NULL ) {
	int j = SFHasCID(sf,gid);
	if ( sf->cidmaster ) sf = sf->cidmaster;
	if ( j==-1 ) {
	    for ( j=0; j<sf->subfontcnt; ++j )
		if ( gid<sf->subfonts[j]->glyphcnt )
	    break;
	    if ( j==sf->subfontcnt )
return( NULL );
	}
	sf = sf->subfonts[j];
    }
    if ( (sc = sf->glyphs[gid])==NULL )
return( NULL );

    if ( gid>=bdf->glyphcnt ) {
	if ( gid>=bdf->glyphmax )
	    bdf->glyphs = grealloc(bdf->glyphs,(bdf->glyphmax=sf->glyphmax)*sizeof(BDFChar *));
	for ( i=bdf->glyphcnt; i<=gid; ++i )
	    bdf->glyphs[i] = NULL;
	bdf->glyphcnt = sf->glyphcnt;
    }
    if ( (bc = bdf->glyphs[gid])==NULL ) {
#ifndef LUA_FF_LIB
	if ( bc!=NULL )
	    /* Done */;
	else if ( bdf->clut==NULL )
	    bc = SplineCharRasterize(sc,bdf->pixelsize);
	else
	    bc = SplineCharAntiAlias(sc,bdf->pixelsize,BDFDepth(bdf));
#endif
	bdf->glyphs[gid] = bc;
	bc->orig_pos = gid;
	BCCharChangedUpdate(bc);
    }
return( bc );
}

BDFChar *BDFMakeChar(BDFFont *bdf,EncMap *map,int enc) {
    SplineFont *sf=bdf->sf;

    if ( enc==-1 )
return( NULL );

    if ( sf->cidmaster!=NULL ) {
	int j = SFHasCID(sf,enc);
	sf = sf->cidmaster;
	if ( j==-1 ) {
	    for ( j=0; j<sf->subfontcnt; ++j )
		if ( enc<sf->subfonts[j]->glyphcnt )
	    break;
	    if ( j==sf->subfontcnt )
return( NULL );
	}
	sf = sf->subfonts[j];
    }
    SFMakeChar(sf,map,enc);
return( BDFMakeGID(bdf,map->map[enc]));
}

/* splinesaveafm.c */

int SCDrawsSomething(SplineChar *sc) {
    int layer,l;
    RefChar *ref;

    if ( sc==NULL )
return( false );
    for ( layer = ly_fore; layer<sc->layer_cnt; ++layer ) {
	if ( sc->layers[layer].splines!=NULL || sc->layers[layer].images!=NULL )
return( true );
	for ( ref = sc->layers[layer].refs; ref!=NULL; ref=ref->next )
	    for ( l=0; l<ref->layer_cnt; ++l )
		if ( ref->layers[l].splines!=NULL )
return( true );
    }
return( false );
}

int SCWorthOutputting(SplineChar *sc) {
return( sc!=NULL &&
	( SCDrawsSomething(sc) || sc->widthset || sc->anchor!=NULL ||
#if HANYANG
	    sc->compositionunit ||
#endif
	    sc->dependents!=NULL /*||
	    sc->width!=sc->parent->ascent+sc->parent->descent*/ ) );
}

void SFKernCleanup(SplineFont *sf,int isv) {
    int i;
    KernPair *kp, *p, *n;
    OTLookup *otl, *otlp, *otln;

    if ( (!isv && sf->kerns==NULL) || (isv && sf->vkerns==NULL) )	/* can't have gotten messed up */
return;
    for ( i=0; i<sf->glyphcnt; ++i ) if ( sf->glyphs[i]!=NULL ) {
	for ( kp = isv ? sf->glyphs[i]->vkerns : sf->glyphs[i]->kerns, p=NULL; kp!=NULL; kp = n ) {
	    n = kp->next;
	    if ( kp->kcid!=0 ) {
		if ( p!=NULL )
		    p->next = n;
		else if ( isv )
		    sf->glyphs[i]->vkerns = n;
		else
		    sf->glyphs[i]->kerns = n;
		chunkfree(kp,sizeof(*kp));
	    } else
		p = kp;
	}
    }
    for ( otl=sf->gpos_lookups, otlp = NULL; otl!=NULL; otl = otln ) {
	otln = otl->next;
	if ( otl->temporary_kern ) {
	    if ( otlp!=NULL )
		otlp->next = otln;
	    else
		sf->gpos_lookups = otln;
	    OTLookupFree(otl);
	} else
	    otlp = otl;
    }
}


static void KCSfree(SplineChar ***scs,int cnt) {
    int i;
    for ( i=1; i<cnt; ++i )
	free( scs[i]);
    free(scs);
}

static SplineChar ***KernClassToSC(SplineFont *sf, char **classnames, int cnt) {
    SplineChar ***scs, *sc;
    int i,j;
    char *pt, *end, ch;

    scs = galloc(cnt*sizeof(SplineChar **));
    for ( i=1; i<cnt; ++i ) {
	for ( pt=classnames[i]-1, j=0; pt!=NULL; pt=strchr(pt+1,' ') )
	    ++j;
	scs[i] = galloc((j+1)*sizeof(SplineChar *));
	for ( pt=classnames[i], j=0; *pt!='\0'; pt=end+1 ) {
	    end = strchr(pt,' ');
	    if ( end==NULL )
		end = pt+strlen(pt);
	    ch = *end;
	    *end = '\0';
	    sc = SFGetChar(sf,-1,pt);
	    if ( sc!=NULL )
		scs[i][j++] = sc;
	    if ( ch=='\0' )
	break;
	    *end = ch;
	}
	scs[i][j] = NULL;
    }
return( scs );
}

static void AddTempKP(SplineChar *first,SplineChar *second,
	int16 offset, struct lookup_subtable *sub,uint16 kcid,int isv) {
    KernPair *kp;

    for ( kp=first->kerns; kp!=NULL; kp=kp->next )
	if ( kp->sc == second )
    break;
    if ( kp==NULL ) {
	kp = chunkalloc(sizeof(KernPair));
	kp->sc = second;
	kp->off = offset;
	kp->subtable = sub;
	kp->kcid = kcid;
	if ( isv ) {
	    kp->next = first->vkerns;
	    first->vkerns = kp;
	} else {
	    kp->next = first->kerns;
	    first->kerns = kp;
	}
    }
}


void SFKernClassTempDecompose(SplineFont *sf,int isv) {
    KernClass *kc, *head= isv ? sf->vkerns : sf->kerns;
    SplineChar ***first, ***last;
    int i, j, k, l;
    OTLookup *otl;

    for ( kc = head, i=0; kc!=NULL; kc = kc->next )
	kc->kcid = ++i;
    for ( kc = head; kc!=NULL; kc = kc->next ) {

	otl = chunkalloc(sizeof(OTLookup));
	otl->next = sf->gpos_lookups;
	sf->gpos_lookups = otl;
	otl->lookup_type = gpos_pair;
	otl->lookup_flags = kc->subtable->lookup->lookup_flags;
	otl->features = FeatureListCopy(kc->subtable->lookup->features);
	otl->lookup_name = copy(_("<Temporary kerning>"));
	otl->temporary_kern = otl->store_in_afm = true;
	otl->subtables = chunkalloc(sizeof(struct lookup_subtable));
	otl->subtables->lookup = otl;
	otl->subtables->per_glyph_pst_or_kern = true;
	otl->subtables->subtable_name = copy(_("<Temporary kerning>"));

	first = KernClassToSC(sf,kc->firsts,kc->first_cnt);
	last = KernClassToSC(sf,kc->seconds,kc->second_cnt);
	for ( i=1; i<kc->first_cnt; ++i ) for ( j=1; j<kc->second_cnt; ++j ) {
	    if ( kc->offsets[i*kc->second_cnt+j]!=0 ) {
		for ( k=0; first[i][k]!=NULL; ++k )
		    for ( l=0; last[j][l]!=NULL; ++l )
			AddTempKP(first[i][k],last[j][l],
				kc->offsets[i*kc->second_cnt+j],
			        otl->subtables,kc->kcid,isv);
	    }
	}
	KCSfree(first,kc->first_cnt);
	KCSfree(last,kc->second_cnt);
    }
}

int SFFindNotdef(SplineFont *sf, int fixed) {
    int notdefpos = -1, i, width=-1;
    /* If all glyphs have the same known width set fixed to it */
    /* If glyphs are proportional set fixed to -1 */
    /* If we don't know yet, set fixed to -2 */

    if ( fixed==-2 ) {          /* Unknown */
        for ( i=0; i<sf->glyphcnt; ++i ) if ( SCWorthOutputting(sf->glyphs[i]) ) {
            if ( strcmp(sf->glyphs[i]->name,".notdef")==0 ) {
                if ( notdefpos==-1 ) notdefpos = i;
            } else if ( width==-1 )
                width = sf->glyphs[i]->width;
            else if ( width!=sf->glyphs[i]->width )
                width = -2;
        }
        if ( width>=0 && sf->glyphcnt>2 && notdefpos>=0) {
            if ( width!=sf->glyphs[notdefpos]->width ) {
                notdefpos = -1;
                for ( i=0; i<sf->glyphcnt; ++i ) if ( SCWorthOutputting(sf->glyphs[i]) ) {
                    if ( strcmp(sf->glyphs[i]->name,".notdef")==0 &&
                            sf->glyphs[i]->width == width ) {
                        notdefpos = i;
                break;
                    }
                }
            }
        }
    } else if ( fixed>=0 ) {            /* Known, fixed width */

        for ( i=0; i<sf->glyphcnt; ++i ) if ( SCWorthOutputting(sf->glyphs[i]) ) {
            if ( strcmp(sf->glyphs[i]->name,".notdef")==0 &&
                    sf->glyphs[i]->width == fixed )
return( i );
        }
    } else {                            /* Known, variable width */
        for ( i=0; i<sf->glyphcnt; ++i ) if ( SCWorthOutputting(sf->glyphs[i]) ) {
            if ( strcmp(sf->glyphs[i]->name,".notdef")==0 )
return( i );
        }
    }

return( notdefpos );
}


#ifdef LUA_FF_LIB
/* no need for iconv here, since PS is 8-bit legacy */
#define Isspace(a) ((a)==' '|| ((a) >= '\t' &&  (a) <= '\r'))
#define Isdigit(a) ((a)>='0' && (a)<='9')
#define Isalpha(a) (((a)>='a' && (a)<='z') || ((a)>='A' && (a)<='Z'))
#define Isupper(a) ((a)>='A' && (a)<='Z')
#define Isalnum(a) (Isalpha(a)||Isdigit(a))
#define Ishexdigit(a) (((a)>='0' && (a)<='9')||((a)>='a' && (a)<='f')||((a)>='A' && (a)<='F'))
#else
#define Isspace isspace
#define Isdigit isdigit
#define Isalpha isalpha
#define Isupper isupper
#define Isalnum isalnum
#define Ishexdigit ishexdigit
#endif




int CheckAfmOfPostscript(SplineFont *sf,char *psname, EncMap *map) {
    char *new, *pt;
    int ret;
    int wasuc=false;

    new = galloc(strlen(psname)+6);
    strcpy(new,psname);
    pt = strrchr(new,'.');
    if ( pt==NULL ) pt = new+strlen(new);
    else wasuc = Isupper(pt[1]);

    if ( sf->mm!=NULL ) {
	strcpy(pt,wasuc?".AMFM":".amfm");
	if ( !LoadKerningDataFromAmfm(sf,new,map)) {
	    strcpy(pt,wasuc?".amfm":".AMFM");
	    ret = LoadKerningDataFromAmfm(sf,new,map);
	} else
	    ret = true;
	/* The above routine reads from the afm file if one exist */
    } else {
	strcpy(pt,wasuc?".AFM":".afm");
	if ( !LoadKerningDataFromAfm(sf,new,map)) {
	    strcpy(pt,wasuc?".afm":".AFM");
	    ret = LoadKerningDataFromAfm(sf,new,map);
	} else
	    ret = true;
    }
    free(new);
return( ret );
}

static void *mygets(FILE *file,char *buffer,int size) {
    char *end = buffer+size-1;
    char *pt = buffer;
    int ch;

    while ( (ch=getc(file))!=EOF && ch!='\r' && ch!='\n' && pt<end )
	*pt++ = ch;
    *pt = '\0';
    if ( ch==EOF && pt==buffer )
return( NULL );
    if ( ch=='\r' ) {
	ch = getc(file);
	if ( ch!='\n' )
	    ungetc(ch,file);
    }
return( buffer );
}


/* ************************************************************************** */
/* **************************** Reading AFM files *************************** */
/* ************************************************************************** */
static void KPInsert( SplineChar *sc1, SplineChar *sc2, int off, int isv ) {
    KernPair *kp;
    int32 script;

    if ( sc1!=NULL && sc2!=NULL ) {
	for ( kp=sc1->kerns; kp!=NULL && kp->sc!=sc2; kp = kp->next );
	if ( kp!=NULL )
	    kp->off = off;
	else if ( off!=0 ) {
	    kp = chunkalloc(sizeof(KernPair));
	    kp->sc = sc2;
	    kp->off = off;
	    script = SCScriptFromUnicode(sc1);
	    if ( script==DEFAULT_SCRIPT )
		script = SCScriptFromUnicode(sc2);
	    kp->subtable = SFSubTableFindOrMake(sc1->parent,
		    isv?CHR('v','k','r','n'):CHR('k','e','r','n'),
		    script, gpos_pair);
	    if ( isv ) {
		kp->next = sc1->vkerns;
		sc1->vkerns = kp;
	    } else {
		kp->next = sc1->kerns;
		sc1->kerns = kp;
	    }
	}
    }
}

int LoadKerningDataFromAfm(SplineFont *sf, char *filename,EncMap *map) {
    FILE *file = fopen(filename,"r");
    char buffer[200], *pt, *ept, ch;
    SplineChar *sc1, *sc2;
    int off, lx, ly, rx, ry;
    char name[44], second[44], lig[44], buf2[100];
    PST *liga;
    double scale = (sf->ascent+sf->descent)/1000.0;

    if ( file==NULL )
return( 0 );
    gwwv_progress_change_line2(_("Reading AFM file"));
    while ( mygets(file,buffer,sizeof(buffer))!=NULL ) {
	if ( strncmp(buffer,"KPX",3)==0 || strncmp(buffer,"KPY",3)==0 ) {
	    int isv = strncmp(buffer,"KPY",3)==0;
	    for ( pt=buffer+3; Isspace(*pt); ++pt);
	    for ( ept = pt; *ept!='\0' && !Isspace(*ept); ++ept );
	    ch = *ept; *ept = '\0';
	    sc1 = SFGetChar(sf,-1,pt);
	    *ept = ch;
	    for ( pt=ept; Isspace(*pt); ++pt);
	    for ( ept = pt; *ept!='\0' && !Isspace(*ept); ++ept );
	    ch = *ept; *ept = '\0';
	    sc2 = SFGetChar(sf,-1,pt);
	    *ept = ch;
	    off = strtol(ept,NULL,10);
	    KPInsert(sc1,sc2,rint(off*scale),isv);
	} else if ( buffer[0]=='C' && Isspace(buffer[1])) {
	    char *pt;
	    sc2 = NULL;
	    for ( pt= strchr(buffer,';'); pt!=NULL; pt=strchr(pt+1,';') ) {
		  if ( sscanf( pt, "; N %40s", name )==1 )
		    sc2 = SFGetChar(sf,-1,name);
		  else if ( sc2!=NULL &&
					sscanf( pt, "; B %d %d %d %d", &lx, &ly, &rx, &ry)==4 ) {
			sc2->xmin = lx;
			sc2->ymin = ly;
			sc2->xmax = rx;
			sc2->ymax = ry;

		  } 
		  else if ( sc2!=NULL &&
			sscanf( pt, "; L %40s %40s", second, lig)==2 ) {
		    sc1 = SFGetChar(sf,-1,lig);
		    if ( sc1!=NULL ) {
			sprintf( buf2, "%s %s", name, second);
			for ( liga=sc1->possub; liga!=NULL; liga=liga->next ) {
			    if ( liga->type == pst_ligature && strcmp(liga->u.lig.components,buf2)==0 )
			break;
			}
			if ( liga==NULL ) {
			    liga = chunkalloc(sizeof(PST));
			    liga->subtable = SFSubTableFindOrMake(sf,
				    CHR('l','i','g','a'),SCScriptFromUnicode(sc2),
				    gsub_ligature);
			    liga->subtable->lookup->store_in_afm = true;
			    liga->type = pst_ligature;
			    liga->next = sc1->possub;
			    sc1->possub = liga;
			    liga->u.lig.lig = sc1;
			    liga->u.lig.components = copy( buf2 );
			}
		    }
		}
	    }
	}
    }
    fclose(file);
return( 1 );
}

static void CheckMMAfmFile(SplineFont *sf,char *amfm_filename,char *fontname,EncMap *map) {
    /* the afm file should be in the same directory as the amfm file */
    /*  with the fontname as the filename */
    char *temp, *pt;

    free(sf->fontname);
    sf->fontname = copy(fontname);

    temp = galloc(strlen(amfm_filename)+strlen(fontname)+strlen(".afm")+1);
    strcpy(temp, amfm_filename);
    pt = strrchr(temp,'/');
    if ( pt==NULL ) pt = temp;
    else ++pt;
    strcpy(pt,fontname);
    pt += strlen(pt);
    strcpy(pt,".afm");
    if ( !LoadKerningDataFromAfm(sf,temp,map) ) {
	strcpy(pt,".AFM");
	LoadKerningDataFromAfm(sf,temp,map);
    }
    free(temp);
}

int LoadKerningDataFromAmfm(SplineFont *sf, char *filename,EncMap *map) {
    FILE *file=NULL;
    char buffer[280], *pt, lastname[257];
    int index, i;
    MMSet *mm = sf->mm;

    if ( mm!=NULL )
	file = fopen(filename,"r");
    pt = strstrmatch(filename,".amfm");
    if ( pt!=NULL ) {
	char *afmname = copy(filename);
	strcpy(afmname+(pt-filename),Isupper(pt[1])?".AFM":".afm");
	LoadKerningDataFromAfm(mm->normal,afmname,map);
	free(afmname);
    }
    if ( file==NULL )
return( 0 );

#if defined(FONTFORGE_CONFIG_GDRAW)
    gwwv_progress_change_line2(_("Reading AFM file"));
#elif defined(FONTFORGE_CONFIG_GTK)
    gwwv_progress_change_line2(_("Reading AFM file"));
#endif
    while ( fgets(buffer,sizeof(buffer),file)!=NULL ) {
	if ( strstrmatch(buffer,"StartMaster")!=NULL )
    break;
    }
    index = -1; lastname[0] = '\0';
    while ( fgets(buffer,sizeof(buffer),file)!=NULL ) {
	if ( strstrmatch(buffer,"EndMaster")!=NULL ) {
	    if ( lastname[0]!='\0' && index!=-1 && index<mm->instance_count )
		CheckMMAfmFile(mm->instances[index],filename,lastname,map);
	    index = -1; lastname[0] = '\0';
	} else if ( sscanf(buffer,"FontName %256s", lastname )== 1 ) {
	    /* Do Nothing, all done */
	} else if ( (pt = strstr(buffer,"WeightVector"))!=NULL ) {
	    pt += strlen("WeightVector");
	    while ( *pt==' ' || *pt=='[' ) ++pt;
	    i = 0;
	    while ( *pt!=']' && *pt!='\0' ) {
		if ( *pt=='0' )
		    ++i;
		else if ( *pt=='1' ) {
		    index = i;
	    break;
		}
		++pt;
	    }
	}
    }
    fclose(file);
return( true );
}


/* from tottfgpos.c */

#if 0 
static uint32 scripts[][15] = {
/* Arabic */	{ CHR('a','r','a','b'), 0x0600, 0x06ff, 0xfb50, 0xfdff, 0xfe70, 0xfeff },
/* Aramaic */	{ CHR('a','r','a','m'), 0x820, 0x83f },
/* Armenian */	{ CHR('a','r','m','n'), 0x0530, 0x058f, 0xfb13, 0xfb17 },
/* Balinese */	{ CHR('b','a','l','i'), 0x1b00, 0x1b7f },
/* Bengali */	{ CHR('b','e','n','g'), 0x0980, 0x09ff },
/* Bliss symb */{ CHR('b','l','i','s'), 0x12200, 0x124ff },
/* Bopomofo */	{ CHR('b','o','p','o'), 0x3100, 0x312f, 0x31a0, 0x31bf },
/* Braille */	{ CHR('b','r','a','i'), 0x2800, 0x28ff },
/* Buginese */	{ CHR('b','u','g','i'), 0x1a00, 0x1a1f },
/* Buhid */	{ CHR('b','u','h','d'), 0x1740, 0x1753 },
/* Byzantine M*/{ CHR('b','y','z','m'), 0x1d000, 0x1d0ff },
/* Canadian Syl*/{CHR('c','a','n','s'), 0x1400, 0x167f },
/* Cherokee */	{ CHR('c','h','e','r'), 0x13a0, 0x13ff },
/* Cirth */	{ CHR('c','i','r','t'), 0x12080, 0x120ff },
/* CJKIdeogra */{ CHR('h','a','n','i'), 0x3300, 0x9fff, 0xf900, 0xfaff, 0x020000, 0x02ffff },
/* Coptic */	{ CHR('c','o','p','t'), 0x2c80, 0x2cff },
/* Cypriot */	{ CHR('c','p','m','n'), 0x10800, 0x1083f },
/* Cyrillic */	{ CHR('c','y','r','l'), 0x0400, 0x052f },
/* Deseret */	{ CHR('d','s','r','t'), 0x10400, 0x1044f },
/* Devanagari */{ CHR('d','e','v','a'), 0x0900, 0x097f },
/* Ethiopic */	{ CHR('e','t','h','i'), 0x1200, 0x139f },
/* Georgian */	{ CHR('g','e','o','r'), 0x1080, 0x10ff },
/* Glagolitic */{ CHR('g','l','a','g'), 0x1080, 0x10ff },
/* Gothic */	{ CHR('g','o','t','h'), 0x10330, 0x1034a },
/* Greek */	{ CHR('g','r','e','k'), 0x0370, 0x03ff, 0x1f00, 0x1fff },
/* Gujarati */	{ CHR('g','u','j','r'), 0x0a80, 0x0aff },
/* Gurmukhi */	{ CHR('g','u','r','u'), 0x0a00, 0x0a7f },
/* Hangul */	{ CHR('h','a','n','g'), 0xac00, 0xd7af, 0x3130, 0x319f, 0xffa0, 0xff9f },
/* Hanunoo */	{ CHR('h','a','n','o'), 0x1720, 0x1734 },
 /* I'm not sure what the difference is between the 'hang' tag and the 'jamo' */
 /*  tag. 'Jamo' is said to be the precomposed forms, but what's 'hang'? */
/* Hebrew */	{ CHR('h','e','b','r'), 0x0590, 0x05ff, 0xfb1e, 0xfb4f },
#if 0	/* Hiragana used to have its own tag, but has since been merged with katakana */
/* Hiragana */	{ CHR('h','i','r','a'), 0x3040, 0x309f },
#endif
/* Hangul Jamo*/{ CHR('j','a','m','o'), 0x1100, 0x11ff, 0x3130, 0x319f, 0xffa0, 0xffdf },
/* Katakana */	{ CHR('k','a','n','a'), 0x3040, 0x30ff, 0xff60, 0xff9f },
/* Javanese */	{ CHR('j','a','v','a'), 0 },	/* MS has a tag, but there is no unicode range */
/* Khmer */	{ CHR('k','h','m','r'), 0x1780, 0x17ff },
/* Kannada */	{ CHR('k','n','d','a'), 0x0c80, 0x0cff },
/* Kharosthi */	{ CHR('k','h','a','r'), 0x10a00, 0x10a5f },
/* Latin */	{ CHR('l','a','t','n'), 0x0041, 0x005a, 0x0061, 0x007a,
	0x00c0, 0x02af, 0x1d00, 0x1eff, 0xfb00, 0xfb0f, 0xff00, 0xff5f, 0, 0 },
/* Lao */	{ CHR('l','a','o',' '), 0x0e80, 0x0eff },
/* Limbu */	{ CHR('l','i','m','b'), 0x1900, 0x194f },
/* Linear A */	{ CHR('l','i','n','a'), 0x10180, 0x102cf },
/* Linear B */	{ CHR('l','i','n','b'), 0x10000, 0x100fa },
/* Malayalam */	{ CHR('m','l','y','m'), 0x0d00, 0x0d7f },
/* Mathematical Alphanumeric Symbols */
		{ CHR('m','a','t','h'), 0x1d400, 0x1d7ff },
/* Mongolian */	{ CHR('m','o','n','g'), 0x1800, 0x18af },
/* Musical */	{ CHR('m','u','s','i'), 0x1d100, 0x1d1ff },
/* Myanmar */	{ CHR('m','y','m','r'), 0x1000, 0x107f },
/* N'Ko */	{ CHR('n','k','o',' '), 0x07c0, 0x07fa },
/* Ogham */	{ CHR('o','g','a','m'), 0x1680, 0x169f },
/* Old Italic */{ CHR('i','t','a','l'), 0x10300, 0x1031e },
/* Old Permic */{ CHR('p','e','r','m'), 0x10350, 0x1037f },
/* Old Persian cuneiform */
		{ CHR('x','p','e','o'), 0x103a0, 0x103df },
/* Oriya */	{ CHR('o','r','y','a'), 0x0b00, 0x0b7f },
/* Osmanya */	{ CHR('o','s','m','a'), 0x10480, 0x104a9 },
/* Phags-pa */	{ CHR('p','h','a','g'), 0xa840, 0xa87f },
/* Phoenician */{ CHR('p','h','n','x'), 0x10900, 0x1091f },
/* Pollard */	{ CHR('p','l','r','d'), 0x104b0, 0x104d9 },
/* Runic */	{ CHR('r','u','n','r'), 0x16a0, 0x16ff },
/* Shavian */	{ CHR('s','h','a','w'), 0x10450, 0x1047f },
/* Sinhala */	{ CHR('s','i','n','h'), 0x0d80, 0x0dff },
/* Sumero-Akkadian Cuneiform */
		{ CHR('x','s','u','x'), 0x12000, 0x1236e },
/* Syloti Nagri */
		{ CHR('s','y','l','o'), 0xa800, 0xa82f },
/* Syriac */	{ CHR('s','y','r','c'), 0x0700, 0x074f },
/* Tagalog */	{ CHR('t','a','g','l'), 0x1700, 0x1714 },
/* Tagbanwa */	{ CHR('t','a','g','b'), 0x1760, 0x1773 },
/* Tai Le */	{ CHR('t','a','l','e'), 0x1950, 0x1974 },
/* Tai Lu */	{ CHR('t','a','l','u'), 0x1980, 0x19df },
/* Tamil */	{ CHR('t','a','m','l'), 0x0b80, 0x0bff },
/* Telugu */	{ CHR('t','e','l','u'), 0x0c00, 0x0c7f },
/* Tengwar */	{ CHR('t','e','n','g'), 0x12000, 0x1207f },
/* Thaana */	{ CHR('t','h','a','a'), 0x0780, 0x07bf },
/* Thai */	{ CHR('t','h','a','i'), 0x0e00, 0x0e7f },
/* Tibetan */	{ CHR('t','i','b','t'), 0x0f00, 0x0fff },
/* Tifinagh */	{ CHR('t','f','n','g'), 0x2d30, 0x2d7f },
/* Ugaritic */	{ CHR('u','g','a','r'), 0x10380, 0x1039d },
/* Yi */	{ CHR('y','i',' ',' '), 0xa000, 0xa4c6 },
		{ 0 }
};

int ScriptIsRightToLeft(uint32 script) {
    if ( script==CHR('a','r','a','b') || script==CHR('h','e','b','r') ||
	    script==CHR('c','p','m','n') || script==CHR('k','h','a','r') ||
	    script==CHR('s','y','r','c') || script==CHR('t','h','a','a') ||
	    script==CHR('n','k','o',' '))
return( true );

return( false );
}

uint32 ScriptFromUnicode(int u,SplineFont *sf) {
    int s, k;

    if ( u!=-1 ) {
	for ( s=0; scripts[s][0]!=0; ++s ) {
	    for ( k=1; scripts[s][k+1]!=0; k += 2 )
		if ( u>=scripts[s][k] && u<=scripts[s][k+1] )
	    break;
	    if ( scripts[s][k+1]!=0 )
	break;
	}
	if ( scripts[s][0]!=0 ) {
	    extern int use_second_indic_scripts;
	    uint32 script = scripts[s][0];
	    if ( use_second_indic_scripts ) {
		/* MS has a parallel set of script tags for their new */
		/*  Indic font shaper */
		if ( script == CHR('b','e','n','g' )) script = CHR('b','n','g','2');
		else if ( script == CHR('d','e','v','a' )) script = CHR('d','e','v','2');
		else if ( script == CHR('g','u','j','r' )) script = CHR('g','j','r','2');
		else if ( script == CHR('g','u','r','u' )) script = CHR('g','u','r','2');
		else if ( script == CHR('k','n','d','a' )) script = CHR('k','n','d','2');
		else if ( script == CHR('m','l','y','m' )) script = CHR('m','l','y','2');
		else if ( script == CHR('o','r','y','a' )) script = CHR('o','r','y','2');
		else if ( script == CHR('t','a','m','l' )) script = CHR('t','m','l','2');
		else if ( script == CHR('t','e','l','u' )) script = CHR('t','e','l','2');
	    }
return( script );
	}
    } else if ( sf!=NULL ) {
	if ( sf->cidmaster!=NULL || sf->subfontcnt!=0 ) {
	    if ( sf->cidmaster!=NULL ) sf = sf->cidmaster;
	    if ( strmatch(sf->ordering,"Identity")==0 )
return( DEFAULT_SCRIPT );
	    else if ( strmatch(sf->ordering,"Korean")==0 )
return( CHR('h','a','n','g'));
	    else
return( CHR('h','a','n','i') );
	}
    }

return( DEFAULT_SCRIPT );
}

uint32 SCScriptFromUnicode(SplineChar *sc) {
    char *pt;
    PST *pst;
    SplineFont *sf;
    int i; unsigned uni;
    FeatureScriptLangList *features;

    if ( sc==NULL )
return( DEFAULT_SCRIPT );

    sf = sc->parent;
    if ( sc->unicodeenc!=-1 )
return( ScriptFromUnicode( sc->unicodeenc,sf ));

    pt = sc->name;
    if ( *pt ) for ( ++pt; *pt!='\0' && *pt!='_' && *pt!='.'; ++pt );
    if ( *pt!='\0' ) {
	char *str = copyn(sc->name,pt-sc->name);
	int uni = sf==NULL || sf->fv==NULL ? UniFromName(str,ui_none,&custom) :
			    UniFromName(str,sf->uni_interp,sf->fv->map->enc);
	free(str);
	if ( uni!=-1 )
return( ScriptFromUnicode( uni,sf ));
    }
    /* Adobe ligature uniXXXXXXXX */
    if ( strncmp(sc->name,"uni",3)==0 && sscanf(sc->name+3,"%4x", &uni)==1 )
return( ScriptFromUnicode( uni,sf ));

    if ( sf==NULL )
return( DEFAULT_SCRIPT );

    if ( sf->cidmaster ) sf=sf->cidmaster;
    else if ( sf->mm!=NULL ) sf=sf->mm->normal;
    for ( i=0; i<2; ++i ) {
	for ( pst=sc->possub; pst!=NULL; pst=pst->next ) {
	    if ( pst->type == pst_lcaret )
	continue;
	    for ( features = pst->subtable->lookup->features; features!=NULL; features=features->next ) {
		if ( features->scripts!=NULL )
return( features->scripts->script );
	    }
	}
    }
return( ScriptFromUnicode( sc->unicodeenc,sf ));
}

SplineChar **SFGlyphsFromNames(SplineFont *sf,char *names) {
    int cnt, ch;
    char *pt, *end;
    SplineChar *sc, **glyphs;

    cnt = 0;
    for ( pt = names; *pt; pt = end+1 ) {
	++cnt;
	end = strchr(pt,' ');
	if ( end==NULL )
    break;
    }

    glyphs = galloc((cnt+1)*sizeof(SplineChar *));
    cnt = 0;
    for ( pt = names; *pt; pt = end+1 ) {
	end = strchr(pt,' ');
	if ( end==NULL )
	    end = pt+strlen(pt);
	ch = *end;
	*end = '\0';
	sc = SFGetChar(sf,-1,pt);
	if ( sc!=NULL && sc->ttf_glyph!=-1 )
	    glyphs[cnt++] = sc;
	*end = ch;
	if ( ch=='\0' )
    break;
    }
    glyphs[cnt] = NULL;
return( glyphs );
}
int gdefclass(SplineChar *sc) {
    PST *pst;
    AnchorPoint *ap;

    if ( sc->glyph_class!=0 )
return( sc->glyph_class-1 );

    if ( strcmp(sc->name,".notdef")==0 )
return( 0 );

    for ( pst=sc->possub; pst!=NULL; pst=pst->next ) {
	if ( pst->type == pst_ligature )
return( 2 );			/* Ligature */
    }

    ap=sc->anchor;
    while ( ap!=NULL && (ap->type==at_centry || ap->type==at_cexit) )
	ap = ap->next;
    if ( ap!=NULL && (ap->type==at_mark || ap->type==at_basemark) )
return( 3 );
    else
return( 1 );
    /* I not quite sure what a componant glyph is. Probably something that */
    /*  is not in the cmap table and is referenced in other glyphs */
    /* Anyway I never return class 4 */ /* (I've never seen it used by others) */
}

#endif /* tottfgpos.c */

/* from charinfo.c */


static int MultipleValues(char *name, int local) {
#ifndef FONTFORGE_CONFIG_NO_WINDOWING_UI
#if defined(FONTFORGE_CONFIG_GDRAW)
    char *buts[3];
    buts[0] = _("_Yes"); buts[1]=_("_No"); buts[2] = NULL;
#elif defined(FONTFORGE_CONFIG_GTK)
    static char *buts[] = { GTK_STOCK_YES, GTK_STOCK_CANCEL, NULL };
#endif
    if ( gwwv_ask(_("Multiple"),(const char **) buts,0,1,_("There is already a glyph with this Unicode encoding\n(named %1$.40s, at local encoding %2$d).\nIs that what you want?"),name,local)==0 )
return( true );
#endif
return( false );
}

static int MultipleNames(void) {
#ifndef FONTFORGE_CONFIG_NO_WINDOWING_UI
#if defined(FONTFORGE_CONFIG_GDRAW)
    char *buts[3];
    buts[0] = _("_Yes"); buts[1]=_("_Cancel"); buts[2] = NULL;
#elif defined(FONTFORGE_CONFIG_GTK)
    static char *buts[] = { GTK_STOCK_YES, GTK_STOCK_CANCEL, NULL };
#endif
    if ( gwwv_ask(_("Multiple"),(const char **) buts,0,1,_("There is already a glyph with this name,\ndo you want to swap names?"))==0 )
return( true );
#endif
return( false );
}
		
int SCSetMetaData(SplineChar *sc,char *name,int unienc,const char *comment) {
    SplineFont *sf = sc->parent;
    int i, mv=0;
    int isnotdef, samename=false;
    struct altuni *alt;

    for ( alt=sc->altuni; alt!=NULL && alt->unienc!=unienc; alt=alt->next );
    if ( (sc->unicodeenc == unienc || alt!=NULL ) && strcmp(name,sc->name)==0 ) {
	samename = true;	/* No change, it must be good */
    }
    if ( alt!=NULL || !samename ) {
	isnotdef = strcmp(name,".notdef")==0;
	for ( i=0; i<sf->glyphcnt; ++i ) if ( sf->glyphs[i]!=NULL && sf->glyphs[i]!=sc ) {
	    if ( unienc!=-1 && sf->glyphs[i]->unicodeenc==unienc ) {
		if ( !mv && !MultipleValues(sf->glyphs[i]->name,i)) {
return( false );
		}
		mv = 1;
	    } else if ( !isnotdef && strcmp(name,sf->glyphs[i]->name)==0 ) {
		if ( !MultipleNames()) {
return( false );
		}
		free(sf->glyphs[i]->name);
		sf->glyphs[i]->namechanged = true;
		if ( strncmp(sc->name,"uni",3)==0 && sf->glyphs[i]->unicodeenc!=-1) {
		    char buffer[12];
		    if ( sf->glyphs[i]->unicodeenc<0x10000 )
			sprintf( buffer,"uni%04X", sf->glyphs[i]->unicodeenc);
		    else
			sprintf( buffer,"u%04X", sf->glyphs[i]->unicodeenc);
		    sf->glyphs[i]->name = copy(buffer);
		} else {
		    sf->glyphs[i]->name = sc->name;
		    sc->name = NULL;
		}
	    break;
	    }
	}
	if ( sc->unicodeenc!=unienc ) {
	    struct splinecharlist *scl;
	    int layer;
	    RefChar *ref;

	    for ( scl=sc->dependents; scl!=NULL; scl=scl->next ) {
		for ( layer=ly_fore; layer<scl->sc->layer_cnt; ++layer )
		    for ( ref = scl->sc->layers[layer].refs; ref!=NULL; ref=ref->next )
			if ( ref->sc==sc )
			    ref->unicode_enc = unienc;
	    }
	}
    }
    if ( alt!=NULL )
	alt->unienc = sc->unicodeenc;
    sc->unicodeenc = unienc;
    if ( sc->name==NULL || strcmp(name,sc->name)!=0 ) {
	free(sc->name);
	sc->name = copy(name);
	sc->namechanged = true;
	GlyphHashFree(sf);
    }
    sf->changed = true;
    if ( unienc>=0xe000 && unienc<=0xf8ff )
	/* Ok to name things in the private use area */;
    else if ( samename )
	/* Ok to name it itself */;
    else {
	FontView *fvs;
	for ( fvs=sf->fv; fvs!=NULL; fvs=fvs->nextsame ) {
	    int enc = fvs->map->backmap[sc->orig_pos];
	    if ( enc!=-1 && ((fvs->map->enc->only_1byte && enc<256) ||
			(fvs->map->enc->has_2byte && enc<65535 ))) {
		fvs->map->enc = &custom;
#ifndef FONTFORGE_CONFIG_NO_WINDOWING_UI
		FVSetTitle(fvs);
#endif		/* FONTFORGE_CONFIG_NO_WINDOWING_UI */
	    }
	}
    }
    free(sc->comment); sc->comment = NULL;
    if ( comment!=NULL && *comment!='\0' )
	sc->comment = copy(comment);

#ifndef FONTFORGE_CONFIG_NO_WINDOWING_UI
    SCRefreshTitles(sc);
#endif		/* FONTFORGE_CONFIG_NO_WINDOWING_UI */
return( true );
}

/* from cvhints.c */

void SCClearRounds(SplineChar *sc) {
    SplineSet *ss;
    SplinePoint *sp;

    for ( ss=sc->layers[ly_fore].splines; ss!=NULL; ss=ss->next ) {
	for ( sp=ss->first; ; ) {
	    sp->roundx = sp->roundy = false;
	    if ( sp->next==NULL )
	break;
	    sp = sp->next->to;
	    if ( sp==ss->first )
	break;
	}
    }
}


/* from cvpointer.c */

RefChar *HasUseMyMetrics(SplineChar *sc) {
    RefChar *r;

    for ( r=sc->layers[ly_fore].refs; r!=NULL; r=r->next )
	if ( r->use_my_metrics )
return( r );

return( NULL );
}

/* if they changed the width, then change the width on all bitmap chars of */
/*  ours, and if we are a letter, then change the width on all chars linked */
/*  to us which had the same width that we used to have (so if we change the */
/*  width of A, we'll also change that of À and Ä and ... */
void SCSynchronizeWidth(SplineChar *sc,real newwidth, real oldwidth, FontView *flagfv) {
    BDFFont *bdf;
    struct splinecharlist *dlist;
    FontView *fv = sc->parent->fv;
    RefChar *r = HasUseMyMetrics(sc);
    int isprobablybase;

    sc->widthset = true;
    if( r!=NULL ) {
	if ( oldwidth==r->sc->width ) {
	    sc->width = r->sc->width;
return;
	}
	newwidth = r->sc->width;
    }
    if ( newwidth==oldwidth )
return;
    sc->width = newwidth;
    for ( bdf=sc->parent->bitmaps; bdf!=NULL; bdf=bdf->next ) {
	BDFChar *bc = bdf->glyphs[sc->orig_pos];
	if ( bc!=NULL ) {
	    int width = rint(sc->width*bdf->pixelsize / (real) (sc->parent->ascent+sc->parent->descent));
	    if ( bc->width!=width ) {
		/*BCPreserveWidth(bc);*/ /* Bitmaps can't set width, so no undo for it */
		bc->width = width;
		BCCharChangedUpdate(bc);
	    }
	}
    }

    if ( !adjustwidth )
return;

    isprobablybase = true;
    if ( sc->unicodeenc==-1 || sc->unicodeenc>=0x10000 ||
	    !unic_isalpha(sc->unicodeenc) || unic_iscombining(sc->unicodeenc))
	isprobablybase = false;

    for ( dlist=sc->dependents; dlist!=NULL; dlist=dlist->next ) {
	RefChar *metrics = HasUseMyMetrics(dlist->sc);
	if ( metrics!=NULL && metrics->sc!=sc )
    continue;
	else if ( metrics==NULL && !isprobablybase )
    continue;
	if ( dlist->sc->width==oldwidth &&
		(flagfv==NULL || !flagfv->selected[flagfv->map->backmap[dlist->sc->orig_pos]])) {
	    SCSynchronizeWidth(dlist->sc,newwidth,oldwidth,fv);
	    if ( !dlist->sc->changed ) {
		dlist->sc->changed = true;
		if ( fv!=NULL )
		    FVToggleCharChanged(dlist->sc);
	    }
	    SCUpdateAll(dlist->sc);
	}
    }
}


/* If they change the left bearing of a character, then in all chars */
/*  that depend on it should be adjusted too. */
/* Also all vstem hints */
/* I deliberately don't set undoes in the dependants. The change is not */
/*  in them, after all */
void SCSynchronizeLBearing(SplineChar *sc,real off) {
    struct splinecharlist *dlist;
    RefChar *ref;
    DStemInfo *d;
    StemInfo *h;
    HintInstance *hi;
    int isprobablybase;

    for ( h=sc->vstem; h !=NULL; h=h->next )
	h->start += off;
    for ( h=sc->hstem; h !=NULL; h=h->next )
	for ( hi = h->where; hi!=NULL; hi=hi->next ) {
	    hi->begin += off;
	    hi->end += off;
	}
    for ( d=sc->dstem; d !=NULL; d=d->next ) {
	d->leftedgetop.x += off;
	d->rightedgetop.x += off;
	d->leftedgebottom.x += off;
	d->rightedgebottom.x += off;
    }

    if ( !adjustlbearing )
return;

    isprobablybase = true;
    if ( sc->unicodeenc==-1 || sc->unicodeenc>=0x10000 ||
	    !unic_isalpha(sc->unicodeenc) || unic_iscombining(sc->unicodeenc))
	isprobablybase = false;

    for ( dlist=sc->dependents; dlist!=NULL; dlist=dlist->next ) {
	RefChar *metrics = HasUseMyMetrics(dlist->sc);
	if ( metrics!=NULL && metrics->sc!=sc )
    continue;
	else if ( metrics==NULL && !isprobablybase )
    continue;
	else if ( metrics==NULL && sc->width!=dlist->sc->width )
    continue;
	SCPreserveState(dlist->sc,false);
	SplinePointListShift(dlist->sc->layers[ly_fore].splines,off,true);
	for ( ref = dlist->sc->layers[ly_fore].refs; ref!=NULL; ref=ref->next )
		if ( ref->sc!=sc ) {
	    SplinePointListShift(ref->layers[0].splines,off,true);
	    ref->transform[4] += off;
	    ref->bb.minx += off; ref->bb.maxx += off;
	}
	SCUpdateAll(dlist->sc);
	SCSynchronizeLBearing(dlist->sc,off);
    }
}


/* from cvgetinfo.c */

void MDReplace(MinimumDistance *md,SplineSet *old,SplineSet *rpl) {
    /* Replace all the old points with the ones in rpl in the minimum distance hints */
    SplinePoint *osp, *rsp;
    MinimumDistance *test;

    if ( md==NULL )
return;

    while ( old!=NULL && rpl!=NULL ) {
	osp = old->first; rsp = rpl->first;
	while ( 1 ) {
	    for ( test=md; test!=NULL ; test=test->next ) {
		if ( test->sp1==osp )
		    test->sp1 = rsp;
		if ( test->sp2==osp )
		    test->sp2 = rsp;
	    }
	    if ( osp->next==NULL || rsp->next==NULL )
	break;
	    osp = osp->next->to;
	    rsp = rsp->next->to;
	    if ( osp==old->first )
	break;
	}
	old = old->next;
	rpl = rpl->next;
    }
}

void SCOrderAP(SplineChar *sc) {
    int lc=0, cnt=0, out=false, i,j;
    AnchorPoint *ap, **array;
    /* Order so that first ligature index comes first */

    for ( ap=sc->anchor; ap!=NULL; ap=ap->next ) {
	if ( ap->lig_index<lc ) out = true;
	if ( ap->lig_index>lc ) lc = ap->lig_index;
	++cnt;
    }
    if ( !out )
return;

    array = galloc(cnt*sizeof(AnchorPoint *));
    for ( i=0, ap=sc->anchor; ap!=NULL; ++i, ap=ap->next )
	array[i] = ap;
    for ( i=0; i<cnt-1; ++i ) {
	for ( j=i+1; j<cnt; ++j ) {
	    if ( array[i]->lig_index>array[j]->lig_index ) {
		ap = array[i];
		array[i] = array[j];
		array[j] = ap;
	    }
	}
    }
    sc->anchor = array[0];
    for ( i=0; i<cnt-1; ++i )
	array[i]->next = array[i+1];
    array[cnt-1]->next = NULL;
    free( array );
}

/* autowidth.c */

#define NOTREACHED	-9999.0

static real SplineFindMinXAtY(Spline *spline,real y,real min) {
    extended t,t1,t2,tbase,val;
    Spline1D *xsp;

    if ( y>spline->from->me.y && y>spline->from->nextcp.y &&
	    y>spline->to->me.y && y>spline->to->prevcp.y )
return( min );
    if ( y<spline->from->me.y && y<spline->from->nextcp.y &&
	    y<spline->to->me.y && y<spline->to->prevcp.y )
return( min );
    if ( min!=NOTREACHED ) {
	if ( min<=spline->from->me.x && min<=spline->from->nextcp.x &&
		min<=spline->to->me.x && min<=spline->to->prevcp.x )
return( min );
    }

    xsp = &spline->splines[0];
    SplineFindExtrema(&spline->splines[1], &t1, &t2 );
    tbase = 0;
    if ( t1!=-1 ) {
	t = SplineSolve(&spline->splines[1],0,t1,y,.01);
	if ( t>=0 && t<=1 ) {
	    val = ((xsp->a*t+xsp->b)*t+xsp->c)*t + xsp->d;
	    if ( min==NOTREACHED || val<min )
		min = val;
	}
	tbase = t1;
    }
    if ( t2!=-1 ) {
	t = SplineSolve(&spline->splines[1],tbase,t2,y,.01);
	if ( t>=0 && t<=1 ) {
	    val = ((xsp->a*t+xsp->b)*t+xsp->c)*t + xsp->d;
	    if ( min==NOTREACHED || val<min )
		min = val;
	}
	tbase = t2;
    }
    t = SplineSolve(&spline->splines[1],tbase,1.0,y,.01);
    if ( t>=0 && t<=1 ) {
	val = ((xsp->a*t+xsp->b)*t+xsp->c)*t + xsp->d;
	if ( min==NOTREACHED || val<min )
	    min = val;
    }
return( min );
}


static real SSFindMinXAtY(SplineSet *spl,real y,real min) {
    Spline *sp, *first;

    while ( spl!=NULL ) {
	first = NULL;
	for ( sp = spl->first->next; sp!=NULL && sp!=first; sp = sp->to->next ) {
	    min = SplineFindMinXAtY(sp,y,min);
	    if ( first==NULL ) first = sp;
	}
	spl = spl->next;
    }
return( min );
}

static real SCFindMinXAtY(SplineChar *sc,real y) {
    real min = NOTREACHED;
    RefChar *ref;

    min = SSFindMinXAtY(sc->layers[ly_fore].splines,y,NOTREACHED);
    for ( ref=sc->layers[ly_fore].refs; ref!=NULL; ref=ref->next )
	min = SSFindMinXAtY(ref->layers[0].splines,y,min);
return( min );
}


real SFGuessItalicAngle(SplineFont *sf) {
    static char *easyserif = "IBDEFHKLNPR";
    int i,si;
    real as, topx, bottomx;
    DBounds bb;
    double angle;

    for ( i=0; easyserif[i]!='\0'; ++i )
	if ( (si=SFFindExistingSlot(sf,easyserif[i],NULL))!=-1 && sf->glyphs[si]!=NULL )
    break;
    if ( easyserif[i]=='\0' )		/* can't guess */
return( 0 );

    SplineCharFindBounds(sf->glyphs[si],&bb);
    as = bb.maxy-bb.miny;

    topx = SCFindMinXAtY(sf->glyphs[si],2*as/3+bb.miny);
    bottomx = SCFindMinXAtY(sf->glyphs[si],as/3+bb.miny);
    if ( topx==bottomx )
return( 0 );

    angle = atan2(as/3,topx-bottomx)*180/3.1415926535897932-90;
    if ( angle<1 && angle>-1 ) angle = 0;
return( angle );
}


/* from uiutil.c */

void IError(const char *format,...) {
  char *newf;
  va_list ap;
  const char *ierr = "Internal Error: ";
  va_start(ap,format);
  newf = malloc(strlen(format)+strlen(ierr)+1);
  if (newf==NULL) {
	perror("memory allocation failed");
	exit(EXIT_FAILURE);
  }
  sprintf(newf,"%s%s",ierr,format);
  _gwwv_post_error(newf,ap);
  va_end(ap);
}

void LogError(const char *format,...) {
    va_list ap;
    va_start(ap,format);
    _gwwv_post_error(format,ap);
    va_end(ap);
}

void ff_post_notice(const char *title,const char *statement,...) {
  char *newf;
  va_list ap;
  va_start(ap,statement);
  newf = malloc(strlen(statement)+strlen(title)+3);
  if (newf==NULL) {
	perror("memory allocation failed");
	exit(EXIT_FAILURE);
  }
  sprintf(newf,"%s: %s",title,statement);
  _gwwv_post_error(newf,ap);
  va_end(ap);
}


/* from statemachine.c */


typedef struct statemachinedlg {
    int state_cnt, class_cnt, index;
    struct asm_state *states;
    ASM *sm;
    SplineFont *sf;
    struct gfi_data *d;
    int isnew;
    int fh, as;
    int stateh, statew;
    int xstart, ystart;		/* This is where the headers start */
    int xstart2, ystart2;	/* This is where the data start */
    int width, height;
    int offleft, offtop;
    int canceldrop, sbdrop;
    int isedit;
    int st_pos;
  int edit_done, edit_ok;
} SMD;
 

SMD *StateMachineEdit(SplineFont *sf,ASM *sm,struct gfi_data *d) {
  /* complete. but prepocessed */
    SMD *smd = gcalloc(1,sizeof(SMD));
return( smd );
}

/* from fvcomposite.c */

#define BottomAccent	0x300
#define TopAccent	0x345


/* for accents between 0x300 and 345 these are some synonyms */
/* type1 wants accented chars built with accents in the 0x2c? range */
/*  except for grave and acute which live in iso8859-1 range */
/*  this table is ordered on a best try basis */
static const unichar_t accents[][4] = {
    { 0x2cb, 0x300, 0x60 },	/* grave */
    { 0x2ca, 0x301, 0xb4 },	/* acute */
    { 0x2c6, 0x302, 0x5e },	/* circumflex */
    { 0x2dc, 0x303, 0x7e },	/* tilde */
    { 0x2c9, 0x304, 0xaf },	/* macron */
    { 0x305, 0xaf },		/* overline, (macron is suggested as a syn, but it's not quite right) */
    { 0x2d8, 0x306 },		/* breve */
    { 0x2d9, 0x307, '.' },	/* dot above */
    { 0xa8,  0x308 },		/* diaeresis */
    { 0x2c0 },			/* hook above */
    { 0x2da, 0xb0 },		/* ring above */
    { 0x2dd },			/* real acute */
    { 0x2c7 },			/* caron */
    { 0x2c8, 0x384, 0x30d, '\''  },	/* vertical line, tonos */
    { 0x30e, '"' },		/* real vertical line */
    { 0 },			/* real grave */
    { 0 },			/* cand... */		/* 310 */
    { 0 },			/* inverted breve */
    { 0x2bb },			/* turned comma */
    { 0x2bc, 0x313, ',' },	/* comma above */
    { 0x2bd },			/* reversed comma */
    { 0x2bc, 0x315, ',' },	/* comma above right */
    { 0x316, 0x60, 0x2cb },	/* grave below */
    { 0x317, 0xb4, 0x2ca },	/* acute below */
    { 0 },			/* left tack */
    { 0 },			/* right tack */
    { 0 },			/* left angle */
    { 0 },			/* horn, sometimes comma but only if nothing better */
    { 0 },			/* half ring */
    { 0x2d4 },			/* up tack */
    { 0x2d5 },			/* down tack */
    { 0x2d6, 0x31f, '+' },	/* plus below */
    { 0x2d7, 0x320, '-' },	/* minus below */	/* 320 */
    { 0x2b2 },			/* hook */
    { 0 },			/* back hook */
    { 0x323, 0x2d9, '.' },	/* dot below */
    { 0x324, 0xa8 },		/* diaeresis below */
    { 0x325, 0x2da, 0xb0 },	/* ring below */
    { 0x326, 0x2bc, ',' },	/* comma below */
    { 0xb8 },			/* cedilla */
    { 0x2db },			/* ogonek */		/* 0x328 */
    { 0x329, 0x2c8, 0x384, '\''  },	/* vertical line below */
    { 0 },			/* bridge below */
    { 0 },			/* real arch below */
    { 0x32c, 0x2c7 },		/* caron below */
    { 0x32d, 0x2c6, 0x52 },	/* circumflex below */
    { 0x32e, 0x2d8 },		/* breve below */
    { 0 },			/* inverted breve below */
    { 0x330, 0x2dc, 0x7e },	/* tilde below */	/* 0x330 */
    { 0x331, 0xaf, 0x2c9 },	/* macron below */
    { 0x332, '_' },		/* low line */
    { 0 },			/* real low line */
    { 0x334, 0x2dc, 0x7e },	/* tilde overstrike */
    { 0x335, '-' },		/* line overstrike */
    { 0x336, '_' },		/* long line overstrike */
    { 0x337, '/' },		/* short solidus overstrike */
    { 0x338, '/' },		/* long solidus overstrike */	/* 0x338 */
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0x340, 0x60, 0x2cb },	/* tone mark, left of circumflex */ /* 0x340 */
    { 0x341, 0xb4, 0x2ca },	/* tone mark, right of circumflex */
    { 0x342, 0x2dc, 0x7e },	/* perispomeni (tilde) */
    { 0x343, 0x2bc, ',' },	/* koronis */
    { 0 },			/* dialytika tonos (two accents) */
    { 0x37a },			/* ypogegrammeni */
    { 0xffff }
};

int CanonicalCombiner(int uni) {
    /* Translate spacing accents to combiners */
    int j,k;

    /* The above table will use these occasionally, but we don't want to */
    /*  translate them. They aren't accents */
    if ( uni==',' || uni=='\'' || uni=='"' || uni=='~' || uni=='^' || uni=='-' ||
	    uni=='+' || uni=='.' )
return( uni );

    for ( j=0; accents[j][0]!=0xffff; ++j ) {
	for ( k=0; k<4; ++k ) {
	    if ( uni==accents[j][k] ) {
		uni = 0x300+j;
	break;
	    }
	}
	if ( uni>=0x300 && uni<0x370 )
    break;
    }
return( uni );
}

/* from cvundoes.c */

int maxundoes=0;

void UndoesFree(Undoes *undo) { }

Undoes *SCPreserveState(SplineChar *sc,int dohints) { return NULL; }
Undoes *BCPreserveState(BDFChar *bc) { return NULL; }
Undoes *SCPreserveBackground(SplineChar *sc) {  return NULL;}
Undoes *SFPreserveGuide(SplineFont *sf) {  return NULL; }
Undoes *SCPreserveLayer(SplineChar *sc,int layer, int dohints) {  return NULL; }

void SCUndoSetLBearingChange(SplineChar *sc,int lbc) {}
void PasteAnchorClassMerge(SplineFont *sf,AnchorClass *into,AnchorClass *from) {}
void PasteRemoveSFAnchors(SplineFont *sf) {}
void PasteRemoveAnchorClass(SplineFont *sf,AnchorClass *dying) {}
void CopyBufferClearCopiedFrom(SplineFont *dying) { }
void PasteIntoFV(FontView *fv,int pasteinto,real trans[6]) { }

RefChar *CopyContainsRef(SplineFont *sf) { return NULL; }

int getAdobeEnc(char *name) {
    extern char *AdobeStandardEncoding[256];
    int i;

    for ( i=0; i<256; ++i )
	if ( strcmp(name,AdobeStandardEncoding[i])==0 )
    break;
    if ( i==256 ) i = -1;
return( i );
}


/* stubs from bvedit.c */

void BCTrans(BDFFont *bdf,BDFChar *bc,BVTFunc *bvts,FontView *fv ) {
}
void BDFCharFindBounds(BDFChar *bc,IBounds *bb) {
}
void BCFlattenFloat(BDFChar *bc ) {
}

/* from combinations.c */


int PSTContains(const char *components,const char *name) {
    const char *pt;
    int len = strlen(name);

    for ( pt = strstr(components,name); pt!=NULL; pt = strstr(pt+len,name)) {
	if (( pt==components || pt[-1]==' ') && (pt[len]==' ' || pt[len]=='\0'))
return( true );
    }
return( false );
}


/* from mm.c (the stuff needed for Apple MM support) */


char *MMAxisAbrev(char *axis_name) {
    if ( strcmp(axis_name,"Weight")==0 )
return( "wt" );
    if ( strcmp(axis_name,"Width")==0 )
return( "wd" );
    if ( strcmp(axis_name,"OpticalSize")==0 )
return( "op" );
    if ( strcmp(axis_name,"Slant")==0 )
return( "sl" );

return( axis_name );
}

static double MMAxisUnmap(MMSet *mm,int axis,double ncv) {
    struct axismap *axismap = &mm->axismaps[axis];
    int j;

    if ( ncv<=axismap->blends[0] )
return(axismap->designs[0]);

    for ( j=1; j<axismap->points; ++j ) {
	if ( ncv<=axismap->blends[j]) {
	    double t = (ncv-axismap->blends[j-1])/(axismap->blends[j]-axismap->blends[j-1]);
return( axismap->designs[j-1]+ t*(axismap->designs[j]-axismap->designs[j-1]) );
	}
    }

return(axismap->designs[axismap->points-1]);
}



static char *_MMMakeFontname(MMSet *mm,real *normalized,char **fullname) {
    char *pt, *pt2, *hyphen=NULL;
    char *ret = NULL;
    int i,j;

    if ( mm->apple ) {
	for ( i=0; i<mm->named_instance_count; ++i ) {
	    for ( j=0; j<mm->axis_count; ++j ) {
		if (( normalized[j] == -1 &&
			RealApprox(mm->named_instances[i].coords[j],mm->axismaps[j].min) ) ||
		    ( normalized[j] ==  0 &&
			RealApprox(mm->named_instances[i].coords[j],mm->axismaps[j].def) ) ||
		    ( normalized[j] ==  1 &&
			RealApprox(mm->named_instances[i].coords[j],mm->axismaps[j].max) ))
		    /* A match so far */;
		else
	    break;
	    }
	    if ( j==mm->axis_count )
	break;
	}
	if ( i!=mm->named_instance_count ) {
	    char *styles = PickNameFromMacName(mm->named_instances[i].names);
	    if ( styles==NULL )
		styles = FindEnglishNameInMacName(mm->named_instances[i].names);
	    if ( styles!=NULL ) {
		ret = galloc(strlen(mm->normal->familyname)+ strlen(styles)+3 );
		strcpy(ret,mm->normal->familyname);
		hyphen = ret+strlen(ret);
		strcpy(hyphen," ");
		strcpy(hyphen+1,styles);
		free(styles);
	    }
	}
    }

    if ( ret==NULL ) {
	pt = ret = galloc(strlen(mm->normal->familyname)+ mm->axis_count*15 + 1);
	strcpy(pt,mm->normal->familyname);
	pt += strlen(pt);
	*pt++ = '_';
	for ( i=0; i<mm->axis_count; ++i ) {
	    if ( !mm->apple )
		sprintf( pt, " %d%s", (int) rint(MMAxisUnmap(mm,i,normalized[i])),
			MMAxisAbrev(mm->axes[i]));
	    else
		sprintf( pt, " %.1f%s", MMAxisUnmap(mm,i,normalized[i]),
			MMAxisAbrev(mm->axes[i]));
	    pt += strlen(pt);
	}
	if ( pt>ret && pt[-1]==' ' )
	    --pt;
	*pt = '\0';
    }

    *fullname = ret;

    ret = copy(ret);
    for ( pt=*fullname, pt2=ret; *pt!='\0'; ++pt )
	if ( pt==hyphen )
	    *pt2++ = '-';
	else if ( *pt!=' ' )
	    *pt2++ = *pt;
    *pt2 = '\0';
return( ret );
}

char *MMMakeMasterFontname(MMSet *mm,int ipos,char **fullname) {
return( _MMMakeFontname(mm,&mm->positions[ipos*mm->axis_count],fullname));
}

/* from splinesaveafm.c */


void SFLigatureCleanup(SplineFont *sf) {
    LigList *l, *next;
    struct splinecharlist *scl, *sclnext;
    int j;

    for ( j=0; j<sf->glyphcnt; ++j ) if ( sf->glyphs[j]!=NULL ) {
        for ( l = sf->glyphs[j]->ligofme; l!=NULL; l = next ) {
            next = l->next;
            for ( scl = l->components; scl!=NULL; scl = sclnext ) {
                sclnext = scl->next;
                chunkfree(scl,sizeof(struct splinecharlist));
            }
            if ( l->lig->temporary ) {
                free(l->lig->u.lig.components);
                chunkfree(l->lig,sizeof(PST));
            }
            free( l );
        }
        sf->glyphs[j]->ligofme = NULL;
    }
}


void SFLigaturePrepare(SplineFont *sf) {
    PST *lig;
    LigList *ll;
    int i,j,k,ch;
    char *pt, *ligstart;
    SplineChar *sc, *tsc;
    struct splinecharlist *head, *last;
    int ccnt, lcnt, lmax=20;
    LigList **all = galloc(lmax*sizeof(LigList *));
	ccnt = 0; /* for -Wall */
    /* First clear out any old stuff */
    for ( j=0; j<sf->glyphcnt; ++j ) if ( sf->glyphs[j]!=NULL )
	sf->glyphs[j]->ligofme = NULL;

    /* Attach all the ligatures to the first character of their components */
    /* Figure out what the components are, and if they all exist */
    /* we're only interested in the lig if all components are worth outputting */
    for ( i=0 ; i<sf->glyphcnt; ++i ) if ( SCWorthOutputting(sf->glyphs[i]) && sf->glyphs[i]->possub!=NULL ) {
	for ( lig = sf->glyphs[i]->possub; lig!=NULL; lig=lig->next ) if ( lig->type==pst_ligature ) {
	    ligstart = lig->u.lig.components;
	    last = head = NULL; sc = NULL;
	    for ( pt = ligstart; *pt!='\0'; ) {
		char *start = pt;
		for ( ; *pt!='\0' && *pt!=' '; ++pt );
		ch = *pt; *pt = '\0';
		tsc = SFGetChar(sf,-1,start);
		*pt = ch;
		if ( tsc!=NULL ) {
		    if ( !SCWorthOutputting(tsc)) {
			sc = NULL;
	    break;
		    }
		    if ( sc==NULL ) {
			sc = tsc;
			ccnt = 1;
		    } else {
			struct splinecharlist *cur = chunkalloc(sizeof(struct splinecharlist));
			if ( head==NULL )
			    head = cur;
			else
			    last->next = cur;
			last = cur;
			cur->sc = tsc;
			cur->next = NULL;
			++ccnt;
		    }
		} else {
		    sc = NULL;
	    break;
		}
		while ( *pt==' ' ) ++pt;
	    }
	    if ( sc!=NULL ) {
		ll = galloc(sizeof(LigList));
		ll->lig = lig;
		ll->next = sc->ligofme;
		ll->first = sc;
		ll->components = head;
		ll->ccnt = ccnt;
		sc->ligofme = ll;
	    } else {
		while ( head!=NULL ) {
		    last = head->next;
		    chunkfree(head,sizeof(*head));
		    head = last;
		}
	    }
	}
    }
    for ( i=0 ; i<sf->glyphcnt; ++i ) if ( (sc=sf->glyphs[i])!=NULL && sc->ligofme!=NULL ) {
	for ( ll=sc->ligofme, lcnt=0; ll!=NULL; ll=ll->next, ++lcnt );
	/* Finally, order the list so that the longest ligatures are first */
	if ( lcnt>1 ) {
	    if ( lcnt>=lmax )
		all = grealloc(all,(lmax=lcnt+30)*sizeof(LigList *));
	    for ( ll=sc->ligofme, k=0; ll!=NULL; ll=ll->next, ++k )
		all[k] = ll;
	    for ( k=0; k<lcnt-1; ++k ) for ( j=k+1; j<lcnt; ++j )
		if ( all[k]->ccnt<all[j]->ccnt ) {
		    ll = all[k];
		    all[k] = all[j];
		    all[j] = ll;
		}
	    sc->ligofme = all[0];
	    for ( k=0; k<lcnt-1; ++k )
		all[k]->next = all[k+1];
	    all[k]->next = NULL;
	}
    }
    free( all );
}

/* from autohint.c, stubs for now */

void FindBlues( SplineFont *sf, real blues[14], real otherblues[10]) { 
}

void QuickBlues(SplineFont *_sf, BlueData *bd) {
}

void SplineFontAutoHint( SplineFont *sf) {
}

void SplineFontAutoHintRefs( SplineFont *_sf) {
}

void SplineCharAutoHint( SplineChar *sc, BlueData *bd ) {
}


/* from genttfinstrs.c */

int TTF__getcvtval(SplineFont *sf,int val) {
    int i;
    struct ttf_table *cvt_tab = SFFindTable(sf,CHR('c','v','t',' '));

    if ( cvt_tab==NULL ) {
	cvt_tab = chunkalloc(sizeof(struct ttf_table));
	cvt_tab->tag = CHR('c','v','t',' ');
	cvt_tab->maxlen = 200;
	cvt_tab->data = galloc(100*sizeof(short));
	cvt_tab->next = sf->ttf_tables;
	sf->ttf_tables = cvt_tab;
    }
    for ( i=0; sizeof(uint16)*i<cvt_tab->len; ++i ) {
	int tval = (int16) memushort(cvt_tab->data,cvt_tab->len, sizeof(uint16)*i);
	if ( val>=tval-1 && val<=tval+1 )
return( i );
    }
    if ( sizeof(uint16)*i>=cvt_tab->maxlen ) {
	if ( cvt_tab->maxlen==0 ) cvt_tab->maxlen = cvt_tab->len;
	cvt_tab->maxlen += 200;
	cvt_tab->data = grealloc(cvt_tab->data,cvt_tab->maxlen);
    }
    memputshort(cvt_tab->data,sizeof(uint16)*i,val);
    cvt_tab->len += sizeof(uint16);
return( i );
}

int TTF_getcvtval(SplineFont *sf,int val) {

    /* by default sign is unimportant in the cvt */
    /* For some instructions anyway, but not for MIAP so this routine has */
    /*  been broken in two. */
    if ( val<0 ) val = -val;
return( TTF__getcvtval(sf,val));
}



struct ttf_table *SFFindTable(SplineFont *sf,uint32 tag) {
    struct ttf_table *tab;

    for ( tab=sf->ttf_tables; tab!=NULL && tab->tag!=tag; tab=tab->next );
return( tab );
}

void initforinstrs(SplineChar *sc) {
}
