#line 2 "yparse.l"
#include "config.h"



#line 7 "yparse.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 38
#define YY_END_OF_BUFFER 39
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[304] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   23,   23,    0,    0,   25,   25,
       39,   37,    3,    4,    5,   30,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,    3,    5,   32,    1,    1,    2,
        1,   31,   34,   37,   37,   37,   37,   37,   37,   37,
       35,   36,   38,   23,   37,   37,   25,    5,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   33,
        5,    5,    0,    0,    0,    0,    0,    0,    0,    0,

        0,   23,   24,    0,   25,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   22,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   29,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   14,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

       19,    0,    0,    0,   28,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   10,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   21,    0,   27,
        0,    0,    0,   11,   12,    6,    7,   15,    0,   13,
        0,   16,   17,    0,   20,   18,    8,    0,    0,    0,

       26,    9,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    4,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    5,    5,    6,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    1,    1,    1,
        8,    1,    1,    1,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        1,    1,    1,    1,    9,    1,   10,   11,   12,   13,

       14,   15,   16,   17,   18,    5,   19,   20,   21,   22,
       23,   24,    5,   25,   26,   27,   28,   29,   30,   31,
       32,    5,   33,    1,   34,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[35] =
    {   0,
        1,    1,    2,    1,    3,    3,    3,    1,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    1,    1
    } ;

static yyconst flex_int16_t yy_base[312] =
    {   0,
        0,   25,   50,    0,    5,   30,   12,   37,   53,   75,
       81,    0,   16,   55,  114,  148,   65,   88,  101,  121,
      381,  382,  382,  382,    0,  382,    7,  370,  356,  356,
      363,  348,   30,    0,  343,  364,  348,  354,  361,  342,
      355,  351,  353,  360,  359,  358,  357,  382,  382,  382,
        0,  382,  382,  339,  351,  329,   42,  343,   62,  344,
      382,  382,  382,    0,  334,  342,  348,    0,  338,  333,
      325,  325,  326,  323,  321,  322,  323,   91,   88,  335,
      319,  329,  326,  325,  315,  326,  320,  317,  330,  329,
      328,  327,  312,  304,  312,  313,  302,  305,  299,  299,

      299,    0,  382,  297,  315,  312,  297,  305,  291,  289,
      300,  291,  285,  283,  300,  297,  294,  279,  286,  288,
      292,  288,  290,  279,  382,  275,  281,  277,  285,  271,
      280,  269,  272,  282,  277,  263,  262,  265,  280,  279,
      260,  277,  257,  275,  274,  263,  264,  258,  263,  256,
      250,  254,  255,  260,  250,  247,  262,  382,  250,  260,
      243,  250,  257,  256,  250,  255,  250,  249,  251,  247,
      231,  245,  228,  228,  229,  237,  225,  237,  220,  241,
      236,  229,  234,  231,  235,  231,  230,  216,  382,  217,
      216,  223,  214,  227,  212,  212,  115,  223,  207,  221,

      382,  207,  213,  205,  382,   47,  204,  203,  217,  204,
      203,  204,  201,  205,  199,  194,  197,  184,  190,  200,
      181,  202,  191,  193,  189,  185,  193,  186,  185,  382,
      181,  179,  114,  176,  178,  157,  169,  150,  167,  162,
      162,  142,  150,  145,  148,  144,  144,  145,  144,  141,
      140,  141,  149,  137,  141,  135,  134,  144,  135,  141,
      129,  145,  121,  118,  115,  118,  117,  133,  131,  130,
      129,  128,  121,  125,  106,  108,  113,  382,  105,  382,
       94,  101,   92,  382,  382,  382,  382,  382,   88,  382,
       72,  382,  382,   33,  382,  382,  382,   22,   10,    2,

      382,  382,  382,  182,  185,  188,  191,  194,  197,  200,
        2
    } ;

static yyconst flex_int16_t yy_def[312] =
    {   0,
      304,  304,  304,    3,  305,  305,  306,  306,  304,  304,
      304,   11,   11,   11,  307,  307,  304,  304,  304,  304,
      303,  303,  303,  303,  308,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  309,  309,  310,  309,  303,  303,  303,
      308,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  311,  303,  303,  303,  308,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  309,  309,
      310,  310,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  311,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,    0,  303,  303,  303,  303,  303,  303,  303,
      303
    } ;

static yyconst flex_int16_t yy_nxt[417] =
    {   0,
      303,   23,   24,   25,  102,   26,   45,   24,   46,  302,
       47,   27,   28,   49,   50,   51,   29,   30,   24,   78,
       31,   69,   32,  301,   79,   33,   23,   24,   25,   70,
       26,   45,   24,   46,  300,   47,   27,   28,   49,   50,
       51,   29,   30,   76,  299,   31,   77,   32,   22,   62,
       33,   23,   24,   25,   23,   24,   25,   24,   52,   96,
       34,   35,   36,  226,   97,   37,   23,   63,   25,   38,
       39,   99,  227,   40,   41,  100,   23,   24,   25,   42,
       52,   43,   23,   53,   25,  298,   65,   22,   62,   23,
       63,   25,   54,   55,   56,  297,   66,   57,   58,  296,

      115,   59,   23,   63,   25,  117,   60,   67,  295,   65,
      118,  294,  293,   61,   22,   23,   63,   25,  116,   66,
      292,   22,   23,   63,   25,  217,  218,   67,  252,  125,
      219,  291,  290,  253,  289,  288,  287,  286,  285,  220,
      284,  283,  282,  281,  280,  279,   22,   22,   22,   23,
       63,   25,  278,  277,  276,   22,  125,  125,  275,  274,
      273,  272,  271,  270,  269,  268,  267,  266,  265,  264,
      263,  262,  261,  125,  125,  260,  259,  258,  257,  256,
       22,   22,   22,   22,   22,   44,   44,   44,   48,   48,
       48,   64,   64,   64,   68,  255,   68,   89,  254,   89,

       91,  251,   91,  250,  249,  248,  247,  246,  245,  244,
      243,  242,  125,  241,  240,  239,  238,  237,  236,  235,
      234,  233,  232,  231,  230,  229,  228,  225,  224,  223,
      125,  222,  221,  216,  215,  214,  213,  212,  211,  210,
      209,  208,  207,  206,  205,  204,  203,  202,  201,  125,
      125,  200,  199,  198,  197,  196,  195,  194,  193,  192,
      191,  190,  189,  188,  187,  186,  185,  184,  183,  182,
      181,  180,  179,  125,  178,  177,  176,  125,  175,  125,
      174,  125,  173,  172,  171,  170,  169,  168,  167,  166,
      165,  164,  163,  162,  161,  160,  159,  158,  157,  156,

      155,  154,  153,  152,  151,  150,  149,  125,  148,  147,
      125,  146,  145,  144,  143,  142,  141,  140,  139,  138,
      137,  105,  103,  136,  135,  134,  133,  132,  131,  130,
      129,  128,   92,   92,   90,   90,  127,  126,  125,  124,
      123,  122,  121,  120,  119,  114,  113,  112,  111,  110,
      109,  108,  107,  106,  105,  104,  103,  101,   98,   95,
       94,   93,   90,   92,   90,   90,   88,   87,   86,   85,
       84,   83,   82,   81,   80,   75,   74,   73,   72,   71,
      303,   21,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303
    } ;

static yyconst flex_int16_t yy_chk[417] =
    {   0,
        0,    1,    1,    1,  311,    1,    5,    5,    5,  300,
        5,    1,    1,    7,    7,    7,    1,    1,   13,   34,
        1,   27,    1,  299,   34,    1,    2,    2,    2,   27,
        2,    6,    6,    6,  298,    6,    2,    2,    8,    8,
        8,    2,    2,   33,  294,    2,   33,    2,   13,   13,
        2,    3,    3,    3,    9,    9,    9,   14,    9,   57,
        3,    3,    3,  206,   57,    3,   17,   17,   17,    3,
        3,   59,  206,    3,    3,   59,   10,   10,   10,    3,
       10,    3,   11,   11,   11,  291,   17,   14,   14,   18,
       18,   18,   11,   11,   11,  289,   17,   11,   11,  283,

       78,   11,   19,   19,   19,   79,   11,   19,  282,   18,
       79,  281,  279,   11,   15,   15,   15,   15,   78,   18,
      277,   15,   20,   20,   20,  197,  197,   20,  233,  276,
      197,  275,  274,  233,  273,  272,  271,  270,  269,  197,
      268,  267,  266,  265,  264,  263,   15,   15,   16,   16,
       16,   16,  262,  261,  260,   16,  259,  258,  257,  256,
      255,  254,  253,  252,  251,  250,  249,  248,  247,  246,
      245,  244,  243,  242,  241,  240,  239,  238,  237,  236,
       16,   16,  304,  304,  304,  305,  305,  305,  306,  306,
      306,  307,  307,  307,  308,  235,  308,  309,  234,  309,

      310,  232,  310,  231,  229,  228,  227,  226,  225,  224,
      223,  222,  221,  220,  219,  218,  217,  216,  215,  214,
      213,  212,  211,  210,  209,  208,  207,  204,  203,  202,
      200,  199,  198,  196,  195,  194,  193,  192,  191,  190,
      188,  187,  186,  185,  184,  183,  182,  181,  180,  179,
      178,  177,  176,  175,  174,  173,  172,  171,  170,  169,
      168,  167,  166,  165,  164,  163,  162,  161,  160,  159,
      157,  156,  155,  154,  153,  152,  151,  150,  149,  148,
      147,  146,  145,  144,  143,  142,  141,  140,  139,  138,
      137,  136,  135,  134,  133,  132,  131,  130,  129,  128,

      127,  126,  124,  123,  122,  121,  120,  119,  118,  117,
      116,  115,  114,  113,  112,  111,  110,  109,  108,  107,
      106,  105,  104,  101,  100,   99,   98,   97,   96,   95,
       94,   93,   92,   91,   90,   89,   88,   87,   86,   85,
       84,   83,   82,   81,   80,   77,   76,   75,   74,   73,
       72,   71,   70,   69,   67,   66,   65,   60,   58,   56,
       55,   54,   47,   46,   45,   44,   43,   42,   41,   40,
       39,   38,   37,   36,   35,   32,   31,   30,   29,   28,
       21,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "yparse.l"

#line 5 "yparse.l"
/* yparse.l -- LogWatcher

   This file is part of the LogWatcher tool.

   Copyright (C) 2002 Artur Robert Czechowski

   The LogWatcher is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   The LogWatcher is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the LogWatcher; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Artur R. Czechowski
   <arturcz@hell.pl>
   http://hell.pl/arturcz/
 */

/*
 * $Id: yparse.l,v 1.27 2004/08/10 12:15:20 arturcz Exp $
 * $Source: /cvsroot/lwatch/files/src/yparse.l,v $
 */

#include <stdio.h>
#include <string.h>

#include "control.h"
#include "acolors.h"
#include "settings.h"
#include "strpcre.h"

#define MAXMSG 80

int *yyip;
char *yypch;
int lineno=1;

char *restr;

#define STACKSIZE 5
int s_stack[STACKSIZE+1];
int s_pointer=0;
int c_state;

#define PUSH(a) if(s_pointer<STACKSIZE) { \
	s_stack[s_pointer++]=YY_START; \
	BEGIN(a); \
} else { \
	die("yparse.l: internal stack overflow\n"); \
}

#define POP if(s_pointer>0) { \
	BEGIN(s_stack[--s_pointer]); \
} else { \
	die("yparse.l: internal stack empty\n"); \
}


#line 710 "yparse.c"

#define INITIAL 0
#define COLOR 1
#define REGEXP 2
#define ERROR 3
#define SECOND 4
#define ACTION 5
#define MULTI 6
#define TEXT 7
#define BOOLEAN 8
#define INTEGER 9

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 88 "yparse.l"


	char errmsg[MAXMSG+1];
	int errind=0;
#ifdef DEBUG
	char mymsg[MAXMSG+1];
#endif
	struct s_action action;


#line 879 "yparse.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 304 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 382 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 98 "yparse.l"
if(errind<MAXMSG) errmsg[errind++]=*yytext;
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 99 "yparse.l"
{
	errmsg[errind]='\0';
	die("Unknown configuration option in line %i:\n%s\n",lineno,errmsg);
}	
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 103 "yparse.l"
;	/* Skip whitespaces */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 104 "yparse.l"
lineno++;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 105 "yparse.l"
;	/* Skip comments */
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 106 "yparse.l"
{
	die("lwatch.conf: OPTION input_fifo IN LINE %i IS DEPRECATED.\nUSE input_file INSTEAD IT.\n",lineno);
}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 109 "yparse.l"
{
	yypch=lw_conf.in_file;
#ifdef DEBUG
	strcpy(mymsg,"input_file");
#endif
	PUSH(TEXT);
}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 116 "yparse.l"
{
	yypch=lw_conf.out_file;
#ifdef DEBUG
	strcpy(mymsg,"output_file");
#endif
	PUSH(TEXT);
}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 123 "yparse.l"
{
	yyip=&lw_conf.show_unparsed;
#ifdef DEBUG
	strcpy(mymsg,"show_unparsed");
#endif
	PUSH(BOOLEAN);
}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 130 "yparse.l"
{
	yyip=&lw_conf.cfg_ver;
#ifdef DEBUG
	strcpy(mymsg,"cfg_ver");
#endif
	PUSH(INTEGER);
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 137 "yparse.l"
{
	PUSH(COLOR);
	yyip=&lw_conf.def_date_color;
#ifdef DEBUG
	strcpy(mymsg,"date_color");
#endif
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 144 "yparse.l"
{
	PUSH(COLOR);
	yyip=&lw_conf.def_host_color;
#ifdef DEBUG
	strcpy(mymsg,"host_color");
#endif
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 151 "yparse.l"
{
	PUSH(COLOR);
	yyip=&lw_conf.def_serv_color;
#ifdef DEBUG
	strcpy(mymsg,"serv_color");
#endif
}
	YY_BREAK
case 14:
#line 159 "yparse.l"
case 15:
YY_RULE_SETUP
#line 159 "yparse.l"
{
	PUSH(COLOR);
	yyip=&lw_conf.def_mesg_color;
#ifdef DEBUG
	strcpy(mymsg,"mesg_color");
#endif
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 166 "yparse.l"
{
	PUSH(COLOR);
	yyip=&action.date_color;
#ifdef DEBUG
	strcpy(mymsg,"date_color");
#endif
}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 173 "yparse.l"
{
	PUSH(COLOR);
	yyip=&action.host_color;
#ifdef DEBUG
	strcpy(mymsg,"host_color");
#endif
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 180 "yparse.l"
{
	PUSH(COLOR);
	yyip=&action.serv_color;
#ifdef DEBUG
	strcpy(mymsg,"serv_color");
#endif
}
	YY_BREAK
case 19:
#line 188 "yparse.l"
case 20:
YY_RULE_SETUP
#line 188 "yparse.l"
{
	PUSH(COLOR);
	yyip=&action.mesg_color;
#ifdef DEBUG
	strcpy(mymsg,"mesg_color");
#endif
}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 195 "yparse.l"
{
	PUSH(COLOR);
	yyip=&action.highlight_color;
#ifdef DEBUG
	strcpy(mymsg,"highlight_color");
#endif
}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 202 "yparse.l"
{
	getcolbystr(*yyip,yytext);
	POP;
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s[%i]\n",mymsg,yytext,*yyip);
#endif
}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 209 "yparse.l"
{
	if(strlen(yytext)>MAXPATHLEN) {
		die("Filename too long: %s\n",yytext);
	} 
	if(!strlen(yypch)) {
		strcpy(yypch,yytext);
#ifdef DEBUG
		fprintf(stderr,"Set %s to %s\n",mymsg,yytext);
#endif
	}
	POP;
}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 221 "yparse.l"
{
	*yyip=0;
	if(!strcasecmp(yytext,"yes")) {
		*yyip=1;
	}
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s (%i)\n",mymsg,yytext,*yyip);
#endif
	POP;
}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 231 "yparse.l"
{
	*yyip=0;
	*yyip=strtol(yytext, &yypch, 10);
	if(*yypch!='\0') {
	  die("Error in line %i: '%s' is not valid integer variable.\n",lineno,yytext);
	}
#ifdef DEBUG
	fprintf(stderr,"Set %s to %s (%i)\n",mymsg,yytext,*yyip);
#endif
	POP;
}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 242 "yparse.l"
{
	if(action.match_host) {
	  die("Error in line %i: only one of match_service and match_host can be set.\n",lineno);
	}
	action.match_service=1;
#ifdef DEBUG
	fprintf(stderr,"Match service instead message\n");
#endif
}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 251 "yparse.l"
{
	action.match_host=1;
	if(action.match_service) {
	  die("Error in line %i: only one of match_service and match_host can be set.\n",lineno);
	}
#ifdef DEBUG
	fprintf(stderr,"Match hostname instead message\n");
#endif
}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 260 "yparse.l"
{
	action.ignore=1;
	action.exit=1;
#ifdef DEBUG
	fprintf(stderr,"Ignore RE\n");
#endif
}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 267 "yparse.l"
{
	action.exit=1;
#ifdef DEBUG
	fprintf(stderr,"Exit on action\n");
#endif
}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 273 "yparse.l"
{
	BEGIN(SECOND);
	yyless(0);
}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 277 "yparse.l"
{
	memset(&action,0,sizeof(action));
	BEGIN(REGEXP);
}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 281 "yparse.l"
{
	BEGIN(ACTION);
}
	YY_BREAK
case 33:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 284 "yparse.l"
{
	restr=newstr(yytext);
#ifdef DEBUG
	action.restr=restr;
#endif
	compile_re(restr,&action.re,&action.rh);
}
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 291 "yparse.l"
{
	lineno++;
	add_action(&action);
#ifndef DEBUG
	freestr(restr);
#endif
	BEGIN(SECOND);
}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 299 "yparse.l"
BEGIN(MULTI);
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 300 "yparse.l"
{
	add_action(&action);
#ifndef DEBUG
	freestr(restr);
#endif
	BEGIN(SECOND);
}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 307 "yparse.l"
{
	if(errind<MAXMSG) errmsg[errind++]=*yytext;
	BEGIN(ERROR);
}	
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 312 "yparse.l"
ECHO;
	YY_BREAK
#line 1328 "yparse.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COLOR):
case YY_STATE_EOF(REGEXP):
case YY_STATE_EOF(ERROR):
case YY_STATE_EOF(SECOND):
case YY_STATE_EOF(ACTION):
case YY_STATE_EOF(MULTI):
case YY_STATE_EOF(TEXT):
case YY_STATE_EOF(BOOLEAN):
case YY_STATE_EOF(INTEGER):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 304 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 304 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 303);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yy_str )
{
    
	return yy_scan_bytes(yy_str,strlen(yy_str) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * bytes, int  len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#undef YY_NEW_FILE
#undef YY_FLUSH_BUFFER
#undef yy_set_bol
#undef yy_new_buffer
#undef yy_set_interactive
#undef yytext_ptr
#undef YY_DO_BEFORE_ACTION

#ifdef YY_DECL_IS_OURS
#undef YY_DECL_IS_OURS
#undef YY_DECL
#endif
#line 312 "yparse.l"



