#!/bin/sh
# Scan all test cases, and emit information about the coverage.
# The first column in the output is the Protocol A call number.
# If a line contains more than one column the second column is the
# error number; otherwise the call succeeded.
#
# This script relies on the formatting of the test cases in obvious
# ways.  See the code below for more information.
cat *.exp | sed -n -e 's/^send "\([0-9][0-9]* [0-9][0-9]*\).*\\n"$/\1/p' \
	-e 's/^simple_expect "=\([0-9][0-9]*\).*".*/= \1/p' \
	-e 's/^simple_expect "%\([0-9][0-9]*\) \([0-9][0-9]*\) \([0-9][0-9]*\)".*/% \1 \2 \3/p' \
| awk '$1 == "=" { ok[call] = ok[call] + 1; next }
$1 == "%" { err[call " " $3] = err[call " " $3] + 1; next }
{ ref = $1; call = $2; next }
END { for (k in ok) { print k } 
      for (k in err) { print k } 
}' \
| sort +0n +1n
