// -*- C++ -*-
/**
 * \file GLog.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GLOG_H
#define GLOG_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlLog.h"
#include "GnomeBase.h"

namespace Gtk {
	class Button;
	class TextView;
}

/**
 * This class implements the dialog to modify the LaTeX preamble
 */
class GLog : public GnomeCB<ControlLog> {
public:
	///
	GLog(ControlLog & c);
	///
	~GLog();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	/// generated by accessors.py
	Gtk::Button * refresh_btn() const;
	/// generated by accessors.py
	Gtk::Button * close_btn() const;
	/// generated by accessors.py
	Gtk::TextView * log_text() const;


};

#endif
