/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.io.FilterInputStream;
import java.io.InputStream;

public class REFilterInputStream
extends FilterInputStream {
    private RE m_expr;
    private String m_replace;
    private String m_buffer;
    private int m_bufpos;
    private int m_offset;
    private CharIndexedInputStream m_stream;

    public int read() {
        char c;
        if (this.m_buffer != null && this.m_bufpos < this.m_buffer.length()) {
            return this.m_buffer.charAt(this.m_bufpos++);
        }
        if (!this.m_stream.isValid()) {
            return -1;
        }
        REMatch rEMatch = new REMatch(this.m_expr.getNumSubs(), this.m_offset, 0);
        if (this.m_expr.match(this.m_stream, rEMatch)) {
            rEMatch.end[0] = rEMatch.index;
            rEMatch.finish(this.m_stream);
            this.m_stream.move(rEMatch.toString().length());
            this.m_offset += rEMatch.toString().length();
            this.m_buffer = rEMatch.substituteInto(this.m_replace);
            this.m_bufpos = 1;
            if (this.m_buffer.length() > 0) {
                return this.m_buffer.charAt(0);
            }
        }
        if ((c = this.m_stream.charAt(0)) == '\uffff') {
            return -1;
        }
        this.m_stream.move(1);
        ++this.m_offset;
        return c;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n++] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public REFilterInputStream(InputStream inputStream, RE rE, String string) {
        super(inputStream);
        this.m_stream = new CharIndexedInputStream(inputStream, 0);
        this.m_expr = rE;
        this.m_replace = string;
    }
}

