#if   !defined(__ENVIRONMENT_HPP)
#define __ENVIRONMENT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if !defined IN_COMMON_HPP
   #error Environment.hpp is included by Common.hpp only.
#endif


namespace   corelinux
{
   DECLARE_CLASS(Environment);

   /**
   Environment is a class utility which encapsulates
   */

   class Environment
   {
   public:

               /// Equality operator

      inline   bool  operator==( EnvironmentCref ) const
               {
                  return true;
               }

      //
      // Accessors
      //
               /// Retreive the real user id for the current process

      static   UserIdentifier getUserId( void );

               /// Retreive the effective user id for the current process

      static   UserIdentifier getEffectiveUserId( void );

               /// Retreive the real group id for the current process

      static   GroupIdentifier getGroupId( void );

               /// Retreive the effective group id for the current process

      static   GroupIdentifier getEffectiveGroupId( void );

               /** 
               Retrieve the environmental value variable from 
               the (name=value) pair. Same behavior as in POSIX getenv
               @param Char const pointer to key (name) to find value for
               @return Char pointer to the value or null if not found
               */

      static   CharPtr  getEnvironmentValue( CharCptr );

      //
      // Mutators
      //

               /**
               Sets an environment name=value. Same behavior and
               return as POSIX putenv.
               @param Char pointer to string with "NAME=VALUE"
               @return Int 0 for success, -1 otherwise
               */

      static   Int   setEnvironmentNameValue( CharPtr );

      //
      // Functions for library
      //

               /**
               Basically, creates a filename for use by those Linux system
               api that require a key (IPC mainly).
               @param Char pointer to fully qualified name
               @param CreateDisposition disposition of object
               @return Int indicating failure (-1)
               */

      static   Int   setupCommonAccess( CharCptr, const CreateDisposition & );

               /**
               The reverse of setupCommonAccess
               @param Char pointer to fully qualified name
               @return Int indicating failure (-1)
               */

      static   Int   removeCommonAccess( CharCptr );

               /// Retrieve the process group id for the current process

      static   ProcessIdentifier getProcessGroupId( void );

               /// Retrieve the process group id for a specific process

      static   ProcessIdentifier getProcessGroupId( ProcessIdentifierRef );

               /// set priority for a specific process

      static   void  setThreadPriority( ProcessIdentifier, Int );

               /// get priority for a specific process

      static   Int   getThreadPriority( ProcessIdentifier );

   protected:

                              Environment( void ) throw (Assertion)
                              {
                                 NEVER_GET_HERE;
                              }
                        
                              Environment( EnvironmentCref )
                                 throw (Assertion)
                              {
                                 NEVER_GET_HERE;
                              }
               
               EnvironmentRef operator=( EnvironmentCref )
                  throw (Assertion)
               {
                  NEVER_GET_HERE;
                  return (*this);
               }
   private:

   
   };
}

#endif

/*
   Common rcs information do not modify
   $Author: dulimart $
   $Revision: 1.4 $
   $Date: 2001/03/20 04:06:00 $
   $Locker:  $
*/

