#!/usr/bin/perl -w

require 5.001;
use Date::Manip;
@Date::Manip::TestArgs=();
$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
} elsif ( -f "test.pl" ) {
  require "test.pl";
} else {
  die "ERROR: cannot find test.pl\n";
}
$ntest=7;

print "1..$ntest\n"  if (! $runtests);
Date_Init(@Date::Manip::TestArgs);

$tests="

1997
10
   1997:1:10:0:0:_0.00

1997
10.5
   1997:1:10:12:0:_0.00

1997
10.510763888888889
   1997:1:10:12:15:30.00

1997
10.510770138888889
   1997:1:10:12:15:30.54

2000
31
   2000:1:31:0:0:_0.00

2000
31.5
   2000:1:31:12:0:_0.00

2000
32
   2000:2:1:0:0:_0.00

";

print "NthDayOfYear...\n";
test_Func($ntest,\&Test_NthDayOfYear,$tests,$runtests);

sub Test_NthDayOfYear {
  my(@tmp)=&Date_NthDayOfYear(@_);
  push @tmp,sprintf("%5.2f",pop(@tmp));
  return join(":",@tmp);
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:

