/*

    Read-write locks class, header
    Copyright (C) 2001 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifdef _XOPEN_SOURCE
#   if (_XOPEN_SOURCE < 600)
#       undef _XOPEN_SOURCE
#       define _XOPEN_SOURCE 600
#   endif
#else
#   define _XOPEN_SOURCE 600
#endif


#include <pthread.h>


#ifndef RWLOCK_HH
#define RWLOCK_HH

    class clRWLock
    {
            pthread_rwlock_t ptrwlLock;
        public:
            clRWLock ()
                { pthread_rwlock_init(&ptrwlLock, NULL); }
            ~clRWLock ()
                { pthread_rwlock_destroy(&ptrwlLock); }
            bool WaitRead ()
                {
                    if (pthread_rwlock_rdlock(&ptrwlLock) != 0)
                        return false;
                    return true;
                }
            bool WaitWrite ()
                {
                    if (pthread_rwlock_wrlock(&ptrwlLock) != 0)
                        return false;
                    return true;
                }
            bool Release ()
                {
                    if (pthread_rwlock_unlock(&ptrwlLock) != 0)
                        return false;
                    return true;
                }
            bool TryRead ()
                {
                    if (pthread_rwlock_tryrdlock(&ptrwlLock) != 0)
                        return false;
                    return true;
                }
            bool TryWrite ()
                {
                    if (pthread_rwlock_trywrlock(&ptrwlLock) != 0)
                        return false;
                    return true;
                }
    };

#endif
