/** -*- C++ -*-
    @file cache/component/records.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <map>
#include <ept/cache/apt/index.h>
#include <apt-pkg/pkgrecords.h>

#ifndef EPT_CACHE_APT_RECORDS_H
#define EPT_CACHE_APT_RECORDS_H

namespace ept {
namespace t {
namespace cache {
namespace apt {

/**
 * Interface to the textual data as provided by libapt-pkg via its own parser
 */
template< typename C >
struct Records {
    // XXX: we shouldn't blindly hold m_records pointer, because
    // its own pointer to cache can disappear from below our hands... sigh
public:
    typedef typename C::Index Index;
    typedef typename C::Aggregator Aggregator;
    typedef typename C::Version Version;

    friend struct cache::Version< C >;

    struct Record {
        std::string shortDescription;
        std::string longDescription;
        std::string maintainer;
        std::string md5sum, source, fileName;
    };

    Records( Aggregator &a );
    virtual ~Records();

#ifndef SWIG_I
    const Record &record( Version v ) const;
#endif

    Index &index() { return m_aggregator.index(); }
    const Index &index() const { return m_aggregator.index(); }
    std::string aptTagData( Version v );
    // bool preload();

protected:
    typedef std::map< Version, Record > Map;
    typedef std::vector<Map> Vector;
    mutable Vector m_vector; // cache only
    Record m_invalid;
    // Map m_map;
    Aggregator m_aggregator;
    pkgRecords *m_records;

};

}
}
}
}

#endif
