/*
 * Merge different vocabularies together and create the tag and facet indexes
 *
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <ept/cache/debtags/vocabularymerger.h>

#include <ept/tests/test-utils.h>
#include <tagcoll/input/string.h>

namespace tut {

using namespace ept;
using namespace tagcoll;

struct ept_cache_debtags_vocabularymerger_shar {
    ept_cache_debtags_vocabularymerger_shar () {
    }
    ~ept_cache_debtags_vocabularymerger_shar () {
    }
};


TESTGRP( ept_cache_debtags_vocabularymerger );

inline static const char* indexref(const char* index, int id)
{
	return index + ((int*)index)[id];
}


template<> template<>
void to::test<1> ()
{
	string voc1 =
		"Facet: taste\n"
		"Description: Taste\n\n"
		"Tag: taste::sweet\n"
		"Description: Sweet\n\n"
		"Tag: taste::salty\n"
		"Description: Salty\n\n";
	string voc2 =
		"Facet: smell\n"
		"Description: Smell\n\n"
		"Tag: smell::fresh\n"
		"Description: Fresh\n\n"
		"Tag: smell::mold\n"
		"Description: Mold\n\n";
	tagcoll::input::String in1(voc1);
	tagcoll::input::String in2(voc2);

	ept::t::cache::debtags::VocabularyMerger vm;

	// Read and merge the two vocabulary samples
	vm.read(in1);
	vm.read(in2);

	// Write the merged vocabulary to /dev/null (but generate offsets and indexes in the meantime)
	vm.write("/dev/null");

	// Create the facet index
	char facetIndex[vm.facetIndexer().encodedSize()];
	vm.facetIndexer().encode(facetIndex);

	// Create the tag index
	char tagIndex[vm.tagIndexer().encodedSize()];
	vm.tagIndexer().encode(tagIndex);

	// Check that the facet names have been encoded correctly and in order
	ensure_equals(string(indexref(facetIndex, 0) + 4*sizeof(int)), "smell");
	ensure_equals(string(indexref(facetIndex, 1) + 4*sizeof(int)), "taste");

	// Check the first and last tag indexes for the facets
	ensure_equals(((int*)indexref(facetIndex, 0))[2], 0);
	ensure_equals(((int*)indexref(facetIndex, 0))[3], 1);
	ensure_equals(((int*)indexref(facetIndex, 1))[2], 2);
	ensure_equals(((int*)indexref(facetIndex, 1))[3], 3);

	// Check that the tag names have been encoded correctly and in order
	ensure_equals(string(indexref(tagIndex, 0) + 3*sizeof(int)), "smell::fresh");
	ensure_equals(string(indexref(tagIndex, 1) + 3*sizeof(int)), "smell::mold");
	ensure_equals(string(indexref(tagIndex, 2) + 3*sizeof(int)), "taste::salty");
	ensure_equals(string(indexref(tagIndex, 3) + 3*sizeof(int)), "taste::sweet");

	// Check the facet indexes for the tags
	ensure_equals(((int*)indexref(tagIndex, 0))[2], 0);
	ensure_equals(((int*)indexref(tagIndex, 1))[2], 0);
	ensure_equals(((int*)indexref(tagIndex, 2))[2], 1);
	ensure_equals(((int*)indexref(tagIndex, 3))[2], 1);
}

}
// vim:set ts=4 sw=4:
