# libesmtp.spec.in
# Based on original file by Carlos Morgado <chbm@chbm.nu>
# Updates from Pawel Salek <pawsa@theochem.kth.se>
# Updates from Christophe Lambin <clambin@easynet.be>

Summary:  	SMTP client library

%define pkg	libesmtp
%define ver	0.8.11
%define rel    	1
%define prefix 	/usr
%define plugindir %{prefix}/lib/esmtp-plugins
%define openssl	0.9.6

Name:     	%{pkg}
Version:  	%{ver}
Release:  	%{rel}

Copyright:	LGPL
Group:    	System Environment/Libraries
Summary:        SMTP client library.
Source:  	%{pkg}-%{ver}.tar.bz2

URL:       	http://www.stafford.uklinux.net/libesmtp/
BuildRoot:	/var/tmp/%{pkg}-root
Prefix:		%{prefix}

Packager:	Brian Stafford <brian@stafford.uklinux.net>
Provides:	%{pkg}
Docdir:		%{_docdir}

Requires:	openssl >= %{openssl}
BuildRequires:	openssl-devel >= %{openssl}

%description
LibESMTP is a library to manage posting (or submission of) electronic
mail using SMTP to a preconfigured Mail Transport Agent (MTA) such as
Exim.  It may be used as part of a Mail User Agent (MUA) or another
program that must be able to post electronic mail but where mail
functionality is not the program's primary purpose.

%package devel
Group:		Development/Libraries
Summary:	Headers and development libraries for libESMTP.
Requires:	%{pkg} = %{ver}
Requires:	openssl-devel >= %{openssl}

%description devel
The libesmtp-devel package contains headers and development libraries
necessary for building programs against libesmtp.

 
%prep 
%setup -T -b 0
#%patch

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} --enable-all --with-auth-plugin-dir=%{plugindir} --enable-pthreads 
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-, root, root)
%doc AUTHORS COPYING COPYING.GPL NEWS Notes README
%{prefix}/lib/libesmtp.so.*
%{plugindir}/sasl-*

%files devel
%defattr(-,root,root)
%{prefix}/bin/libesmtp-config
%{prefix}/include/*
%{prefix}/lib/libesmtp.so
%{prefix}/lib/libesmtp.la
%{prefix}/lib/libesmtp.a

