=begin
  textdomain.rb - GetText::Textdomain

  Copyright (C) 2001-2004  Masao Mutoh
  Copyright (C) 2001-2003  Masahiro Sakai

      Masahiro Sakai    <s01397ms@sfc.keio.ac.jp>
      Masao Mutoh       <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: textdomain.rb,v 1.2 2004/10/10 18:37:45 mutoh Exp $
=end


module GetText
  class TextDomain
    def initialize(name, path, locale, charset)
      @name, @path = name, path
      @search_files = Array.new
    
      if ENV["GETTEXT_PATH"]
        @locale_dirs = ENV["GETTEXT_PATH"].split(/,/)
      elsif path
        @locale_dirs = [path]
      else
        @locale_dirs = []
        prefix = Config::CONFIG["prefix"]
        @locale_dirs << File.join(prefix, "share", "locale") 
        @locale_dirs << File.join(prefix, "local", "share", "locale")
        @locale_dirs << File.join(Config::CONFIG["datadir"], "locale")
        @locale_dirs.uniq!
      end
    
      @mofiles = Hash.new
      set_charset(charset, false)
      set_locale(locale, false)
      load_mo(false)
    
      puts "Search path:#{@locale_dirs.inspect}" if $DEBUG
    end
    
    def set_locale(locale, reload = true)
      locale = "C" unless locale
      puts "locale:#{locale}" if $DEBUG
      @locales = []
      matched = /^([A-Za-z]+)(_[A-Za-z]+)?(\.\w+)?((?:@[^@]*)*)/.match(locale)

      if matched and matched.size > 1
        matched = matched.to_a
        matched.shift
        while not matched.empty?
          @locales.push(matched.join(''))
          matched.pop
        end
        @locales.uniq!
      else
        @locales.push(locale)
      end
      load_mo(false) if reload
    end
    
    def gettext(msgid)
      if @mo
	if @mo[msgid]
	  result = @mo[msgid].size > 0 ? @mo[msgid] : msgid
	else
	  result = msgid
	end
      else
        no_mo_file if $DEBUG
        result = msgid
      end
      result
    end

    def ngettext(msgid, msgid_plural, n)
      msg = gettext(msgid + "\000" + msgid_plural)
      if msg.include?("\000")
        ary = msg.split("\000")
        if @mo
          plural = eval(@mo.plural)
          if plural.kind_of?(Numeric)
            msg = ary[plural]
          else
            msg = plural ? ary[1] : ary[0]
          end
        else
          msg = n == 1 ? ary[0] : ary[1]
        end
      end
      msg
    end

    def sgettext(msgid, div = '|')
      msg = gettext(msgid)
      if msg == msgid
        if index = msg.rindex(div)
          msg = msg[(index + 1)..-1]
        end
      end
      msg
    end

    def no_mo_file
      print("\nMO file is not found in\n")
      @search_files.each do |fname|
        print("\t#{fname}\n")
      end
    end

    def same_property?(name, path, locale, charset)
      @name == name and @path == path and @locales.include?(locale) and @charset == charset
    end
    
    def set_charset(charset, reload = true)
      if charset and charset != ""
        @charset = charset
      else
        @charset = ENV["OUTPUT_CHARSET"] ? ENV["OUTPUT_CHARSET"] : Locale.codeset
      end
      load_mo(false) if reload
    end

    def load_mo(cache = true)
      @mo = nil
      if cache 
        @locales.each do |locale|
          if @mo = @mofiles[locale]
            return @mo
          end
        end
      end
      @locale_dirs.each do |dir|
      @locales.each{|locale|
        fname = File.join(dir, locale, "LC_MESSAGES", @name + ".mo")
        @search_files << fname
        if File.exist?(fname)
          @mo = MOFile.open(fname, @charset)
          @mofiles[locale] = @mo
         break
        end
      }
      end
    end
  end
end
