/* GNOME-DB Library
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgda/gda-data-model.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-util.h>
#include "table-properties-dialog.h"

void
table_properties_dialog (GtkWindow *parent, GdaConnection *cnc, const gchar *table_name)
{
	GtkWidget *dialog, *table, *grid, *label, *entry;
	GdaParameterList *params;
	GdaDataModel *fields_model;

	/* create the dialog */
	dialog = gtk_dialog_new_with_buttons (_("Table Properties"), parent, 0,
					      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
					      NULL);

	table = gnome_db_new_table_widget (2, 3, FALSE);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), table, TRUE, TRUE, 12);

	label = gnome_db_new_label_widget (_("Table Name"));
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 6, 6);
	entry = gnome_db_new_entry_widget (0, FALSE);
	gtk_entry_set_text (GTK_ENTRY (entry), table_name);
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 6, 6);

	params = gda_parameter_list_new ();
	gda_parameter_list_add_parameter (params, gda_parameter_new_string ("name", table_name));
	fields_model = gda_connection_get_schema (cnc, GDA_CONNECTION_SCHEMA_FIELDS, params);
	grid = gnome_db_grid_new_with_model (fields_model);
	gtk_widget_show (grid);
	gtk_table_attach (GTK_TABLE (table), grid, 0, 3, 1, 2,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK, 6, 6);

	/* run the dialog */
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);

	/* free memory */
	gda_parameter_list_free (params);
	g_object_unref (fields_model);
}
