/*******************************************************************************************************************************************
 cvscale.c
*******************************************************************************************************************************************/

#include "cvscale.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CVScale);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVScale::CVScale (CContainer *inOwner, const CScaleListener *inListener)
	:CScale	 (inOwner, inListener)
{
	// launch the gtk instanciation process
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVScale::~CVScale ()
{
	// gtk deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CVScale::PerformWidgetInstanciate ()
{
	// ok, min, max, step
	return ::gtk_vscale_new_with_range (m_Min, m_Max, m_Step);
}

