/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#ifndef __GTRANS_IFASE_EXEC_H__
#define __GTRANS_IFASE_EXEC_H__

#include <glib.h>
#include "gtrans_ifase_result.h"
#include "gtrans_ifase_conn.h"


/*
 * gtrans_ifase_exec
 */
GTransIFaseResult *
gtrans_ifase_exec(GTransIFaseConn *conn,
		  gchar           *qstr);



/*
 * gtrans_ifase_exec_list_dbs
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_list_dbs(GTransIFaseConn *conn);



/*
 * gtrans_ifase_exec_list_tables
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_list_tables(GTransIFaseConn *conn);




/*
 * gtrans_ifase_exec_table_select_all
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_table_select_all(GTransIFaseConn *conn,
				   gchar           *table);




GTransIFaseResult *
gtrans_ifase_exec_drop_table(GTransIFaseConn *conn,
			     gchar           *table);


#endif /* __GTRANS_IFASE_EXEC_H__ */




