/*
     (C)opyright RISKO Gergely, 2001.
     
     This program can be licensed under the terms of 
     GNU Lesser General Public License v2.1 or above,
     it can be found (on Debian systems) in
     /usr/share/common-licenses/LGPL-2.1
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "libhs.h"

struct hs_struct
{
    char name[30];
    long int point;
};

int comp_ex(void *a, void *b)	/* The standard comparison function */
{
    struct hs_struct *da = (struct hs_struct *) a;
    struct hs_struct *db = (struct hs_struct *) b;

    return (da->point>db->point) - (da->point<db->point);
}

int main(int argc, char ** argv)
{
    struct hs_table * hstable;
    
    if ((argc==2) && (strcmp(argv[1],"print")==0))
    {
        /* We only want to print the high-score table */
	struct hs_item *curitem;
	
	hstable=hs_readtable("example","easy", sizeof(struct hs_struct));
        curitem=hstable->head;
        while (curitem)
        {
	    printf("%30s\t%6ld\n", ((struct hs_struct*) curitem->data)->name, 
    			      ((struct hs_struct*) curitem->data)->point);
	    curitem=curitem->next;
	}
	/* It is for educational pruposes */
	printf("Keeping the shared lock for 10 seconds!\n");
	sleep(10);
        hs_free(hstable);
    }
    else
    {
        struct hs_struct ** heroes;
        
        heroes=malloc(4*sizeof(void *));
        heroes[3]=NULL;
        heroes[0]=malloc(sizeof(struct hs_struct));
        heroes[1]=malloc(sizeof(struct hs_struct));
        heroes[2]=malloc(sizeof(struct hs_struct));
        strcpy(heroes[0]->name, "Eotvos Lorand"); heroes[0]->name[strlen("Eotvos Lorand")]=0;
        strcpy(heroes[1]->name, "Gabor Denes"); heroes[1]->name[strlen("Gabor Denes")]=0;
        strcpy(heroes[2]->name, "Bolyai Janos"); heroes[2]->name[strlen("Bolyai Janos")]=0;
        heroes[0]->point=1000;
        heroes[1]->point=500;
        heroes[2]->point=250;
        hstable=hs_open("example", "easy", (void **) heroes, sizeof(struct hs_struct));
	/*                 |         |             |              |
	                   |         |             |              |
	  the name of the program    |             |              |
	                             |             |              |
	    the difficulty level (branch name)     |              |
	                                           |              |
	             the default data for the first run           |
		                                                  |
		                                the size of hs_struct
	*/
        if (hstable==NULL)
        {
	    printf("Can't open & lock!\n");
        }
        else
        {
    	    struct hs_item *curitem;
	    struct hs_struct inshero;
    	
	    /* inserting a name */
	    strcpy(inshero.name, "Teller Ede");
            inshero.name[strlen("Teller Ede")]=0;
	    inshero.point=452;
    	    printf("%d\n", hs_insert(hstable, &inshero, comp_ex));
	    /* Write out the first 10 best points */
    	    if (hs_write(*hstable, 10)==0) printf("Can't write!\n");
	    /* Listing the table */
    	    curitem=hstable->head;
    	    while (curitem)
    	    {
    		printf("%30s\t%6ld\n", ((struct hs_struct*) curitem->data)->name, 
    				      ((struct hs_struct*) curitem->data)->point);
	        curitem=curitem->next;
	    }
	    /* for educational pruposes */
	    printf("Keeping the exclusive lock for 10 seconds!\n");
	    sleep(10);
	    hs_free(hstable);
        }
    }
    
    return 0;
}
