#!/usr/bin/perl -w

use strict;
use Tie::IxHash;
use HTML::Widgets::SelectLayers;

tie my %o, 'Tie::IxHash',
  'download'     => 'Download',
  'installation' => 'Installation',
  'compatibility' => 'Compatibility',
  'documentation' => 'Documentation',
  'cvs' => 'Anonymous CVS access',
;

my %html = (

  'download' => '<A HREF="HTML-Widgets-SelectLayers-0.04.tar.gz">Download HTML-Widgets-SelectLayers-0.04.tar.gz</a>',

  'installation' => '<PRE>
  perl Makefile.PL
  make
  make test
  make install
</PRE>',

'cvs' => '<PRE>
Anonymous CVS access is available:
  $ export CVSROOT=":pserver:anonymous@pouncequick.420.am:/home/cvs/cvsroot"
  $ cvs login
  (Logging in to anonymous@pouncequick.420.am
  CVS password: anonymous
  $ cvs checkout DBIx-DBSchema
as well as <A HREF="http://www.420.am/cgi-bin/cvsweb/HTML-Widgets-SelectLayers">browsable via cvsweb</A>.
</PRE>',

'documentation' => join('',<DATA>),

'compatibility' => '<PRE>
This HTML generated by this module uses JavaScript, but nevertheless attempts
to be as cross-browser as possible, testing for features via DOM support rather
than specific browsers or versions.  It has been tested under Mozilla
0.9.8->1.4, Netscape 4.77, IE 5.5, Konqueror 2.2.2->3.1.5, and Opera 5.0.
</PRE>',

);
close DATA;

my $w = new HTML::Widgets::SelectLayers(
  'options' => \%o,
  'selected_layer' => 'download',
  'layer_callback' => sub {
    my $layer = shift;
    "<BR>". $html{$layer};
  },
  #'form_action'    => '',
  #'form_text' => [],
  #'form_checkbox' => [],
);

print <<END, $w->html, "</BODY></HTML>\n";
<HTML>
<HEAD>
<TITLE>HTML::Widgets::SelectLayers - selectable HTML layers</TITLE>
</HEAD>
<BODY>
<PRE>
HTML::Widgets::SelectLayers

Copyright (c) 2002 Ivan Kohler
All rights reserved.
This program is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.

This module implements an HTML widget with multiple layers.  Only one layer
is visible at any given time, controlled by a &lt;SELECT&gt; box.  For an example
see below.

</PRE>
<FORM NAME="dummy">
END

__DATA__
<HR>
<P>
<H1><A NAME="name">NAME</A></H1>
<P>HTML::Widgets::SelectLayers - Perl extension for selectable HTML layers</P>
<P>
<HR>
<H1><A NAME="synopsis">SYNOPSIS</A></H1>
<PRE>
  use HTML::Widgets::SelectLayers;</PRE>
<PRE>
  use Tie::IxHash;
  tie my %options, 'Tie::IxHash',
    'value'  =&gt; 'Select One',
    'value2' =&gt; 'Select Two',
  ;</PRE>
<PRE>
  $widget = new HTML::Widgets::SelectLayers(
    'options'       =&gt; \%options,
    'form_name'     =&gt; 'dummy',
    'form_actoin'   =&gt; 'process.cgi',
    'form_text'     =&gt; [ qw( textfield1 textfield2 ) ],
    'form_checkbox' =&gt; [ qw( checkbox1 ) ],
    'layer_callback' =&gt; sub {
      my $layer = shift;
      my $html = qq!&lt;INPUT TYPE=&quot;hidden&quot; NAME=&quot;layer&quot; VALUE=&quot;$layer&quot;&gt;!;
      $html .= $other_stuff;
      $html;
    },
  );</PRE>
<PRE>
  print '&lt;FORM NAME=dummy&gt;'.
        '&lt;INPUT TYPE=&quot;text&quot; NAME=&quot;textfield1&quot;&gt;'.
        '&lt;INPUT TYPE=&quot;text&quot; NAME=&quot;textfield2&quot;&gt;'.
        '&lt;INPUT TYPE=&quot;checkbox&quot; NAME=&quot;checkbox1&quot; VALUE=&quot;Y&quot;&gt;'.
        $widget-&gt;html;</PRE>
<P>
<HR>
<H1><A NAME="description">DESCRIPTION</A></H1>
<P>This module implements an HTML widget with multiple layers.  Only one layer
is visible at any given time, controlled by a &lt;SELECT&gt; box.  For an
example see <A HREF="http://www.420.am/selectlayers/">http://www.420.am/selectlayers/</A></P>
<P>This HTML generated by this module uses JavaScript, but nevertheless attempts
to be as cross-browser as possible, testing for features via DOM support rather
than specific browsers or versions.  It has been tested under Mozilla 0.9.8,
Netscape 4.77, IE 5.5, Konqueror 2.2.2, and Opera 5.0.</P>
<P>
<HR>
<H1><A NAME="forms">FORMS</A></H1>
<P>Not all browsers seem happy with forms that span layers.  The generated HTML
will have a &lt;/FORM&gt; tag before the layers and will generate
&lt;FORM&gt; and &lt;/FORM&gt; tags for each layer.  To facilitate
&lt;SUBMIT&gt; buttons located within the layers, you can pass a form name
and element names, and the relevant values will be copied to the layer's form.
See the <STRONG>form_</STRONG> options below.</P>
<P>
<HR>
<H1><A NAME="methods">METHODS</A></H1>
<DL>
<DT><STRONG><A NAME="item_new_KEY%2C_VALUE%2C_KEY%2C_VALUE%2E%2E%2E">new KEY, VALUE, KEY, VALUE...</A></STRONG><BR>
<DD>
Options are passed as name/value pairs:
<P>options - Hash reference of layers and labels for the &lt;SELECT&gt;.  See
          <A HREF="http://search.cpan.org/doc/GSAR/Tie-IxHash-1.21/lib/Tie/IxHash.pm">the Tie::IxHash manpage</A> to control ordering.
          In HTML: &lt;OPTION VALUE=``$layer''&gt;$label&lt;/OPTION&gt;</P>
<P>layer_callback - subroutine reference to create each layer.  The layer name
                 is passed as an option in <EM>@_</EM></P>
<P>selected_layer - (optional) initially selected layer</P>
<P>form_name - (optional) Form name to copy values from.  If not supplied, no
            values will be copied.</P>
<P>form_action - Form action</P>
<P>form_text - (optional) Array reference of text (or hidden) form fields to copy
            from the <STRONG>form_name</STRONG> form.</P>
<P>form_checkbox - (optional) Array reference of checkbox form fields to copy from
                the <STRONG>form_name</STRONG> form.</P>
<P>fixup_callback - (optional) subroutine reference, returns supplimentary
                 JavaScript for the function described above under FORMS.</P>
<P>#form_select</P>
<P>size - (optional) size of the &lt;SELECT&gt;, default 1.</P>
<P>unique_key - (optional) prepended to all JavaScript function/variable/object
             names to avoid namespace collisions.</P>
<P>html_beween - (optional) HTML between the &lt;SELECT&gt; and the layers.</P>
<P></P>
<DT><STRONG><A NAME="item_html">html</A></STRONG><BR>
<DD>
Returns HTML for the widget.
<P></P></DL>
<P>
<HR>
<H1><A NAME="author">AUTHOR</A></H1>
<P>Ivan Kohler &lt;<A HREF="mailto:ivan-selectlayers@420.am">ivan-selectlayers@420.am</A>&gt;</P>
<P>
<HR>
<H1><A NAME="copyright">COPYRIGHT</A></H1>
<P>Copyright (c) 2002 Ivan Kohler
All rights reserved.
This program is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.</P>
<P>
<HR>
<H1><A NAME="bugs">BUGS</A></H1>
<P>JavaScript</P>
<P>
<HR>
<H1><A NAME="see also">SEE ALSO</A></H1>
<P><EM>perl</EM>.  <A HREF="http://search.cpan.org/doc/GSAR/Tie-IxHash-1.21/lib/Tie/IxHash.pm">the Tie::IxHash manpage</A>, <A HREF="http://www.xs4all.nl/~ppk/js/dom.html">http://www.xs4all.nl/~ppk/js/dom.html</A>,
<A HREF="http://javascript.about.com/library/scripts/blsafeonload.htm">http://javascript.about.com/library/scripts/blsafeonload.htm</A></P>

