/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.spi.signature;

import java.lang.reflect.Method;

import junit.framework.Test;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.test.BaseTestCase;

/**
 * Signature equality tests.
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class SignatureEqualsUnitTestCase extends BaseTestCase
{
   public SignatureEqualsUnitTestCase(String s)
   {
      super(s);
   }

   public static Test suite()
   {
      return suite(SignatureEqualsUnitTestCase.class);
   }

   public void testEqualsMethodSignature() throws Exception
   {
      MethodSignature sig1 = getMethodSignature();
      MethodSignature sig2 = getMethodSignature();
      assertEquals(sig1.hashCode(), sig2.hashCode());
      assertTrue(sig1.equals(sig2));
      assertTrue(sig2.equals(sig1));
   }
   
   public void testEqualsDeclaredMethodSignature() throws Exception
   {
      DeclaredMethodSignature sig1 = getDeclaredMethodSignature();
      DeclaredMethodSignature sig2 = getDeclaredMethodSignature();
      assertEquals(sig1.hashCode(), sig2.hashCode());
      assertTrue(sig1.equals(sig2));
      assertTrue(sig2.equals(sig1));
   }
   
   @SuppressWarnings({"EqualsBetweenInconvertibleTypes"})
   public void testEqualsMethodSignatureAndDeclaredMethodSignature() throws Exception
   {
      MethodSignature ms = getMethodSignature();
      DeclaredMethodSignature ds = getDeclaredMethodSignature();
      assertEquals(ms.hashCode(), ds.hashCode());
      assertTrue(ms.equals(ds));
      assertTrue(ds.equals(ms));
   }
   
   protected MethodSignature getMethodSignature() throws Exception
   {
      return new MethodSignature(getMethod());
   }
   
   protected DeclaredMethodSignature getDeclaredMethodSignature() throws Exception
   {
      return new DeclaredMethodSignature(getMethod());
   }
   
   protected Method getMethod() throws Exception
   {
      Class<?> clazz = this.getClass();
      return clazz.getDeclaredMethod("getMethod");
   }
}
